*         system: TSCREEN
*   program name: viewrpt.prg
*original author: steve boone, pes
*  original date: 07/11/90
*        purpose: allows for viewing of a database on the screen with one
*                 150 byte record

*  update author: Kevin Stroupe,PES
*    update date: 6/25/91
* update purpose: To use in TSCREEN
*        comment:
*    called from: runmodel.prg, tsmain.prg
*          calls:

*  update author: Gerry Chike,PES
*    update date: 11/10/92
* update purpose: Added keyword EXCLUSIVE to USE output files
*        comment: Keyword required in FOXPRO LAN development environment



* position pointers in database file
USE output EXCLUSIVE

SET CURSOR OFF
ON KEY LABEL PGUP
ON KEY LABEL PGDN
IF (model = 'ScrnP' .OR. model = 'ScrnpF') .AND. Simple = 'N'
   no_graph = .T.
ELSE         
   no_graph = .F.
ENDIF

IF LEN(ALLTRIM(model)) > 0
   review = .F.
ELSE 
   review = .T.
ENDIF
IF .NOT. review
   DO CASE
      CASE model = 'Puff'
         USE output EXCLUSIVE
         APPEND FROM 'puff.out' SDF   
         fil = 'puff.out'
      CASE model = 'ScrnF' .OR. model = 'ScrnA' .OR. model = 'ScrnP'
         USE output EXCLUSIVE
         APPEND FROM 'screen.out' SDF   
         fil = 'screen.out'
*      CASE model = 'ScrnA2'
*         USE output EXCLUSIVE
*         APPEND FROM 'screen.out' SDF
*         fil = 'screen.out'
      CASE model = 'RVD'
         USE output EXCLUSIVE
         APPEND FROM 'rvd.out' SDF   
         fil = 'rvd.out'
      CASE model = 'BM'
         USE output EXCLUSIVE
         APPEND FROM 'BMTS.out' SDF   
         fil = 'BMTS.out'
   ENDCASE
ELSE
   APPEND FROM &fil SDF 
ENDIF
STORE 1 TO tof
go bottom
STORE recno() TO bof
go tof

** display operational parameters on screen
*set color to &say
*@ 24, 0 SAY padc('Pg Up, Pg Dn, , , ' + chr(27) + ', ' + chr(26) + ', Alt-, Alt-, (F)ile, (P)rint, Esc',80)
*set color to &normal

IF review
   label = ' Model Printed Output '   
ENDIF
DEFINE WINDOW surround FROM 0,0 TO 24,79 COLOR &SelColor TITLE label
ACTIVATE WINDOW surround 
@ 20,1 SAY PADC('',76,'') COLOR W+/B
@ 21,0 SAY PADC('<>,  <>,  <>,  <>,  Alt<>,  Alt<>,  <PgUp>,  <PgDn>,  <Home>,  <End>',78)
IF review .OR. no_graph
   @ 22,0 SAY PADC('<P> Print    <F> Save to File    <Esc> Exit', 78)
ELSE
   @ 22,0 SAY PADC('<G> Graph    <P> Print    <F> Save to File    <Esc> Exit', 78)
ENDIF
DEFINE WINDOW browwind FROM 1,1 TO 20,78 COLOR &BrowColor
ACTIVATE WINDOW BrowWind

** select, define and open report display window
*define window view from 0, 0 to 23, 79 none color &normal, &say, &hbdr
*activate window view

* display first screenfull
linecnt = 0
col = 1
STORE recno() TO holdrec
DO WHILE .not. eof() .and. linecnt < 18
   @ linecnt, 0 SAY substr(line,col,75)
   linecnt = linecnt + 1
   skip
ENDDO
skip -1

* loop on keystrokes
keypress = 0
DO WHILE keypress <> 27
*   wait for a key to be pressed
   keypress = 0
   DO WHILE keypress = 0
      keypress = inkey()
   ENDDO

*   operations
   DO CASE
*     home
      CASE keypress = 1
         GO TOP
         linecnt = 0  
         DO WHILE .not. eof() .and. linecnt < 18
            @ linecnt, 0 SAY substr(line,col,75)
            linecnt = linecnt + 1
            skip
         ENDDO
*     end
      CASE keypress = 6        
         linecnt = 0 
         GO BOTTOM
         SKIP -17 
         DO WHILE .not. eof() .and. linecnt < 18
            @ linecnt, 0 SAY substr(line,col,75)
            linecnt = linecnt + 1
            skip
         ENDDO
         SKIP -1
*     right arrow
      case keypress = 4
*         if possible, move screen contents to the left 5 characters
         if col < 71
            col = col + 5
            linecnt = 0
            skip -17
            DO WHILE .not. eof() .and. linecnt < 18
               @ linecnt, 0 SAY substr(line,col,75)
               linecnt = linecnt + 1
               skip
            ENDDO
            skip -1
         endif
*     left arrow
      case keypress = 19
*         if possible, move screen contents to the right 5 characters
         if col > 1
            col = col - 5
            linecnt = 0
            skip -17
            DO WHILE .not. eof() .and. linecnt < 18
               @ linecnt, 0 SAY substr(line,col,75)
               linecnt = linecnt + 1
               skip
            ENDDO
            skip -1
         endif
*     up arrow
      CASE keypress = 5
*        if not at top of file, go back one record
         if recno() - 18 > 0
            skip -18
            scroll 0,0,17,75,-1
            @  0,  0 SAY substr(line,col,75)
            skip 17
         endif
*     alt-up arrow, continuous downscroll
      CASE keypress = 194
*        if not at top of file, go back one record
         keypress = 0
         do while keypress = 0 .and. recno() - 18 > 0
            keypress = inkey()
            skip -18
            scroll 0,0,17,75,-1
            @  0,  0 SAY substr(line,col,75)
            skip 17
         enddo
*     down arrow
      CASE keypress = 24
*        if not at bottom of file, go forward one record
         IF recno() <> bof .and. .not. eof()
            skip
            scroll 0,0,17,75,1
            @ 17, 0 SAY substr(line,col,75)
         ENDIF
*     alt-down arrow, continuous upscroll
      CASE keypress = 193
*        if not at bottom of file, go forward one record
         keypress= 0
         do while keypress = 0 .and. recno() <> bof .and. .not. eof()
            keypress = inkey()
            skip
            scroll 0,0,17,75,1
            @ 17, 0 SAY substr(line,col,75)
         enddo
*     page up
      CASE keypress = 18
         STORE 0 TO cntr
*         skip back one screenfull of records or as far as possible
         DO WHILE recno() <> tof .and. cntr < 46
            skip -1
            cntr = cntr + 1
         ENDDO
*         write data to screen
         STORE 0 TO linecnt
         DO WHILE .not. eof() .and. linecnt < 18
            @ linecnt, 0 SAY substr(line,col,75)
            linecnt = linecnt + 1
            skip
         ENDDO
         skip -1
*     page down
      CASE keypress = 3
         STORE 0 TO cntr
*         skip forward one screenfull of records or as far as possible
         DO WHILE recno() < bof .and. cntr < 18
            skip 1
            cntr = cntr + 1
         ENDDO
         skip -17
         clear
*         write data to screen
         STORE 0 TO linecnt
         DO WHILE .not. eof() .and. linecnt < 18
            @ linecnt, 0 SAY substr(line,col,75)
            linecnt = linecnt + 1
            skip
         ENDDO
         skip -1
*     escape
      CASE keypress = 27
         EXIT
*     Letter P or p
      CASE keypress = 80 .or. keypress = 112
         DEFINE WINDOW msg FROM 10,10 TO 14,70 SHADOW COLOR &MesColor
         ACTIVATE WINDOW msg
         @ 1,0 SAY PADC('Make sure printer is online and has plenty of paper.',60)
         WAIT '    Press <Esc> to exit or any other key to print'
         IF LASTKEY() = 27
            RELEASE  WINDOW msg
            LOOP
         ENDIF     
         CLEAR
         @ 1,0 SAY PADC('Printing Model Output, Please stand by...',60)
         COPY FILE &fil TO prn
         EJECT
         RELEASE  WINDOW msg
              
*     Letter F or f
     CASE keypress = 70 .or. keypress = 102
        filname = SPACE(8)
        DEFINE WINDOW question FROM 8,6 TO 14,73 SHADOW COLOR &MesColor
        ACTIVATE WINDOW question  
        @ 1,51 FILL TO 1,58 COLOR &IPColor
        @ 3, 0 SAY PADC('<Esc> Exit/ No Save',67)
        @ 1,1 SAY 'Enter a unique file name for this model output ->         .RPT'
        @ 1,51 GET filname PICTURE '@! NNNNNNNN'  VALID ChkName(filname)
        SET CURSOR ON
        READ
        RELEASE WINDOW question                  
        SET CURSOR OFF
        IF LASTKEY() = 27 
           LOOP
        ENDIF
        filname = ALLTRIM(filname)+'.RPT'
        COPY FILE &fil TO &filname
     * G or g   
     CASE keypress = 71 .OR. keypress = 103 .AND. .NOT. review .AND. .NOT. no_graph
        rec_holder = RECNO()
        USE
        SET CURSOR ON
        DO graf
        SET CURSOR OFF
        USE output EXCLUSIVE
        GO rec_holder
   ENDCASE
ENDDO
* delete all records from report database
ZAP
* close databases
CLOSE DATABASES
RELEASE WINDOW BrowWind
RELEASE WINDOW Surround
SET CURSOR ON
ON KEY LABEL PGUP = 1
ON KEY LABEL PGDN = 1

RETURN
