#!/bin/csh -f

# Path to wrfcmaq2inmap
set scripts = /path/to/gen_wrfcmaq.py
# Path to daily WRF outputs
set wrfpath = /path/to/wrf/output/wrfout_d03_2018-01-01_00_00_00
# Path to MCIP outputs -- just need DENS variable from daily METCRO3D
set mcippath = /path/to/mcip/METCRO3D_20180101.nc
# Path to output from CMAQ -- need daily concentration files
set cmaqpath = /path/to/cmaq/conc/CCTM_CONC_v533_pgi_saprc07tcx_ae6_aq_r2_base18_20180101.nc
# Set the output wrfcmaq file
set outfile = /path/to/output/wrfcmaq_20180101.ncf
# Mechanism to use (saprc or cb6)
set mech = saprc
# Vertical layers mapping for WRF to MCIP
set vertmap = /path/to/vertmap/vert_layers_50_to_28.csv

$scripts/./gen_wrfcmaq.py $wrf $mcip $cmaq $gday $outfile -l $vertmap -m $mech

