      PROGRAM COMPLY

c Declare dynamic arrays

      REAL*4, ALLOCATABLE :: releaseht(:)           !stack height (m)
      REAL*4, ALLOCATABLE :: bldheight(:)           !building height (m)
      REAL*4, ALLOCATABLE :: bldwidth(:)            !building width (m)
      REAL*4, ALLOCATABLE :: distance(:)            !distance between stack and receptor (m)
      REAL*4, ALLOCATABLE :: distanceveg(:)         !distance between garden and receptor (m)
      REAL*4, ALLOCATABLE :: distancecow(:)         !distance between cows/milk and receptor (m)
      REAL*4, ALLOCATABLE :: distancemeat(:)        !distance between meat and receptor (m)
      REAL*4, ALLOCATABLE :: windspeed(:)           !wind speed (m/s)
      REAL*4, ALLOCATABLE :: latitude(:)            !latitude (decimal degrees)
      REAL*4, ALLOCATABLE :: longitude(:)           !longitude (decimal degrees)
      REAL*4, ALLOCATABLE :: pctcalm(:)             !percentage of calm days at wind data location
      REAL*4, ALLOCATABLE :: IFACTOR(:)             !line number of nuclide inhalation factor

      REAL*8, ALLOCATABLE :: rademis(:,:)           !radionuclide emissions (Ci/s) for each stack
      REAL*8, ALLOCATABLE :: conc(:,:)              !radionuclide air concentration (Bq/m3)
      REAL*8, ALLOCATABLE :: dose(:,:)              !radionuclide dose (mrem/yr)
      REAL*8, ALLOCATABLE :: wbfac(:,:)             !whole body dose factor from ICRP Commentary 3
      REAL*8, ALLOCATABLE :: vegfac(:,:)            !vegetable dose factor from ICRP Commentary 3
      REAL*8, ALLOCATABLE :: cowfac(:,:)            !cow dose factor from ICRP Commentary 3
      REAL*8, ALLOCATABLE :: meatfac(:,:)           !meat dose factor from  ICRP Commentary 3
      REAL*8, ALLOCATABLE :: vegconc(:,:)           !radionuclide air concentration at garden (Bq/m3)
      REAL*8, ALLOCATABLE :: vegdose(:,:)           !radionuclide dose by vegetables (mrem/yr)
      REAL*8, ALLOCATABLE :: cowconc(:,:)           !radionuclide air concentration at cows (Bq/m3)
      REAL*8, ALLOCATABLE :: cowdose(:,:)           !radionuclide dose by meat and milk (mrem/yr)
      REAL*8, ALLOCATABLE :: windbinfreq(:,:)       !Sector (wind dir) frequency from that direction
      REAL*8, ALLOCATABLE :: windbinspeed(:,:)      !Sector (wind dir) average speed from that direction (m/s)
      REAL*8, ALLOCATABLE :: windbinsrdist(:,:)     !Sector (wind dir) source-receptor distance (m)

      INTEGER, ALLOCATABLE :: nrads(:)              !number of emitted radionucludes at each stack
      INTEGER, ALLOCATABLE :: nwindbins(:)          !number of wind direction bins at each stack

      CHARACTER*8,  ALLOCATABLE :: radname(:,:)     !radionuclide names at each stack
      CHARACTER*3,  ALLOCATABLE :: windbinname(:,:) !wind direction sector 
      CHARACTER*3,  ALLOCATABLE :: sectorname(:,:)  !sector name for receptors
      CHARACTER*3,  ALLOCATABLE :: vegsector(:)     !Sector (wind dir) location of vegetables
      CHARACTER*3,  ALLOCATABLE :: milksector(:)    !Sector (wind dir) location of cow/milk
      CHARACTER*3,  ALLOCATABLE :: meatsector(:)    !Sector (wind dir) location of meat

      CHARACTER*200,ALLOCATABLE :: windsource(:)    !Source of wind data
      CHARACTER*200,ALLOCATABLE :: winddates(:)     !Date coverage of wind data
      CHARACTER*200,ALLOCATABLE :: windloc(:)       !Location of wind data
      CHARACTER*200,ALLOCATABLE :: winddist(:)      !Distance from wind data to source

c Declare other variables and calculated terms

      REAL FACTOR,FACTORB,area,xcrit,SIGMAZ,CAPSIG,pp,alldose,idose,dist,altconc
      REAL altdose,totvegdose,itotvegdose,totcowdose,itotcowdose
     
      INTEGER nstacks                               !number of unique stacks
      INTEGER N, M, I, J, K                         !loop counters

      CHARACTER*200 title,company,facility,address,poc,phone,inline
      CHARACTER*8 NUC
      CHARACTER*2 NN

      integer date_time(8)                      !for date stamp function
      character*10 b(3)                         !for date stamp function

c Open input and output files 

      write(*,*)
      write(*,*)'COMPLY v2.0 for internal testing only'
      write(*,*)
 
      open(11,file='input.level4.txt',status='old',form='formatted')
      open(12,file='output.level4.txt',status='unknown',form='formatted')
      open(13,file='diag.level4.txt',status='unknown',form='formatted')

      open(9,file='output.level4.table3.csv',status='unknown',form='formatted')
      open(10,file='output.level4.table7.csv',status='unknown',form='formatted')
      open(31,file='output.level4.tableC5.csv',status='unknown',form='formatted')
      open(32,file='output.level4.table21.csv',status='unknown',form='formatted')
      open(30,file='output.level4.halflife.csv',status='unknown',form='formatted')

c Read input namelist file

       read(11,'(20x,a)') title
       read(11,'(20x,a)') company
       read(11,'(20x,a)') facility
       read(11,'(20x,a)') address
       read(11,'(20x,a)') poc
       read(11,'(20x,a)') phone

       read(11,'(20x,i3)') nstacks

       allocate(latitude(nstacks))
       allocate(longitude(nstacks))
       allocate(releaseht(nstacks))
       allocate(bldheight(nstacks))
       allocate(bldwidth(nstacks))
       allocate(distance(nstacks))
       allocate(distanceveg(nstacks))
       allocate(distancecow(nstacks))
       allocate(distancemeat(nstacks))
       allocate(vegsector(nstacks))
       allocate(milksector(nstacks))
       allocate(meatsector(nstacks))
       allocate(windspeed(nstacks))
       allocate(nrads(nstacks))
       allocate(windsource(nstacks))
       allocate(winddates(nstacks))
       allocate(windloc(nstacks))
       allocate(winddist(nstacks))
       allocate(pctcalm(nstacks))
       allocate(nwindbins(nstacks))


       do n = 1, nstacks 

       read(11,'(20x,f10.5)') latitude(n)
       read(11,'(20x,f10.5)') longitude(n)
       read(11,'(20x,f10.5)') releaseht(n)
       read(11,'(20x,f10.5)') bldheight(n)
       read(11,'(20x,f10.5)') bldwidth(n)
       read(11,'(20x,f10.5)') distance(n)
       read(11,'(20x,f10.5)') distanceveg(n)
       read(11,'(20x,f10.5)') distancecow(n)
       read(11,'(20x,f10.5)') distancemeat(n)

       read(11,'(20x,a)') vegsector(n)
       read(11,'(20x,a)') milksector(n)
       read(11,'(20x,a)') meatsector(n)

       read(11,'(20x,f10.5)') windspeed(n)

       read(11,'(20x,i3)') nrads(n)

       allocate(radname(nstacks,nrads(n)))
       allocate(rademis(nstacks,nrads(n)))
       allocate(conc(nstacks,nrads(n)))
       allocate(dose(nstacks,nrads(n)))
       allocate(wbfac(nstacks,nrads(n)))
       allocate(vegfac(nstacks,nrads(n)))
       allocate(cowfac(nstacks,nrads(n)))
       allocate(meatfac(nstacks,nrads(n)))
       allocate(vegconc(nstacks,nrads(n)))
       allocate(vegdose(nstacks,nrads(n)))
       allocate(cowconc(nstacks,nrads(n)))
       allocate(cowdose(nstacks,nrads(n)))

       do m = 1, nrads(n)
       read(11,'(20x,a)') inline
       read(inline,*) radname(n,m),rademis(n,m)
       enddo !end loop over reading in radionuclide emissions

       read(11,'(20x,a)') windsource(n)
       read(11,'(20x,a)') winddates(n)
       read(11,'(20x,a)') windloc(n)
       read(11,'(20x,a)') winddist(n)

       read(11,'(20x,f10.5)') pctcalm(n)
       read(11,'(20x,i3)') nwindbins(n)

       allocate(windbinname(nstacks,nwindbins(n)))
       allocate(windbinfreq(nstacks,nwindbins(n)))
       allocate(windbinspeed(nstacks,nwindbins(n)))
       allocate(windbinsrdist(nstacks,nwindbins(n)))
       allocate(sectorname(nstacks,nwindbins(n)))

       do m = 1, nwindbins(n)
       read(11,'(20x,a)') inline
       read(inline,*) windbinname(n,m),windbinfreq(n,m),windbinspeed(n,m),windbinsrdist(n,m),sectorname(n,m)
       enddo !end loop over reading in wind data and source-receptor distances

       enddo !end loop over reading in stacks


c Read in ancillary files

       write(*,*)
       write(9,700)
       write(10,600)
       write(30,610)
       write(31,620)
       write(32,630)

       OPEN( 14, FILE='TABLE3.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='UNFORMATTED', ACCESS='DIRECT', RECL=3 )

        do i = 1, 878
         READ( 14 , REC = i, err=999 ) NUC, FACTOR

c Make a text version of the originally distributed possession table
         write(9,701)  NUC, FACTOR
  700 FORMAT('Nuclide,Dose (mrem/yr)/(Ci/m3)')
  701 FORMAT(a,1(',',E10.3))

         do n = 1, nstacks
           do m = 1, nrads(n)
           if(radname(n,m).eq.NUC) then
           wbfac(n,m) = FACTOR
           write(*,*) 'Whole body dose factor from table:',NUC,FACTOR,wbfac(n,m)
           endif
           enddo !end loop over radionuclides
          enddo !end loop over stacks
        enddo !end loop over lines on the input file 
 999    continue


       OPEN( 15, FILE='TABLE7.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=16 )

        do i = 1, 878
         READ( 15 , REC = i, err=998 ) NUC, FACTOR, FACTORB

c Make a text version of the originally distributed possession table
         write(10,601)  NUC, FACTOR, FACTORB
  600 FORMAT('Nuclide,Veg Dose (mrem/yr)/(Ci/m3),CowMilk Dose(mrem/yr)/(Ci/m3)')
  601 FORMAT(a,',',E10.3,',',E10.3)


         write(*,*) NUC, FACTOR, FACTORB
          do n = 1, nstacks
           do m = 1, nrads(n)
           if(radname(n,m).eq.NUC) then
           vegfac(n,m) = FACTOR
           cowfac(n,m) = FACTORB/2.
           meatfac(n,m) = FACTORB/2.
           write(*,*) 'Vegetable dose factor from table:',NUC,FACTOR,vegfac(n,m)
           write(*,*) 'Cow/milk dose factor from table:',NUC,FACTORB,cowfac(n,m)
      open(10,file='output.level4.table7.csv',status='unknown',form='formatted')
           write(*,*) 'Meat dose factor from table:',NUC,FACTORB,meatfac(n,m)
           endif
           enddo !end loop over radionuclides
          enddo !end loop over stacks
        enddo !end loop over lines on the input file
 998    continue

        write(*,*)



c Open other input tables

       OPEN( 16, FILE='TABLEL4.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=156 )

       do i = 1, 1 !only 3 lines on the file

         READ( 16, REC =  i )
     &   REMCON,DEPTIM,VDEPN,VDEPI,VDEPP,FRVEG,FRMILK,FRMEAT,TWEATH,TEVEG,TEMILK,TEMEAT,
     &   YVEG,YMILK,YMEAT,PVEG,PMILK,PMEAT,QMILK,QMEAT,QWMILK,QWMEAT,CH2O,CCARB,
     &   FHVEG,FHMEAT,FHMILK,FHFEED,FCVEG,FCMEAT,FCMILK,
     &   CONVEG,CONMILK,CONMEAT,BREATH,DELVEG,DELMILK,DELMEAT,RAINRATE

         write(*,*)'QAOUT',
     &   REMCON,DEPTIM,VDEPN,VDEPI,VDEPP,FRVEG,FRMILK,FRMEAT,TWEATH,TEVEG,TEMILK,TEMEAT,
     &   YVEG,YMILK,YMEAT,PVEG,PMILK,PMEAT,QMILK,QMEAT,QWMILK,QWMEAT,CH2O,CCARB,
     &   FHVEG,FHMEAT,FHMILK,FHFEED,FCVEG,FCMEAT,FCMILK,
     &   CONVEG,CONMILK,CONMEAT,BREATH,DELVEG,DELMILK,DELMEAT,RAINRATE

       enddo


c Open other input tables

       allocate(IFACTOR(9000))

       OPEN( 17, FILE='TABLE21.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=12 )

       do i = 1, 9000
       READ( 17, REC = i, err=997) IFACTOR(i)

       write(*,*)'IH dose eq:',i,IFACTOR(i)
       enddo
 997    continue



       OPEN(18 , FILE='HALFLIFE.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=12 )
         do i = 1, 900

         READ( 18, REC =  i , err=996) NUC,FACTOR

c Make a text version of the originally distributed possession table
         write(30,611)  NUC, FACTOR
  610 FORMAT('Nuclide,Half Life (years)')
  611 FORMAT(a,',',E10.3)

         write(*,*)'HALFLIFE:',i,NUC,FACTOR
         enddo
 996    continue


       OPEN(19 , FILE='TREE.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='UNFORMATTED', ACCESS='DIRECT', RECL=2 )
        I = 1
 990       continue
         READ( 19, REC = I , err=995) J
         write(*,*)'number of nuclides=',J
         do K = 1, J
         READ( 19, REC = I+K , err=995) NUC
         write(*,*)'TREE:',I,J,K,NUC
         enddo
        i = i + J + 1
       goto 990
 995    continue


       OPEN(20 , FILE='INDX.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=72 )
         do i = 1, 900
         READ( 20, REC =  i , err=899) 
     &         NUC, I0, I1, I2, I3, I4, I5, I7,
     &         IB2, IC3, IC4, IC5, IC6, ITREE, ICON, IPOS, IHL

c Make a text version of the originally distributed possession table
         write(32,631)  NUC, IFACTOR(IC3)
  630 FORMAT('Nuclide,Inhalation Dose')
  631 FORMAT(a,',',E10.3)

        write(*,*)'INDEX:',i,NUC,IFACTOR(IC3)
         enddo
 899    continue



        OPEN( 21, FILE='TABLEC5.DAT', STATUS='OLD', IOSTAT=NERR,
     &         FORM='BINARY', ACCESS='DIRECT', RECL=12 )

       do i = 1, 9000

         READ( 21, REC = i, err=777) NUC,FACTOR
c Make a text version of the originally distributed possession table
         write(31,621)  NUC, FACTOR
  620 FORMAT('Nuclide,Immersion Dose')
  621 FORMAT(a,',',E10.3)

         write(*,*)'Immersion dose eq:',i,NUC,FACTOR
       enddo
 777    continue



           stop


c Calculate air concentration and dose for each stack
c Emission rate assumption is Ci/s
c 0.25 term used in following equations is a default wind direction frequency fraction

       do n = 1, nstacks

       area = bldwidth(n) * bldheight(n)
       xcrit = 2.5 * sqrt(area)

       do m = 1, nrads(n)
       if(distance(n).lt.xcrit) then
       conc =   (0.25*rademis(n,m)) /
     &          (3.14*windspeed(n)*1.0*amin1(bldwidth(n),bldheight(n))) 
       else
       SIGMAZ = (0.06 * distance(n)) / SQRT( 1.0 + 0.0015 * distance(n))
       CAPSIG = SQRT( SIGMAZ ** 2 + area / 3.14 )
       pp = 2.032 / ( distance(n) * CAPSIG )
       conc(n,m) = (0.25*rademis(n,m)*pp) / windspeed(n)
       endif

       dose(n,m) = wbfac(n,m) * conc(n,m)

       write(*,*)'Concentration and dose:',n,radname(n,m),rademis(n,m),
     & distance(n),conc(n,m),dose(n,m)

       enddo !end loop over radionuclides
       enddo !end loop over stacks

       write(*,*)

c Calculate air concentration and dose by vegetables

       do n = 1, nstacks

       area = bldwidth(n) * bldheight(n)
       xcrit = 2.5 * sqrt(area)

       do m = 1, nrads(n)
       if(distanceveg(n).lt.xcrit) then
       vegconc =   (0.25*rademis(n,m)) /
     &          (3.14*windspeed(n)*1.0*amin1(bldwidth(n),bldheight(n)))
       else
       SIGMAZ = (0.06 * distanceveg(n)) / SQRT( 1.0 + 0.0015 * distanceveg(n))
       CAPSIG = SQRT( SIGMAZ ** 2 + area / 3.14 )
       pp = 2.032 / ( distanceveg(n) * CAPSIG )
       vegconc(n,m) = (0.25*rademis(n,m)*pp) / windspeed(n)
       endif

       vegdose(n,m) = vegfac(n,m) * vegconc(n,m)

       write(*,*)'Concentration and dose:',n,radname(n,m),rademis(n,m),
     & distance(n),vegconc(n,m),vegdose(n,m)

       enddo !end loop over radionuclides
       enddo !end loop over stacks

       write(*,*)

c Calculate air concentration and dose by meat and milk

       do n = 1, nstacks

       area = bldwidth(n) * bldheight(n)
       xcrit = 2.5 * sqrt(area)

       do m = 1, nrads(n)
       if(distancecow(n).lt.xcrit) then
       cowconc =   (0.25*rademis(n,m)) /
     &          (3.14*windspeed(n)*1.0*amin1(bldwidth(n),bldheight(n)))
       else
       SIGMAZ = (0.06 * distancecow(n)) / SQRT( 1.0 + 0.0015 * distancecow(n))
       CAPSIG = SQRT( SIGMAZ ** 2 + area / 3.14 )
       pp = 2.032 / ( distancecow(n) * CAPSIG )
       cowconc(n,m) = (0.25*rademis(n,m)*pp) / windspeed(n)
       endif

       cowdose(n,m) = cowfac(n,m) * cowconc(n,m)

       write(*,*)'Concentration and dose:',n,radname(n,m),rademis(n,m),
     & distance(n),cowconc(n,m),cowdose(n,m)

       enddo !end loop over radionuclides
       enddo !end loop over stacks

       write(*,*)


c Calculate total dose

       alldose = 0.
       idose = 0.
       totvegdose = 0.
       itotvegdose = 0.
       totcowdose = 0.
       itotcowdose = 0.

       do n = 1, nstacks
       do m = 1, nrads(n)
       alldose = alldose + dose(n,m) + vegdose(n,m) + cowdose(n,m)
       totvegdose = totvegdose + vegdose(n,m)
       totcowdose = totcowdose + cowdose(n,m)
         read(radname(n,m),'(a2)') NN
         if(NN.eq.'I-') then
         idose = idose + dose(n,m) + vegdose(n,m) + cowdose(n,m)
         itotvegdose = itotvegdose + vegdose(n,m)
         itotcowdose = itotcowdose + cowdose(n,m)
         endif
       enddo !end loop over radionuclides
       enddo !end loop over stacks

       write(*,*)'Total dose (mrem/yr):',alldose
       write(*,*)'Total dose limit is 10.0 mrem/yr'
       write(*,*)'Total iodine dose (mrem/yr):',idose
       write(*,*)'Iodine limit is 3.0 mrem/yr'
       write(*,*)
       write(*,*)'Total dose vegetable fraction:',totvegdose/alldose
       write(*,*)'Total dose meat/milk fraction:',totcowdose/alldose
       write(*,*)'Total dose inhalation fraction:',1-((totvegdose/alldose)+(totcowdose/alldose))
       write(*,*)

c Write stardardized output

       write(12,1000) title
       write(12,1001) company
       write(12,1002) facility 
       write(12,1003) address
       write(12,1004) poc
       write(12,1005) phone

       do n = 1, nstacks
       write(12,1006) latitude(n)
       write(12,1007) longitude(n)
       write(12,1008) releaseht(n)
       write(12,1009) bldheight(n)
       write(12,1010) bldwidth(n)
       write(12,1011) distance(n)
       write(12,1012) windspeed(n)

       write(12,1013) nrads(n)

       do m=1, nrads(n)
       write(12,1014) radname(n,m),rademis(n,m),conc(n,m),(dose(n,m)+vegdose(n,m)+cowdose(n,m)),dose(n,m),vegdose(n,m),cowdose(n,m)
       enddo !end loop over radionuclides

       enddo !end loop over stacks

       write(12,2000) alldose
       write(12,2001) idose
       write(12,2002) totvegdose/alldose
       write(12,2003) itotvegdose/idose
       write(12,2004) totcowdose/alldose
       write(12,2005) itotcowdose/idose


c Add time stamp of model simulation to output file

       call date_and_time(b(1), b(2), b(3), date_time)

       print *,'Program execution date and time information:'
       print *,'year=',date_time(1)
       print *,'month_of_year=',date_time(2)
       print *,'day_of_month=',date_time(3)
       print *,'time difference in minutes=',date_time(4)
       print *,'hour of day=',date_time(5)
       print *,'minutes of hour=',date_time(6)
       print *,'seconds of minute=',date_time(7)
       print *,'milliseconds of second=',date_time(8)
       print *, 'DATE=',b(1)
       print *, 'TIME=',b(2)
       print *, 'ZONE=',b(3)

       write(12,*)
       write(12,2100) date_time(2),date_time(3),date_time(1),
     &           date_time(5),date_time(6)


c Formatting for output file

 1000 FORMAT('Project:',a)
 1001 FORMAT('Company:',a)
 1002 FORMAT('Facility:',a)
 1003 FORMAT('Address:',a)
 1004 FORMAT('Point of Contact:',a)
 1005 FORMAT('Phone Number:',a)
 1006 FORMAT('Latitude (degrees):',f10.5)
 1007 FORMAT('Longitude (degrees):',f10.5)
 1008 FORMAT('Release height (m):',f10.1)
 1009 FORMAT('Building height (m):',f10.1)
 1010 FORMAT('Building width (m):',f10.1)
 1011 FORMAT('Distance from source to receptor (m):',f10.1)
 1012 FORMAT('Assumed wind speed (m/s):',f10.1)
 1013 FORMAT('Number of radionuclides:',I2)
 1014 FORMAT(a,',',f25.20,',',f25.20,4(',',f10.6))
 2000 FORMAT('Total effective dose equivalent (mrem/yr):',f10.2)
 2001 FORMAT('Total effective dose equivalent iodine only (mrem/yr):',f10.2)

 2002 FORMAT('Vegetable fraction of total effective dose equivalent:',f5.2)
 2003 FORMAT('Vegetable fraction of total effective dose equivalent iodine only:',f5.2)
 2004 FORMAT('Meat/milk fraction of total effective dose equivalent:',f5.2)
 2005 FORMAT('Meat/milk fraction of total effective dose equivalent iodine only:',f5.2)


 2100 FORMAT('Date/Time (LST) stamp of simulation (MM/DD/YYYY HH:MM):',i2,'/',i2,'/',i4,' ',i2,':',i2)

c Extra output for QA purposes only

       write(13,3001) !write header to file
 
       do n = 1, nstacks

       area = bldwidth(n) * bldheight(n)
       xcrit = 2.5 * sqrt(area)

       do m = 1, nrads(n)

       do j = 1, nwindbins(n)

       do dist = 5, 2000, 5

       SIGMAZ = (0.06 * dist) / SQRT( 1.0 + 0.0015 * dist)
       CAPSIG = SQRT( SIGMAZ ** 2 + area / 3.14 )
       pp = 2.032 / ( dist * CAPSIG )

       if(dist.lt.xcrit) then
       conc =   (windbinfreq(n,j)*rademis(n,m)) /
     &          (3.14*windbinspeed(n,j)*1.0*amin1(bldwidth(n),bldheight(n)))
       else
       conc(n,m) = (windbinfreq(n,j)*rademis(n,m)*pp) / windbinspeed(n,j)
       endif
        
       altconc = (windbinfreq(n,j)*rademis(n,m)*pp) / windbinspeed(n,j) 


       dose(n,m) = wbfac(n,m) * conc(n,m)
       vegdose(n,m) = vegfac(n,m) * conc(n,m)
       cowdose(n,m) = cowfac(n,m) * conc(n,m)
       altdose = wbfac(n,m) * altconc
       altdoseb = vegfac(n,m) * altconc
       altdosec = cowfac(n,m) * altconc

       if(dist.eq.windbinsrdist(n,j)) then
        write(*,*) radname(n,m),n,m,j,sectorname(n,j),dist,dose(n,m),windbinsrdist(n,j)
       endif

       write(13,3000) n,radname(n,m),dist,
     &     conc(n,m),dose(n,m),
     &     vegdose(n,m),cowdose(n,m),
     &     altconc,altdose,
     &     altdoseb,altdosec

       enddo !end loop over radionuclides
       enddo !end loop over number of wind direction bins
       enddo !end loop over distances between source and receptor
       enddo !end loop over stacks

 3000  FORMAT(i2,',',a,',',f6.1,8(',',f25.20))
 3001  FORMAT('STACK,RADNAME,DISTANCE,CONC,WBDOSE,VEGDOSE,COWDOSE,ALTCONC,ALTWB,ALTVEG,ALTCOW')

c End of program

      END 

