       program rfmx

!----------------------------------------------------------------------

c *** Variable declarations
      implicit none
      
      include 'PARMS3.EXT'
      include 'IODECL3.EXT'
      include 'FDESC3.EXT'

      INTEGER :: NCOLS, NROWS, NLAYS, NVARS, JDATE, JTIME, RUNLEN
      INTEGER :: TSTEP, NSTEPS, I,V, T, VMAX, UMAX, DMAX
      CHARACTER*16    VNAME( MXVARS3 ) !  list of vble names, from user
      CHARACTER*16    UNITS( MXVARS3 ) !  list of vble units
      CHARACTER*80    VDESC( MXVARS3 ) !  list of vble descs
      CHARACTER*256   MESG    !  buffer for m3exit(), etc
      CHARACTER*16    INAME   !  logical name of the input file
      LOGICAL         EFLAG !flag: error has happened

      REAL    :: rlon0,rlat0,tlat1,tlat2,xloc,yloc,rlat,rlon,xpos,ypos
      REAL    :: xorg,yorg,dx,xlong,xlat,beta1,beta2,weight, beta3
      REAL    :: beta1ts, beta2ts, beta1sr, beta2sr, beta3ts, beta3sr
      REAL    :: beta4ts, beta4sr, beta4, mesh
      INTEGER :: xorig,yorig,nx,ny,IH,j,tempy,tempx,ii,jj, xyear
      integer    c, r, k, layer, hour, ihour, idate, n, nfiles,HOURS
      real cfac,cfac2,distance

      REAL, ALLOCATABLE :: indica(:,:),indicb(:,:),indic(:,:)
      REAL, ALLOCATABLE :: TOTS( :,:,:),QA(:,:),qd(:,:)
      REAL, ALLOCATABLE :: ammonia(:,:)
      REAL, ALLOCATABLE :: convfac(:)
      REAL, ALLOCATABLE :: GRID( :,:,:),ALTGRID(:,:),xloca(:,:),yloca(:,:)
      REAL, ALLOCATABLE :: latit(:,:),longi(:,:),stktk(:,:),acres(:,:)
      INTEGER, ALLOCATABLE :: row(:,:),col(:,:),fips(:,:),stkht(:,:)
      INTEGER, ALLOCATABLE :: xday(:),xtime(:)

      CHARACTER(LEN=16) :: progname
      CHARACTER(LEN=16) :: aqtarget, outfile, outfileqd
      CHARACTER(LEN=180) :: ename(366),xname(366),land,fname,aname

      INTEGER :: istatus, MXREC, JSTEP
      INTEGER :: TRIMLEN
      real       envreal

      EXTERNAL TRIMLEN, envreal

c *** Initialize variables
      progname = 'RFMX'

      cfac = (1./1000.) * 0.001102293 * 3600. !convert from g to tons and sec to hour

      write(*,*) 'max vars',MXVARS3

      read(*,'(a)') fname
      read(fname,*) rlon0,rlat0,tlat1,tlat2,nx,ny,xorg,yorg,dx
      write(*,'(a,t20,3f10.0)') 'Projection:',rlon0,rlat0,tlat1,tlat2
      write(*,*) 'X and Y cells:',nx,ny
      xorg=xorg*1000.
      yorg=yorg*1000.
      dx=dx*1000.
      write(*,*) 'X orig, Y orig, cell size (m):',xorg,yorg,dx

      read(*,'(a)') fname
      read(fname,*) xyear
      write(*,*)'Year for output file:', xyear

      read(*,'(a)') outfile
      write(*,*)'Output emissions QA file:', outfile

      read(*,'(a)') outfileqd
      write(*,*)'Output air quality file:', outfileqd

      read(*,'(a)') fname
      read(fname,*) nfiles
      write(*,*)'# of input files to matchy:',nfiles

      do n = 1, nfiles
      read(*,'(a)') ename(n)
       write(*,*)'FILE:',ename(n)
      enddo



c---- Allocate and clear main program arrays

      allocate ( TOTS(nx, ny , 10) )
      allocate ( qd(nx,ny))

        DO R = 1, ny
         DO C = 1, nx
          do V = 1, 10
           TOTS( C,R,V ) = 0.0
           qd(c,r) = 0.0
          ENDDO
         ENDDO
        ENDDO


c---- start processing input files

      do n = 1, nfiles

c---- open file: gridded info

      land = ename(n)

      if ( .not. open3( land, FSREAD3, progname ) ) THEN
         MESG = 'Could not open file "' //
     &   land( 1: TRIMLEN(land))
     &   // '" for input'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

      IF ( .NOT. DESC3(land))THEN
         MESG = 'Could not get description info for file "' //
     &            land( 1: TRIMLEN( land) ) //'"'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      ENDIF

        NCOLS = NCOLS3D
        NROWS = NROWS3D
        NLAYS = NLAYS3D
        TSTEP = TSTEP3D
        JSTEP = TSTEP3D
        MXREC = MXREC3D
        NVARS = NVARS3D

       write(*,*) NCOLS,NROWS,NLAYS,TSTEP,NVARS3D
       write(*,*) 'Reading model file'

C.......   Get max string-lengths for use in variables-listing:

        VMAX = TRIMLEN( VNAME3D( 1 ) )
        UMAX = TRIMLEN( UNITS3D( 1 ) )
        DMAX = TRIMLEN( VDESC3D( 1 ) )
        DO  I = 1, NVARS3D
            VMAX = MAX( VMAX , TRIMLEN( VNAME3D( I ) ) )
            UMAX = MAX( UMAX , TRIMLEN( UNITS3D( I ) ) )
            DMAX = MAX( DMAX , TRIMLEN( VDESC3D( I ) ) )
        END DO

        WRITE( *,92000 )
     &  ' ', 'The list of variables in this file is:', ' ',
     &  ( VNAME3D( I )( 1:VMAX ) // ' (' //
     &    UNITS3D( I )( 1:UMAX ) // '): ' //
     &    VDESC3D( I )( 1:DMAX ), I = 1, NVARS3D )

c---- read in variables and sum over all hours

       JDATE = SDATE3D
       JTIME = STIME3D


       write(*,*)'max records',MXREC,JDATE,JTIME
           MESH = XCELL3D/DX
           write(*,*)'MESH FACTOR:',MESH,DX,XCELL3D
           write(*,*)'GRID SPECS:',NCOLS3D,NROWS3D

       allocate(GRID(NCOLS3D,NROWS3D,1))
       

       DO T = 1, 1  !only want 1 hour of averaged data
      write(*,*) 'Reading file at',JDATE,JTIME

        DO  V = 1, NVARS3D

            write(*,*),NVARS3D,V,VNAME3D(V)

            IF ( .NOT. READ3( land, VNAME3D( V ), ALLAYS3,
     &                        JDATE, JTIME, GRID ) ) THEN
                MESG = 'Read failure:  file ' // land //
     &                 ' variable ' // VNAME3D( V )
                CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                       MESG, 2 )
            END IF      !  if read3() failed


c------------matchy

           write(*,*)'HERE'


           DO I = 1, NX !loop over input file grid dimensions
            DO J = 1, NY

c             C = int(0 + ((I-1)/MESH))
c             R = int(0 + ((J-1)/MESH))
             C = int(1 + ((I-1)/MESH)) 
             R = int(1 + ((J-1)/MESH)) 

            II = int((XORG - XORIG3D)/XCELL3D )
            JJ = int((YORG - YORIG3D)/YCELL3D )


c           write(*,*) 'location ',i,j,C+II,R+JJ,GRID(C+II,R+JJ,1)
          if(II+C.gt.0.and.JJ+R.gt.0.and.II+C.lt.NCOLS3D.and.JJ+R.lt.NROWS3D) then

           if(GRID( C+II,R+JJ,1).ne.-9) then
           TOTS( I,J,V ) =  GRID( C+II,R+JJ,1)
c           TOTS( I,J,V ) =  GRID( I,J,1)
           endif

          endif

            ENDDO
           ENDDO

c------------end matchy part

        ENDDO !end loop over variables on file

          CALL NEXTIME( JDATE, JTIME, JSTEP )

      enddo !end loop over times

      if ( .not. close3 ( land ) ) THEN
         MESG = 'Could not close file'
         CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

       deallocate(GRID)

c----- Loop over the rest of the input files
   
       enddo !end loop over all input files

c------
c------ create output file
c------       
     
       JDATE = SDATE3D
       JTIME = STIME3D
       TSTEP3D = 240000
     
            NCOLS3D = NX
            NROWS3D = NY
            XORIG3D = XORG
            YORIG3D = YORG
            XCELL3D = DX
            YCELL3D = DX
            GDTYP3D = 2
            P_ALP3D = 33.
            P_BET3D = 45.
            P_GAM3D = -97.
            XCENT3D = -97.
            YCENT3D = 40.

            SDATE3D = (xyear * 1000) + 001
            STIME3D = 000000
            NLAYS3D = 1
            NVARS3D = NVARS

            JDATE = SDATE3D
            JTIME = STIME3D

            DO I = 1, NVARS
c                VNAME3D( I ) = VNAME( I )
                UNITS3D( I ) = 'tons'
                VDESC3D( I ) = 'Gridded emissions'
c                VTYPE3D( I ) = M3REAL  
            END DO     

            DO I = 1, NVARS
             write(*,*)   VNAME3D( I )
             write(*,*)   UNITS3D( I ) 
             write(*,*)   VDESC3D( I ) 
c                VTYPE3D( I ) = M3REAL
            END DO
                
      if ( .not. open3( outfile, FSCREA3, progname ) ) THEN
          MESG = 'Could not open file "' //
     &     outfile( 1: TRIMLEN(outfile))
     &     // '" for output'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if    
                
          do V = 1,NVARS
           write(*,*)VNAME3D(V),UNITS3D(V)

      IF ( .NOT. WRITE3( OUTFILE,VNAME3D(V),JDATE, JTIME, TOTS(1,1,V) )) THEN
                 MESG = 'Could not write totals to ' // VNAME3D(V)
                  CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                          MESG, 2 )
                END IF      !  if write3() failed
      
          enddo !end loop over variables


c---- outfput second file with air quality surfaces

            DO I = 1, NVARS
c                VNAME3D( I ) = VNAME( I )
                UNITS3D( I ) = 'ug/m3'
                VDESC3D( I ) = 'NLIN2.0'
c                VTYPE3D( I ) = M3REAL  
            END DO

      if ( .not. open3( outfileqd, FSCREA3, progname ) ) THEN
          MESG = 'Could not open file "' //
     &     outfile( 1: TRIMLEN(outfileqd))
     &     // '" for output'
           CALL M3EXIT( progname, 0, 0, MESG, 2 )
      end if

          do V = 1,NVARS
           write(*,*)VNAME3D(V)


      IF ( .NOT. WRITE3( OUTFILEQD,VNAME3D(V),JDATE, JTIME, TOTS(1,1,V)
     &    )) THEN
                 MESG = 'Could not write totals to ' // VNAME3D(V)
                  CALL M3EXIT( 'VERTOT:VERSTEP', JDATE, JTIME,
     &                          MESG, 2 )
                END IF      !  if write3() failed

          enddo !end loop over variables


C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

91000   FORMAT ( //5X , '*** ERROR ABORT in program VERTOT ***',
     &            /5X , A ,
     &           // )        !  generic error message format

C...........   Informational (LOG) message formats... 92xxx

92000   FORMAT ( 5X , A )

92999   FORMAT ( //5X , A, // )

C...........   Formatted file I/O formats............ 93xxx

93000   FORMAT ( A16 )

C...........   Internal buffering formats............ 94xxx

C...........   Miscellaneous formats................. 95xxx

95000   FORMAT ( /5X , A , $ )          !  generic prompt format.


      stop

      END


c-----Start subroutines
      subroutine lcpgeo(iway,phic,xlonc,truelat1,truelat2,xloc,yloc,
     &                  xlon,ylat)
c
c     LCPGEO performs Lambert Conformal to geodetic (lat/lon) translation
c
c     Code based on the TERRAIN preprocessor for MM5 v2.0,
c     developed by Yong-Run Guo and Sue Chen, National Center for
c     Atmospheric Research, and Pennsylvania State University
c     10/21/1993
c
c     Input arguments:
c        iway                Conversion type
c                            0 = geodetic to Lambert Conformal
c                            1 = Lambert Conformal to geodetic
c        phic                Central latitude (deg, neg for southern hem)
c        xlonc               Central longitude (deg, neg for western hem)
c        truelat1            First true latitute (deg, neg for southern hem)
c        truelat2            Second true latitute (deg, neg for southern hem)
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
c     Output arguments:
c        xloc/yloc           Projection coordinates (km)
c        xlon/ylat           Longitude/Latitude (deg)
c
      data conv/57.29578/, a/6370./
c
c-----Entry Point
c
      if (phic.lt.0) then
        sign = -1.
      else
        sign = 1.
      endif
      pole = 90.
      if (abs(truelat1).gt.90.) then
        truelat1 = 60.
        truelat2 = 30.
        truelat1 = sign*truelat1
        truelat2 = sign*truelat2
      endif
      xn = alog10(cos(truelat1/conv)) - alog10(cos(truelat2/conv))
      xn = xn/(alog10(tan((45. - sign*truelat1/2.)/conv)) -
     &         alog10(tan((45. - sign*truelat2/2.)/conv)))           
      psi1 = 90. - sign*truelat1
      psi1 = psi1/conv
      if (phic.lt.0.) then
        psi1 = -psi1
        pole = -pole
      endif
      psi0 = (pole - phic)/conv
      xc = 0.
      yc = -a/xn*sin(psi1)*(tan(psi0/2.)/tan(psi1/2.))**xn
c
c-----Calculate lat/lon of the point (xloc,yloc)
c
      if (iway.eq.1) then
        xloc = xloc + xc
        yloc = yloc + yc
        if (yloc.eq.0.) then
          if (xloc.ge.0.) flp = 90./conv
          if (xloc.lt.0.) flp = -90./conv
        else
          if (phic.lt.0.) then
            flp = atan2(xloc,yloc)
          else
            flp = atan2(xloc,-yloc)
          endif
        endif
        flpp = (flp/xn)*conv + xlonc
        if (flpp.lt.-180.) flpp = flpp + 360.
        if (flpp.gt. 180.) flpp = flpp - 360. 
        xlon = flpp 
c
        r = sqrt(xloc*xloc + yloc*yloc)
        if (phic.lt.0.) r = -r
        cell = (r*xn)/(a*sin(psi1))
        rxn  = 1.0/xn
        cel1 = tan(psi1/2.)*cell**rxn
        cel2 = atan(cel1)
        psx  = 2.*cel2*conv
        ylat = pole - psx
c
c-----Calculate x/y from lat/lon
c
      else
        ylon = xlon - xlonc
        if (ylon.gt. 180.) ylon = ylon - 360.
        if (ylon.lt.-180.) ylon = ylon + 360.
        flp = xn*ylon/conv
        psx = (pole - ylat)/conv
        r = -a/xn*sin(psi1)*(tan(psx/2.)/tan(psi1/2.))**xn
        if (phic.lt.0.) then
          xloc = r*sin(flp)
          yloc = r*cos(flp)
        else
          xloc = -r*sin(flp)
          yloc =  r*cos(flp)
        endif
      endif
c
      xloc = xloc - xc
      yloc = yloc - yc
c
      return
      end

      subroutine caldate(idate)

      integer idate
      dimension nday(12)
      data nday/31,28,31,30,31,30,31,31,30,31,30,31/

c
c-----Entry point
c
c-----If it is already in calender date, return
c

      icent = int(idate/100000)
      iyear = int((idate - icent*100000)/1000)
      jday = idate - icent*100000 - iyear*1000

      nday(2) = 28
      if (mod(iyear,4).eq.0) nday(2) = 29
      mday = 0
      do imonth = 1,12
        mday = mday + nday(imonth)
        if (mday.ge.jday) go to 20
      enddo
 20   iday = jday - (mday - nday(imonth))
      idate = icent*1000000 + iyear*10000 + imonth*100 + iday
c
c      write(*,'(4i6)') icent,iyear,imonth,iday

      return
      end
