c
c-----------------------------------------------------------------------
c   Parameters for array dimensions:
c-----------------------------------------------------------------------
c
c   MXCELLS -- maximum number of cells (used for local arrays)
c   MXLAYER -- maximum number of layers (used for local arrays)
c   MXSPEC  -- maximum number of species (used for local arrays)
c   MXPTSRC -- maximum number of point sources (used for local arrays)
c   MXINFILE     -- maximum number of input files to read
c
      integer   MXCELLS
      integer   MXLAYER
      integer   MXSPEC
      integer   MXPTSRC
      integer   MXINFILE
c
      parameter ( MXCELLS =      200 )
      parameter ( MXLAYER =       30 )
      parameter ( MXSPEC  =      155 )
      parameter ( MXPTSRC =  1000000 )
      parameter ( MXINFILE =      90 )      
c
c-----------------------------------------------------------------------
c   Parameters for error codes:
c-----------------------------------------------------------------------
c
c   KEYLEN  -- length of keyword for packet identifier/terminator
c   IEOD    -- error code for end of data occured on read
c   IEOF    -- error code for end of file encountered on read
c   IFAIL   -- error code for error encountered, leads to termination
c   IRDERR  -- error code for error occurred on formatted read
c   ISKIP   -- error code for data insuffucient for processing, skip and continue
c   ISUCES  -- error code for no error occurred
c   IWRERR  -- error code for error occurred on formatted write
c
      integer KEYLEN
      integer IEOD
      integer IEOF
      integer IFAIL
      integer IRDERR
      integer ISKIP
      integer ISUCES
      integer IWRERR
c
      parameter ( KEYLEN = 20 )
      parameter ( ISKIP  =  1 )
      parameter ( ISUCES =  0 )
      parameter ( IFAIL  = -1 )
      parameter ( IEOD   = -2 )
      parameter ( IEOF   = -3 )
      parameter ( IRDERR = -4 )
      parameter ( IWRERR = -5 )
c
c-----------------------------------------------------------------------
c     Parameters/Variables for input/output files:
c-----------------------------------------------------------------------
c
c   IORSPEC      -- unit number for input species list file
c   ITYP_PTS     -- indicates the input filetype is standard points
c   ITYP_PTC     -- indicates the input filetype is compressed points
c   ncf_iowemis  -- NCF file handle for output emissions file
c   ifile_typ    -- filetype of input emissions file
c   runmsg       -- simultion description
c   ncf_compress -- flag to determine if chunking is used
c   ioremis      -- array of unit numbers of input emissions file
c   infile       -- array of names of input file
c   outfile      -- name of output file
c   spcfile      -- name of input species list file
c   nfiles       -- number of input files
c
      integer IORSPEC
      integer ITYP_PTS
      integer ITYP_PTC
c
      parameter ( IORSPEC  = 10 )
      parameter ( ITYP_PTS = 2  )
      parameter ( ITYP_PTC = 3  )
c
      integer         ncf_iowemis
      integer         ifile_typ(MXINFILE)
      character*60    runmsg
      logical         ncf_compress
      character*(200) outfile
      character*(200) spcfile
      character*(200) infile(MXINFILE)
      integer         ioremis(MXINFILE)
      integer         nfiles
c
      common /iodat/ ncf_iowemis, ifile_typ, ncf_compress, ioremis,
     &               nfiles
      common /iochr/ infile, outfile, spcfile, runmsg
c
c-----------------------------------------------------------------------
c     Variables defining grid sizes/extents/projections:
c-----------------------------------------------------------------------
c
c  ncol    -- number of columns for each grid
c  nrow    -- number of rows for each grid
c  nlay    -- number of layers for each grid
c  delx    -- grid cell size in x-direction for each grid (m)
c  dely    -- grid cell size in y-direction for each grid (m)
c  xorg    -- input grid x-origin (SW corner) (km or degrees)
c  yorg    -- input grid y-origin (SW corner) (km or degrees)
c  iuzon   -- UTM zone
c  itzon   -- time zone (5=EST,8=PST,0=UTC)
c  polelon -- longitude of projection pole (degrees)
c  polelat -- latitude of projection pole (degrees)
c  tlat1   -- 1st true latitude of Lambert, Polar, Mercator projections (deg)
c  tlat2   -- 2nd true latitude of Lambert projection (degrees)
c  iproj   -- type of projection
c  llatlon -- .TRUE. if projection is lat/lon
c  lutm    -- .TRUE. if projection is UTM
c  lambrt  -- .TRUE. if projection is LCP
c  lrpolar -- .TRUE. if projection is 
c  lpolar  -- .TRUE. if projection is polar stereographic
c  lmerc   -- .TRUE. if projection is 
c
      integer ncol
      integer nrow
      integer nlay
      real    delx
      real    dely
      integer iuzon
      integer itzon
      real    xorg
      real    yorg
      real    polelon
      real    polelat
      real    tlat1
      real    tlat2
      integer iproj
      logical llatlon
      logical lutm
      logical lambrt
      logical lrpolar
      logical lpolar
      logical lmerc
      real    deltay
c
      common /grdinp/ ncol, nrow, nlay, delx, dely, iuzon, itzon,
     &                xorg, yorg, polelon, polelat, tlat1, tlat2, iproj,
     &                llatlon, lutm, lambrt, lrpolar, lpolar, lmerc, deltay
c
c-----------------------------------------------------------------------
c   Variables for point source data:
c-----------------------------------------------------------------------
c
c  nptsrc    -- number of point source stacks
c  xstk      -- stack x-location (km or degrees)
c  ystk      -- stack y-location (km or degrees)
c  piglet    -- flag indicating a PiG point source
c  sa_region -- source region ID for SA source region override
c  hstk      -- stack height (meters)
c  dstk      -- stack diameter (meters)
c  tstk      -- stack exit temperature (K)
c  vstk      -- stack exit velocity (meters/s)
c  flowrat   -- stack flow rate (m3/hr)
c               if positive, used to re-calculate hour-specific vstk
c               if negative, used as plume base for plume distribution
c                          override
c  effph     -- effective plume height (meters)
c             if negative, bypass internal plume rise calculation
c                          used as plume top for plume distirbuiton
c                             override
c                otherwise, ignored
c  ptemis    -- point source emission rates (mol/s)
c
      real    xstk(MXPTSRC)
      real    ystk(MXPTSRC)
      real    hstk(MXPTSRC)
      real    dstk(MXPTSRC)
      real    tstk(MXPTSRC)
      real    vstk(MXPTSRC)
      real    flowrat(MXPTSRC)
      real    effph(MXPTSRC)
      integer piglet(MXPTSRC)
      integer sa_region(MXPTSRC)
      real    ptemis(MXPTSRC,MXSPEC)
      integer nptsrc
      real    plumerise(MXPTSRC)
      real    plume_bot(MXPTSRC)
      real    plume_top(MXPTSRC)

      common /stkdat/ xstk, ystk, hstk, dstk, tstk, vstk, flowrat,
     &                effph, piglet, sa_region, ptemis, nptsrc
      common /plumedata/ plumerise, plume_bot, plume_top
c
c-----------------------------------------------------------------------
c   Variables for time span:
c-----------------------------------------------------------------------
c
c  begtim  -- begining time
c  begdate -- begining date
c  endtim  -- ending time
c  enddate -- ending date
c
      real    begtim
      integer begdate
      real    endtim
      integer enddate
c
      common /timespandat/ begtim, begdate, endtim, enddate
c
c-----------------------------------------------------------------------
c   Variables for species list:
c-----------------------------------------------------------------------
c
c  nspec      -- total number of modeled species
c  lgas       -- flag for determining if species is gas or particulate
c  spcname    -- species name
c  idxspc     -- index of file species into total list
c  nspec_file -- total number of modeled species
c
      integer      nspec
      logical      lgas(MXSPEC)
      character*10 spcname(MXSPEC)
      integer      idxspc(MXINFILE,MXSPEC)
      integer      nspec_file(MXINFILE)
c
      common /spcchr/ spcname
      common /spcdat/ nspec, lgas, idxspc, nspec_file
