C**** RDOPTS_PTS
c
c
      subroutine rdopts_pts( ierr )
c
c-----------------------------------------------------------------------
c
c     This routine reads the program options from standard input.
c
c   Arguments:
c     Outputs:
c       ierr   I   error code
c
c-----------------------------------------------------------------------
c   Argument declaration:
c-----------------------------------------------------------------------
c
      integer ierr
c
c-----------------------------------------------------------------------
c   Include files:
c-----------------------------------------------------------------------
c
      include 'camx2ncf_pts.inc'
c
c-----------------------------------------------------------------------
c   Local variables:
c-----------------------------------------------------------------------
c
      character*(KEYLEN) keyin, keytmp
      character*200      fname, string, action
      logical            lexist
c
c-----------------------------------------------------------------------
c   External functions:
c-----------------------------------------------------------------------
c
      integer istrln
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c  --- initialize projection flags ---
c
      llatlon = .FALSE.
      lutm    = .FALSE.
      lambrt  = .FALSE.
      lrpolar = .FALSE.
      lpolar  = .FALSE.
      lmerc   = .FALSE.
c
c  --- read the projection type ---
c
      write(*,'(A)') 'Enter projection type: '
      read(*,'(20X,A)',ERR=7000) keyin
      keytmp = keyin
      call toupper( keytmp )
      call jstlft( keytmp)
      if( keytmp(:3) .EQ. 'UTM' ) then
         lutm = .TRUE.
      else if( keytmp(:6) .EQ. 'LATLON' ) then
         llatlon = .TRUE.
      else if( keytmp(:6) .EQ. 'RPOLAR' ) then
         lrpolar = .TRUE.
      else if( keytmp(:7) .EQ. 'LAMBERT' ) then
         lambrt = .TRUE.
      else if( keytmp(:5) .EQ. 'POLAR' ) then
         lpolar = .TRUE.
      else if( keytmp(:8) .EQ. 'MERCATOR' ) then
         lmerc = .TRUE.
      else
         goto 7001
      endif
c
c  ---- read the parameters for this type ---
c
      if( lutm ) then
         write(*,'(A)') 'Enter UTM zone: '
         read(*,'(20X,I10)',ERR=7000) iuzon
      endif
      if( lrpolar .OR. lambrt .OR. lpolar .OR. lmerc ) then
         write(*,'(A)') 'Enter Longitude Pole: '
         read(*,'(20X,F10.0)',ERR=7000) polelon
         write(*,'(A)') 'Enter Latitude Pole: '
         read(*,'(20X,F10.0)',ERR=7000) polelat
      endif
      if( lambrt .OR. lpolar .OR. lmerc ) then
         write(*,'(A)') 'Enter True Latitude 1: '
         read(*,'(20X,F10.0)',ERR=7000) tlat1
         write(*,'(A)') 'Enter True Latitude 2: '
         read(*,'(20X,F10.0)',ERR=7000) tlat2
      endif
c
c  ---- read the time zone ---
c
      write(*,'(A)') 'Enter time zone:'
      read(*,'(20X,I10)',ERR=7000) itzon
c
c  --- get the filename of the species list file ---
c
      write(*,'(A)') 'Enter inputs species list input filename: '
      read(*,'(20X,A)',ERR=7000) string
      fname = string
      call jstlft( fname )
      spcfile = fname
      inquire(file=fname,exist=lexist)
      if( .NOT. lexist ) goto 7002
      open(unit=IORSPEC,file=fname,ERR=7003)
c
c   --- read the input emissions files ---
c
      nfiles = 0
 111  continue
      write(*,*) 'Enter input emissions filename (/END/ when done): '
      read(*,'(20X,A)',ERR=7000) fname
      call jstlft( fname )
      keyin = fname(:20)
      call toupper( keyin )
      if( keyin(:5) .NE. '/END/' ) then
          nfiles = nfiles + 1
          if( nfiles .GT. MXINFILE ) goto 7004
          infile(nfiles) = fname
          ioremis(nfiles) = IORSPEC + nfiles
          inquire(file=fname,exist=lexist)
          if( .NOT. lexist ) goto 7001
          open(unit=ioremis(nfiles),file=fname,form='UNFORMATTED',ERR=7003)
          goto 111
      endif
c
c  --- read the name of the output NetCDF file ---
c
      write(*,*) 'Enter output NetCDF filename: '
      read(*,'(20X,A)',ERR=7000) fname
      call jstlft( fname )
      outfile = fname
      action = 'Opening output NetCDF file.'
      call ncf_createfile(ierr,outfile,action,ncf_iowemis)
      if( ierr .NE. ISUCES ) goto 9999
c
c   --- set error flag and return ---
c
      ierr = ISUCES 
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(*,'(//,A)') 'ERROR: Reading options from standard input.'
      ierr = IFAIL
      goto 9999
c
 7001 continue
      write(*,'(//,2A)') 'ERROR: Invalid projection type entered: ',
     &                                          keyin(:istrln(keyin)) 
      write(*,'(A)') 'Accceptable options are: '
      write(*,'(10X,A)') 'UTM'
      write(*,'(10X,A)') 'LATLON'
      write(*,'(10X,A)') 'RPOLAR'
      write(*,'(10X,A)') 'LAMBERT'
      write(*,'(10X,A)') 'POLAR'
      write(*,'(10X,A)') 'MERCATOR'
      ierr = IFAIL
      goto 9999
c
 7002 continue
      write(*,'(//,A)') 'ERROR: Input file does not exist.'
      write(*,'(A,//)') fname(:istrln(fname))
      ierr = IFAIL
      goto 9999
c
 7003 continue
      write(*,'(//,A)') 'ERROR: Cannot open input file.'
      write(*,'(A,//)') fname(:istrln(fname))
      ierr = IFAIL
      goto 9999
c
 7004 continue
      write(*,'(//,A,I5)') 'ERROR: Number of input files exceeds max: ',MXINFILE
      write(*,'(A,//)') 'Increase the parameter MXINFILE.'
      ierr = IFAIL
      goto 9999
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
