      subroutine readpt(ierr,icur_file)
      implicit none
c
c----------------------------------------------------------------
c
c     READPT reads the time-variant records of the point source file and
c     cycles through to current time/date to load point emission rates
c
c----------------------------------------------------------------
c  Argument declarations:
c----------------------------------------------------------------
c
c  ierr       I error code
c  icur_file  I index of current file
c
      integer ierr      
      integer icur_file
c
c----------------------------------------------------------------
c  Include files:
c----------------------------------------------------------------
c
      include 'camx2ncf_pts.inc'
c
c----------------------------------------------------------------
c  Local variables:
c----------------------------------------------------------------
c
      character*200 action
      character*4   ptspec(10)
      integer       icell, jcell, kcell, ispc, n, idat1, idat2
      integer       idum, i, npts, izcell(MXPTSRC)
      real          emispts(MXPTSRC), height_layer(MXLAYER), pi
      real          tim1, tim2
c
      data pi /3.1415927/
c
c----------------------------------------------------------------
c  Entry point
c----------------------------------------------------------------
c
 111  continue
      read(ioremis(icur_file),END=222) idat1,tim1,idat2,tim2
      write(*,'(A,I3,A,2(f7.0,i8.5))') 'Read point source file ',
     &                     icur_file,' at ',tim1,idat1,tim2,idat2 
      if(NINT(1000*tim2) .EQ. 0) then
        tim2 = 24.
        idat2 = idat2 - 1
      endif
      tim1 = 100.*AINT(tim1) + 60.*AMOD(tim1,1.)
      tim2 = 100.*AINT(tim2) + 60.*AMOD(tim2,1.)
c
      read(ioremis(icur_file)) idum, npts 
      read(ioremis(icur_file)) (idum,idum,sa_region(n),flowrat(n),
     &                            effph(n),n=nptsrc+1,nptsrc+npts)
      do n=nptsrc+1,nptsrc+npts
         plumerise(n) = 0.
         if( effph(n) .LT. 0. .AND. flowrat(n) .GE. 0. ) 
     &                                    plumerise(n) = -effph(n) 
         plume_bot(n) = 0.
         plume_top(n) = 0.
         if( effph(n) .LT.  0. .AND. flowrat(n) .LT. 0. ) then
            plume_bot(n) = MIN( ABS(effph(n)), ABS(flowrat(n)) )
            plume_top(n) = MAX( ABS(flowrat(n)), ABS(effph(n)) )
         endif
      enddo
      do 10 ispc = 1,nspec_file(icur_file)
         read(ioremis(icur_file)) idum,(ptspec(i),i=1,10),
     &                   (ptemis(n,ispc),n=nptsrc+1,nptsrc+npts)
c
c --- next species ---
c
 10   continue
      nptsrc = nptsrc + npts
c
c  --- normal completion ---
c
      ierr = ISUCES
      goto 9999
c
 222  continue
      ierr = IEOF
c
 9999 continue
c
      return
      end
