#! /bin/csh -f

cat $0
uname -a
date

# based on github run_hr2day.csh

set torun = 1

chdir $WCDIR/post

# # alias testing
# set torun = 0
# alias aget echo
# alias cp   echo

# based on github run_combine.csh and bkx combine.aconc.job and
# combine.dep.job.

#> Configure the system environment and set up the module 
#> capability
   limit stacksize unlimited
#

#> Choose compiler and set up CMAQ environment with correct
#> libraries using config.cmaq. Options: intel | gcc | pgi
# the cmaq_env.csh is sourced from the
# /work/MOD3DEV/rmm/CMAQV52/base/config_cmaq.csh
# /work/MOD3DEV/rmm/CMAQV521    /config_cmaq.csh
 if ( ! $?compiler ) then
   setenv compiler intel
   setenv compilerVrsn 17.0
   setenv compilerString ${compiler}${compilerVrsn}
   set cmenv = /work/MOD3DEV/cmaq_common/cmaq_env.csh
   ls -lpF $cmenv
   set t = `date +%s`
   set freez = /home/bkx/cmaq/misc/fr/cmaq_env.csh.$t
   \cp -p $cmenv $freez
   ls -lpF   $freez
   source    $freez
 endif

# these assignments must be consistent with cmaq_env.csh
# ensure version of exe is valid
set cbdir = /work/MOD3EVAL/bkx/cmaq/wr401/task4/2018/cctm/july_2019_runs/github/chk11jun2019/POST/hr2day/scripts
set exe   = $cbdir/BLD_hr2day_v53_intel17.0/hr2day_v53.exe
# tz file not changed as of 2020-08-04
# -rw-r--r--. 1 bkx mod3eval 4973545 2020-08-04 11:37 /work/ROMO/users/bkx/cmaq/testgit/github/CMAQ53_repo/POST/writesite/inputs/tz.csv
# Files ./github/CMAQ53_repo/POST/writesite/inputs/tz.csv and /work/MOD3EVAL/bkx/cmaq/wr401/task4/2018/cctm/july_2019_runs/github/CMAQ53_repo/POST/hr2day/inputs/tz.csv are identical
# tz file not changed as of 11 jun 2019
# Files ./github1/CMAQ52_repo/POST/hr2day/inputs/tz.csv and /work/MOD3EVAL/bkx/cmaq/wr401/task4/2018/cctm/github/CMAQ53_repo/POST/hr2day/inputs/tz.csv are identical
# /work/ROMO/users/bkx/cmaq/testgit
# -rw-r--r--. 1 bkx romo 4973545 2017-10-26 13:54 ./github1/CMAQ52_repo/POST/hr2day/inputs/tz.csv
set tzdir = /work/MOD3EVAL/bkx/cmaq/wr401/task4/2018/cctm/july_2019_runs/github/CMAQ53_repo/POST/hr2day/inputs
setenv TZFILE $tzdir/tz.csv

# =====================================================================
#> HR2DAY Configuration Options
# =====================================================================

#> set to use local time (default is GMT)
# setenv USELOCAL Y # from driver

#> set to use daylight savings time (default is N)
# setenv USEDST N # from driver

#> location of time zone data file, tz.csv (this is a required input file
#> when using USELOCAL Y to shift from GMT to local time)
# setenv TZFILE $tzdir/tz.csv # set above

#> partial day calculation (computes value for last day)
 setenv PARTIAL_DAY Y

#> constant hour offset between desired time zone and GMT (default is 0)
 setenv HROFFSET 0

#> starting hour for daily metrics (default is 0)
# setenv START_HOUR 0 # from driver

#> ending hour for daily metrics (default is 23)
# setenv END_HOUR 23 # from driver

#> Number of 8hr values to use when computing daily maximum 8hr ozone.
#> Allowed values are 24 (use all 8-hr averages with starting hours 
#> from 0 - 23 hr local time) and 17 (use only the 17 8-hr averages
#> with starting hours from 7 - 23 hr local time)
 setenv HOURS_8HRMAX 24
# setenv HOURS_8HRMAX 17

#> define species (format: "Name, units, From_species, Operation")
#>  operations : {SUM, AVG, MIN, MAX, @MAXT, MAXDIF, 8HRMAX, SUM06}
# setenv SPECIES_1 "O3,ppbV,O3,8HRMAX"  # from driver

alias s "fgrep -aie"
alias gi "grep -aie"

set ercd = $DSCR/env.scr
setenv >! $ercd
echo '===================================================================='
echo "hr2day settings for infile :"
gi '^INFILE=' $ercd
gi '^M3_FILE_1=' $ercd
gi '^OUTFILE=' $ercd
gi '^TZFILE=' $ercd
gi '^PARTIAL_DAY=' $ercd
gi '^HROFFSET=' $ercd
gi '^HOURS_8HRMAX=' $ercd
gi '^USELOCAL=' $ercd
gi '^USEDST=' $ercd
gi '^START_HOUR=' $ercd
gi '^END_HOUR=' $ercd
gi '^HOURS_8HRMAX=' $ercd
echo '----------------------'
echo "hr2day species for $INFILE :"
gi '^SPECIES_[0-9]*=' $ercd

#> set input and output files
# setenv INFILE ${CMAQ_DATA}/POST/COMBINE_ACONC_201107.nc  # from driver
          #[Add location of input file, e.g. COMBINE_ACONC file.]
# setenv OUTFILE ${CMAQ_DATA}/POST/dailymaxozone.nc # from driver

#> Executable call:
$exe
 exit()


