#! /bin/csh

cat $0
uname -a
date

#set echo

# stream 1

setenv ADIR1  /asm1/ROMO/2016platform/CMAQv532/2016fm_cb6r3_ae7nvpoa_16j/12US2/output
setenv ADIR2  
setenv AMET1 
setenv AMET2  
setenv WCDIR  [ENTER CORRECT PATHNAME]
setenv EPI    2016fm_16j_cb6r3_ae7_aq_nvpoa.v532_m3dry.12US2_35

setenv INDIR   $WCDIR/output
setenv PFX     CCTM_
setenv SFX     _${EPI}_
setenv SFX2    .nc
setenv METSFX  .12US2.35L.
setenv METFLAG na   # na for this work

foreach y ( 2016 )
setenv YEAR $y

# start month
foreach m ( 01 02 03 04 05 06 07 08 09 10 11 12)

setenv MONTH $m
set chkgen = $WCDIR/post/log/done_$YEAR$MONTH

setenv OUTDIR  $WCDIR/extr/$YEAR$MONTH
mkdir -p $OUTDIR

# calculate begin and enddate

set nday = _______
if ( $MONTH == 01 ) set nday   = 31
if ( $MONTH == 02 ) set nday   = 28
if ( $MONTH == 03 ) set nday   = 31
if ( $MONTH == 04 ) set nday   = 30
if ( $MONTH == 05 ) set nday   = 31
if ( $MONTH == 06 ) set nday   = 30
if ( $MONTH == 07 ) set nday   = 31
if ( $MONTH == 08 ) set nday   = 31
if ( $MONTH == 09 ) set nday   = 30
if ( $MONTH == 10 ) set nday   = 31
if ( $MONTH == 11 ) set nday   = 30
if ( $MONTH == 12 ) set nday   = 31
if (( $YEAR == 2000 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2004 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2008 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2012 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2016 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2020 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2024 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2028 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2032 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2036 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2040 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2044 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2048 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2052 ) && ( $MONTH == 02 )) set nday = 29
if (( $YEAR == 2056 ) && ( $MONTH == 02 )) set nday = 29

setenv NDAY $nday

setenv BEGDAY $y${m}01
setenv BEGCOM `date -d "$BEGDAY -1 days" '+%Y%m%d' `  # add 1 day previous to combine
setenv ENDDAY $y${m}$nday
setenv ENDDAY `date -d "$ENDDAY  1 days" '+%Y%m%d' `  # add 1 day after    to combine
set chkday =  `date -d "$ENDDAY  1 days" '+%Y%m%d' `  # add 1 day after    to endday

if ( $ENDDAY > 20161231 ) setenv ENDDAY   20161231
if ( $chkday > 20161231 ) set    chkday = 20161231

set chkyr = `echo $chkday |cut -b1-4`
set adir = $ADIR1

    set chkfile1 =      $INDIR/${PFX}ACONC$SFX$chkday$SFX2
    set chkfile2 = $adir/ACONC/${PFX}ACONC$SFX$chkday$SFX2

    echo '========================================================'
    echo to run $YEAR$MONTH waiting for:
    echo $chkfile1
    echo $chkfile2

    chkloop:
    if ( (-e $chkfile1) || (-e $chkfile2) ) then
        if ( $chkday == 20161231 ) sleep 3599 # wait for 1231 to finish

        sleep 60  # warning: uncomment for production
        set d = "`date`"
        setenv EXECUTION_ID "$d"
        echo month $m execid: $d
	echo "sbatch $y$m"

        set logo = driver$y$m.log1

	if ( -e $chkgen ) then 
#	    echo "previous run exists, abort at $YEAR$MONTH "
#	    exit
	    echo "previous run exists, skipping $YEAR$MONTH "
	    goto startnext
        endif

        echo "sbatch ... $YEAR$MONTH"
        sbatch --job-name=dr$y$m --error=$logo --output=$logo --export=MONTH,WCDIR,OUTDIR,ADIR1,ADIR2,AMET1,AMET2,EPI,INDIR,PFX,SFX,SFX2,METSFX,METFLAG,BEGDAY,BEGCOM,ENDDAY,NDAY,YEAR gendriv.csh

# wait until the gendriv finishes a month before continuing the loop
	chkgenr:
	if ( -e $chkgen ) then
	    goto startnext
	else
	    sleep 180
	    goto chkgenr
        endif
	startnext:

    else  # waiting for cctm output
        sleep 3600
        goto chkloop
    endif # if file
end # month
end # year

exit
