#!/work/ROMO/anaconda3/envs/dev/bin/python

# import the new reader
from PseudoNetCDF import pncopen

# Set up some paths
inpath = '/work/ROMO/users/kpc/stl/obs/ceilometer/QQQ.his'
outpath = 'QQQ.nc'
figpath = 'QQQ.png'

# Read the input
cf = pncopen(inpath, format = 'ceilometerl2')

# Save the output to a netcdf file
cf.save(outpath)

# Here I am thinning the data to make plotting faster.
# to plot the whole dataset, comment out the next rwo
cf = cf.sliceDimensions(time = slice(None, None, 20))
# Or you could just average the times
# cf = cf.applyAlongDimensions(time = lambda x: x.reshape(-1, 10).mean(1))

# Now make the plot
fig = cf.plot()

# In beteen now and save, you could modify the figure any way you want
fig.suptitle('Add title here')
fig.axes[0].yaxis.set_ticks([0, 100, 200, 300, 400, 450])

# Now save
fig.savefig(figpath)
