
SUBROUTINE interp_linear (xn, yn, n, x, y )
 
   !-------------------------------------------------------------------------
   ! Description:
   !    Simple linear interpolation
   !
   ! Preconditions required:
   !    input xn and yn array must be sorted in the ascending order
   !
   ! Revision history:
   !    Created Mar 28, 2008 (D. Yin)   
   !-------------------------------------------------------------------------

   IMPLICIT none

   !arguments and their descriptions
   REAL,	DIMENSION (n),	INTENT( IN) :: xn  !array of independent variables
   REAL,	DIMENSION (n),	INTENT( IN) :: yn  !array of dependent variables
   INTEGER,			INTENT( IN) :: n   ! dimension
   REAL,			INTENT( IN) :: x   ! input x
   REAL,			INTENT(OUT) :: y   ! output y
  
   !local variables and their descriptions
   INTEGER				    :: loop

   DO loop=1,n
      IF (x.LE.xn(loop))THEN
         y=yn(loop-1)+(x-xn(loop-1))*(yn(loop)-yn(loop-1))/(xn(loop)-xn(loop-1)) 
         EXIT
      ENDIF
   ENDDO
    
END SUBROUTINE interp_linear

