        SUBROUTINE ADDPOL(NEWPOL, POS)

!***********************************************************************
!  DESCRIPTION:
!      This subroutine add NEWPOL to POLLIST if NEWPOL is not in POLLIST
!        This subroutine will update following variables
!           TOTAL_NUM_POL, MASTERPOLLIST(:)
!           and return the current position of this NEWPOL
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

!...........   SUBROUTINE ARGUMENTS
        CHARACTER*16, INTENT(IN)  :: NEWPOL
        INTEGER,      INTENT(OUT) :: POS

!...........   Other local variables
        INTEGER                    :: I
!......... Follow variables are related to stack_group file

        CHARACTER*300              :: MESG                !  message buffer
        CHARACTER*16, ALLOCATABLE  :: NEWLIST(:)
        INTEGER                    :: NEWSIZE
        LOGICAL                    :: FOUND_SPC
        CHARACTER*16               :: PROGNAME = 'ADDPOL' !  program name

!***********************************************************************
!   begin body of program ADDPOL
      ! Check MASTERLIST to make sure the NEWPOL is not in the list
      FOUND_SPC = .FALSE.

      ! Increase the MASTERLIST if necessary
      IF (TOTAL_NUM_POL .EQ. SIZE_OF_MASTERLIST) THEN
         ! We need increase the size of MASTERLIST
         NEWSIZE = SIZE_OF_MASTERLIST + 5
         ALLOCATE(NEWLIST(NEWSIZE))
         DO I = 1, TOTAL_NUM_POL
            NEWLIST(I) = MASTERPOLLIST(I)
         END DO
         DEALLOCATE(MASTERPOLLIST)
         ALLOCATE(MASTERPOLLIST(NEWSIZE))
         DO I = 1, TOTAL_NUM_POL
            MASTERPOLLIST(I) = NEWLIST(I)
         END DO
         DEALLOCATE(NEWLIST)
         SIZE_OF_MASTERLIST = NEWSIZE
      END IF

      ! If this is the first entry
      IF (TOTAL_NUM_POL .EQ. 0) THEN
         MASTERPOLLIST(1) = NEWPOL
         TOTAL_NUM_POL = TOTAL_NUM_POL + 1
         POS = 1
         GO TO 999
      END IF

      ! Check to see if NEWPOL in MASTERLIST or not
      DO I = 1, TOTAL_NUM_POL
         IF (MASTERPOLLIST(I) .EQ. NEWPOL) THEN
            FOUND_SPC = .TRUE.
            POS = I
            EXIT
         END IF
      END DO

      IF (.NOT. FOUND_SPC) THEN
         TOTAL_NUM_POL = TOTAL_NUM_POL + 1
         POS = TOTAL_NUM_POL
         MASTERPOLLIST(TOTAL_NUM_POL) = NEWPOL
      END IF

999   CONTINUE
      RETURN
C******************  FORMAT  STATEMENTS   ******************************

        END SUBROUTINE ADDPOL
