        SUBROUTINE GETFIPS()
C***********************************************************************
C  DESCRIPTION:
C      This subroutine build up the FIPS array from USA_340_NOFILL.txt
C
C  PRECONDITIONS REQUIRED:
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C      Subroutines: I/O API subroutine
C
C  REVISION  HISTORY:
C      Created 11/2011 by Charles Chang
C
C****************************************************************************/
C.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'    !  I/O API file description data structures.
        INCLUDE 'IODECL3.EXT'

C.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          PROMPTFFILE
        LOGICAL          GETYN
        INTEGER          TRIMLEN
        REAL             STR2REAL
        INTEGER          STR2INT
        EXTERNAL         PROMPTFFILE, GETYN, TRIMLEN, STR2REAL, STR2INT

C...........   Other local variables
        CHARACTER(16)               :: FNAME
        CHARACTER(16)               :: ANAME
        CHARACTER(16)               :: SURGNAME          ! SCICHEM IMC input logical name
        INTEGER                     :: I
        INTEGER                     :: FDEV            ! Unit number for SCICHEM IMC file
        CHARACTER(300)              :: MESG             !  message buffer
        LOGICAL                     :: rdonly, fmtflag
        CHARACTER(300)              :: LINE             !  input file line buffer
        INTEGER                     :: IFIPS
        INTEGER                     :: COL, ROW
        REAL                        :: RATIO
        CHARACTER(80)               :: LINEBUF
        CHARACTER(40)               :: SEGMENT(5)
        CHARACTER(16)               :: PROGNAME = 'GETFIPS' !  program name

C***********************************************************************
C   begin body of program GETFIPS
C   calling PROMPTFFILE to get the
        WRITE(*,*) 'GRIDNAME IS ',  GRIDNAME_INFO
        IF (TRIM(GRIDNAME_INFO) .EQ. '12EUS1_279X240') THEN
           ALLOCATE(FIPS(444,336))
           ALLOCATE(SURGRATIO(444,336))
           IF (DEBUG .EQ. 2) THEN
              WRITE(*,*)'DIMENIONS OF FIPS array are 444 and 336'
           END IF
        ELSE
           ALLOCATE(FIPS(NCOLS,NROWS))
           ALLOCATE(SURGRATIO(NCOLS,NROWS))
           IF (DEBUG .EQ. 2) THEN
              WRITE(*,*) 'DIMENIONS OF FIPS array are ', NCOLS, NROWS
           END IF
        END IF

        RDONLY = .TRUE.
        FMTFLAG = .TRUE.
        FIPS = 0
        SURGRATIO = 0.

        SURGNAME = 'USA340_SURG'
        MESG = 'Enter logical name for USA 340 surrogate file '
        FDEV = PROMPTFFILE(MESG, RDONLY, FMTFLAG, SURGNAME, PROGNAME)
        ! Read FDEV first time to get how many species are there in this file
        DO
           READ( FDEV, 93000, END=100) LINE
           ! Check first char if first char == # this is a section flag
           IF (LINE(1:1) == '#') THEN
              CYCLE
           ELSE
              LINEBUF = ''
              CALL PARSLINE(LINE,5,SEGMENT)
              IFIPS = STR2INT(SEGMENT(2))
              COL = STR2INT(SEGMENT(3))
              ROW = STR2INT(SEGMENT(4))
              RATIO = STR2REAL(SEGMENT(5))
              IF (DEBUG .EQ. 3) THEN
                 WRITE(*,*) 'COL = ', COL
                 WRITE(*,*) 'ROW = ', ROW
                 WRITE(*,*) 'RATIO = ', RATIO
                 WRITE(*,*) 'SURGRATIO(',COL,',',ROW,') = ', SURGRATIO(COL,ROW)
              END IF
              IF (RATIO .GT. SURGRATIO(COL,ROW)) THEN
                 FIPS(COL,ROW) = IFIPS
                 SURGRATIO(COL,ROW) = RATIO
              END IF
           END IF
        END DO

100     CONTINUE

        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)

C...........   Internal buffering formats............ 94xxx

94010   FORMAT( 10( A, :, I8, :, 1X ) )

        END SUBROUTINE GETFIPS
