        SUBROUTINE RDEMISFILE(FDEV)

!***********************************************************************
!  DESCRIPTION:
!      This subroutine will READ emission input text file and store
!        the necessary information to global variables
!      The new feature is PTCOORDTYPE
!        If PTCOORDTYPE = LAMBERT then it will treat x coordinates and
!         y coordinates as Lambert
!        If PTCOORDTYPE = LATLONG then it will treat x coordinates and
!         y coordinates as Longitude and Latitude
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'    !  I/O API file description data structures.
        INCLUDE 'IODECL3.EXT'

!...........   SUBROUTINE ARGUMENTS
        INTEGER, INTENT(IN)  :: FDEV

C...........   Other local variables
        INTEGER           :: I, J, N
        CHARACTER*25      :: INFO_TXT
        INTEGER           :: STKID, NUMPOL
        REAL              :: XCOORD, YCOORD
        REAL              :: STKHT, STKDM, STKET, STKVE, STKFLW
        CHARACTER*16      :: PNAME
        INTEGER           :: PNAME_INDEX, P_POSITION
        REAL              :: DAILYEMIS
        CHARACTER*16      :: EMISUNIT
        REAL              :: HRRATE(24)


C......... Follow variables are related to stack_group file

        CHARACTER*300     :: MESG             !  message buffer
        CHARACTER*16      :: PROGNAME = 'RDEMISFILE' !  program name

!***********************************************************************
!   begin body of program RDEMISFILE

!******************************************************************
!  Start read emission input file first time to set up
!    MASTERPOLLIST
      READ(FDEV,*) INFO_TXT, MODELSTARTDATE
      READ(FDEV,*) INFO_TXT, MODELSTARTHOUR
      READ(FDEV,*) INFO_TXT,GRIDNAME_INFO
      READ(FDEV,*) INFO_TXT, NUM_STACKS

      DO I = 1, NUM_STACKS
         READ(FDEV,*) INFO_TXT, STKID
         READ(FDEV,*) INFO_TXT, XCOORD
         READ(FDEV,*) INFO_TXT, YCOORD
         READ(FDEV,*) INFO_TXT, STKHT
         READ(FDEV,*) INFO_TXT, STKDM
         READ(FDEV,*) INFO_TXT, STKET
         READ(FDEV,*) INFO_TXT, STKVE
         READ(FDEV,*) INFO_TXT, STKFLW
         READ(FDEV,*) INFO_TXT, NUMPOL

         DO J = 1, NUMPOL
            READ(FDEV,*) INFO_TXT, PNAME
            ! Build up MASTERLIST of pollutants
            CALL ADDPOL(PNAME,PNAME_INDEX)
            READ(FDEV,*) INFO_TXT, DAILYEMIS
            READ(FDEV,*) INFO_TXT, EMISUNIT
            READ(FDEV,*) INFO_TXT, (HRRATE(N), N=1,24)
         END DO ! Num of pollutants
      END DO ! Num of stacks

      WRITE(*,*) "Total num of pollutants = ", TOTAL_NUM_POL
!************************************************************
!  Using TOTAL_NUM_POL from above code to
!    allocate memory for following arrays
!    POLNAME, DAILY_EMIS, HR_RATIO
!**********************************************************
      ALLOCATE(STACK_ID(NUM_STACKS))
      ALLOCATE(NUM_OF_POL(NUM_STACKS))
      ALLOCATE(X_COORD(NUM_STACKS))
      ALLOCATE(Y_COORD(NUM_STACKS))
      ALLOCATE(LONGITUDE(NUM_STACKS))
      ALLOCATE(LATITUDE(NUM_STACKS))
      ALLOCATE(STK_HT(NUM_STACKS))
      ALLOCATE(STK_DM(NUM_STACKS))
      ALLOCATE(STK_ET(NUM_STACKS))
      ALLOCATE(STK_VE(NUM_STACKS))
      ALLOCATE(STK_FLW(NUM_STACKS))
      ALLOCATE(CMAQ_EMIS_UNIT(TOTAL_NUM_POL))
      ! Allocate following 2D arrays
      ALLOCATE(POLNAME(NUM_STACKS,TOTAL_NUM_POL))
      ALLOCATE(DAILY_EMIS(NUM_STACKS,TOTAL_NUM_POL))
      ALLOCATE(EMIS_UNIT(NUM_STACKS,TOTAL_NUM_POL))
      ! Allocate following 3D array
      ALLOCATE(HR_RATIO(NUM_STACKS,TOTAL_NUM_POL,24))

!************************************************************
!  Rewind the input file and read it again to build up
!    arrays
!  Initialize arrays
!**********************************************************
      ! Rewind the file to read it again to set up
      ! arrays
      REWIND(FDEV)
      STACK_ID = 0
      NUM_OF_POL = 0
      X_COORD = 0.
      Y_COORD = 0.
      LONGITUDE = 0.
      LATITUDE = 0.
      STK_HT = 0.
      STK_DM = 0.
      STK_ET = 0.
      STK_VE = 0.
      STK_FLW = 0.
      CMAQ_EMIS_UNIT = ""
      POLNAME = ""
      DAILY_EMIS = 0.
      EMIS_UNIT = ""
      HR_RATIO = 0.

      READ(FDEV,*,END=100) INFO_TXT, MODELSTARTDATE
      READ(FDEV,*,END=100) INFO_TXT, MODELSTARTHOUR
      READ(FDEV,*,END=100) INFO_TXT,GRIDNAME_INFO
      READ(FDEV,*,END=100) INFO_TXT, NUM_STACKS
      ! Following are stack dependent information
      DO I = 1, NUM_STACKS
         READ(FDEV,*,END=100) INFO_TXT, STACK_ID(I)
         IF (PTCOORDTYPE .EQ. 'LAMBERT') THEN
            READ(FDEV,*,END=100) INFO_TXT, X_COORD(I)
            READ(FDEV,*,END=100) INFO_TXT, Y_COORD(I)
         ELSE IF (PTCOORDTYPE .EQ. 'LATLONG') THEN
            READ(FDEV,*,END=100) INFO_TXT, LONGITUDE(I)
            READ(FDEV,*,END=100) INFO_TXT, LATITUDE(I)
         END IF
         READ(FDEV,*,END=100) INFO_TXT, STK_HT(I)
         READ(FDEV,*,END=100) INFO_TXT, STK_DM(I)
         READ(FDEV,*,END=100) INFO_TXT, STK_ET(I)
         READ(FDEV,*,END=100) INFO_TXT, STK_VE(I)
         READ(FDEV,*,END=100) INFO_TXT, STK_FLW(I)
         READ(FDEV,*,END=100) INFO_TXT, NUM_OF_POL(I)

         ! *************************************************************************************
         ! NUM_OF_POL will hold how many pollutant for current stack
         ! TOTAL_NUM_POL will hold how many unique pollutnats in this emission input file
         ! *************************************************************************************
         DO J = 1, NUM_OF_POL(I)
            READ(FDEV,*,END=100) INFO_TXT, POLNAME(I,J)
            ! Since the MASTERPOLLIST is alreay built up, so
            ! this call just to get the position of current POLNAME
            ! from MASTERPOLLIST, then use this information to assign
            ! the value to DAILY_EMIS, EMIS_UNIT and HR_RATIO arrays
            CALL ADDPOL(POLNAME(I,J),P_POSITION)
            READ(FDEV,*,END=100) INFO_TXT, DAILY_EMIS(I,P_POSITION)
            READ(FDEV,*,END=100) INFO_TXT, EMIS_UNIT(I,P_POSITION)
            ! Build up CMAQ_EMIS_UNIT
            CMAQ_EMIS_UNIT(P_POSITION) = EMIS_UNIT(I,P_POSITION)
            READ(FDEV,*,END=100) INFO_TXT, (HR_RATIO(I,P_POSITION,N), N=1,24)
         END DO ! Num of pollutants
      END DO ! Num of stacks

100   CONTINUE

!******************  FORMAT  STATEMENTS   ******************************

        END SUBROUTINE RDEMISFILE
