       SUBROUTINE WRCAMX()
!----------------------------------------------------------------------
!   Convert emission input file to CAMX model file
!----------------------------------------------------------------------
! *** Variable declarations
      USE MODINFO
      IMPLICIT none

      INCLUDE 'PARMS3.EXT'
      INCLUDE 'IODECL3.EXT'
      INCLUDE 'FDESC3.EXT'

      INTEGER                  :: NVARS, JDATE
      INTEGER                  :: TSTEP, I,V
      CHARACTER*16             :: VNAME( MXVARS3 ) !  list of vble names, from user
      CHARACTER*256            :: MESG       !  buffer for m3exit(), etc
      CHARACTER*16             :: ANAME      !  logical name of the input file
      CHARACTER*16             :: CAMXNAME   !  logical name of the input file
      LOGICAL                  :: EFLAG      !  flag: error has happened

      REAL                     :: XCEN,YCEN,PALPHA,PBETA,XLOC,YLOC,RLAT,RLON,XPOS,YPOS
      REAL                     :: DX,RONE,RZERO,DUP(9)
      INTEGER                  :: NX,NY,IONE,IZERO,J,TEMPA,TEMPB,TEMPC,CDATE
      INTEGER                  :: C, R, K, LAYER, HOUR, IHOUR, IDATE, N, NFILES,HOURS
      REAL                     :: CAMX_XORG, CAMX_YORG
      REAL                     :: CFAC, CONV
      CHARACTER*10             :: CSPEC
      CHARACTER*60             :: TEMP
      CHARACTER(LEN=16)        :: PROGNAME
      LOGICAL                  :: RDONLY, FMTFLAG
      INTEGER                  :: ISTATUS

      REAL, ALLOCATABLE        :: EMIS(:,:)
      REAL, ALLOCATABLE        :: GRID( :,:,:),XLOCA(:,:),YLOCA(:,:)
      REAL, ALLOCATABLE        :: STKDM(:,:),STKHT(:,:),STKTK(:,:),STKVE(:,:),STKFLW(:,:)
      INTEGER, ALLOCATABLE     :: ROW(:,:),COL(:,:)
      CHARACTER*4              :: IFILE(10), MSPEC(10,1000), NOTE(60)
      CHARACTER*4              :: NOTE1(10), NOTE2(10), NOTE3(10), NOTE4(10)
      CHARACTER*4              :: NOTE5(10), NOTE6(10)

      REAL, ALLOCATABLE        :: DAILYEMIS2HOUR(:,:)
      INTEGER                  :: CAMX_FILENUM

!  External variables
      INTEGER                  :: TRIMLEN, PROMPTFFILE
      LOGICAL                  :: DSCGRID
      EXTERNAL TRIMLEN, DSCGRID, PROMPTFFILE


c      DATA IFILE/'P','T','S','O','U','R','C','E',' ',' '/
      DATA NOTE1/'E','M','I','S','2','C','A','M','X',' '/
      DATA NOTE2/' ','V','R','S','I','O','N',' ','1','.'/
      DATA NOTE3/'0',' ','N','O','V',' ','2','0','1','1'/
      DATA NOTE4/' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA NOTE5/' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA NOTE6/' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/

      TEMP = 'File generated with MKEMIS'
       DO I=1,60
        WRITE(NOTE(I),'(A)') TEMP(I:I)
       END DO

      TEMP = 'PTSOURCE'
       DO I=1,10
        WRITE(IFILE(I),'(A)') TEMP(I:I)
       END DO

c *** Initialize variables
      progname = 'INLINE2CAMX'
      cfac  = (1./1000.) * 0.001102293 * 3600. !convert from g to tons and sec to hour
      ione  = 1
      izero = 0
      rone  = 1.
      rzero = 0.

      ! Retrieve the grid information from GRIDDESC
      ! Environmental variable GRIDDESC must be set
      GDNAM3D = GRIDNAME_INFO
      IF ( .NOT. DSCGRID( GDNAM3D, ANAME, CTYPE,
     &                    P_ALP3D, P_BET3D, P_GAM3D,
     &                    XCENT3D, YCENT3D, XORIG3D,
     &                    YORIG3D, XCELL3D, YCELL3D,
     &                    NCOLS3D, NROWS3D, NTHIK3D ) ) THEN

          MESG = 'Grid "' // GDNAM3D( 1:TRIMLEN( GDNAM3D ) ) //
     &           '" not found in GRIDDESC file'
          CALL M3WARN( PROGNAME, 0, 0, MESG )
      END IF          !  if DSCGRID failed

      CAMXNAME = 'CAMX_FILE'
      RDONLY   = .FALSE.
      FMTFLAG  = .FALSE.

      MESG = 'Enter logical name of the CAMX file name'
      CAMX_FILENUM = PROMPTFFILE(MESG, RDONLY, FMTFLAG, CAMXNAME, PROGNAME)
      XCEN        = XCENT3D
      YCEN        = YCENT3D
      PALPHA      = P_ALP3D
      PBETA       = P_BET3D
      NX          = NCOLS3D
      NY          = NROWS3D
      DX          = XCELL3D
      CAMX_XORG   = XORIG3D
      CAMX_YORG   = YORIG3D

      WRITE(*,'(a,t20,4f10.0)') 'Projection:',XCEN,YCEN,PALPHA,PBETA
      WRITE(*,*) 'X and Y cells:',NX,NY
      WRITE(*,*) 'X orig, Y orig, cell size (m):',CAMX_XORG,CAMX_YORG,DX

!********************************************
!!! Process stack group information
!********************************************
!---- open ioapi file: stack info

      NCOLS = 1
      NROWS = NUM_STACKS
      TSTEP = 10000

!---- allocate and clear arrays
      ALLOCATE ( EMIS(1000, NROWS) )
      ALLOCATE ( DAILYEMIS2HOUR(NROWS,TOTAL_NUM_POL))

      ALLOCATE ( GRID(NCOLS, NROWS,1000) )
      ALLOCATE ( STKDM(NCOLS, NROWS))
      ALLOCATE ( STKHT(NCOLS, NROWS))
      ALLOCATE ( STKTK(NCOLS, NROWS))
      ALLOCATE ( STKVE(NCOLS, NROWS))
      ALLOCATE ( STKFLW(NCOLS, NROWS))
      ALLOCATE ( ROW(NCOLS, NROWS))
      ALLOCATE ( COL(NCOLS, NROWS))
      ALLOCATE ( XLOCA(NCOLS, NROWS))
      ALLOCATE ( YLOCA(NCOLS, NROWS))

!---- read in variables and sum over all hours
      JDATE = JULIANDATE
      DO I = 1, NUM_STACKS
         STKDM(1,I)   =  STK_DM(I) ! m
         STKHT(1,I)   =  STK_HT(I) ! m
         STKTK(1,I)   =  STK_ET(I) ! K
         STKVE(1,I)   =  STK_VE(I)*3600.0 !m/s to m/hr
         STKFLW(1,I)  =  STK_VE(I)*3.1416*(STK_DM(I)/2.)*(STK_DM(I)/2.)*3600. !m3/s to m3/hr
         XLOCA(1,I)   =  X_COORD(I)
         YLOCA(1,I)   =  Y_COORD(I)
         ! FOLLOWING 2 VARIABLES WILL BE CALCULATED
         COL(1,I)     = 1 + INT((X_COORD(I)-CAMX_XORG)/XCELL)
         ROW(1,I)     = 1 + INT((Y_COORD(I)-CAMX_YORG)/YCELL)
       END DO

C.......   Get max string-lengths for use in variables-listing:
c---- camx file header
      WRITE(*,*)'Number of stacks:',NROWS
      NVARS = TOTAL_NUM_POL

      ! Convert speices names and put the old name into char*4 array
      DO V = 1,TOTAL_NUM_POL
         CSPEC = MASTERPOLLIST(V)

         if(CSPEC.eq.'NO') then
         CONV = 907184.*(1./30.)
         elseif(CSPEC.eq.'NO2') then
          CONV = 907184.*(1./46.)
         elseif(CSPEC.eq.'SO2') then !expecting g/s
          CONV = 3600.*(1./64.)
         elseif(CSPEC.eq.'CO') then
          CONV = 907184.*(1./44.)
         elseif(CSPEC.eq.'PDCH') then
          CONV = 907184.*(1./400) 
         else
          CONV = 1.0
         endif

         DAILYEMIS2HOUR(:,V) = DAILY_EMIS(:,V) * CONV  

         DO I=1,10
            WRITE(MSPEC(I,V),'(A)') CSPEC(I:I)
         END DO
         WRITE(*,*) MSPEC(:,V)
      END DO
      CSPEC = 'TOLA'
      DO I=1,10
         WRITE(MSPEC(I,(NVARS+1)),'(A)') CSPEC(I:I)
      END DO
      CSPEC = 'XYLA'
      DO I=1,10
         WRITE(MSPEC(I,(NVARS+2)),'(A)') CSPEC(I:I)
      END DO
      CSPEC = 'ISP'
      DO I=1,10
         WRITE(MSPEC(I,(NVARS+3)),'(A)') CSPEC(I:I)
      END DO
      CSPEC = 'TRP'
      DO I=1,10
         WRITE(MSPEC(I,(NVARS+4)),'(A)') CSPEC(I:I)
      END DO


!      SDATE3D = JULIANDATE
!      TEMPA = INT(SDATE3D/1000)*1000 !CONVERT TO CAMX DATE FORMATE YYDDD
!      TEMPB = SDATE3D - TEMPA        !JDAY
!      IF (TEMPA .LT. 2000000) THEN
!         TEMPC = TEMPA - 1900000
!      ELSE
!         TEMPC = TEMPA - 2000000
!      END IF
!      CDATE = TEMPC + TEMPB
      CDATE = MODELSTARTDATE

      write(*,*) CAMX_FILENUM,IFILE,NOTE,IONE,(NVARS+4),CDATE,REAL(0)

      OPEN(CAMX_FILENUM,form='unformatted')

      WRITE(CAMX_FILENUM) IFILE,NOTE,IONE,(NVARS+4),CDATE,REAL(0),CDATE,REAL(23)
      WRITE(CAMX_FILENUM) RZERO,RZERO,IZERO,CAMX_XORG,CAMX_YORG,DX,DX,NX,NY,
     $   IONE,IZERO,IZERO,RZERO,RZERO,RZERO
      WRITE (*,1007) CDATE, REAL(0), CDATE, REAL(23)
      WRITE(CAMX_FILENUM) IZERO,IZERO,NX,NY
      WRITE(CAMX_FILENUM) ((MSPEC(I,J),I=1,10),J=1,(NVARS+4))
      WRITE(*,1013) ((MSPEC(I,J),I=1,10),J=1,(NVARS+4))
      WRITE(CAMX_FILENUM) IONE,NROWS
      WRITE(CAMX_FILENUM) (XLOCA(1,R),YLOCA(1,R),STKHT(1,R),-(STKDM(1,R)),STKTK(1,R),
     &   STKVE(1,R),R=1,NROWS)

!---- Calculate hourly rate from emission input file
       JDATE = SDATE3D
       DO HOURS = 1, 24
          DO  V = 1, NVARS
             DO C = 1, NCOLS
                EMIS(V,:) = DAILYEMIS2HOUR(:,V) * HR_RATIO(:,V,HOURS)
             END DO
          END DO !END loop over variables on file

          !---- write out to camx file for this hour
          WRITE(CAMX_FILENUM) CDATE,REAL(HOURS-1),CDATE,REAL(HOURS)
          WRITE(*,1007) CDATE,REAL(HOURS-1),CDATE,REAL(HOURS)

          WRITE(CAMX_FILENUM) IONE,NROWS
          WRITE(CAMX_FILENUM) (COL(1,R),ROW(1,R),IONE,(STKFLW(1,R)),IONE,R=1,NROWS)
          DO V=1,NVARS
             WRITE(camx_filenum) ione,(MSPEC(I,V),I=1,10),(EMIS(V,R),R=1,NROWS)
          END DO !END nspecs loop

          DO K=1,4 !duplicate species
             WRITE(CAMX_FILENUM) IONE,(MSPEC(I,(NVARS+K)),I=1,10),((EMIS(DUP(K),R)),R=1,NROWS)
          END DO !END loop over duplicate species for SOA chemistry
          !----- done writing to camx file
       END DO !END loop over hours

 8080 FORMAT(a20,1x,i10,1x,f20.10,1x,a10)
 1007 FORMAT(2(I10,F10.2),I10)
 1013 FORMAT(1X,10A1)

9999  CONTINUE
C******************  FORMAT  STATEMENTS   ******************************
C...........   Error and warning message formats..... 91xxx
91000   FORMAT ( //5X , '*** ERROR ABORT in SUBROUTINE VERTOT ***',
     &            /5X , A ,
     &           // )        !  generic error message format

C...........   Informational (LOG) message formats... 92xxx
92000   FORMAT ( 5X , A )
92999   FORMAT ( //5X , A, // )

C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT ( A16 )

C...........   Miscellaneous formats................. 95xxx
95000 FORMAT ( /5X , A , $ )          !  generic prompt format.

       END SUBROUTINE WRCAMX

