        SUBROUTINE WRSCISCN(FDEV, STACK_INDEX)
!***********************************************************************
!  DESCRIPTION:
!      This subroutine reads the SCN file for SCICHEM model.
!       The major subroutine under this is write_hour()
!      Additional code will address if there are more than
!       one stack, this subroutine will write to multiple
!       files
!
!  PRECONDITIONS REQUIRED:
!
!  SUBROUTINES AND FUNCTIONS CALLED:
!      Subroutines: I/O API subroutine
!
!  REVISION  HISTORY:
!      Created 11/2011 by Charles Chang
!
!****************************************************************************/
!.........  MODINFO contains all the public variables
        USE MODINFO

        IMPLICIT NONE

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'FDESC3.EXT'
        INCLUDE 'IODECL3.EXT'

C.........  EXTERNAL FUNCTIONS and their descriptions:
        INTEGER          PROMPTFFILE
        INTEGER          TRIMLEN
        EXTERNAL         PROMPTFFILE, TRIMLEN


C.........  SUBROUTINE ARGUMENTS
        INTEGER     , INTENT (IN):: FDEV          ! file unit no.
        INTEGER     , INTENT (IN):: STACK_INDEX   ! how to get proper stack information

C...........   Other local variables
        INTEGER                     :: I,J,K
        CHARACTER(300)              :: MESG             !  message buffer
        CHARACTER(300)              :: LINE             !  input file line buffer
        CHARACTER(300)              :: LINEBUF
        CHARACTER(40)               :: SEGMENT(7)
        INTEGER                     :: LOC_EMIS_UNIT
        INTEGER,      PARAMETER     :: TOT_HOURS = 24
        CHARACTER(5), PARAMETER     :: SPACE5 = '     '
        ! Following variables are related to SCICHEM SCN files
        CHARACTER(5), PARAMETER     :: SCN_STARTREC = '&SCN'
        CHARACTER(2), PARAMETER     :: SCN_ENDREC = ' /'
        REAL                        :: TREL
        REAL                        :: XREL
        REAL                        :: YREL
        REAL                        :: ZREL
        REAL                        :: CMASS
        REAL                        :: SCN_SIZE
        REAL                        :: TDUR
        CHARACTER(7)                :: RELTYP
        CHARACTER(82)               :: NAME_REL
        CHARACTER(19)               :: RELMAT
        REAL                        :: SIGX
        REAL                        :: SIGY
        REAL                        :: SIGZ
        INTEGER                     :: SUBGROUP
        REAL                        :: LOGNORM_MMD
        REAL                        :: LOGNORM_SIGMA
        INTEGER                     :: NUMBER_RANDOM
        REAL                        :: RANDOM_SPREAD
        INTEGER                     :: SCN_RANDOM_SEED
        REAL                        :: HORIZ_UNCERTAINTY
        REAL                        :: VERT_UNCERTAINTY
        REAL                        :: UREL
        REAL                        :: VREL
        REAL                        :: WREL
        REAL                        :: WMOM
        REAL                        :: BUOY
        REAL, ALLOCATABLE           :: REL_MC(:)
        REAL                        :: OPID
        REAL, ALLOCATABLE           :: OPMOD(:)
        CHARACTER(160)              :: STR_BUFFER
        CHARACTER(2000)             :: STR_REL_MC
        CHARACTER(2000)             :: STR_OPMOD
        CHARACTER(2100)             :: STR_BUFFER2
        CHARACTER(40)               :: STR_FORMAT_RELMC
        CHARACTER(40)               :: STR_FORMAT_OPMOD
        CHARACTER(40)               :: STR_OUT_RELMC
        CHARACTER(40)               :: STR_OUT_OPMOD
        INTEGER, ALLOCATABLE        :: POLNAME_INDEX(:) ! IMC_SPECNAME to find out the position of each POLNAME
                                                        ! If index equal 0 this means the species is not exist from IMC file
        LOGICAL, ALLOCATABLE        :: UNITCONVERTYN(:) ! Determine if emission rate need convert to different unit
        REAL,    ALLOCATABLE        :: CONVERTUNITRATIO(:)
        REAL                        :: NEW_DAILY_EMIS
        CHARACTER(16)               :: OLD_UNIT
        CHARACTER(16)               :: NEW_UNIT
        CHARACTER(16)               :: OLDUNITMASS
        CHARACTER(16)               :: OLDUNITTIME
        CHARACTER(16)               :: NEWUNITMASS
        CHARACTER(16)               :: NEWUNITTIME
        REAL                        :: MASS_RATIO
        REAL                        :: TIME_RATIO
        INTEGER                     :: REL_INDEX
        INTEGER                     :: POL_POSITION

        LOGICAL                     :: FIRST_TIME

        CHARACTER(16) :: PROGNAME = 'WRSCISCN' !  program name

C***********************************************************************
C   begin body of program WRSCISCN
        IF (DEBUG .EQ. 2) THEN
           WRITE(*,*) 'STACK INDEX = ', STACK_INDEX
           WRITE(*,*) 'IMC_POL_COUNT = ', IMC_POL_COUNT
           WRITE(*,*) 'IMC_EMIS_UNIT = ', IMC_EMIS_UNIT
        END IF
        ALLOCATE(REL_MC(IMC_POL_COUNT))
        ALLOCATE(OPMOD(IMC_POL_COUNT))
        ALLOCATE(POLNAME_INDEX(NUM_OF_POL(STACK_INDEX)))
        ALLOCATE(UNITCONVERTYN(NUM_OF_POL(STACK_INDEX)))
        ALLOCATE(CONVERTUNITRATIO(NUM_OF_POL(STACK_INDEX)))

        FIRST_TIME = .FALSE.

        ! Rearrange the following code
        XREL = X_COORD(STACK_INDEX) / 1000.0 
        YREL = Y_COORD(STACK_INDEX) / 1000.0
        ZREL = STK_HT(STACK_INDEX)
        SCN_SIZE = STK_DM(STACK_INDEX)
        WMOM = STK_VE(STACK_INDEX)
        BUOY = STK_ET(STACK_INDEX) - 273.0

        ! Following variables are constants
        CMASS = 1.0
        TDUR = 1.0
        RELTYP = " 'CSPR'"
        RELMAT = " 'TRAC            '"
        SIGX = 0.0
        SIGY = 0.0
        SIGZ = 0.0
        SUBGROUP = 1
        LOGNORM_MMD = -1.0e36
        LOGNORM_SIGMA = -1.0e36
        NUMBER_RANDOM = -65535
        RANDOM_SPREAD = -1.0e36
        SCN_RANDOM_SEED = -65535
        UREL = 0.0
        VREL = 0.0
        WREL = 0.0

        ! Initialized NAME_REL then put ' ' around it
        NAME_REL(1:1) = "'"
        DO I = 2, 81
           NAME_REL(I:I) = " "
        END DO
        NAME_REL(82:82) = "'"

        ! Find out POLNAME from IMC_SPECNAME
        POLNAME_INDEX = 0
        UNITCONVERTYN = .FALSE.
        DO I = 1, NUM_OF_POL(STACK_INDEX)
           DO J = 1, IMC_POL_COUNT
              IF (POLNAME(STACK_INDEX,I) .EQ. IMC_SPECNAME(J)) THEN
                 WRITE(*,*) 'Found species name ', TRIM(POLNAME(STACK_INDEX,I)), ' at position of ', J
                 POLNAME_INDEX(I) = J
                 write(*,*) 'POLNAME_INDEX = ', POLNAME_INDEX(I)
                 EXIT
              END IF
           END DO
        END DO

        DO I = 1, NUM_OF_POL(STACK_INDEX)
           IF (POLNAME_INDEX(I) .EQ. 0) THEN
              WRITE(*,*) 'WARNNING!!!! species name ', TRIM(POLNAME(STACK_INDEX,I)), 
     &    ' does not match SCICHEM input file'
              WRITE(*,*) ' This ', TRIM(POLNAME(STACK_INDEX,I)), 
     &    ' will not be included.'
           END IF
        END DO
        ! Write out dynamic format string for REL_MC and OPMOD
        WRITE(STR_FORMAT_RELMC,94070) '(',IMC_POL_COUNT,"(F10.5,','))"
        WRITE(STR_FORMAT_OPMOD,94070) '(',IMC_POL_COUNT,"(I3,','))"

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!! Main block to write to SCN file
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        CONVERTUNITRATIO = 1.0
        DO K = 1, NUM_OF_POL(STACK_INDEX)
           ! Determine if we need convert the unit or not
           ! Convert daily amount from emis input unit to IMC unit
           CALL ADDPOL(POLNAME(STACK_INDEX,K), POL_POSITION)
           OLD_UNIT = EMIS_UNIT(STACK_INDEX,POL_POSITION)
           CALL UPCASE(OLD_UNIT)
           NEW_UNIT = IMC_EMIS_UNIT
           CALL UPCASE(NEW_UNIT)
           ! Parse the OLD_UNIT into mass and time
           CALL PARSEUNIT(OLD_UNIT,OLDUNITMASS,OLDUNITTIME)
           CALL PARSEUNIT(NEW_UNIT,NEWUNITMASS,NEWUNITTIME)
           ! Compare the result to determine if they are same or not
           IF ((OLDUNITMASS .NE. NEWUNITMASS) .OR. (OLDUNITTIME .NE. NEWUNITTIME)) THEN
              UNITCONVERTYN(K) = .TRUE.
              CALL MASSCONVERT(OLDUNITMASS,NEWUNITMASS,IMC_MOLEWEIGHT(POLNAME_INDEX(K)),MASS_RATIO)
              CALL TIMECONVERT(OLDUNITTIME,NEWUNITTIME,TIME_RATIO)
              CONVERTUNITRATIO(K) = MASS_RATIO / TIME_RATIO
              IF (DEBUG .EQ. 2 ) THEN
                 WRITE(*,*) 'POLNAME = ', POLNAME(STACK_INDEX,K)
                 WRITE(*,*) 'OLD_UNIT = ', OLD_UNIT
                 WRITE(*,*) 'OLDUNITMASS = ', OLDUNITMASS
                 WRITE(*,*) 'OLDUNITTIME = ', OLDUNITTIME
                 WRITE(*,*) 'NEW_UNIT = ', NEW_UNIT
                 WRITE(*,*) 'NEWUNITMASS = ', NEWUNITMASS
                 WRITE(*,*) 'NEWUNITTIME = ', NEWUNITTIME
                 WRITE(*,*) 'MASS RATIO = ', MASS_RATIO
                 WRITE(*,*) 'TIME_RATIO = ', TIME_RATIO
                 WRITE(*,*) 'CONV RATIO = ',CONVERTUNITRATIO(K)
              END IF
           END IF
        END DO

           DO I = 1, TOT_HOURS
              REL_MC = 0.
              OPMOD = 0
              ! Calculate the hourly rate
              WRITE(FDEV,*) SCN_STARTREC
              TREL = REAL(I-1)
              WRITE(STR_BUFFER,94025) ' TREL =', TREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' XREL =', XREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER) 
              WRITE(STR_BUFFER,94025) ' YREL =', YREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' ZREL =', ZREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' CMASS =', CMASS, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' SIZE =', SCN_SIZE, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' TDUR =', TDUR, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,93000) ' RELTYP =' // RELTYP // ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,93000) ' NAME_REL =  ' // NAME_REL // ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,93000) ' RELMAT = ' // RELMAT // ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' SIGX =', SIGX, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' SIGY =', SIGY, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' SIGZ =', SIGZ, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94015) ' SUBGROUP =', SUBGROUP, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94035) ' LOGNORM_MMD =', LOGNORM_MMD, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER) 
              WRITE(STR_BUFFER,94035) ' LOGNORM_SIGMA =', LOGNORM_SIGMA, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94015) ' NUMBER_RANDOM =', NUMBER_RANDOM, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94035) ' RANDOM_SPREAD =', RANDOM_SPREAD, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' HORIZ_UNCERTAINTY =', HORIZ_UNCERTAINTY, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' VERT_UNCERTAINTY =', VERT_UNCERTAINTY, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94015) ' RANDOM_SEED =', SCN_RANDOM_SEED, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' UREL =', UREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' VREL =', VREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' WREL =', WREL, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' WMOM =', WMOM, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_BUFFER,94025) ' BUOY =', BUOY, ','
              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              ! Get REL_MC
              DO J = 1, NUM_OF_POL(STACK_INDEX)
                 CALL ADDPOL(POLNAME(STACK_INDEX,J), POL_POSITION)
                 REL_INDEX = POLNAME_INDEX(J)
                 REL_MC(REL_INDEX) = DAILY_EMIS(STACK_INDEX,POL_POSITION)
     &            * CONVERTUNITRATIO(J) * HR_RATIO(STACK_INDEX,POL_POSITION,I)
              END DO
              WRITE(STR_REL_MC,STR_FORMAT_RELMC) (REL_MC(K),K=1,IMC_POL_COUNT)
              WRITE(STR_BUFFER2,93000)' REL_MC = ' // TRIM(STR_REL_MC)
              WRITE(STR_OUT_RELMC,94080) '(A',LEN_TRIM(STR_BUFFER2),')'
              WRITE(FDEV,STR_OUT_RELMC) STR_BUFFER2
              WRITE(STR_BUFFER,94015) ' OPID = ', OPID, ','
c              WRITE(FDEV,93000) TRIM(STR_BUFFER)
              WRITE(STR_OPMOD,STR_FORMAT_OPMOD) (OPMOD(K),K=1,IMC_POL_COUNT)
              WRITE(STR_BUFFER2,93000)' OPMOD = ' // TRIM(STR_OPMOD)
              WRITE(STR_OUT_OPMOD,94070) '(A',LEN_TRIM(STR_BUFFER2),')'
c              WRITE(FDEV,STR_OUT_OPMOD) STR_BUFFER2
              WRITE(FDEV,93000) SCN_ENDREC
           END DO
           CLOSE(FDEV)


        RETURN

C******************  FORMAT  STATEMENTS   ******************************
C...........   Formatted file I/O formats............ 93xxx
93000   FORMAT(A)

C...........   Internal buffering formats............ 94xxx
94010   FORMAT( 10( A, :, I8, :, 1X ) )
94015   FORMAT(A, I8, A)
94020   FORMAT( 10( A, :, F14.6, :, 1X ) )
94025   FORMAT(A, F14.6, A)
94030   FORMAT( 10( A, :, E10.3, :, 1X ) )
94035   FORMAT( A, E10.1, A )
94040   FORMAT(F9.4, :, 1X, :, A)
94060   FORMAT(23(F10.5,','),F10.5)
#94070   FORMAT(10(A, :, I3.3))
94070   FORMAT(10(A, :, I3))
94080   FORMAT(10(A, :, I5))

        END SUBROUTINE WRSCISCN
