#!/bin/csh -f

set log = $0.log
cat $0 >! $log
uname -a >> $log
date >> $log

set DIR = /work/ROMO/users/kpc/util/mkemis1.1

setenv PROMPTFLAG       Y
setenv IOAPI_ISPH       6370000
setenv EMISINPUT        $DIR/emission_4TVA1_latlong.txt
setenv GRIDDESC         $DIR/GRIDDESC
setenv USA340_SURG      $DIR/USA_340_NOFILL_12US1_444X336.txt
setenv CAMX_FILE        $DIR/ptsr.99181.4TVA1.camx.bin
if (-e $CAMX_FILE) rm -f $CAMX_FILE

./create_pt_emission.x  << EOF >>& $log
CAMX
LATLONG

N

$CAMX_FILE

EOF

