
!------------------------------------------------------------------------!
!  The Community Multiscale Air Quality (CMAQ) system software is in     !
!  continuous development by various groups and is based on information  !
!  from these groups: Federal Government employees, contractors working  !
!  within a United States Government contract, and non-Federal sources   !
!  including research institutions.  These groups give the Government    !
!  permission to use, prepare derivative works of, and distribute copies !
!  of their work in the CMAQ system to the public and to permit others   !
!  to do so.  The United States Environmental Protection Agency          !
!  therefore grants similar permission to use the CMAQ system software,  !
!  but users are requested to provide copies of derivative works or      !
!  products designed to operate in the CMAQ system to the United States  !
!  Government without restrictions as to use by others.  Software        !
!  that is used with the CMAQ system but distributed under the GNU       !
!  General Public License or the GNU Lesser General Public License is    !
!  subject to their copyright restrictions.                              !
!------------------------------------------------------------------------!

      SUBROUTINE HRRATES

C***********************************************************************
C
C  FUNCTION: To calculate rates of reactions
C
C  PRECONDITIONS: For the CB6R3M_AE7_KMTBR mechanism
C
C  KEY SUBROUTINES/FUNCTIONS CALLED: None
C
C  REVISION HISTORY: Created by EBI solver program, Jan  9, 2020
C
C***********************************************************************
      USE HRDATA

      IMPLICIT NONE

C.....INCLUDES: NONE


C.....ARGUMENTS: NONE


C.....PARAMETERS: NONE


C.....EXTERNAL FUNCTIONS: NONE


C.....SAVED VARIABLES: NONE
!     CHARACTER( 16 ), SAVE  ::  PNAME = 'HRRATES'   ! Program name


C.....LOCAL VARIABLES: None

C***********************************************************************
C..NOTE: RXRAT commented out are not referenced by any routine
!     RXRAT(      1 ) = RKI(     1 ) * YC(  NO2 )
!     RXRAT(      2 ) = RKI(     2 ) * YC(  O )
!     RXRAT(      3 ) = RKI(     3 ) * YC(  O3 ) * YC(  NO )
!     RXRAT(      4 ) = RKI(     4 ) * YC(  O ) * YC(  NO )
!     RXRAT(      5 ) = RKI(     5 ) * YC(  O ) * YC(  NO2 )
      RXRAT(      6 ) = RKI(     6 ) * YC(  O ) * YC(  NO2 )
!     RXRAT(      7 ) = RKI(     7 ) * YC(  O ) * YC(  O3 )
      RXRAT(      8 ) = RKI(     8 ) * YC(  O3 )
      RXRAT(      9 ) = RKI(     9 ) * YC(  O3 )
!     RXRAT(     10 ) = RKI(    10 ) * YC(  O1D )
!     RXRAT(     11 ) = RKI(    11 ) * YC(  O1D )
!     RXRAT(     12 ) = RKI(    12 ) * YC(  O3 ) * YC(  OH )
!     RXRAT(     13 ) = RKI(    13 ) * YC(  O3 ) * YC(  HO2 )
!     RXRAT(     14 ) = RKI(    14 ) * YC(  OH ) * YC(  O )
!     RXRAT(     15 ) = RKI(    15 ) * YC(  HO2 ) * YC(  O )
      RXRAT(     16 ) = RKI(    16 ) * YC(  OH ) * YC(  OH )
      RXRAT(     17 ) = RKI(    17 ) * YC(  OH ) * YC(  OH )
!     RXRAT(     18 ) = RKI(    18 ) * YC(  OH ) * YC(  HO2 )
      RXRAT(     19 ) = RKI(    19 ) * YC(  HO2 ) * YC(  HO2 )
      RXRAT(     20 ) = RKI(    20 ) * YC(  HO2 ) * YC(  HO2 )
      RXRAT(     21 ) = RKI(    21 ) * YC(  H2O2 )
      RXRAT(     22 ) = RKI(    22 ) * YC(  H2O2 ) * YC(  OH )
      RXRAT(     23 ) = RKI(    23 ) * YC(  H2O2 ) * YC(  O )
!     RXRAT(     24 ) = RKI(    24 ) * YC(  NO ) * YC(  NO )
!     RXRAT(     25 ) = RKI(    25 ) * YC(  HO2 ) * YC(  NO )
      RXRAT(     26 ) = RKI(    26 ) * YC(  NO2 ) * YC(  O3 )
      RXRAT(     27 ) = RKI(    27 ) * YC(  NO3 )
      RXRAT(     28 ) = RKI(    28 ) * YC(  NO3 )
      RXRAT(     29 ) = RKI(    29 ) * YC(  NO3 ) * YC(  NO )
      RXRAT(     30 ) = RKI(    30 ) * YC(  NO3 ) * YC(  NO2 )
      RXRAT(     31 ) = RKI(    31 ) * YC(  NO3 ) * YC(  O )
      RXRAT(     32 ) = RKI(    32 ) * YC(  NO3 ) * YC(  OH )
      RXRAT(     33 ) = RKI(    33 ) * YC(  NO3 ) * YC(  HO2 )
      RXRAT(     34 ) = RKI(    34 ) * YC(  NO3 ) * YC(  O3 )
      RXRAT(     35 ) = RKI(    35 ) * YC(  NO3 ) * YC(  NO3 )
!     RXRAT(     36 ) = RKI(    36 ) * YC(  NO3 ) * YC(  NO2 )
      RXRAT(     37 ) = RKI(    37 ) * YC(  N2O5 )
      RXRAT(     38 ) = RKI(    38 ) * YC(  N2O5 )
      RXRAT(     39 ) = RKI(    39 ) * YC(  N2O5 )
!     RXRAT(     40 ) = RKI(    40 ) * YC(  NO ) * YC(  OH )
      RXRAT(     41 ) = RKI(    41 ) * YC(  NO ) * YC(  NO2 )
      RXRAT(     42 ) = RKI(    42 ) * YC(  HONO ) * YC(  HONO )
      RXRAT(     43 ) = RKI(    43 ) * YC(  HONO )
      RXRAT(     44 ) = RKI(    44 ) * YC(  HONO ) * YC(  OH )
      RXRAT(     45 ) = RKI(    45 ) * YC(  NO2 ) * YC(  OH )
      RXRAT(     46 ) = RKI(    46 ) * YC(  HNO3 ) * YC(  OH )
      RXRAT(     47 ) = RKI(    47 ) * YC(  HNO3 )
!     RXRAT(     48 ) = RKI(    48 ) * YC(  HO2 ) * YC(  NO2 )
      RXRAT(     49 ) = RKI(    49 ) * YC(  PNA )
      RXRAT(     50 ) = RKI(    50 ) * YC(  PNA )
      RXRAT(     51 ) = RKI(    51 ) * YC(  PNA ) * YC(  OH )
      RXRAT(     52 ) = RKI(    52 ) * YC(  SO2 ) * YC(  OH )
      RXRAT(     53 ) = RKI(    53 ) * YC(  C2O3 ) * YC(  NO )
!     RXRAT(     54 ) = RKI(    54 ) * YC(  C2O3 ) * YC(  NO2 )
      RXRAT(     55 ) = RKI(    55 ) * YC(  PAN )
      RXRAT(     56 ) = RKI(    56 ) * YC(  PAN )
      RXRAT(     57 ) = RKI(    57 ) * YC(  C2O3 ) * YC(  HO2 )
      RXRAT(     58 ) = RKI(    58 ) * YC(  C2O3 ) * YC(  RO2 )
      RXRAT(     59 ) = RKI(    59 ) * YC(  C2O3 ) * YC(  C2O3 )
      RXRAT(     60 ) = RKI(    60 ) * YC(  C2O3 ) * YC(  CXO3 )
      RXRAT(     61 ) = RKI(    61 ) * YC(  CXO3 ) * YC(  NO )
      RXRAT(     62 ) = RKI(    62 ) * YC(  CXO3 ) * YC(  NO2 )
      RXRAT(     63 ) = RKI(    63 ) * YC(  PANX )
      RXRAT(     64 ) = RKI(    64 ) * YC(  PANX )
      RXRAT(     65 ) = RKI(    65 ) * YC(  CXO3 ) * YC(  HO2 )
      RXRAT(     66 ) = RKI(    66 ) * YC(  CXO3 ) * YC(  RO2 )
      RXRAT(     67 ) = RKI(    67 ) * YC(  CXO3 ) * YC(  CXO3 )
      RXRAT(     68 ) = RKI(    68 ) * YC(  RO2 ) * YC(  NO )
      RXRAT(     69 ) = RKI(    69 ) * YC(  RO2 ) * YC(  HO2 )
      RXRAT(     70 ) = RKI(    70 ) * YC(  RO2 ) * YC(  RO2 )
      RXRAT(     71 ) = RKI(    71 ) * YC(  MEO2 ) * YC(  NO )
      RXRAT(     72 ) = RKI(    72 ) * YC(  MEO2 ) * YC(  HO2 )
      RXRAT(     73 ) = RKI(    73 ) * YC(  MEO2 ) * YC(  C2O3 )
      RXRAT(     74 ) = RKI(    74 ) * YC(  MEO2 ) * YC(  RO2 )
      RXRAT(     75 ) = RKI(    75 ) * YC(  XO2H ) * YC(  NO )
      RXRAT(     76 ) = RKI(    76 ) * YC(  XO2H ) * YC(  HO2 )
      RXRAT(     77 ) = RKI(    77 ) * YC(  XO2H ) * YC(  C2O3 )
      RXRAT(     78 ) = RKI(    78 ) * YC(  XO2H ) * YC(  RO2 )
      RXRAT(     79 ) = RKI(    79 ) * YC(  XO2 ) * YC(  NO )
      RXRAT(     80 ) = RKI(    80 ) * YC(  XO2 ) * YC(  HO2 )
      RXRAT(     81 ) = RKI(    81 ) * YC(  XO2 ) * YC(  C2O3 )
      RXRAT(     82 ) = RKI(    82 ) * YC(  XO2 ) * YC(  RO2 )
      RXRAT(     83 ) = RKI(    83 ) * YC(  XO2N ) * YC(  NO )
      RXRAT(     84 ) = RKI(    84 ) * YC(  XO2N ) * YC(  HO2 )
      RXRAT(     85 ) = RKI(    85 ) * YC(  XO2N ) * YC(  C2O3 )
      RXRAT(     86 ) = RKI(    86 ) * YC(  XO2N ) * YC(  RO2 )
      RXRAT(     87 ) = RKI(    87 ) * YC(  MEPX ) * YC(  OH )
      RXRAT(     88 ) = RKI(    88 ) * YC(  MEPX )
      RXRAT(     89 ) = RKI(    89 ) * YC(  ROOH ) * YC(  OH )
      RXRAT(     90 ) = RKI(    90 ) * YC(  ROOH )
      RXRAT(     91 ) = RKI(    91 ) * YC(  NTR1 ) * YC(  OH )
      RXRAT(     92 ) = RKI(    92 ) * YC(  NTR1 )
      RXRAT(     93 ) = RKI(    93 ) * YC(  FACD ) * YC(  OH )
      RXRAT(     94 ) = RKI(    94 ) * YC(  AACD ) * YC(  OH )
      RXRAT(     95 ) = RKI(    95 ) * YC(  PACD ) * YC(  OH )
      RXRAT(     96 ) = RKI(    96 ) * YC(  FORM ) * YC(  OH )
      RXRAT(     97 ) = RKI(    97 ) * YC(  FORM )
      RXRAT(     98 ) = RKI(    98 ) * YC(  FORM )
      RXRAT(     99 ) = RKI(    99 ) * YC(  FORM ) * YC(  O )
      RXRAT(    100 ) = RKI(   100 ) * YC(  FORM ) * YC(  NO3 )
      RXRAT(    101 ) = RKI(   101 ) * YC(  FORM ) * YC(  HO2 )
      RXRAT(    102 ) = RKI(   102 ) * YC(  HCO3 )
      RXRAT(    103 ) = RKI(   103 ) * YC(  HCO3 ) * YC(  NO )
      RXRAT(    104 ) = RKI(   104 ) * YC(  HCO3 ) * YC(  HO2 )
      RXRAT(    105 ) = RKI(   105 ) * YC(  ALD2 ) * YC(  O )
      RXRAT(    106 ) = RKI(   106 ) * YC(  ALD2 ) * YC(  OH )
      RXRAT(    107 ) = RKI(   107 ) * YC(  ALD2 ) * YC(  NO3 )
      RXRAT(    108 ) = RKI(   108 ) * YC(  ALD2 )
      RXRAT(    109 ) = RKI(   109 ) * YC(  ALDX ) * YC(  O )
      RXRAT(    110 ) = RKI(   110 ) * YC(  ALDX ) * YC(  OH )
      RXRAT(    111 ) = RKI(   111 ) * YC(  ALDX ) * YC(  NO3 )
      RXRAT(    112 ) = RKI(   112 ) * YC(  ALDX )
      RXRAT(    113 ) = RKI(   113 ) * YC(  GLYD ) * YC(  OH )
      RXRAT(    114 ) = RKI(   114 ) * YC(  GLYD )
      RXRAT(    115 ) = RKI(   115 ) * YC(  GLYD ) * YC(  NO3 )
      RXRAT(    116 ) = RKI(   116 ) * YC(  GLY ) * YC(  OH )
      RXRAT(    117 ) = RKI(   117 ) * YC(  GLY )
      RXRAT(    118 ) = RKI(   118 ) * YC(  GLY ) * YC(  NO3 )
      RXRAT(    119 ) = RKI(   119 ) * YC(  MGLY )
      RXRAT(    120 ) = RKI(   120 ) * YC(  MGLY ) * YC(  NO3 )
      RXRAT(    121 ) = RKI(   121 ) * YC(  MGLY ) * YC(  OH )
!     RXRAT(    122 ) = RKI(   122 ) * YC(  OH )
      RXRAT(    123 ) = RKI(   123 ) * YC(  CO ) * YC(  OH )
      RXRAT(    124 ) = RKI(   124 ) * YC(  OH )
      RXRAT(    125 ) = RKI(   125 ) * YC(  ETHA ) * YC(  OH )
      RXRAT(    126 ) = RKI(   126 ) * YC(  MEOH ) * YC(  OH )
      RXRAT(    127 ) = RKI(   127 ) * YC(  ETOH ) * YC(  OH )
      RXRAT(    128 ) = RKI(   128 ) * YC(  KET )
      RXRAT(    129 ) = RKI(   129 ) * YC(  ACET )
      RXRAT(    130 ) = RKI(   130 ) * YC(  ACET ) * YC(  OH )
      RXRAT(    131 ) = RKI(   131 ) * YC(  PRPA ) * YC(  OH )
      RXRAT(    132 ) = RKI(   132 ) * YC(  PAR ) * YC(  OH )
      RXRAT(    133 ) = RKI(   133 ) * YC(  ROR )
      RXRAT(    134 ) = RKI(   134 ) * YC(  ROR )
      RXRAT(    135 ) = RKI(   135 ) * YC(  ROR ) * YC(  NO2 )
      RXRAT(    136 ) = RKI(   136 ) * YC(  ETHY ) * YC(  OH )
      RXRAT(    137 ) = RKI(   137 ) * YC(  ETH ) * YC(  O )
      RXRAT(    138 ) = RKI(   138 ) * YC(  ETH ) * YC(  OH )
      RXRAT(    139 ) = RKI(   139 ) * YC(  ETH ) * YC(  O3 )
      RXRAT(    140 ) = RKI(   140 ) * YC(  ETH ) * YC(  NO3 )
      RXRAT(    141 ) = RKI(   141 ) * YC(  OLE ) * YC(  O )
      RXRAT(    142 ) = RKI(   142 ) * YC(  OLE ) * YC(  OH )
      RXRAT(    143 ) = RKI(   143 ) * YC(  OLE ) * YC(  O3 )
      RXRAT(    144 ) = RKI(   144 ) * YC(  OLE ) * YC(  NO3 )
      RXRAT(    145 ) = RKI(   145 ) * YC(  IOLE ) * YC(  O )
      RXRAT(    146 ) = RKI(   146 ) * YC(  IOLE ) * YC(  OH )
      RXRAT(    147 ) = RKI(   147 ) * YC(  IOLE ) * YC(  O3 )
      RXRAT(    148 ) = RKI(   148 ) * YC(  IOLE ) * YC(  NO3 )
      RXRAT(    149 ) = RKI(   149 ) * YC(  ISOP ) * YC(  OH )
      RXRAT(    150 ) = RKI(   150 ) * YC(  ISOP ) * YC(  O )
      RXRAT(    151 ) = RKI(   151 ) * YC(  ISO2 ) * YC(  NO )
      RXRAT(    152 ) = RKI(   152 ) * YC(  ISO2 ) * YC(  HO2 )
      RXRAT(    153 ) = RKI(   153 ) * YC(  ISO2 ) * YC(  C2O3 )
      RXRAT(    154 ) = RKI(   154 ) * YC(  ISO2 ) * YC(  RO2 )
      RXRAT(    155 ) = RKI(   155 ) * YC(  ISO2 )
      RXRAT(    156 ) = RKI(   156 ) * YC(  ISOP ) * YC(  O3 )
      RXRAT(    157 ) = RKI(   157 ) * YC(  ISOP ) * YC(  NO3 )
      RXRAT(    158 ) = RKI(   158 ) * YC(  ISPD ) * YC(  OH )
      RXRAT(    159 ) = RKI(   159 ) * YC(  ISPD ) * YC(  O3 )
      RXRAT(    160 ) = RKI(   160 ) * YC(  ISPD ) * YC(  NO3 )
      RXRAT(    161 ) = RKI(   161 ) * YC(  ISPD )
      RXRAT(    162 ) = RKI(   162 ) * YC(  ISPX ) * YC(  OH )
      RXRAT(    163 ) = RKI(   163 ) * YC(  HPLD )
      RXRAT(    164 ) = RKI(   164 ) * YC(  HPLD ) * YC(  NO3 )
      RXRAT(    165 ) = RKI(   165 ) * YC(  EPOX ) * YC(  OH )
      RXRAT(    166 ) = RKI(   166 ) * YC(  EPX2 ) * YC(  HO2 )
      RXRAT(    167 ) = RKI(   167 ) * YC(  EPX2 ) * YC(  NO )
      RXRAT(    168 ) = RKI(   168 ) * YC(  EPX2 ) * YC(  C2O3 )
      RXRAT(    169 ) = RKI(   169 ) * YC(  EPX2 ) * YC(  RO2 )
      RXRAT(    170 ) = RKI(   170 ) * YC(  INTR ) * YC(  OH )
      RXRAT(    171 ) = RKI(   171 ) * YC(  TERP ) * YC(  O )
      RXRAT(    172 ) = RKI(   172 ) * YC(  TERP ) * YC(  OH )
      RXRAT(    173 ) = RKI(   173 ) * YC(  TERP ) * YC(  O3 )
      RXRAT(    174 ) = RKI(   174 ) * YC(  TERP ) * YC(  NO3 )
      RXRAT(    175 ) = RKI(   175 ) * YC(  APIN ) * YC(  O )
      RXRAT(    176 ) = RKI(   176 ) * YC(  APIN ) * YC(  OH )
      RXRAT(    177 ) = RKI(   177 ) * YC(  APIN ) * YC(  O3 )
      RXRAT(    178 ) = RKI(   178 ) * YC(  APIN ) * YC(  NO3 )
      RXRAT(    179 ) = RKI(   179 ) * YC(  BENZENE ) * YC(  OH )
      RXRAT(    180 ) = RKI(   180 ) * YC(  BZO2 ) * YC(  NO )
      RXRAT(    181 ) = RKI(   181 ) * YC(  BZO2 ) * YC(  C2O3 )
      RXRAT(    182 ) = RKI(   182 ) * YC(  BZO2 ) * YC(  HO2 )
      RXRAT(    183 ) = RKI(   183 ) * YC(  BZO2 ) * YC(  RO2 )
      RXRAT(    184 ) = RKI(   184 ) * YC(  TOL ) * YC(  OH )
      RXRAT(    185 ) = RKI(   185 ) * YC(  TO2 ) * YC(  NO )
      RXRAT(    186 ) = RKI(   186 ) * YC(  TO2 ) * YC(  C2O3 )
      RXRAT(    187 ) = RKI(   187 ) * YC(  TO2 ) * YC(  HO2 )
      RXRAT(    188 ) = RKI(   188 ) * YC(  TO2 ) * YC(  RO2 )
      RXRAT(    189 ) = RKI(   189 ) * YC(  XYLMN ) * YC(  OH )
      RXRAT(    190 ) = RKI(   190 ) * YC(  NAPH ) * YC(  OH )
      RXRAT(    191 ) = RKI(   191 ) * YC(  XLO2 ) * YC(  NO )
      RXRAT(    192 ) = RKI(   192 ) * YC(  XLO2 ) * YC(  HO2 )
      RXRAT(    193 ) = RKI(   193 ) * YC(  XLO2 ) * YC(  C2O3 )
      RXRAT(    194 ) = RKI(   194 ) * YC(  XLO2 ) * YC(  RO2 )
      RXRAT(    195 ) = RKI(   195 ) * YC(  CRES ) * YC(  OH )
      RXRAT(    196 ) = RKI(   196 ) * YC(  CRES ) * YC(  NO3 )
      RXRAT(    197 ) = RKI(   197 ) * YC(  CRO ) * YC(  NO2 )
      RXRAT(    198 ) = RKI(   198 ) * YC(  CRO ) * YC(  HO2 )
      RXRAT(    199 ) = RKI(   199 ) * YC(  CRON ) * YC(  OH )
      RXRAT(    200 ) = RKI(   200 ) * YC(  CRON ) * YC(  NO3 )
      RXRAT(    201 ) = RKI(   201 ) * YC(  CRON )
      RXRAT(    202 ) = RKI(   202 ) * YC(  XOPN )
      RXRAT(    203 ) = RKI(   203 ) * YC(  XOPN ) * YC(  OH )
      RXRAT(    204 ) = RKI(   204 ) * YC(  XOPN ) * YC(  O3 )
      RXRAT(    205 ) = RKI(   205 ) * YC(  XOPN ) * YC(  NO3 )
      RXRAT(    206 ) = RKI(   206 ) * YC(  OPEN )
      RXRAT(    207 ) = RKI(   207 ) * YC(  OPEN ) * YC(  OH )
      RXRAT(    208 ) = RKI(   208 ) * YC(  OPEN ) * YC(  O3 )
      RXRAT(    209 ) = RKI(   209 ) * YC(  OPEN ) * YC(  NO3 )
      RXRAT(    210 ) = RKI(   210 ) * YC(  CAT1 ) * YC(  OH )
      RXRAT(    211 ) = RKI(   211 ) * YC(  CAT1 ) * YC(  NO3 )
      RXRAT(    212 ) = RKI(   212 ) * YC(  OPO3 ) * YC(  NO )
      RXRAT(    213 ) = RKI(   213 ) * YC(  OPO3 ) * YC(  NO2 )
      RXRAT(    214 ) = RKI(   214 ) * YC(  OPAN )
      RXRAT(    215 ) = RKI(   215 ) * YC(  OPO3 ) * YC(  HO2 )
      RXRAT(    216 ) = RKI(   216 ) * YC(  OPO3 ) * YC(  C2O3 )
      RXRAT(    217 ) = RKI(   217 ) * YC(  OPO3 ) * YC(  RO2 )
      RXRAT(    218 ) = RKI(   218 ) * YC(  OPAN ) * YC(  OH )
      RXRAT(    219 ) = RKI(   219 ) * YC(  PANX ) * YC(  OH )
      RXRAT(    220 ) = RKI(   220 ) * YC(  ECH4 ) * YC(  OH )
      RXRAT(    221 ) = RKI(   221 ) * YC(  XPRP )
      RXRAT(    222 ) = RKI(   222 ) * YC(  XPRP )
      RXRAT(    223 ) = RKI(   223 ) * YC(  XPAR )
      RXRAT(    224 ) = RKI(   224 ) * YC(  XPAR )
      RXRAT(    225 ) = RKI(   225 ) * YC(  CL2 )
      RXRAT(    226 ) = RKI(   226 ) * YC(  HOCL )
      RXRAT(    227 ) = RKI(   227 ) * YC(  CL ) * YC(  O3 )
      RXRAT(    228 ) = RKI(   228 ) * YC(  CLO ) * YC(  CLO )
      RXRAT(    229 ) = RKI(   229 ) * YC(  CLO ) * YC(  NO )
      RXRAT(    230 ) = RKI(   230 ) * YC(  CLO ) * YC(  HO2 )
      RXRAT(    231 ) = RKI(   231 ) * YC(  CLO ) * YC(  MEO2 )
      RXRAT(    232 ) = RKI(   232 ) * YC(  OH ) * YC(  FMCL )
      RXRAT(    233 ) = RKI(   233 ) * YC(  FMCL )
      RXRAT(    234 ) = RKI(   234 ) * YC(  CL )
      RXRAT(    235 ) = RKI(   235 ) * YC(  CL ) * YC(  PAR )
      RXRAT(    236 ) = RKI(   236 ) * YC(  CL ) * YC(  PRPA )
      RXRAT(    237 ) = RKI(   237 ) * YC(  CL ) * YC(  ETHA )
      RXRAT(    238 ) = RKI(   238 ) * YC(  CL ) * YC(  ETH )
      RXRAT(    239 ) = RKI(   239 ) * YC(  CL ) * YC(  OLE )
      RXRAT(    240 ) = RKI(   240 ) * YC(  CL ) * YC(  IOLE )
      RXRAT(    241 ) = RKI(   241 ) * YC(  CL ) * YC(  ISOP )
      RXRAT(    242 ) = RKI(   242 ) * YC(  CL ) * YC(  FORM )
      RXRAT(    243 ) = RKI(   243 ) * YC(  CL ) * YC(  ALD2 )
      RXRAT(    244 ) = RKI(   244 ) * YC(  CL ) * YC(  ALDX )
      RXRAT(    245 ) = RKI(   245 ) * YC(  CL ) * YC(  MEOH )
      RXRAT(    246 ) = RKI(   246 ) * YC(  CL ) * YC(  ETOH )
      RXRAT(    247 ) = RKI(   247 ) * YC(  HCL ) * YC(  OH )
      RXRAT(    248 ) = RKI(   248 ) * YC(  CL ) * YC(  TOL )
      RXRAT(    249 ) = RKI(   249 ) * YC(  CL ) * YC(  XYLMN )
      RXRAT(    250 ) = RKI(   250 ) * YC(  CL ) * YC(  NAPH )
      RXRAT(    251 ) = RKI(   251 ) * YC(  CLNO2 )
      RXRAT(    252 ) = RKI(   252 ) * YC(  CLO ) * YC(  NO2 )
      RXRAT(    253 ) = RKI(   253 ) * YC(  CLNO3 )
      RXRAT(    254 ) = RKI(   254 ) * YC(  CLNO3 )
      RXRAT(    255 ) = RKI(   255 ) * YC(  CLNO3 )
      RXRAT(    256 ) = RKI(   256 ) * YC(  TOLRO2 ) * YC(  NO )
      RXRAT(    257 ) = RKI(   257 ) * YC(  TOLRO2 ) * YC(  HO2 )
      RXRAT(    258 ) = RKI(   258 ) * YC(  XYLRO2 ) * YC(  NO )
      RXRAT(    259 ) = RKI(   259 ) * YC(  XYLRO2 ) * YC(  HO2 )
      RXRAT(    260 ) = RKI(   260 ) * YC(  BENZRO2 ) * YC(  NO )
      RXRAT(    261 ) = RKI(   261 ) * YC(  BENZRO2 ) * YC(  HO2 )
      RXRAT(    262 ) = RKI(   262 ) * YC(  SESQ ) * YC(  O3 )
      RXRAT(    263 ) = RKI(   263 ) * YC(  SESQ ) * YC(  OH )
      RXRAT(    264 ) = RKI(   264 ) * YC(  SESQ ) * YC(  NO3 )
      RXRAT(    265 ) = RKI(   265 ) * YC(  PAHRO2 ) * YC(  NO )
      RXRAT(    266 ) = RKI(   266 ) * YC(  PAHRO2 ) * YC(  HO2 )
      RXRAT(    267 ) = RKI(   267 ) * YC(  SOAALK ) * YC(  OH )
      RXRAT(    268 ) = RKI(   268 ) * YC(  NTR2 )
      RXRAT(    269 ) = RKI(   269 ) * YC(  N2O5 )
      RXRAT(    270 ) = RKI(   270 ) * YC(  N2O5 )
      RXRAT(    271 ) = RKI(   271 ) * YC(  H2NO3PIJ )
      RXRAT(    272 ) = RKI(   272 ) * YC(  H2NO3PK )
      RXRAT(    273 ) = RKI(   273 ) * YC(  H2NO3PIJ ) * YC(  ACLI )
      RXRAT(    274 ) = RKI(   274 ) * YC(  H2NO3PIJ ) * YC(  ACLJ )
      RXRAT(    275 ) = RKI(   275 ) * YC(  H2NO3PK ) * YC(  ACLK )
      RXRAT(    276 ) = RKI(   276 ) * YC(  NO2 )
      RXRAT(    277 ) = RKI(   277 ) * YC(  EPOX )
      RXRAT(    278 ) = RKI(   278 ) * YC(  IEPOXP ) * YC(  ASO4J )
      RXRAT(    279 ) = RKI(   279 ) * YC(  IEPOXP )
      RXRAT(    280 ) = RKI(   280 ) * YC(  GLY )
      RXRAT(    281 ) = RKI(   281 ) * YC(  MGLY )
      RXRAT(    282 ) = RKI(   282 ) * YC(  TERPNRO2 ) * YC(  NO )
      RXRAT(    283 ) = RKI(   283 ) * YC(  TERPNRO2 ) * YC(  HO2 )
      RXRAT(    284 ) = RKI(   284 ) * YC(  TERPNRO2 ) * YC(  NO3 )
      RXRAT(    285 ) = RKI(   285 ) * YC(  TERPNRO2 ) * YC(  RO2 )
      RXRAT(    286 ) = RKI(   286 ) * YC(  MTNO3 ) * YC(  CL )
      RXRAT(    287 ) = RKI(   287 ) * YC(  MTNO3 ) * YC(  OH )
      RXRAT(    288 ) = RKI(   288 ) * YC(  MTNO3 )
      RXRAT(    289 ) = RKI(   289 ) * YC(  AMTNO3J )
      RXRAT(    290 ) = RKI(   290 ) * YC(  AAVB2J )
      RXRAT(    291 ) = RKI(   291 ) * YC(  AAVB3J )
      RXRAT(    292 ) = RKI(   292 ) * YC(  AAVB4J )
      RXRAT(    293 ) = RKI(   293 ) * YC(  AISO1J )
      RXRAT(    294 ) = RKI(   294 ) * YC(  AISO2J )
      RXRAT(    295 ) = RKI(   295 ) * YC(  ASQTJ )
      RXRAT(    296 ) = RKI(   296 ) * YC(  APOCI ) * YC(  OH )
      RXRAT(    297 ) = RKI(   297 ) * YC(  APNCOMI ) * YC(  OH )
      RXRAT(    298 ) = RKI(   298 ) * YC(  APOCJ ) * YC(  OH )
      RXRAT(    299 ) = RKI(   299 ) * YC(  APNCOMJ ) * YC(  OH )
      RXRAT(    300 ) = RKI(   300 ) * YC(  PCVOC ) * YC(  OH )
      RXRAT(    301 ) = RKI(   301 ) * YC(  VLVPO1 ) * YC(  OH )
      RXRAT(    302 ) = RKI(   302 ) * YC(  VSVPO1 ) * YC(  OH )
      RXRAT(    303 ) = RKI(   303 ) * YC(  VSVPO2 ) * YC(  OH )
      RXRAT(    304 ) = RKI(   304 ) * YC(  VSVPO3 ) * YC(  OH )
      RXRAT(    305 ) = RKI(   305 ) * YC(  VIVPO1 ) * YC(  OH )
      RXRAT(    306 ) = RKI(   306 ) * YC(  VLVOO1 ) * YC(  OH )
      RXRAT(    307 ) = RKI(   307 ) * YC(  VLVOO2 ) * YC(  OH )
      RXRAT(    308 ) = RKI(   308 ) * YC(  VSVOO1 ) * YC(  OH )
      RXRAT(    309 ) = RKI(   309 ) * YC(  VSVOO2 ) * YC(  OH )
      RXRAT(    310 ) = RKI(   310 ) * YC(  VSVOO3 ) * YC(  OH )
      RXRAT(    311 ) = RKI(   311 ) * YC(  FORM_PRIMARY ) * YC(  OH )
      RXRAT(    312 ) = RKI(   312 ) * YC(  FORM_PRIMARY ) * YC(  NO3 )
      RXRAT(    313 ) = RKI(   313 ) * YC(  FORM_PRIMARY ) * YC(  O )
      RXRAT(    314 ) = RKI(   314 ) * YC(  FORM_PRIMARY )
      RXRAT(    315 ) = RKI(   315 ) * YC(  FORM_PRIMARY )
      RXRAT(    316 ) = RKI(   316 ) * YC(  FORM_PRIMARY ) * YC(  CL )
      RXRAT(    317 ) = RKI(   317 ) * YC(  ALD2_PRIMARY ) * YC(  OH )
      RXRAT(    318 ) = RKI(   318 ) * YC(  ALD2_PRIMARY ) * YC(  NO3 )
      RXRAT(    319 ) = RKI(   319 ) * YC(  ALD2_PRIMARY ) * YC(  O )
      RXRAT(    320 ) = RKI(   320 ) * YC(  ALD2_PRIMARY )
      RXRAT(    321 ) = RKI(   321 ) * YC(  ALD2_PRIMARY ) * YC(  CL )
      RXRAT(    322 ) = RKI(   322 ) * YC(  BUTADIENE13 ) * YC(  OH )
      RXRAT(    323 ) = RKI(   323 ) * YC(  BUTADIENE13 ) * YC(  O3 )
      RXRAT(    324 ) = RKI(   324 ) * YC(  BUTADIENE13 ) * YC(  NO3 )
      RXRAT(    325 ) = RKI(   325 ) * YC(  BUTADIENE13 ) * YC(  CL )
      RXRAT(    326 ) = RKI(   326 ) * YC(  ACRO_PRIMARY ) * YC(  OH )
      RXRAT(    327 ) = RKI(   327 ) * YC(  ACRO_PRIMARY ) * YC(  O3 )
      RXRAT(    328 ) = RKI(   328 ) * YC(  ACRO_PRIMARY ) * YC(  NO3 )
      RXRAT(    329 ) = RKI(   329 ) * YC(  ACRO_PRIMARY )
      RXRAT(    330 ) = RKI(   330 ) * YC(  ACRO_PRIMARY ) * YC(  CL )
      RXRAT(    331 ) = RKI(   331 ) * YC(  ACROLEIN ) * YC(  OH )
      RXRAT(    332 ) = RKI(   332 ) * YC(  ACROLEIN ) * YC(  O3 )
      RXRAT(    333 ) = RKI(   333 ) * YC(  ACROLEIN ) * YC(  NO3 )
      RXRAT(    334 ) = RKI(   334 ) * YC(  ACROLEIN )
      RXRAT(    335 ) = RKI(   335 ) * YC(  ACROLEIN ) * YC(  CL )
      RXRAT(    336 ) = RKI(   336 ) * YC(  TOLU ) * YC(  OH )
      RXRAT(    337 ) = RKI(   337 ) * YC(  TOLU ) * YC(  CL )
      RXRAT(    338 ) = RKI(   338 ) * YC(  HG ) * YC(  O3 )
      RXRAT(    339 ) = RKI(   339 ) * YC(  HG ) * YC(  CL2 )
      RXRAT(    340 ) = RKI(   340 ) * YC(  HG ) * YC(  H2O2 )
      RXRAT(    341 ) = RKI(   341 ) * YC(  HG ) * YC(  OH )
      RXRAT(    342 ) = RKI(   342 ) * YC(  HG ) * YC(  CL )
      RXRAT(    343 ) = RKI(   343 ) * YC(  BR ) * YC(  O3 )
      RXRAT(    344 ) = RKI(   344 ) * YC(  BRO ) * YC(  HO2 )
      RXRAT(    345 ) = RKI(   345 ) * YC(  BR ) * YC(  HO2 )
      RXRAT(    346 ) = RKI(   346 ) * YC(  HBR ) * YC(  OH )
      RXRAT(    347 ) = RKI(   347 ) * YC(  BRO ) * YC(  BRO )
      RXRAT(    348 ) = RKI(   348 ) * YC(  BRO ) * YC(  BRO )
      RXRAT(    349 ) = RKI(   349 ) * YC(  BRO ) * YC(  NO )
      RXRAT(    350 ) = RKI(   350 ) * YC(  BR ) * YC(  BRNO3 )
      RXRAT(    351 ) = RKI(   351 ) * YC(  BR2 ) * YC(  OH )
      RXRAT(    352 ) = RKI(   352 ) * YC(  BRO ) * YC(  OH )
      RXRAT(    353 ) = RKI(   353 ) * YC(  BR ) * YC(  NO3 )
      RXRAT(    354 ) = RKI(   354 ) * YC(  BRO ) * YC(  NO2 )
      RXRAT(    355 ) = RKI(   355 ) * YC(  BR ) * YC(  NO2 )
      RXRAT(    356 ) = RKI(   356 ) * YC(  BRO ) * YC(  CLO )
      RXRAT(    357 ) = RKI(   357 ) * YC(  FORM ) * YC(  BR )
      RXRAT(    358 ) = RKI(   358 ) * YC(  ALD2 ) * YC(  BR )
      RXRAT(    359 ) = RKI(   359 ) * YC(  OLE ) * YC(  BR )
      RXRAT(    360 ) = RKI(   360 ) * YC(  ISOP ) * YC(  BR )
      RXRAT(    361 ) = RKI(   361 ) * YC(  FMBR ) * YC(  OH )
      RXRAT(    362 ) = RKI(   362 ) * YC(  BRO ) * YC(  MEO2 )
      RXRAT(    363 ) = RKI(   363 ) * YC(  CH3BR ) * YC(  OH )
      RXRAT(    364 ) = RKI(   364 ) * YC(  MB3 ) * YC(  OH )
      RXRAT(    365 ) = RKI(   365 ) * YC(  MB2 ) * YC(  OH )
      RXRAT(    366 ) = RKI(   366 ) * YC(  MB2C ) * YC(  OH )
      RXRAT(    367 ) = RKI(   367 ) * YC(  MBC2 ) * YC(  OH )
      RXRAT(    368 ) = RKI(   368 ) * YC(  MBC ) * YC(  OH )
      RXRAT(    369 ) = RKI(   369 ) * YC(  DMS ) * YC(  BRO )
      RXRAT(    370 ) = RKI(   370 ) * YC(  BR2 )
      RXRAT(    371 ) = RKI(   371 ) * YC(  HOBR )
      RXRAT(    372 ) = RKI(   372 ) * YC(  BRO )
      RXRAT(    373 ) = RKI(   373 ) * YC(  BRNO2 )
      RXRAT(    374 ) = RKI(   374 ) * YC(  BRNO3 )
      RXRAT(    375 ) = RKI(   375 ) * YC(  BRNO3 )
      RXRAT(    376 ) = RKI(   376 ) * YC(  BRCL )
      RXRAT(    377 ) = RKI(   377 ) * YC(  FMBR )
      RXRAT(    378 ) = RKI(   378 ) * YC(  MB3 )
      RXRAT(    379 ) = RKI(   379 ) * YC(  MB2C )
      RXRAT(    380 ) = RKI(   380 ) * YC(  MBC2 )
      RXRAT(    381 ) = RKI(   381 ) * YC(  BRNO3 )
      RXRAT(    382 ) = RKI(   382 ) * YC(  HOBR ) * YC(  ACLJ )
      RXRAT(    383 ) = RKI(   383 ) * YC(  HOBR ) * YC(  ABRJ )
      RXRAT(    384 ) = RKI(   384 ) * YC(  HBR )
      RXRAT(    385 ) = RKI(   385 ) * YC(  I ) * YC(  O3 )
      RXRAT(    386 ) = RKI(   386 ) * YC(  I ) * YC(  HO2 )
      RXRAT(    387 ) = RKI(   387 ) * YC(  I2 ) * YC(  OH )
      RXRAT(    388 ) = RKI(   388 ) * YC(  HI ) * YC(  OH )
      RXRAT(    389 ) = RKI(   389 ) * YC(  HOI ) * YC(  OH )
      RXRAT(    390 ) = RKI(   390 ) * YC(  IO ) * YC(  HO2 )
      RXRAT(    391 ) = RKI(   391 ) * YC(  IO ) * YC(  NO )
      RXRAT(    392 ) = RKI(   392 ) * YC(  INO ) * YC(  INO )
      RXRAT(    393 ) = RKI(   393 ) * YC(  INO2 ) * YC(  INO2 )
      RXRAT(    394 ) = RKI(   394 ) * YC(  I2 ) * YC(  NO3 )
      RXRAT(    395 ) = RKI(   395 ) * YC(  INO3 ) * YC(  I )
      RXRAT(    396 ) = RKI(   396 ) * YC(  I ) * YC(  BRO )
      RXRAT(    397 ) = RKI(   397 ) * YC(  IO ) * YC(  BR )
      RXRAT(    398 ) = RKI(   398 ) * YC(  IO ) * YC(  BRO )
      RXRAT(    399 ) = RKI(   399 ) * YC(  IO ) * YC(  CLO )
      RXRAT(    400 ) = RKI(   400 ) * YC(  OIO ) * YC(  OIO )
      RXRAT(    401 ) = RKI(   401 ) * YC(  OIO ) * YC(  NO )
      RXRAT(    402 ) = RKI(   402 ) * YC(  IO ) * YC(  IO )
      RXRAT(    403 ) = RKI(   403 ) * YC(  IO ) * YC(  OIO )
      RXRAT(    404 ) = RKI(   404 ) * YC(  I2O2 )
      RXRAT(    405 ) = RKI(   405 ) * YC(  I2O4 )
      RXRAT(    406 ) = RKI(   406 ) * YC(  INO2 )
      RXRAT(    407 ) = RKI(   407 ) * YC(  INO3 )
      RXRAT(    408 ) = RKI(   408 ) * YC(  I ) * YC(  NO )
      RXRAT(    409 ) = RKI(   409 ) * YC(  I ) * YC(  NO2 )
      RXRAT(    410 ) = RKI(   410 ) * YC(  IO ) * YC(  NO2 )
      RXRAT(    411 ) = RKI(   411 ) * YC(  CH3I ) * YC(  OH )
      RXRAT(    412 ) = RKI(   412 ) * YC(  DMS ) * YC(  IO )
      RXRAT(    413 ) = RKI(   413 ) * YC(  I2 )
      RXRAT(    414 ) = RKI(   414 ) * YC(  HOI )
      RXRAT(    415 ) = RKI(   415 ) * YC(  IO )
      RXRAT(    416 ) = RKI(   416 ) * YC(  OIO )
      RXRAT(    417 ) = RKI(   417 ) * YC(  INO )
      RXRAT(    418 ) = RKI(   418 ) * YC(  INO2 )
      RXRAT(    419 ) = RKI(   419 ) * YC(  INO3 )
      RXRAT(    420 ) = RKI(   420 ) * YC(  I2O2 )
      RXRAT(    421 ) = RKI(   421 ) * YC(  I2O3 )
      RXRAT(    422 ) = RKI(   422 ) * YC(  I2O4 )
      RXRAT(    423 ) = RKI(   423 ) * YC(  ICL )
      RXRAT(    424 ) = RKI(   424 ) * YC(  IBR )
      RXRAT(    425 ) = RKI(   425 ) * YC(  CH3I )
      RXRAT(    426 ) = RKI(   426 ) * YC(  MI2 )
      RXRAT(    427 ) = RKI(   427 ) * YC(  MIB )
      RXRAT(    428 ) = RKI(   428 ) * YC(  MIC )
      RXRAT(    429 ) = RKI(   429 ) * YC(  I2O2 )
      RXRAT(    430 ) = RKI(   430 ) * YC(  I2O3 )
      RXRAT(    431 ) = RKI(   431 ) * YC(  I2O4 )
      RXRAT(    432 ) = RKI(   432 ) * YC(  INO3 ) * YC(  ACLJ )
      RXRAT(    433 ) = RKI(   433 ) * YC(  INO3 ) * YC(  ABRJ )
      RXRAT(    434 ) = RKI(   434 ) * YC(  INO2 ) * YC(  ACLJ )
      RXRAT(    435 ) = RKI(   435 ) * YC(  INO2 ) * YC(  ABRJ )
      RXRAT(    436 ) = RKI(   436 ) * YC(  HOI ) * YC(  ACLJ )
      RXRAT(    437 ) = RKI(   437 ) * YC(  HOI ) * YC(  ABRJ )
      RXRAT(    438 ) = RKI(   438 ) * YC(  HI )
      RXRAT(    439 ) = RKI(   439 ) * YC(  DMS ) * YC(  OH )
      RXRAT(    440 ) = RKI(   440 ) * YC(  DMS ) * YC(  OH )
      RXRAT(    441 ) = RKI(   441 ) * YC(  DMS ) * YC(  NO3 )
      RXRAT(    442 ) = RKI(   442 ) * YC(  DMS ) * YC(  CL )
      RXRAT(    443 ) = RKI(   443 ) * YC(  DMS ) * YC(  CLO )


      RETURN

      END
