C-----------------------------------------------------------------------
      FUNCTION NCPUS()
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM: NCPUS          SET NUMBER OF CPUS
C   PRGMMR: IREDELL          ORG: W/NMC23     DATE: 94-08-19
C
C ABSTRACT: SET NUMBER OF CPUS 
C   DESIGNATING THE NUMBER OF PROCESSORS OVER WHICH TO PARALLELIZE.
C
C PROGRAM HISTORY LOG:
C   94-08-19  IREDELL
C   98-11-09  VUONG     ADD DOC BLOCK AND REMOVE CRAY REFERENCES
C 1998-12-18  IREDELL   IBM SMP VERSION
C 2010-11-16  SLOVACEK  LINUX MUST HAVE DIFFERENT CALL
C 2012-11-01  MIRVIS    Multi- threading on LINUX-IBM/TIDE
C
C USAGE:    NC=NCPUS()
C   OUTPUT ARGUMENTS:
C     NCPUS        INTEGER NUMBER OF CPUS
C
C SUBPROGRAMS CALLED:
C     NUM_PARTHDS  XLF INTRINSIC TO RETURN NUMBER OF THREADSRTHDS
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN
C
C$$$
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      INTEGER NTHREADS, TID, OMP_GET_NUM_THREADS,OMP_GET_THREAD_NUM
C     Obtain thread number
#ifdef LINUX
!$OMP PARALLEL PRIVATE(TID)
      TID = OMP_GET_THREAD_NUM()
!      PRINT *, '...............thread # ', TID
	if (TID. eq. 0) then
        NCPUS=OMP_GET_NUM_THREADS()
!        PRINT *, 'totaly #------------------- of threads = ',NCPUS
	endif
!$OMP END PARALLEL
#else
      NCPUS=NUM_PARTHDS()
#endif

      RETURN
      END
