       SUBROUTINE W3FA01(P,T,RH,TD,PLCL,TLCL)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FA01         COMPUTE LIFTING CONDENDSATION LEVEL
C   AUTHOR: HOWCROFT,J.      ORG: W/NMC342   DATE: 79-07-01
C
C ABSTRACT: GIVEN THE PRESSURE, TEMPERATURE AND RELATIVE HUMIDITY OF
C   AN AIR PARCEL AT SOME POINT IN THE ATMOSPHERE, CALCULATE THE
C   DEWPOINT TEMPERATURE AND THE PRESSURE AND TEMPERATURE OF THE
C   LIFTING CONDENSATION LEVEL.
C
C PROGRAM HISTORY LOG:
C   79-07-01  J.HOWCROFT
C   89-01-24  R.E.JONES   CHANGE TO MICROSOFT FORTRAN 4.10
C   90-06-11  R.E.JONES   CHANGE TO SUN FORTRAN 1.3
C   91-03-29  R.E.JONES   CONVERT TO SiliconGraphics FORTRAN
C   93-03-29  R.E.JONES   ADD SAVE STATEMENT
C   95-09-25  R.E.JONES   PUT IN CRAY W3 LIBRARY
C
C USAGE: CALL W3FA01(P,T,RH,TD,PLCL,TLCL)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     P      ARG LIST  PARCEL PRESSURE IN MILLIBARS
C     T      ARG LIST  PARCEL TEMPERATURE IN DEGREES CELSIUS
C     RH     ARG LIST  PARCEL RELATIVE HUMIDITY IN PERCENT
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     TD     ARG LIST  DEWPOINT TEMPERATURE IN DEGREES CELSIUS
C     PLCL   ARG LIST  PRESSURE OF LCL IN MILLIBARS
C     TLCL   ARG LIST  TEMPERATURE AT LCL IN DEGREES CELSIUS
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     ABS    ALOG   ALOG10 EXP                                SYSLIB
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/256, J916/2048
C
C$$$
C
      SAVE
C
C        DEFINITION OF THE POTENTIAL TEMPERATURE
C
      POTEMP(T,P) = (T+273.16)*((1000./P)**0.2857)
C
C        TETENS FORMULA WITH NATURAL BASE
C
      VAPRES(T)   = 6.11*EXP((17.2694*T)/(T+237.3))
C
C        BEGIN
C
      IF (RH.LT.100) GO TO 10
        PLCL = P
        TLCL = T
        TD   = T
        GO TO 40
C
C       CALCULATE DEW POINT FROM RH AND T
C
   10 CONTINUE
        AR    = ALOG(RH*0.01)/17.269
        TD    = (-237.3*(AR+1.0)*T - AR*237.3**2)/(AR*T+237.3*(AR-1.0))
        E     = VAPRES(TD)
        W     = (0.622*E)/(P-E)
        THETA = POTEMP(T,P)
C
C        DO STACKPOLE'S THING AS IN JOUR APPL MET, VOL 6, PP 464-467.
C
        EPS  = 0.1
        CGES = 0.5
C
C        CONSTANTS   -35.86 = 237.30 - 273.16
C                    2048.7 = 273.16 *   7.50
C
        PGES = (((CGES*(-35.86)+2048.7)/(THETA*(7.5-CGES)))**3.5)*1000.
C
C        START ITERATION.
C
   20 CONTINUE
        CGES = ALOG10((PGES*W)/(6.11*(0.622+W)))
        PLCL = (((CGES*(-35.86)+2048.7)/(THETA*(7.5-CGES)))**3.5)*1000.
        IF (ABS(PLCL-PGES) .LT. EPS)  GO TO 30
        PGES = PLCL
        GO TO 20
C
   30 CONTINUE
        TLCL   = (CGES * 237.3) / (7.5 - CGES)
C
C        FALL THRU WITH  P,T  OF THE LIFTED CONDENSATION LEVEL.
C
   40 CONTINUE
        RETURN
      END
