       SUBROUTINE W3FI20(A,B)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FI20         CUT A 65 X 65 GRID TO A NMC 1977 POINT GRID
C   AUTHOR: JONES, R.E.      ORG: W342       DATE: 84-07-02
C
C ABSTRACT: EXTRACTS THE NMC 1977 POINT OCTAGON GRID POINTS OUT OF
C   A 65X65 (4225 POINT) ARRAY.
C
C PROGRAM HISTORY LOG:
C   73-06-15  R.E.JONES
C   84-07-02  R.E.JONES   CONVERT TO VS FORTRAN
C   89-02-02  R.E.JONES   CONVERT TO MICROSOFT FORTRAN 4.10
C   90-08-22  R.E.JONES   CONVERT TO SUN FORTRAN 1.3
C   91-03-29  R.E.JONES   CONVERT TO SiliconGraphics FORTRAN
C   93-03-29  R.E.JONES   ADD SAVE STATEMENT
C
C USAGE:  CALL W3FI20 (A,B)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     A      ARG LIST  REAL*4 (65 X 65 GRID, 4225 POINT) ARRAY
C                      GRID IS OFFICE NOTE 84 TYPE 27 OR 1B HEX
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     B      ARG LIST  1977 POINT ARRAY (OCTAGON) OFFICE NOTE 84 TYPE
C                      0 OR HEX 0.
C
C   REMARKS: ARRAYS A AND B MAY BE THE SAME ARRAY OR BE EQUIVALENCED,
C     IN WHICH CASE THE FIRST 1977 WORDS OF 'A' ARE WRITTEN OVER.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/256, J916/2048.
C
C$$$
C
      REAL          A(*)
      REAL          B(*)
C
      INTEGER       RB
      INTEGER       LBR(51)
      INTEGER       RBR(51)
C
      SAVE
C
      DATA LBR/479,543,607,671,735,799,863,927,991,1055,1119,1183,1247,
     &1311,1375,1440,1505,1570,1635,1700,1765,1830,1895,1960,2025,2090,
     &2155,2220,2285,2350,2415,2480,2545,2610,2675,2740,2805,2871,2937,
     &3003,3069,3135,3201,3267,3333,3399,3465,3531,3597,3663,3729/
C
      DATA RBR/497,563,629,695,761,827,893,959,1025,1091,1157,1223,1289,
     &1355,1421,1486,1551,1616,1681,1746,1811,1876,1941,2006,2071,2136,
     &2201,2266,2331,2396,2461,2526,2591,2656,2721,2786,2851,2915,2979,
     &3043,3107,3171,3235,3299,3363,3427,3491,3555,3619,3683,3747/
C
         N = 0
C
      DO 200 I = 1,51
        LB = LBR(I)
        RB = RBR(I)
C
      DO 100 J = LB,RB
        N = N + 1
        B(N) = A(J)
 100  CONTINUE
C
 200  CONTINUE
C
      RETURN
      END
