      SUBROUTINE W3FM08 (A,Z,LI,LJ)
C$$$  SUBROUTINE DOCUMENTATION BLOCK ***
C SUBR: W3FM08   - NINE POINT SMOOTHER/DESMOOTHER
C   AUTHOR: HOWCROFT, J.       ORG: W342          DATE: 71-02-01
C
C ABSTRACT: NINE POINT SMOOTHER/DESMOOTHER. SMOOTHER PASS USES AN
C   EQUIVALENT LINEAR SMOOTHER WITH STENCIL (.25 .5 .25) AND THE
C   DESMOOTHER USES STENCIL (-.25 1.5 -.25). TWO GRID INTERVAL WAVES
C   ARE ANNIHILATED, FOUR GRID INTERVAL WAVES HAVE A .75 RESPONSE.
C
C PROGRAM HISTORY LOG:
C   71-02-01 J.HOWCROFT
C   84-07-01  R.E.JONES   CHANGE TO IBM VS FORTRAN
C   94-07-27  R.E.JONES   CHANGE TO CRAY CFT77 FORTRAN
C
C USAGE: CALL W3FM08 (A,Z,LI,LJ)
C
C   INPUT:
C     ' A' - REAL   SIZE (LI,LJ) ARRAY TO HOLD FIELD TO BE SMOOTHED
C     ' Z' - REAL   SIZE (LI,LJ) WORK AREA
C     'LI' - INTEGER   NUMBER OF COLUMNS
C     'LJ' - INTEGER   NUMBER OF ROWS
C   OUTPUT:
C     ' A' - ARRAY HOLDING SMOOTHED FIELD
C
C   EXIT STATES: NONE
C
C   EXTERNAL REFERENCES: NONE
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916-128, Y-MP8/864, Y-MP EL92/256
C
C$$$
C
      REAL     A(LI,LJ)
      REAL     Z(LI,LJ)
C
      SAVE
C
      LI1 = LI - 1
      LJ1 = LJ - 1
      DO 1  J=2,LJ1
      DO 1  I=2,LI1
      CRUX = A(I-1,J-1) + A(I+1,J-1) + A(I+1,J+1) + A(I-1,J+1)
      PLUS = A(I,J-1) + A(I,J+1) + A(I-1,J) + A(I+1,J)
      Z(I,J) = 0.25 * A(I,J)  + .125 * PLUS + .0625 * CRUX
    1 CONTINUE
      DO 2  I=1,LI
      Z(I,1) = A(I,1)
      Z(I,LJ) = A(I,LJ)
    2 CONTINUE
      DO 3  J=1,LJ
      Z(1,J) = A(1,J)
      Z(LI,J) = A(LI,J)
    3 CONTINUE
      DO 4  J=2,LJ1
      DO 4  I=2,LI1
      CRUX = Z(I-1,J-1) + Z(I+1,J-1) + Z(I+1,J+1) + Z(I-1,J+1)
      PLUS = Z(I,J-1) + Z(I,J+1) + Z(I-1,J) + Z(I+1,J)
      A(I,J) = 2.25 * Z(I,J)  - .375 * PLUS + .0625 * CRUX
    4 CONTINUE
      RETURN
      END
