       SUBROUTINE W3FT03(FL,HI,STI,STJ,MAXI,MAXJ,ITYPE)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FT03         A POINT INTERPOLATER
C   AUTHOR: HOWCROFT, J.     ORG: W342       DATE: 79-02-15
C
C ABSTRACT: DO EITHER BILINEAR OR BIQUADRATIC INTERPOLATION FOR A
C   POINT WITHIN A TWO-DIMENSIONAL DATA ARRAY.
C
C PROGRAM HISTORY LOG:
C   79-02-15  J.HOWCROFT
C   89-01-25  R.E.JONES  CHANGE TO MICROSOFT FORTRAN 4.10
C   90-06-12  R.E.JONES  CHANGE TO SUN FORTRAN 1.3
C   91-03-30  R.E.JONES  CONVERT TO SiliconGraphics FORTRAN
C   93-03-29  R.E.JONES  ADD SAVE STATEMENT
C   96-07-01  R.E.JONES  COMPILE ON CRAY
C
C USAGE:  CALL W3FT03(FL,HI,STI,STJ,MAXI,MAXJ,KQUAD)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     FL     ARG LIST  REAL*4 TWO-DIMENSIONAL CARTESIAN ARRAY OF DATA
C     MAXI   ARG LIST  INTEGER*4 I-DIMENSION OF FL
C     MAXJ   ARG LIST  INTEGER*4 J-DIMENSION OF FL
C     STI    ARG LIST  REAL*4 I-COORDINATE TO WHICH A VALUE IS TO BE
C                      INTERPOLATED
C     STJ    ARG LIST  REAL*4 J-COORDINATE TO WHICH A VALUE IS TO BE
C                      INTERPOLATED
C     KQUAD  ARG LIST  INTEGER*4 INTERPOLATION METHOD:
C                      IF = 2, BIQUADRATIC INTERPOLATION IS DONE,
C                      IF = ANY OTHER VALUE, DO BILINEAR.
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     HI     ARG LIST  REAL*4 INTERPOLATED OUTPUT VALUE
C
C   REMARKS: NO ERROR CHECKS ARE MADE. IT IS LEFT FOR THE USER TO
C     DETERMINE THAT THE POINT FOR WHICH INTERPOLATION IS DESIRED
C     LIES WITHIN THE GRID.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY C916/256, CRAY J916/2048
C
C$$$
C
       REAL            FL(MAXI,MAXJ)
       REAL            E (4)
C
       SAVE
C
       I  = STI
       J  = STJ
       DI = I
       DJ = J
       DI = STI - DI
       DJ = STJ - DJ
C
       HI = 0.
C                      TEST FOR POINT OFF GRID.
       IF (I.LT.1 .OR. I.GT.MAXI) GO TO 300
       IF (J.LT.1 .OR. J.GT.MAXJ) GO TO 300
       IF (ITYPE .NE. 2) GO TO 100
C                      DO BILINEAR IF POINT IS BETWEEN ULTIMATE AND
C                      PENULTIMATE ROWS, WHERE BIQUAD NOT POSSIBLE.
       IF (I.LT.2 .OR. I.GT.(MAXI-1)) GO TO 100
       IF (J.LT.2 .OR. J.GT.(MAXJ-1)) GO TO 100
       GO TO 200
C
C        BILINEAR.
  100  CONTINUE
         HI = FL(I  ,J  )*(1.-DI)*(1.-DJ)  + FL(I+1,J  )*DI*(1.-DJ)
     &      + FL(I  ,J+1)*(1.-DI)*DJ       + FL(I+1,J+1)*DI*DJ
         GO TO 300
C
  200  CONTINUE
C        BIQUADRATIC.
       DI2 = DI*(DI-1.)*.25
       DJ2 = DJ*(DJ-1.)*.25
       J1  = J - 1
       DO 250  K=1,4
         E(K) = FL(I  ,J1)*(1.-DI-DI2) + FL(I+1,J1)*(DI-DI2)
     &        + (FL(I-1,J1) + FL(I+2,J1))*DI2
         J1 = J1 + 1
  250  CONTINUE
       HI = E(2)*(1.-DJ-DJ2) + E(3)*(DJ-DJ2) + (E(1) + E(4))*DJ2
C
  300  CONTINUE
       RETURN
       END
