       SUBROUTINE W3FT39(VLN,GN,PLN,FL,WORK,TRIGS,RCOS)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FT39         COMPUTES 2.5X2.5 N. HEMI. GRID-VECTOR
C   AUTHOR: R.E.JONES        ORG: W323       DATE: 84-06-27
C
C ABSTRACT: COMPUTES 2.5 X 2.5 N. HEMI. GRID OF 145 X 37 POINTS
C   FROM SPECTRAL COEFFICIENTS IN A RHOMBOIDAL 30 RESOLUTION
C   REPRESENTING A VECTOR FIELD.
C
C PROGRAM HISTORY LOG:
C   93-07-23  R.E.JONES   NEW VERSION OF W3FT09, TAKES OUT W3FA12
C                         MAKES PLN 3 DIMENSIONS, PLN IS COMPUTED
C                         ONE TIME IN MAIN PROGRAM, TRADES MEMORY
C                         FOR MORE SPEED. W3FA12 USED 70% OF CPU TIME.
C
C USAGE:  CALL W3FT39(VLN,GN,PLN,FL,WORK,TRIGS,RCOS)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     VLN    ARG LIST  992 COMPLEX COEFF.
C     PLN    ARG LIST  (32,31,37) REAL SPACE WITH LEGENDRE POLYNOMIALS
C                      COMPUTED BY W3FA12.
C     FL     ARG LIST  31 COMPLEX SPACE FOR FOURIER COEFF.
C     WORK   ARG LIST  144 WORK SPACE FOR SUBR. W3FT12
C     TRIGS  ARG LIST  216 PRECOMPUTED TRIG FUNCS. USED
C                      IN W3FT12, COMPUTED BY W3FA13
C     RCOS   ARG LIST  37 RECIPROCAL COSINE LATITUDES OF
C                      2.5 X 2.5 GRID MUST BE COMPUTED BEFORE
C                      FIRST CALL TO W3FT11 USING SR W3FA13.
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     GN     ARG LIST  (145,37) GRID VALUES.
C                      5365 POINT GRID IS TYPE 29 OR 1D O.N. 84
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     AIMAG  CMPLX  REAL                                      SYSTEM
C     W3FT12                                                  W3LIB
C
C WARNING: W3FT09 WAS OPTIMIZED TO RUN IN A SMALL AMOUNT OF
C   MEMORY, IT WAS NOT OPTIMIZED FOR SPEED, 70 PERCENT OF THE TIME WAS
C   USED BY SUBROUTINE W3FA12 COMPUTING THE LEGENDRE POLYNOMIALS. SINCE
C   THE LEGENDRE POLYNOMIALS ARE CONSTANT THEY NEED TO BE COMPUTED
C   ONLY ONCE IN A PROGRAM. BY MOVING W3FA12 TO THE MAIN PROGRAM AND
C   COMPUTING PLN AS A (32,31,37) ARRAY AND CHANGING THIS SUBROUTINE
C   TO USE PLN AS A THREE DIMENSION ARRAY THE RUNNING TIME WAS CUT
C   70 PERCENT. ADD FOLLOWING CODE TO MAIN PROGRAM TO COMPUTE EPS, PLN,
C   TRIGS, AND RCOS ONE TIME IN PROGRAM.
C     
C       DOUBLE PRECISION EPS(992)
C       DOUBLE PRECISION COLRA
C
C       REAL             PLN( 32, 31, 37 )
C       REAL             RCOS(37)
C       REAL             TRIGS(216)
C
C       DATA  PI /3.14159265/
C
C       DRAD = 2.5 * PI / 180.0
C       CALL W3FA11(EPS,30)
C       CALL W3FA13(TRIGS,RCOS)
C       DO LAT = 1,37
C         COLRA = (LAT - 1) * DRAD
C         CALL W3FA12 (PLN(1,1,LAT), COLRA, 30, EPS)
C       END DO
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN  
C   MACHINE:  CRAY Y-MP8/864, CRAY Y-MP EL2/128
C
C$$$
C
       COMPLEX          FL( 31 )
       COMPLEX          VLN( 32 , 31 )
C
       REAL             GN(145,37)
       REAL             PLN( 32, 31, 37 )
       REAL             RCOS(37)
       REAL             TRIGS(216)
       REAL             WORK(144)
C
       SAVE
C
         DO 400 LAT = 2,37
           LATN  = 38 - LAT
C
           DO 100 L = 1, 31
             FL(L) = (0.,0.)
 100       CONTINUE
C
             DO 300 L = 1, 31
C
               DO 200 I = 1, 32
                 FL(L) = FL(L) + CMPLX(PLN(I,L,LAT) * REAL(VLN(I,L)),
     &           PLN(I,L,LAT) * AIMAG(VLN(I,L)) )
 200           CONTINUE
C
             FL(L)=CMPLX(REAL(FL(L))*RCOS(LAT),AIMAG(FL(L))*RCOS(LAT))
 300         CONTINUE
C
         CALL W3FT12(FL,WORK,GN(1,LATN),TRIGS)
C
 400     CONTINUE
C
C***   POLE ROW=CLOSEST LATITUDE ROW
C
         DO 500 I = 1,145
           GN(I,37) = GN(I,36)
 500     CONTINUE
C
         RETURN
       END
