       SUBROUTINE W3FT40(FLN,GN,PLN,FL,WORK,TRIGS)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FT40         COMPUTES 2.5 X 2.5 S. HEMI. GRID-SCALER
C   AUTHOR: JONES,R.E.       ORG: W323       DATE: 93-07-23
C
C ABSTRACT: COMPUTES 2.5 X 2.5 S. HEMI. GRID OF 145 X 37 POINTS
C   FROM SPECTRAL COEFFICIENTS IN A RHOMBOIDAL 30 RESOLUTION
C   REPRESENTING A SCALER FIELD.
C
C PROGRAM HISTORY LOG:
C   93-07-23  R.E.JONES   NEW VERSION OF W3FT10, TAKES OUT W3FA12
C                         MAKES PLN 3 DIMENSIONS, PLN IS COMPUTED
C                         ONE TIME IN MAIN PROGRAM, TRADES MEMORY
C                         FOR MORE SPEED. W3FA12 USED 70% OF CPU TIME.
C
C USAGE:  CALL W3FT40(FLN,GN,PLN,FL,WORK,TRIGS)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     FLN    ARG LIST  961 COMPLEX COEFF.
C     PLN    ARG LIST  (32,31,37) REAL SPACE WITH LEGENDRE POLYNOMIALS
C                      COMPUTED BY W3FA12.
C     FL     ARG LIST  31 COMPLEX SPACE FOR FOURIER COEFF.
C     WORK   ARG LIST  144 REAL WORK SPACE FOR SUBR. W3FT12
C     TRIGS  ARG LIST  216 PRECOMPUTED TRIG FUNCS. USED
C                      IN W3FT12, COMPUTED BY W3FA13
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     GN     ARG LIST  (145,37) GRID VALUES.
C                      5365 POINT GRID IS TYPE 30 OR 1E O.N. 84
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     AIMAG  CMPLX  REAL                                      SYSTEM
C     W3FT12                                                  W3LIB
C
C WARNING: W3FT10 WAS OPTIMIZED TO RUN IN A SMALL AMOUNT OF
C   MEMORY, IT WAS NOT OPTIMIZED FOR SPEED, 70 PERCENT OF THE TIME WAS
C   USED BY SUBROUTINE W3FA12 COMPUTING THE LEGENDRE POLYNOMIALS. SINCE
C   THE LEGENDRE POLYNOMIALS ARE CONSTANT THEY NEED TO BE COMPUTED
C   ONLY ONCE IN A PROGRAM. BY MOVING W3FA12 TO THE MAIN PROGRAM AND
C   COMPUTING PLN AS A (32,31,37) ARRAY AND CHANGING THIS SUBROUTINE
C   TO USE PLN AS A THREE DIMENSION ARRAY THE RUNNING TIME WAS CUT
C   70 PERCENT. ADD FOLLOWING CODE TO MAIN PROGRAM TO COMPUTE EPS, PLN,
C   TRIGS, AND RCOS ONE TIME IN PROGRAM.
C     
C       DOUBLE PRECISION EPS(992)    [CHANGE TO REAL ON CRAY] 
C       DOUBLE PRECISION COLRA       [CHANGE TO REAL ON CRAY]
C
C       REAL             PLN( 32, 31, 37 )
C       REAL             RCOS(37)
C       REAL             TRIGS(216)
C
C       DATA  PI /3.14159265/
C
C       DRAD = 2.5 * PI / 180.0
C       CALL W3FA11(EPS,30)
C       CALL W3FA13(TRIGS,RCOS)
C       DO LAT = 1,37
C         COLRA = (LAT - 1) * DRAD
C         CALL W3FA12 (PLN(1,1,LAT), COLRA, 30, EPS)
C       END DOC
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN  
C   MACHINE:  CRAY Y-MP8/864, CRAY Y-MP EL2/128
C
C$$$
C
       COMPLEX          FL( 31 )
       COMPLEX          FLN( 31 , 31 )
C
       REAL             GN(145,37)
       REAL             PLN( 32, 31, 37 )
       REAL             TRIGS(216)
       REAL             WORK(144)
C
       SAVE
C
         DO 400 LAT = 1,37
C
           DO 100 L = 1, 31
             FL(L) = (0.,0.)
 100       CONTINUE
C
           DO 300 L = 1, 31
             I = 1
             FL(L) = FL(L)+CMPLX(PLN(I,L,LAT) * REAL(FLN(I,L)) ,
     &       PLN(I,L,LAT) * AIMAG(FLN(I,L)) )
C
             DO  200 I = 2, 30 ,2
               FL(L) = FL(L)-CMPLX(PLN(I,L,LAT) * REAL(FLN(I,L)) ,
     &         PLN(I,L,LAT) * AIMAG(FLN(I,L)) )
               FL(L) = FL(L)+CMPLX(PLN(I+1,L,LAT) * REAL(FLN(I+1,L)),
     &         PLN(I+1,L,LAT) * AIMAG(FLN(I+1,L)))
 200         CONTINUE
C
 300       CONTINUE
C
         CALL W3FT12(FL,WORK,GN(1,LAT ),TRIGS)
 400     CONTINUE
C
         RETURN
       END
