subroutine intrp3no2dp1(f,dpno2,dx,dy,obstime,mype)
!$$$  subprogram documentation block
!                .      .    .                                       .
! subprogram:    intrp3oz    space-time linear interpolation for ozone
!   prgmmr: parrish          org: np22                date: 2013-01-26
!  dpno2(k) for omi apriori adjustment Lenzen 2015-05-10
!
! abstract: same as intrp3oz but for special case n=1, with n argument removed.
!            This has been created to solve problem of type mismatch debug
!            compile
!            error on WCOSS.
!
! program history log:
!   2013-01-26  parrish
!
!   input argument list:
!     f        - input interpolator (gridded guess ozone fields)
!     dx,dy - input x,y-coords of interpolation points (grid units)
!     obstime  - observation times
!     mype     - mpi task id
!
!   output argument list:
!     g        - output interpolatees (guess ozone at observation location)
!     dpno2     - delta pressure * layer ozone at observation location
!     sfcp     - surface pressure at observation location
!
! attributes:
!   language: f90
!   machine:  ibm RS/6000 SP
!
!$$$
!--------
  use kinds, only: r_kind,i_kind
  use guess_grids, only: nfldsig,hrdifsig,ges_prsi
  use gridmod, only: lat2,lon2,nlat,nlon,nsig,lon1,istart,jstart
  use constants, only: zero, one, rozcon
  implicit none

! Declare passed variables
  integer(i_kind)                               ,intent(in   ) :: mype
  real(r_kind)                                  ,intent(in   ) :: dx,dy,obstime
  real(r_kind),dimension(lat2,lon2,nsig,nfldsig),intent(in   ) :: f
!  real(r_kind)                                  ,intent(  out) :: g
  real(r_kind),dimension(nsig)                 ,intent(out)    :: dpno2
  

! Declare local variables
  integer(i_kind) j,k,ix,ix1,iy,iy1,kk,itsig,itsigp,iz1,iz2
  integer(i_kind) ixp,iyp,mm1
  real(r_kind) w00,w01,w10,w11,delx,dely,delx1,dely1
  real(r_kind) dtsig,dtsigp,pob
  real(r_kind) delp1,delp2,delp3,delp4,delp5,delp6,delp7,delp8


!*************************************************************************
! Initialize variables
!  g=zero
!  dp=zero
  dpno2=zero
!  sfcp=zero
  mm1=mype+1


! Loop over number of observations.

!    Get horizontal interpolation information.  This information includes
!    the (i,j) indices of the grid points surrounding the observation,
!    plus the corresponding interpolation weights between these points
!    and the observation.

     ix1=dx; iy1=dy
     ix1=max(1,min(ix1,nlat))
     delx=dx-ix1; dely=dy-iy1; delx=max(zero,min(delx,one))
     ix=ix1-istart(mm1)+2; iy=iy1-jstart(mm1)+2
     if(iy<1) then
        iy1=iy1+nlon
        iy=iy1-jstart(mm1)+2
     end if
     if(iy>lon1+1) then
        iy1=iy1-nlon
        iy=iy1-jstart(mm1)+2
     end if
     ixp=ix+1; iyp=iy+1
     if(ix1==nlat) then
        ixp=ix
     end if
     delx1=one-delx; dely1=one-dely
     w00=delx1*dely1; w10=delx*dely1; w01=delx1*dely; w11=delx*dely
        
!    Set the weights for linear time iterpolation from the guess to 
!    the observation time.
!     if(mype.eq.0)then
!          write(6,*)'obstime',obstime,'hrdiffsig',hrdifsig,'nfldsig',nfldsig
!           call flush(6)
!     endif

     if(obstime > hrdifsig(1) .and. obstime < hrdifsig(nfldsig))then
        do j=1,nfldsig-1
           if(obstime > hrdifsig(j) .and. obstime <= hrdifsig(j+1))then
              itsig=j
              itsigp=j+1
              dtsig=((hrdifsig(j+1)-obstime)/(hrdifsig(j+1)-hrdifsig(j)))
           end if
        end do
     else if(obstime <=hrdifsig(1))then
        itsig=1
        itsigp=1
        dtsig=one
     else
        itsig=nfldsig
        itsigp=nfldsig
        dtsig=one
     end if
     dtsigp=one-dtsig
     
!
!    Perform spatial and temporal interpolation for the total column 
!    ozone observation
!     write(100+mype,*)'ix',ix,iy,itsig,itsigp,'prsi',ges_prsi(ix,iy,1,itsig),ges_prsi(ix,iy,nsig,itsig)
     do kk=1,nsig
        delp1=ges_prsi(ix ,iy ,kk,itsig )-ges_prsi(ix ,iy ,kk+1,itsig )
        delp2=ges_prsi(ixp,iy ,kk,itsig )-ges_prsi(ixp,iy ,kk+1,itsig )
        delp3=ges_prsi(ix ,iyp,kk,itsig )-ges_prsi(ix ,iyp,kk+1,itsig )
        delp4=ges_prsi(ixp,iyp,kk,itsig )-ges_prsi(ixp,iyp,kk+1,itsig )
        delp5=ges_prsi(ix ,iy ,kk,itsigp)-ges_prsi(ix ,iy ,kk+1,itsigp)
        delp6=ges_prsi(ixp,iy ,kk,itsigp)-ges_prsi(ixp,iy ,kk+1,itsigp)
        delp7=ges_prsi(ix ,iyp,kk,itsigp)-ges_prsi(ix ,iyp,kk+1,itsigp)
        delp8=ges_prsi(ixp,iyp,kk,itsigp)-ges_prsi(ixp,iyp,kk+1,itsigp)
!        dp(kk)=dp(kk)+(w00*delp1+w10*delp2+w01*delp3+w11*delp4)*dtsig + &
!                      (w00*delp5+w10*delp6+w01*delp7+w11*delp8)*dtsigp
        dpno2(kk)=dpno2(kk)+ &
              (f(ix ,iy ,kk,itsig )*w00*delp1 &
             + f(ixp,iy ,kk,itsig )*w10*delp2 &
             + f(ix ,iyp,kk,itsig )*w01*delp3 &
             + f(ixp,iyp,kk,itsig )*w11*delp4)*dtsig + &
              (f(ix ,iy ,kk,itsigp)*w00*delp5 &
             + f(ixp,iy ,kk,itsigp)*w10*delp6 &
             + f(ix ,iyp,kk,itsigp)*w01*delp7 &
             + f(ixp,iyp,kk,itsigp)*w11*delp8)*dtsigp
!        dpno2(kk)=dpno2(kk)*rozcon
     enddo

! End of routine
  return
end subroutine intrp3no2dp1
