module omimod
  use kinds, only : r_kind,i_kind,r_single
  implicit none
! omi dimensions
  integer(i_kind) :: nprs,nlat,ncol,nmon
  parameter (nprs=11,nlat=18,ncol=10,nmon=12)
! omi apriori data
  real(r_single) :: apreff(nprs),aprprb(nprs),aprprt(nprs),aprprs(nprs)
  real(r_single) :: aprlat(nlat),aprcol(ncol),aprmon(nmon)
  real(r_single) :: apriori(nlat,nprs,ncol,nmon)
  real(r_kind) :: pintapr(0:nprs+1),aprdp(0:nprs)
  real(r_kind) :: mapriori(nlat,ncol,nprs)
  logical :: fixedkernel,lfixsfc,no2scatterweight
  parameter (fixedkernel=.true.) 
!  parameter (fixedkernel=.false.) 
! omi kernel data
! add no2 pressure for scattering weight since are a constanst
  integer(i_kind),parameter :: nlevscatwt=35
  real(r_kind) :: presscatwt(nlevscatwt),pintscatwt(0:nlevscatwt),pintscatwtcb(0:nlevscatwt)
  integer(i_kind) :: no2pe=-1
  logical :: bcastpresscatwt=.true.
  contains 
    subroutine readapriori
    use mpimod, only : mype
    use mpimod, only : mpi_real4, mpi_comm_world
    use obsmod, only : iadate,ianldate
    implicit none
    integer k,ic,ndum,ndum1,ndum2,ndum3,iret,idat,iday,imonth,ihr,iyear,mindex0,mindex1
    integer ii,jj,ll
    real mscale,apr0,apr1
    real(r_kind) :: spstandatm
    character *10 cfixsfc
    cfixsfc=' '
    call getenv('FIXSFC',cfixsfc)
    if(cfixsfc.eq.'YES')then
      lfixsfc=.true.
      if(mype.eq.0)write(6,*)'**** FIX OMI SFC'
    else 
      lfixsfc=.false.
    endif
    spstandatm=1013.25
    aprprb(1)=spstandatm
    do k=2,nprs
      aprprb(k)=aprprb(k-1)/2.
      aprprt(k-1)=aprprb(k)
!      if(mype.eq.0)then
!        write(6,*)k,'aprprb',k,aprprb(k)
!      endif
    end do
    aprprt(nprs)=aprprt(nprs-1)/2.
    do k=1,nprs
      aprprs(k)=.5*(aprprb(k)+aprprt(k))
      pintapr(k+1)=aprprt(k)
      aprdp(k)=aprprb(k)-aprprt(k)
    end do
    pintapr(1)=aprprb(1)
    pintapr(0)=aprprb(1)+aprdp(1)
    aprdp(0)=aprdp(1)
!    if(mype.eq.0)then
!      do k=1,nprs
!        !write(6,*)'aprprb',aprprb(k),aprprt(k),'av',aprprs(k),'dp',aprdp(k)
!      end do
!      do k=0,nprs+1
!        write(6,*)'pintapr',k,pintapr(k)
!      !end do
!    endif
    go to 200
!    return
!   in new version only need aprprb,aprprt,aprprs
    if(mype.eq.0)then
      if(fixedkernel)then
        write(6,*)'Opening TOMS_V8_kernal.dat'
        call flush(6)
        open (83,file='TOMS_V8_kernel.dat',form='formatted',STATUS='old')
        read(83,*)ndum
        read(83,*)aprprb,aprprt,aprprs,apreff
!        !do k=1,nprs
!          !write(6,*)'top',aprprt(k)
!          write(6,*)k,aprprs(k),'apreff',apreff(k)
!          write(6,*)'bot',aprprb(k)
!        end do
        close(83)
      endif
!   c new file from Brad and OMI PI on 3/2/06
      open (83,file='OMI_apriori.dat',form='formatted',STATUS='old')
!#ifdef READNEW
!      write(6,*)'call readapriori'
!      call flush(6)
!      call readapriori(nlat,nprs,ncol,nmon,aprlat,aprcol,aprprs,aprmon,apriori)
!#else
      read(83,*)ndum,ndum1,ndum2,ndum3
      read(83,*)aprlat,aprprs,aprcol,aprmon
      read(83,*)apriori
!      do k=1,nprs
!        write(6,*)k,aprprs(k),(apriori(9,k,ic,3),ic=1,5)
!      end do
!#endif
      close(83)
      write(6,*)'DONE with DATA READ '
      call flush(6)
    endif
    if(fixedkernel)then
      call mpi_bcast(aprprb,nprs,mpi_real4,0,mpi_comm_world,iret)
      call mpi_bcast(aprprt,nprs,mpi_real4,0,mpi_comm_world,iret)
      call mpi_bcast(apreff,nprs,mpi_real4,0,mpi_comm_world,iret)
      do k=1,nprs
        pintapr(k+1)=aprprt(k)
        aprdp(k)=aprprb(k)-aprprt(k)
      end do
      pintapr(1)=aprprb(1)
      pintapr(0)=aprprb(1)+aprdp(1)
      aprdp(0)=aprdp(1)
    endif
    call mpi_bcast(aprprs,nprs,mpi_real4,0,mpi_comm_world,iret)
    call mpi_bcast(aprlat,nlat,mpi_real4,0,mpi_comm_world,iret)
    call mpi_bcast(aprcol,ncol,mpi_real4,0,mpi_comm_world,iret)
    call mpi_bcast(aprmon,nmon,mpi_real4,0,mpi_comm_world,iret)
    call mpi_bcast(apriori,nlat*nprs*ncol*nmon,mpi_real4,0,mpi_comm_world,iret)
!    write(100+mype,*)'pintapr',pintapr
  idat=ianldate
  if(mype.eq.0)write(6,*)'iadate',iadate,'ianldated',ianldate
  iday=idat/100
  iday=mod(iday,100)
  imonth=idat/10000
  imonth=mod(imonth,100)
  ihr=mod(idat,100)
  iyear=idat/100000
  if(mype.eq.0)then
    print *,'TOMSday',imonth,iday,'ihr',ihr
  endif
  if(iday.lt.15) then
    mindex0=imonth-1
    mindex1=imonth
    mscale=(iday+15)/30.
  endif
  if(iday.ge.15) then
    mindex0=imonth
    mindex1=imonth+1
    mscale=(iday-15)/30.
  endif
  if(mindex0.eq.0)mindex0=12
  if(mindex1.eq.13)mindex1=1
!  if(mype.eq.0)then
!     write(100+mype,*)'iday',iday,'imonth',imonth,'ihr',ihr,'mindex0',mindex0,mindex1,'mscale',mscale
!  endif
 
! construct interpolated monthly apriori
  do jj=1,nlat
    do ii=1,ncol
      do ll=1,nprs
        apr0=apriori(jj,ll,ii,mindex0)
        apr1=apriori(jj,ll,ii,mindex1)
!        write(100+mype,*)'ii',ii,jj,ll,'mindex0',mindex0,mindex1,'apr0',apr0,apr1
        if((apr0.lt.999.).and.(apr1.lt.999.)) mapriori(jj,ii,ll)=apr0+mscale*(apr1-apr0)
        if((apr0.eq.999.).and.(apr1.lt.999.)) mapriori(jj,ii,ll)=apr1
        if((apr0.lt.999.).and.(apr1.eq.999.)) mapriori(jj,ii,ll)=apr0
        if((apr0.eq.999.).and.(apr1.eq.999.)) then
!       print,'monthly apriori interp failed at (lat,col) ',aprlat(jj),aprcol(ii)
!        write(100+mype,*)'monthly failed ',aprlat(jj),aprcol(ii),'ii',ii,jj,ll
        mapriori(jj,ii,ll)=999.
        endif
      enddo
    enddo
  enddo
200 continue
  return
  end subroutine readapriori
  subroutine sendpresscatwt
  use kinds, only: r_kind,r_single,i_kind
  use mpimod, only : mpi_comm_world,mpi_rtype,mpi_integer4,npe
  use mpimod, only : mype
  use no2info, only : ihave_no2
  implicit none
  integer(i_kind)           ::        nno2pe(1:npe),ierr,k
  if(.not.ihave_no2)return
!   write(6,*)'sendpresscatwt'
!   call flush(6)
  if(bcastpresscatwt)then 
!    write(6,*)mype,'bcastpresscatwt',no2pe
    bcastpresscatwt=.false.
    call mpi_gather(no2pe,1,mpi_integer4,nno2pe,1,mpi_integer4,0,mpi_comm_world,ierr)
!    write(6,*)mype,'no2pe',no2pe
!    if(mype.eq.0)then
!      write(6,*)'nno2pe',nno2pe
!      call flush(6)
!    endif
    
    if(mype.eq.0.and.no2pe.eq.0)then
!      write(6,*)'zero is no2pe'
    else
      if(mype.eq.0)then
        do k=1,npe
          if(nno2pe(k)>no2pe)then
!            write(6,*)'nno2pe not neg ',k,nno2pe(k)
            no2pe=nno2pe(k)
          endif
        end do
      endif
    endif
    call mpi_bcast(no2pe,1,mpi_integer4,0,mpi_comm_world,ierr)
!    write(6,*)mype,'no2pe',no2pe
    if(no2pe>=0)then
    call mpi_bcast(presscatwt,nlevscatwt,mpi_rtype,no2pe,mpi_comm_world,ierr)
    endif
!    call mpi_bcast(pintscatwt,nlevscatwt+1,mpi_rtype,no2pe,mpi_comm_world,ierr)
  endif
  pintscatwt(0)=1100.
  pintscatwt(nlevscatwt)=0.
  do k=1,nlevscatwt-1
    pintscatwt(k)=.5*(presscatwt(k)+presscatwt(k+1))
  end do
  pintscatwtcb=pintscatwt*.1
!  write(840+mype,*)'end of sendpressscatwt'

  end subroutine sendpresscatwt
end module omimod
