
load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

  cdf_analysis = addfile("run/gsiprd_2011032212_arw_singleobs/wrf_inout.cdf","r")
  cdf_bk = addfile("/2011032212/wrfinput_d01_ARW_2011-03-22_12.cdf","r")
  Ta = cdf_analysis->T(0,:,:,:)
  Tb = cdf_bk->T(0,:,:,:)
  DT = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->U(0,:,:,:)
  Tb = cdf_bk->U(0,:,:,:)
  DU = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->V(0,:,:,:)
  Tb = cdf_bk->V(0,:,:,:)
  DV = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->QVAPOR(0,:,:,:)
  Tb = cdf_bk->QVAPOR(0,:,:,:)
  DQ = Ta - Tb
  delete(Ta)
  delete(Tb)
  DQ = DQ * 1000.0
  lon = cdf_bk->XLONG(0,:,:)
  lat = cdf_bk->XLAT(0,:,:)

  nx=dimsizes(DT(1,1,:))
  ny=dimsizes(DT(1,:,1))
  nz=dimsizes(DT(:,1,1))

  f2dv = new ((/nz,nx/), typeof(DT))
  f2dh = new ((/ny,nx/), typeof(DT))

  rmax = -9999.0
  do k=0, nz-1
  do j=0, ny-1
  do i=0, nx-1
    if (rmax .le. DT(k,j,i)) then
       rmax=DT(k,j,i)
       imax=i
       jmax=j
       kmax=k
    end if
  end do
  end do
  end do

  print(rmax)
  print(imax)
  print(jmax)
  print(kmax)

  kmax=15

  titles = new(4,string)
  titles(0)="T inc, XY"
  titles(1)="U inc, XY"
  titles(2)="V inc, XY"
  titles(3)="Q inc, XY"

  plot = new(4,graphic)

  xwks = gsn_open_wks("pdf","GSI_prepbufr_arw_15")
;  xwks = gsn_open_wks("x11","gsun01n")
  gsn_define_colormap(xwks,"cosam12")

  resources                  =  True              ; plot mods desired
  resources@gsnDraw              = False              ; Do not draw plot
  resources@gsnFrame             = False              ; Do not advance frame

  resources@cnMonoLineColor    = False
  resources@cnFillOn    = False
;  resources@cnFillOn    = True
  resources@gsnContourNegLineDashPattern = 1         ; negtive line use dash



; map
  resources@sfXArray         = lon
  resources@sfYArray         = lat

  resources@mpProjection       = "LambertConformal" ; choose projection
  resources@mpLimitMode        = "Corners"          ; choose range of map
  resources@mpLeftCornerLatF      = 3.0
  resources@mpLeftCornerLonF      = -135.
  resources@mpRightCornerLatF     = 57.0
  resources@mpRightCornerLonF     = -10.0

  resources@mpLambertParallel1F   = 45.0       ; ncl adds from grib file
  resources@mpLambertParallel2F   = 45.0       ; ncl adds from grib file
  resources@mpLambertMeridianF    = -99.12     ; ncl adds from grib file
  resources@pmTickMarkDisplayMode = "Always"
  resources@mpFillOn              =  False             ; turn off map fill
  resources@mpOutlineDrawOrder    = "PostDraw"         ; continent outline last
  resources@mpOutlineBoundarySets = "GeophysicalAndUSStates" ; state boundaries
  resources@mpGridAndLimbOn = False                  ; turn off lat/lon lines 
  resources@mpPerimOn = True
  resources@pmLabelBarDisplayMode = "Always" ; Turn on label bar.
  resources@lbPerimOn             = False    ; Turn off perimeter on label bar.


  resources@cnLevelSpacingF = 0.2
  plot(0) = gsn_contour_map(xwks, DT(kmax,:,:), resources)
  do j=0, ny-1
  do i=0, nx-1
      f2dh(j,i) = (DU(kmax,j,i) + DU(kmax,j,i+1))/2.0
  end do
  end do
  resources@cnLevelSpacingF = 1.0
  plot(1) = gsn_contour_map(xwks, f2dh, resources)
  do j=0, ny-1
  do i=0, nx-1
      f2dh(j,i) = (DV(kmax,j,i) + DV(kmax,j+1,i))/2.0
  end do
  end do
  resources@cnLevelSpacingF = 1.0
  plot(2) = gsn_contour_map(xwks, f2dh, resources)
  resources@cnLevelSpacingF = 0.1
  plot(3) = gsn_contour_map(xwks, DQ(kmax,:,:), resources)

  resourcesP                    =  True              ; plot mods desired
  resourcesP@gsnPanelFigureStrings = titles
  resourcesP@gsnPanelFigureStringsFontHeightF = 0.01 
  resourcesP@amJust = "TopLeft"     
  resourcesP@gsnPanelFigureStringsPerimOn = False  
  gsn_panel(xwks,plot,(/2,2/),resourcesP)

  delete(plot)
  delete(resources)
  delete(resourcesP)
end
