load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "./fill_nmm_grid2.ncl"

begin

  cdf_analysis = addfile("./e02b_prepbufr_nmm_2011060212/wrf_inout.cdf","r")
  cdf_bk = addfile("/2011060212/nmm/wrfinput_d01_2011-06-02_12:00:00.cdf","r")
  Ta = cdf_analysis->T(0,:,:,:)
  Tb = cdf_bk->T(0,:,:,:)
  DT = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->U(0,:,:,:)
  Tb = cdf_bk->U(0,:,:,:)
  DU = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->V(0,:,:,:)
  Tb = cdf_bk->V(0,:,:,:)
  DV = Ta - Tb
  delete(Ta)
  delete(Tb)
  Ta = cdf_analysis->Q(0,:,:,:)
  Tb = cdf_bk->Q(0,:,:,:)
  DQ = Ta - Tb
  delete(Ta)
  delete(Tb)
  DQ = DQ * 1000.0
  lon = cdf_bk->GLON(0,:,:)
  lat = cdf_bk->GLAT(0,:,:)

  nx=dimsizes(DT(1,1,:))
  ny=dimsizes(DT(1,:,1))
  nz=dimsizes(DT(:,1,1))
  f3d  = new ((/nz,ny-2,2*nx-1-2/), typeof(DT))
  lona = new ((/ny-2,2*nx-1-2/), typeof(lon))
  lata = new ((/ny-2,2*nx-1-2/), typeof(lat))
  
  fill_nmm_grid2(lon(:,:),nx,ny,lona(:,:),1)
  fill_nmm_grid2(lat(:,:),nx,ny,lata(:,:),1)
  lona = lona * 180.0 /3.1415926
  lata = lata * 180.0 /3.1415926

  do k=0, nz-1
    fill_nmm_grid2(DT(k,:,:),nx,ny,f3d(k,:,:),1)
  end do

  rmax = -9999.0
  do k=0, nz-1
  do j=0, ny-1-4
  do i=0, 2*nx-1-1-4
    if (rmax .le. f3d(k,j,i)) then
       rmax=f3d(k,j,i)
       imax=i
       jmax=j
       kmax=k
    end if
  end do
  end do
  end do

  print(rmax)
  print(imax)
  print(jmax)
  print(kmax)

  kmax=0

  titles = new(4,string)
  titles(0)="T inc, XY"
  titles(1)="U inc, XY"
  titles(2)="V inc, XY"
  titles(3)="Q inc, XY"

  plot = new(4,graphic)

;  xwks = gsn_open_wks("pdf","e02b_prepbufr_nmm_sfc")
  xwks = gsn_open_wks("x11","gsun01n")
  gsn_define_colormap(xwks,"cosam12")

  resources                  =  True              ; plot mods desired
  resources@gsnDraw              = False              ; Do not draw plot
  resources@gsnFrame             = False              ; Do not advance frame

  resources@cnMonoLineColor    = False
;  resources@cnFillOn    = True
  resources@cnFillOn    = False
;  resources@gsnContourNegLineDashPattern = 1

; map
  resources@sfXArray         = lona
  resources@sfYArray         = lata

  resources@mpProjection       = "LambertConformal" ; choose projection
  resources@mpLimitMode        = "Corners"          ; choose range of map
  resources@mpLeftCornerLatF      = 15.0
  resources@mpLeftCornerLonF      = -95.
  resources@mpRightCornerLatF     = 52.0
  resources@mpRightCornerLonF     = -42.0

  resources@mpLambertParallel1F   = 37.0       ; ncl adds from grib file
  resources@mpLambertParallel2F   = 37.0       ; ncl adds from grib file
  resources@mpLambertMeridianF    = -75.0     ; ncl adds from grib file
  resources@pmTickMarkDisplayMode = "Always"
  resources@mpFillOn              =  False             ; turn off map fill
  resources@mpOutlineDrawOrder    = "PostDraw"         ; continent outline last
  resources@mpOutlineBoundarySets = "GeophysicalAndUSStates" ; state boundaries
  resources@mpGridAndLimbOn = False                  ; turn off lat/lon lines 
  resources@mpPerimOn = True
  resources@pmLabelBarDisplayMode = "Always" ; Turn on label bar.
  resources@lbPerimOn             = False    ; Turn off perimeter on label bar.

;  resources@cnLevelSpacingF = 0.5
  plot(0) = gsn_contour_map(xwks, f3d(kmax,:,:), resources)
  do k=0, nz-1
    fill_nmm_grid2(DU(k,:,:),nx,ny,f3d(k,:,:),2)
  end do
;  resources@cnLevelSpacingF = 1.0
  plot(1) = gsn_contour_map(xwks, f3d(kmax,:,:), resources)
  do k=0, nz-1
    fill_nmm_grid2(DV(k,:,:),nx,ny,f3d(k,:,:),2)
  end do
;  resources@cnLevelSpacingF = 1.0
  plot(2) = gsn_contour_map(xwks, f3d(kmax,::,:), resources)
  do k=0, nz-1
    fill_nmm_grid2(DQ(k,:,:),nx,ny,f3d(k,:,:),1)
  end do
;  resources@cnLevelSpacingF = 1.0
  plot(3) = gsn_contour_map(xwks, f3d(kmax,:,:), resources)

  resourcesP                    =  True              ; plot mods desired
  resourcesP@gsnPanelFigureStrings = titles
  resourcesP@gsnPanelFigureStringsFontHeightF = 0.01 
  resourcesP@amJust = "TopLeft"     
  resourcesP@gsnPanelFigureStringsPerimOn = False  
  gsn_panel(xwks,plot,(/2,2/),resourcesP)

  delete(plot)
  delete(resources)
  delete(resourcesP)
end

