!=================================================================================
!=================================================================================
        subroutine process_allrjlists(var)

        implicit none

        character(4),intent(in)::var

        integer(4),parameter::nt=20000
        character(1),parameter:: star='*'

        logical lsta,lwfo,lglb,ldyn
        integer(4) nsta,nwfo,nglb,ndyn
        integer(4) lun,m,n,ncount,nobs,n1,nn

        integer(4) itype_sta(nt)
        integer(4) itype_wfo(nt)
        integer(4) itype_glb(nt)
        integer(4) itype_dyn(nt)

        real(4) rlat_sta(nt)
        real(4) rlat_wfo(nt)
        real(4) rlat_glb(nt)
        real(4) rlat_dyn(nt)

        real(4) rlon_sta(nt)
        real(4) rlon_wfo(nt)
        real(4) rlon_glb(nt)
        real(4) rlon_dyn(nt)
 
        character(8) cstation_sta(nt)
        character(8) cstation_wfo(nt)
        character(8) cstation_glb(nt)
        character(8) cstation_dyn(nt)

        character(2) cloc_sta(nt)
        character(2) cloc_wfo(nt)
        character(2) cloc_glb(nt)
        character(2) cloc_dyn(nt)

        character(30) corigin_sta(nt)
        character(30) corigin_wfo(nt)
        character(30) corigin_glb(nt)
        character(30) corigin_dyn(nt)

        integer(4),allocatable:: itype(:)
        real(4),allocatable:: rlat(:)
        real(4),allocatable:: rlon(:)
        character(8),allocatable:: cstation(:)
        character(2),allocatable:: cloc(:)
        character(30),allocatable:: corigin(:)

        integer(4),allocatable:: iflag(:)
        integer(4) kx
        logical fexist

        character(8) csta
        character(7) coriginaux
        character(80) ch0,ch1,ch2(6)
 
        data ch2/'reject list for wind obs', &
                  'reject list for temperature obs', &
                  'reject list for surface pressure obs', &
                  'reject list for specific humidity obs', &
                  'reject list for satellite wind speed obs', &
                  'reject list for all mass obs'/

        print*,' ***************************************************'
        print*,' entering process_allrjlists . variable is ',var
        print*,' ***************************************************'

        lsta=.false. ; lwfo=.false. ; lglb=.false. ; ldyn=.false.

        inquire(file=trim(var)//'_rjlist.txt_static',exist=lsta)
        inquire(file=trim(var)//'_rjlist.txt_wfos',exist=lwfo)
        inquire(file=trim(var)//'_rjlist.txt_global',exist=lglb)
        inquire(file=trim(var)//'_rjlist.txt_dynamic',exist=ldyn)

        if (.not.(lsta .or. lwfo .or. lglb .or. ldyn)) then
           print*,'variable is ', var
           print*,'no input rjlist available ... returning'
           return
        endif
      
        do n=1,80
          ch0(n:n)=star
        enddo

        corigin_sta(:)='sta------------'
        corigin_wfo(:)='----wfo--------'
        corigin_glb(:)='--------glb----'
        corigin_dyn(:)='------------dyn'

        lun=60 

        nsta=0
        if (lsta) then
          open(lun,file=trim(var)//'_rjlist.txt_static',form='formatted')
          do n=1,3
             read(lun,*) ch1
          enddo
          n=1
100       continue
          read(lun,1234,end=101)cstation_sta(n),itype_sta(n), & 
               rlat_sta(n),rlon_sta(n),cloc_sta(n),coriginaux

               csta(1:8)=cstation_sta(n)(1:8)
               kx=188 ; if (trim(var)=='w') kx=288

               if (itype_sta(n)==kx .and. csta(7:7)==' ' .and. & 
                   (csta(8:8)=='x' .or.  csta(8:8)=='a')) cstation_sta(n)=trim(csta(1:7))
          n=n+1
          goto 100
101       continue
          nsta=n-1
          close(lun)
        end if
        print*,'nsta=',nsta

        nwfo=0
        if (lwfo) then
          open(lun,file=trim(var)//'_rjlist.txt_wfos',form='formatted')
          do n=1,3
             read(lun,*) ch1
          enddo
          n=1
200       continue
          read(lun,1234,end=201)cstation_wfo(n),itype_wfo(n), & 
               rlat_wfo(n),rlon_wfo(n),cloc_wfo(n),coriginaux

               csta(1:8)=cstation_wfo(n)(1:8)
               kx=188 ; if (trim(var)=='w') kx=288

               if (itype_wfo(n)==kx .and. csta(7:7)==' ' .and. &
                   (csta(8:8)=='x' .or.  csta(8:8)=='a')) cstation_wfo(n)=trim(csta(1:7))
          n=n+1
          goto 200
201       continue
          nwfo=n-1
          close(lun)
        end if
        print*,'nwfo=',nwfo

        nglb=0
        if (lglb) then
          open(lun,file=trim(var)//'_rjlist.txt_global',form='formatted')
          do n=1,3
             read(lun,*) ch1
          enddo
          n=1
300       continue
          read(lun,1234,end=301)cstation_glb(n),itype_glb(n), & 
               rlat_glb(n),rlon_glb(n),cloc_glb(n),coriginaux

               csta(1:8)=cstation_glb(n)(1:8)
               kx=188 ; if (trim(var)=='w') kx=288

               if (itype_glb(n)==kx .and. csta(7:7)==' ' .and. &
                   (csta(8:8)=='x' .or.  csta(8:8)=='a')) cstation_glb(n)=trim(csta(1:7))
          n=n+1
          goto 300
301       continue
          nglb=n-1
          close(lun)
        end if
        print*,'nglb=',nglb

        ndyn=0
        if (ldyn) then
          open(lun,file=trim(var)//'_rjlist.txt_dynamic',form='formatted')
          do n=1,3
             read(lun,*) ch1
          enddo
          n=1
400       continue
          read(lun,1234,end=401)cstation_dyn(n),itype_dyn(n), & 
               rlat_dyn(n),rlon_dyn(n),cloc_dyn(n),coriginaux

               csta(1:8)=cstation_dyn(n)(1:8)
               kx=188 ; if (trim(var)=='w') kx=288

               if (itype_dyn(n)==kx .and. csta(7:7)==' ' .and. &
                   (csta(8:8)=='x' .or.  csta(8:8)=='a')) cstation_dyn(n)=trim(csta(1:7))
          n=n+1
          goto 400
401       continue
          ndyn=n-1
          close(lun)
        end if
        print*,'ndyn=',ndyn

        if (lsta .and. lwfo) then
          ncount=0
          do n=1,nsta
             do m=1,nwfo
               if (trim(cstation_sta(n))==trim(cstation_wfo(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the static and the wfo list:',trim(cstation_wfo(m))
                  corigin_sta(n)(5:7)='wfo'
                  corigin_wfo(m)(1:3)='sta'
               endif
             enddo
           enddo
           print*,'nsta,nwfo,ncoincident=',nsta,nwfo,ncount
        endif

        if (lsta .and. lglb) then
          ncount=0
          do n=1,nsta
             do m=1,nglb
               if (trim(cstation_sta(n))==trim(cstation_glb(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the static and the glb list:',trim(cstation_glb(m))
                  corigin_sta(n)(9:11)='glb'
                  corigin_glb(m)(1:3)='sta'
               endif
             enddo
           enddo
           print*,'nsta,nglb,ncoincident=',nsta,nglb,ncount
        endif

        if (lsta .and. ldyn) then
          ncount=0
          do n=1,nsta
             do m=1,ndyn
               if (trim(cstation_sta(n))==trim(cstation_dyn(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the static and the dynamic list:',trim(cstation_dyn(m))
                  corigin_sta(n)(13:15)='dyn'
                  corigin_dyn(m)(1:3)='sta'
               endif
             enddo
           enddo
           print*,'nsta,ndyn,ncoincident=',nsta,ndyn,ncount
        endif

        if (lwfo .and. lglb) then
          ncount=0
          do n=1,nwfo
             do m=1,nglb
               if (trim(cstation_wfo(n))==trim(cstation_glb(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the wfo and the glb list:',trim(cstation_glb(m))
                  corigin_wfo(n)(9:11)='glb'
                  corigin_glb(m)(5:7)='wfo'
               endif
             enddo
           enddo
           print*,'nwfo,nglb,ncoincident=',nwfo,nglb,ncount
        endif

        if (lwfo .and. ldyn) then
          ncount=0
          do n=1,nwfo
             do m=1,ndyn
               if (trim(cstation_wfo(n))==trim(cstation_dyn(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the wfo and the dynamic list:',trim(cstation_dyn(m))
                  corigin_wfo(n)(13:15)='dyn'
                  corigin_dyn(m)(5:7)='wfo'
               endif
             enddo
           enddo
           print*,'nwfo,ndyn,ncoincident=',nwfo,ndyn,ncount
        endif

        if (lglb .and. ldyn) then
          ncount=0
          do n=1,nglb
             do m=1,ndyn
               if (trim(cstation_glb(n))==trim(cstation_dyn(m))) then
                  ncount=ncount+1
                  print*,'this ob is on both the glb and the dynamic list:',trim(cstation_dyn(m))
                  corigin_glb(n)(13:15)='dyn'
                  corigin_dyn(m)(9:11)='glb'
               endif
             enddo
           enddo
           print*,'nglb,ndyn,ncoincident=',nglb,ndyn,ncount
        endif


        nobs=nsta+nwfo+nglb+ndyn
        print*,'total number of reject obs incluing duplicates: nobs=',nobs

        allocate(cstation(max(1,nobs)))
        allocate(itype(max(1,nobs)))
        allocate(rlat(max(1,nobs)))
        allocate(rlon(max(1,nobs)))
        allocate(cloc(max(1,nobs)))
        allocate(corigin(max(1,nobs)))
        allocate(iflag(max(1,nobs)))

        n1=1
        do n=n1,nsta
           nn=n-n1+1
           cstation(n)=cstation_sta(nn)
           itype(n)=itype_sta(nn)
           rlat(n)=rlat_sta(nn)
           rlon(n)=rlon_sta(nn)
           cloc(n)=cloc_sta(nn)
           corigin(n)=corigin_sta(nn)
        enddo

        n1=nsta+1
        do n=n1,nsta+nwfo
           nn=n-n1+1
           cstation(n)=cstation_wfo(nn)
           itype(n)=itype_wfo(nn)
           rlat(n)=rlat_wfo(nn)
           rlon(n)=rlon_wfo(nn)
           cloc(n)=cloc_wfo(nn)
           corigin(n)=corigin_wfo(nn)
        enddo

        n1=(nsta+nwfo)+1
        do n=n1,nsta+nwfo+nglb
           nn=n-n1+1
           cstation(n)=cstation_glb(nn)
           itype(n)=itype_glb(nn)
           rlat(n)=rlat_glb(nn)
           rlon(n)=rlon_glb(nn)
           cloc(n)=cloc_glb(nn)
           corigin(n)=corigin_glb(nn)
        enddo

        n1=(nsta+nwfo+nglb)+1
        do n=n1,nobs
           nn=n-n1+1
           cstation(n)=cstation_dyn(nn)
           itype(n)=itype_dyn(nn)
           rlat(n)=rlat_dyn(nn)
           rlon(n)=rlon_dyn(nn)
           cloc(n)=cloc_dyn(nn)
           corigin(n)=corigin_dyn(nn)
        enddo

        iflag(:)=+1
        do n=1,nobs
           do m=n+1,nobs
              if (cstation(n)==cstation(m)) iflag(m)=-1
           enddo
        enddo

        open(lun,file=trim(var)//'_rejectlist',form='formatted')

        if (trim(var)=='w')    n=1
        if (trim(var)=='t')    n=2
        if (trim(var)=='p')    n=3
        if (trim(var)=='q')    n=4
        if (trim(var)=='spd')  n=5
        if (trim(var)=='mass') n=6

        write(lun,'(a80)') ch0
        write(lun,'(a80)') ch2(n)
        write(lun,'(a80)') ch0

        nn=0
        do n=1,nobs
          if (iflag(n) > 0) then 
            nn=nn+1
            write(lun,1235)cstation(n),itype(n),rlat(n),rlon(n),cloc(n),corigin(n)
          endif
        enddo
        print*,'the new ',var,' reject list contains ',nn,'obs'

        close(lun)
     
1234  format("'",a8,'| itype=',i3,2x,'lat=',f10.4,2x,'lon=',f10.4,2x, & 
             'loc=',a2,2x,'origin:',a7,"'")
1235  format("'",a8,'| itype=',i3,2x,'lat=',f10.4,2x,'lon=',f10.4,2x, & 
             'loc=',a2,2x,'origin: ',a15,"'")

        deallocate(cstation)
        deallocate(itype)
        deallocate(rlat)
        deallocate(rlon)
        deallocate(cloc)
        deallocate(corigin)
        deallocate(iflag)

        return
        end
!=================================================================================
!=================================================================================
       subroutine join_rjlists
 
       implicit none

       integer(4),parameter::nfiles=15
       character(90) flname(nfiles),cstart,clast,cstring
       character(2) c2
       character(5) cfmt
       integer(4) m,n,k
       logical fexist

       print*,' ***************************************************'
       print*,' entering join_rjlists'
       print*,' ***************************************************'

       flname(1)='mass_rjlist.txt_static'
       flname(2)='t_rjlist.txt_static'
       flname(3)='q_rjlist.txt_static'
       flname(4)='p_rjlist.txt_static'
       flname(5)='w_rjlist.txt_static'
       flname(6)='mass_rjlist.txt_wfos'
       flname(7)='t_rjlist.txt_wfos'
       flname(8)='q_rjlist.txt_wfos'
       flname(9)='p_rjlist.txt_wfos'
       flname(10)='w_rjlist.txt_wfos'
       flname(11)='mass_rjlist.txt_global'
       flname(12)='t_rjlist.txt_global'
       flname(13)='q_rjlist.txt_global'
       flname(14)='p_rjlist.txt_global'
       flname(15)='w_rjlist.txt_global'

       open (30,file='bigrjlist_new.txt',form='formatted')

       do 500 n=1,nfiles
          fexist=.false.
          inquire(file=trim(flname(n)),exist=fexist)
          if (fexist) then
              open (20,file=trim(flname(n)),form='formatted')
              cstart='start of '//'rtma_'//trim(flname(n)) 
              write(30,"(a)") trim(cstart) 
              do 100 m=1,100000
                 read(20,"(a90)",end=101) cstring
                 k=len_trim(cstring)
                 write(c2,"(i2.2)") k
                 cfmt="("//'a'//c2//")"
                 write(30,cfmt) trim(cstring)
!                write(30,"(a)") trim(cstring)   !works too
100           continue
101           continue
              clast='end of '//'rtma_'//trim(flname(n)) 
              write(30,"(a)") trim(clast) 
             close(20) 
          endif
500    continue

       print*,' ***************************************************'
       print*,' exiting join_rjlists'
       print*,' ***************************************************'
       return
       end
!=================================================================================
!=================================================================================
       subroutine separate_rjlists
       implicit none

       integer(4),parameter::nfiles=15
       character(90) flname(nfiles),cstring
       character(2) c2
       character(5) cfmt
       integer(4) m,n,k,nstart,nend
       logical fexist

       print*,' ***************************************************'
       print*,' entering separate_rjlists'
       print*,' ***************************************************'

       flname(1)='mass_rjlist.txt_static'
       flname(2)='t_rjlist.txt_static'
       flname(3)='q_rjlist.txt_static'
       flname(4)='p_rjlist.txt_static'
       flname(5)='w_rjlist.txt_static'
       flname(6)='mass_rjlist.txt_wfos'
       flname(7)='t_rjlist.txt_wfos'
       flname(8)='q_rjlist.txt_wfos'
       flname(9)='p_rjlist.txt_wfos'
       flname(10)='w_rjlist.txt_wfos'
       flname(11)='mass_rjlist.txt_global'
       flname(12)='t_rjlist.txt_global'
       flname(13)='q_rjlist.txt_global'
       flname(14)='p_rjlist.txt_global'
       flname(15)='w_rjlist.txt_global'

       fexist=.false.
       inquire(file='bigrjlist.txt',exist=fexist)
       if (fexist) then
          open (30,file='bigrjlist.txt',form='formatted')

          do 500 n=1,nfiles
             rewind(30)
             nstart=-999  ; nend=-999
             do 100 m=1,100000
                 read(30,"(a90)",end=101) cstring
                 if (trim(cstring)=='start of '//'rtma_'//trim(flname(n))) nstart=m
                 if (trim(cstring)=='end of '//'rtma_'//trim(flname(n)))   nend=m
100          continue
101          continue
             print*,'in file number,nstart,nend=',n,nstart,nend 
             if (nstart.gt.0 .and. nend.gt.0) then
                open (20,file=trim(flname(n)),form='formatted')
                rewind(30)
                do  m=1,nend
                   read(30,"(a90)") cstring
                   if (m.gt.nstart .and. m.lt.nend) then
                      k=len_trim(cstring)
                      write(c2,"(i2.2)") k
                      cfmt="("//'a'//c2//")"
                      write(20,cfmt) trim(cstring)
!                     write(20,"(a)") trim(cstring)   !works too
                   endif
                enddo
                close(20)
             endif
500       continue
          close(30)
       endif
          
       print*,' ***************************************************'
       print*,' exiting separate_rjlists'
       print*,' ***************************************************'

       return
       end
