module errs_common
!$$$ module documentation block
!           .      .    .                                       .
! module:   errs_common
!   prgmmr: pondeca          org: np23                date: 2012-11-13
!
! abstract: 
!
!
! program history log:
!   2012-10-15  pondeca - 
!
! attributes:
!   language: f90
!   machine:
!
!$$$ end documentation block

  use kinds, only: i_kind,r_single

  implicit none

  real(r_single),allocatable,dimension(:,:):: psierr
  real(r_single),allocatable,dimension(:,:):: chierr
  real(r_single),allocatable,dimension(:,:):: uerr
  real(r_single),allocatable,dimension(:,:):: verr
  real(r_single),allocatable,dimension(:,:):: uerr2
  real(r_single),allocatable,dimension(:,:):: verr2
  real(r_single),allocatable,dimension(:,:):: wspderr
  real(r_single),allocatable,dimension(:,:):: wdirerr
  real(r_single),allocatable,dimension(:,:):: wdirerr2
  real(r_single),allocatable,dimension(:,:):: terr
  real(r_single),allocatable,dimension(:,:):: tderr
  real(r_single),allocatable,dimension(:,:):: qerr
  real(r_single),allocatable,dimension(:,:):: perr
  real(r_single),allocatable,dimension(:,:):: gusterr
  real(r_single),allocatable,dimension(:,:):: viserr
  real(r_single),allocatable,dimension(:,:):: pblherr
  real(r_single),allocatable,dimension(:,:):: disterr


contains

subroutine create_errs_common(i1,i2,j1,j2,igust,ivis,ipblh,idist)

   implicit none
 
   integer(i_kind),intent(in)::i1,i2,j1,j2
   integer(i_kind),intent(in)::igust,ivis,ipblh,idist

   allocate ( psierr   (i1:i2,j1:j2) )
   allocate ( chierr   (i1:i2,j1:j2) )
   allocate ( uerr     (i1:i2,j1:j2) )
   allocate ( verr     (i1:i2,j1:j2) )
   allocate ( uerr2    (i1:i2,j1:j2) )
   allocate ( verr2    (i1:i2,j1:j2) )
   allocate ( wspderr  (i1:i2,j1:j2) )
   allocate ( wdirerr  (i1:i2,j1:j2) )
   allocate ( wdirerr2 (i1:i2,j1:j2) )
   allocate ( terr     (i1:i2,j1:j2) )
   allocate ( tderr    (i1:i2,j1:j2) )
   allocate ( qerr     (i1:i2,j1:j2) )
   allocate ( perr     (i1:i2,j1:j2) )

   if (igust > 0) allocate ( gusterr  (i1:i2,j1:j2) )
   if (ivis  > 0) allocate ( viserr   (i1:i2,j1:j2) )
   if (ipblh > 0) allocate ( pblherr  (i1:i2,j1:j2) )
   if (idist > 0) allocate ( disterr  (i1:i2,j1:j2) )
 
end subroutine create_errs_common

subroutine destroy_errs_common(igust,ivis,ipblh,idist)
   implicit none
 
   integer(i_kind),intent(in)::igust,ivis,ipblh,idist

   deallocate ( psierr   )
   deallocate ( chierr   )
   deallocate ( uerr     )
   deallocate ( verr     )
   deallocate ( uerr2    )
   deallocate ( verr2    )
   deallocate ( wspderr  )
   deallocate ( wdirerr  )
   deallocate ( wdirerr2 ) 
   deallocate ( terr     )
   deallocate ( tderr    )
   deallocate ( qerr     )
   deallocate ( perr     )

   if (igust > 0) deallocate ( gusterr  )
   if (ivis  > 0) deallocate ( viserr   )
   if (ipblh > 0) deallocate ( pblherr  )
   if (idist > 0) deallocate ( disterr  )

end subroutine destroy_errs_common

end module errs_common
!************************************************************
!************************************************************
