       SUBROUTINE W3FB08_8(ALAT,ALON,ALAT1,ALON1,ALATIN,DX,XI,XJ)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM:  W3FB08        LAT/LON TO MERC (I,J) FOR GRIB
C   PRGMMR: STACKPOLE        ORG: NMC42       DATE:88-04-05
C
C ABSTRACT: CONVERTS A LOCATION ON EARTH GIVEN IN
C   THE COORDINATE SYSTEM OF LATITUDE/LONGITUDE TO AN (I,J)
C   COORDINATE SYSTEM OVERLAID ON A MERCATOR MAP PROJECTION
C   W3FB08 IS THE REVERSE OF W3FB09
C   USES GRIB SPECIFICATION OF THE LOCATION OF THE GRID
C
C PROGRAM HISTORY LOG:
C   88-03-01  ORIGINAL AUTHOR:  STACKPOLE, W/NMC42
C   90-04-12  R.E.JONES   CONVERT TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FB08 (ALAT,ALON,ALAT1,ALON1,ALATIN,DX,XI,XJ)
C   INPUT ARGUMENT LIST:
C     ALAT     - LATITUDE IN DEGREES (NEGATIVE IN SOUTHERN HEMIS)
C     ALON     - EAST LONGITUDE IN DEGREES, REAL*4
C     ALAT1    - LATITUDE  OF LOWER LEFT CORNER OF GRID (POINT (1,1))
C     ALON1    - LONGITUDE OF LOWER LEFT CORNER OF GRID (POINT (1,1))
C                ALL REAL*4
C     ALATIN   - THE LATITUDE AT WHICH THE MERCATOR CYLINDER
C                INTERSECTS THE EARTH
C     DX       - MESH LENGTH OF GRID IN METERS AT ALATIN
C
C   OUTPUT ARGUMENT LIST:
C     XI       - I COORDINATE OF THE POINT SPECIFIED BY ALAT, ALON
C     XJ       - J COORDINATE OF THE POINT; BOTH REAL*4
C
C   REMARKS: FORMULAE AND NOTATION LOOSELY BASED ON HOKE, HAYES,
C     AND RENNINGER'S "MAP PROJECTIONS AND GRID SYSTEMS...", MARCH 1981
C     AFGWC/TN-79/003
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP8/832
C
C$$$
C
         DATA  RERTH /6.3712E+6/, PI/3.1416/
C
C        PRELIMINARY VARIABLES AND REDIFINITIONS
C
         RADPD  = PI    / 180.0
         DEGPR  = 180.0 / PI
         CLAIN  = COS(RADPD*ALATIN)
         DELLON = DX   / (RERTH*CLAIN)
C
C        GET DISTANCE FROM EQUATOR TO ORIGIN ALAT1
C
         DJEO = 0.
         IF (ALAT1.NE.0.)
     &     DJEO = (ALOG(TAN(0.5*((ALAT1+90.0)*RADPD))))/DELLON
C
C        NOW THE I AND J COORDINATES
C
         XI = 1. + ((ALON - ALON1)/(DELLON*DEGPR))
         XJ = 1. + (ALOG(TAN(0.5*((ALAT + 90.) * RADPD))))/
     &               DELLON
     &             - DJEO
C
      RETURN
      END
