#!/bin/ksh 
# . /home/lenzen/.bashrc
# Source global definitions
#if [ -f /etc/bashrc ]; then
#        . /etc/bashrc
#fi
#####################################################
# Setup environment -- EPA Atmos Cluster
#####################################################

export CDATE=`date -ud "${JDATE:0:4}-01-01 ${JTIME:0:2}:${JTIME:2:2}:${JTIME:4:2}+0000 +${JDATE:4:3}day -1day" +%Y%m%d%H%M%S`
export CDATEB=`date -ud "${JDATE:0:4}-01-01 ${JTIME:0:2}:${JTIME:2:2}:${JTIME:4:2}+0000 +${JDATE:4:3}day -1day -1hour" +%Y%m%d%H%M%S`
#echo ITIME $ITIME JTIME $JTIME CDATE $CDATE
export GSIDATE=`date -ud "${JDATE:0:4}-01-01 ${JTIME:0:2}:${JTIME:2:2}:${JTIME:4:2}+0000 +${JDATE:4:3}day -1day" +%Y%m%d%H`
export cycledated=`date -ud "${JDATE:0:4}-01-01 +${JDATE:4:3}day -1day" +%Y%m%d%H`
export METFILEDATE=`echo $CDATE | cut -c3-8`
export BUFRDATE=$CDATE
export HOURRES=`echo $CDATE | cut -c9-10`
export YYYYMMDDRES=`echo $CDATE | cut -c1-8`
export CDATEB
export YYYYMMDD=`echo $CDATEB | cut -c1-8`
export HH=`echo $CDATEB | cut -c9-10`
export YYYY=`echo $CDATEB | cut -c1-4`
export MM=`echo $CDATEB | cut -c5-6`
export DD=`echo $CDATEB | cut -c7-8`
export CMAQOUTDIR=$OUTDIR #from CMAQ
export ITIME=`expr $JTIME / 10000` #JTIME from gsi.source created by cmaq driver.F 

# AJL set up directory path to save GSI output and increment files
export CMAQGSIOUTDIR=$CMAQOUTDIR/GSI
export outdirgsi=${CMAQGSIOUTDIR}/$GSIDATE
export CMAQGSIDIFFDIR=$outdirgsi
mkdir -p $outdirgsi

export GSIMAINRUNDIR=$GSIOUT #from CMAQ csh script
mkdir -p $GSIMAINRUNDIR

# AJl set up scratch directory to run gsi inside
export scratch_d_gsi=$GSIMAINRUNDIR/$GSIDATE
mkdir -p $scratch_d_gsi

# AJL setup path to where you stored OMI NO2 bufr files
export base_data_disk=/work/MOD3EVAL/jeast/satellite/TROPOMINO2/data/bufr/

export HOUR=`echo $cycledated | cut -c9-10`
echo HOUR $HOUR
export YYYYMMDD=`echo $cycledated | cut -c1-8`
export MMDD=`echo $cycledated | cut -c5-8`

# AJL path to cmaqrestart file used by GSI
mkdir -p ${GSIOUT}/restart/
export CMAQRESTART=${GSIOUT}/restart/aqm.$YYYYMMDDRES.t${HOURRES}z.gsi.ncf

# AJL set up path where metcro2d and metcro3d files are located
# since writenmmbcmaq2gsino2 need to read them
export METDIR=$METpath #from cmaq csh script

# AJl set up path were grdcro2d is stored so writenmmbcmaq2gsino2 can read it
export PATHGRID=$METDIR

# AJL read in met, grid and CMAQ NO2 file and make file needed by GSI
#$GSISCRIPTDIR/writenmmbcmaq2gsino2.x $CDATE >& $scratch_d_gsi/outwrite.$GSIDATE
#$GSISCRIPTDIR/writenmmbcmaq2gsino2.x $CDATE >& $scratch_d_gsi/outwrite.TEST
#$GSISCRIPTDIR/writenmmbcmaq2gsino2.x $CDATE > $scratch_d_gsi/outwrite.$GSIDATE 2>&1

#export GSI_DIR=/work/ROMO/users/bhenders/HAQAST/NO2ASSIM/gsi_tropomi/
export GSI_DIR=/work/MOD3EVAL/jeast/GSI/gsi_tropomi/
export GSI_RUN_DIR=$GSI_DIR/run/
export NO2SCATTERWEIGHT=YES

# set up where bufr no2 files are
# set up routine to modify dates
export new_date=$utilr_dir/da_advance_time.exe
# now BUFRDATE is same as GSIDATE  since GSIDATE is now end of CMAQ period of GSI
# restart should be 3 hours earlier than gsidate
# set up path to observations

# ajl GSIDATE is begging time of CMAQ run need to increment to have correct date
export BUFRDATE=$GSIDATE
YYYYB=`echo $BUFRDATE | cut -c 1-4`
MMB=`echo $BUFRDATE | cut -c 5-6`
OBS_ROOT=$base_data_disk/
# check to see if have buffer files if not skip GSI

# set no2 error
# since now slant column should be bigger
export no2gross=4000

export FIX_ROOT=${GSI_DIR}/fix/
#export BERROR=${FIX_ROOT}/be.201807.cmaq.hemi.antcut.gsi.bw2.gcv
qcase=$(echo $GSIDIR | rev | cut -d'/' -f2 | rev ) # extract case name, same as APPL in cmaq run script
#export BERROR=${FIX_ROOT}/be.${YYYY}${MM}.cmaq.hemi.${qcase}.gsi.bw2.gcv

export BERROR=${FIX_ROOT}/be.${YYYY}${MM}.cmaq.hemi.lnoxcut.gsi.bw2.gcv
#export BERROR=${FIX_ROOT}/be.${YYYY}${MM}.cmaq.hemi.antcut.gsi.bw2.gcv
                            
# run GSI script
# want time to be BUFR time since GSIDATE is CMAQINCHR earlier
# run GSI using all of NO2 data could make scripts to use a thinning grid
# AJL CHANGE HERE if want to change name of GSi run script
  #/work/MOD3EVAL/jeast/scratch/debug_gsi/CMAQ_testcase/gsi/run_gsi_CMAQ.TROPOMI.NO2.hemi.TEST.ksh >& $scratch_d_gsi/outcmaqgsi.$BUFRDATE




#####################################################
# machine set up (users should change this part)
#####################################################

  
ARCH='LINUX'
#  ARCH='LINUX_PBS'
# Supported configurations:
            # IBM_LSF,
            # LINUX, LINUX_LSF, LINUX_PBS,
            # DARWIN_PGI
#
#####################################################
# case set up (users should change this part)
#####################################################
#
# ANAL_TIME= analysis time  (YYYYMMDDHH)
# WORK_ROOT= working directory, where GSI runs
# PREPBURF = path of PreBUFR conventional obs
# BK_ROOT  = path of background files
# OBS_ROOT = path of observations files
# FIX_ROOT = path of fix files
# GSI_EXE  = path and name of the gsi executable 
#  export DONO2=YES
export OMP_NUM_THREADS=1
export FORT_BUFFERED=true
#  ANAL_TIME=2015031100
#  GUESS_TIME=2015031100
#  echo GSIDATE $GSIDATE BUFRDATE $BUFRDATE
GSI_TIME=$GSIDATE
ANAL_TIME=$GSI_TIME
GUESS_TIME=$GSI_TIME
echo GSI_TIME $GSIDATE
SST_TIME=`echo $ANAL_TIME | cut -c 1-8`12
YYYY=`echo $ANAL_TIME | cut -c 1-4`
YYYYB=`echo $BUFRDATE | cut -c 1-4`
MM=`echo $ANAL_TIME | cut -c 5-6`
MMB=`echo $BUFRDATE | cut -c 5-6`
DD=`echo $ANAL_TIME | cut -c 7-8`
HH=`echo $ANAL_TIME | cut -c 9-10`
cmaqfile=cmaq_d01_${YYYY}-${MM}-${DD}_${HH}:00:00
echo cmaqfile $cmaqfile
WORK_ROOT=$scratch_d_gsi
OBS_ROOT=$base_data_disk/ #$YYYYB/
echo JDE $OBS_ROOT 
# Make sure OBS_ROOT is defined and exists
if [ ! "${OBS_ROOT}" ]; then
  echo "ERROR: \$OBS_ROOT is not defined!"
  rmdir $WORK_ROOT
  exit 1
fi
PREPBUFR=${OBS_ROOT}/gdas1.t00z.prepbufr.nr
FIX_ROOT=${GSI_DIR}/fix/
CRTM_ROOT=${GSI_DIR}/src/libs/crtm_2.1.3
GSI_EXE=${GSI_DIR}/run/gsi.exe
# path to uwh file or restart file
BK_FILE=

#------------------------------------------------
# if_clean = clean  : delete temperal files in working directory (default)
#            no     : leave running directory as is (this is for debug only)
#  if_clean=clean
if_clean=no

# Set the JCAP resolution which you want.
# All resolutions use LEVS=64
JCAP=62
LEVS=44
JCAP_B=62
#
#
BYTE_ORDER=Big_Endian
#workdir=${WORK_ROOT}
#echo " Create working directory:" ${workdir}
cd ${WORK_ROOT}
/bin/rm -rf ${SCRATCHDIR}/GSIDONE
sleep 1
# clean out old sigf
#/bin/rm -f sigf00*

# GSIPROC is processor number used for GSI analysis
GSIPROC=24

cat << EOF > ${scratch_d_gsi}/submit.gsi
#!/bin/bash
#SBATCH -p debug
#SBATCH -t 00:20:00
#SBATCH -n $GSIPROC
#SBATCH --gid=mod3eval
#SBATCH --account=mod3eval
#SBATCH --exclusive
#SBATCH -J gsi
#SBATCH -o GSI.%j.out
#SBATCH -e GSI.%j.out

# intelmpi 19
. /etc/profile.d/modules.sh
module purge
module load intel/19.0.5 intelmpi/19.0.8 netcdf-4.7.4/intel-19.0

module load ucx/1.10.1

# write CMAQ restart file
$GSISCRIPTDIR/writenmmbcmaq2gsino2.x $CDATE > $scratch_d_gsi/outwrite.$GSIDATE 2>&1

# Prep some files
echo ' Run GSI with' ${bk_core} 'background'
/bin/rm -f sigf00*
rsync -av $GSIDIR/$cmaqfile sigf00 || exit 1
cp -p sigf00 sigf00.orig

# run gsi
mpirun -np $GSIPROC ./gsi.exe
EXIT_STATUS=\$?
echo EXIT_STATUS is \${EXIT_STATUS}
if test \$EXIT_STATUS -eq 0; then # successful GSI
    # update restart file
    $GSISCRIPTDIR/updaterestart.x > $scratch_d_gsi/outupdate.$GSIDATE 2>&1
    echo GSIDONE > ${SCRATCHDIR}/GSIDONE  
else # failed GSI
    echo 'GSI FAILED' > $scratch_d_gsi/GSIFAIL
fi
EOF

#####################################################
# Users should NOT change script after this point
#####################################################
#

case $ARCH in
   'IBM_LSF')
      ###### IBM LSF (Load Sharing Facility)
      RUN_COMMAND="mpirun.lsf " ;;

   'LINUX')
      if [ $GSIPROC = 1 ]; then
         #### Linux workstation - single processor
#         RUN_COMMAND="srun --export=ALL --overcommit -N 1-1 -n 1    "
         #RUN_COMMAND=""
         RUN_COMMAND="mpirun -np ${GSIPROC}  "
      else
         ###### Linux workstation -  mpi run
#         RUN_COMMAND="srun --export=ALL --overcommit -N 1-1 -n ${GSIPROC}  "
#         RUN_COMMAND="srun --ntasks=2 --export=ALL  "
         #RUN_COMMAND="mpirun -np ${GSIPROC}  "
         RUN_COMMAND=""
      fi ;;

   'LINUX_LSF')
      ###### LINUX LSF (Load Sharing Facility)
      RUN_COMMAND="mpirun.lsf " ;;

   'LINUX_PBS')
      #### Linux cluster PBS (Portable Batch System)
      ulimit -a
      RUN_COMMAND="mpirun -np ${GSIPROC} " ;;

   'DARWIN_PGI')
      ### Mac - mpi run
      if [ $GSIPROC = 1 ]; then
         #### Mac workstation - single processor
         RUN_COMMAND=""
      else
         ###### Mac workstation -  mpi run
         RUN_COMMAND="mpirun -np ${GSIPROC} -machinefile ~/mach "
      fi ;;

   * )
     print "error: $ARCH is not a supported platform configuration."
     exit 1 ;;
esac


##################################################################################
# Check GSI needed environment variables are defined and exist
#
 
# Make sure ANAL_TIME is defined and in the correct format
if [ ! "${ANAL_TIME}" ]; then
  echo "ERROR: \$ANAL_TIME is not defined!"
  exit 1
fi

# Make sure WORK_ROOT is defined and exists
if [ ! "${WORK_ROOT}" ]; then
  echo "ERROR: \$WORK_ROOT is not defined!"
  exit 1
fi

# Make sure the background file exists
#if [ ! -r "${BK_ROOT}" ]; then
#  echo "ERROR: ${BK_ROOT} does not exist!"
#exit 1
#fi

# Make sure OBS_ROOT is defined and exists
if [ ! "${OBS_ROOT}" ]; then
  echo "ERROR: \$OBS_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${OBS_ROOT}" ]; then
  echo "ERROR: OBS_ROOT directory '${OBS_ROOT}' does not exist!"
  exit 1
fi

# Set the path to the GSI static files
if [ ! "${FIX_ROOT}" ]; then
  echo "ERROR: \$FIX_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${FIX_ROOT}" ]; then
  echo "ERROR: fix directory '${FIX_ROOT}' does not exist!"
  exit 1
fi

# Set the path to the CRTM coefficients 
if [ ! "${CRTM_ROOT}" ]; then
  echo "ERROR: \$CRTM_ROOT is not defined!"
  exit 1
fi
if [ ! -d "${CRTM_ROOT}" ]; then
  echo "ERROR: fix directory '${CRTM_ROOT}' does not exist!"
  exit 1
fi


# Make sure the GSI executable exists
if [ ! -x "${GSI_EXE}" ]; then
  echo "ERROR: ${GSI_EXE} does not exist!"
  exit 1
fi

# Check to make sure the number of processors for running GSI was specified
if [ -z "${GSIPROC}" ]; then
  echo "ERROR: The variable $GSIPROC must be set to contain the number of processors to run GSI"
  exit 1
fi

################################################################################
## Given the analysis date, compute the date from which the
# first guess comes.  Extract cycle and set prefix and suffix
# for guess and observation data files
hha=`echo $ANAL_TIME | cut -c9-10`
hhg=`echo $GUESS_TIME | cut -c9-10`
echo hha $hha hhg $hhg

#
##################################################################################
# Create the ram work directory and cd into it


#
##################################################################################
# Set some parameters for use by the GSI executable and to build the namelist
echo " Build the namelist "

# Given the requested resolution, set dependent resolution parameters
if [[ "$JCAP" = "382" ]]; then
   LONA=768
   LATA=384
   DELTIM=180
   resol=1
elif [[ "$JCAP" = "62" ]]; then
   LONA=192
   LATA=94
   DELTIM=1200
   resol=2
else
   echo "INVALID JCAP = $JCAP"
#   exit
fi
LONA=187
LATA=187
NLAT=` expr $LATA + 2 `

# CO2 namelist and file decisions
ICO2=${ICO2:-0}
if [ $ICO2 -gt 0 ] ; then
        # Copy co2 files to $workdir
        co2dir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./global_co2_data.txt
        co2=$co2dir/global_co2.gcmscl_$yyyy.txt
        while [ ! -s $co2 ] ; do
                ((yyyy-=1))
                co2=$co2dir/global_co2.gcmscl_$yyyy.txt
        done
        if [ -s $co2 ] ; then
                cp $co2 ./global_co2_data.txt
        fi
        if [ ! -s ./global_co2_data.txt ] ; then
                echo "\./global_co2_data.txt" not created
                exit 1
        fi
fi
#CH4 file decision
ICH4=${ICH4:-0}
if [ $ICH4 -gt 0 ] ; then
#        # Copy ch4 files to $workdir
        ch4dir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./ch4globaldata.txt
        ch4=$ch4dir/global_ch4_esrlctm_$yyyy.txt
        while [ ! -s $ch4 ] ; do
                ((yyyy-=1))
                ch4=$ch4dir/global_ch4_esrlctm_$yyyy.txt
        done
        if [ -s $ch4 ] ; then
                cp $ch4 ./ch4globaldata.txt
        fi
        if [ ! -s ./ch4globaldata.txt ] ; then
                echo "\./ch4globaldata.txt" not created
                exit 1
        fi
fi
IN2O=${IN2O:-0}
if [ $IN2O -gt 0 ] ; then
#        # Copy ch4 files to $workdir
        n2odir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./n2oglobaldata.txt
        n2o=$n2odir/global_n2o_esrlctm_$yyyy.txt
        while [ ! -s $n2o ] ; do
                ((yyyy-=1))
                n2o=$n2odir/global_n2o_esrlctm_$yyyy.txt
        done
        if [ -s $n2o ] ; then
                cp $n2o ./n2oglobaldata.txt
        fi
        if [ ! -s ./n2oglobaldata.txt ] ; then
                echo "\./n2oglobaldata.txt" not created
                exit 1
        fi
fi
ICO=${ICO:-0}
if [ $ICO -gt 0 ] ; then
#        # Copy CO files to $workdir
        codir=${FIX_ROOT}/global
        yyyy=`echo $ANAL_TIME | cut -c1-4`
        rm ./coglobaldata.txt
        co=$codir/global_co_esrlctm_$yyyy.txt
        while [ ! -s $co ] ; do
                ((yyyy-=1))
                co=$codir/global_co_esrlctm_$yyyy.txt
        done
        if [ -s $co ] ; then
                cp $co ./coglobaldata.txt
        fi
        if [ ! -s ./coglobaldata.txt ] ; then
                echo "\./coglobaldata.txt" not created
                exit 1
        fi
fi
SETUP=""
GRIDOPTS=""
BKGVERR=""
ANBKGERR=""
JCOPTS=""
STRONGOPTS=""
OBSQC=""
OBSINPUT=""
SUPERRAD=""
SINGLEOB=""

ln -fs ${GSI_EXE} . || exit 1


# Link to the prepbufr data
/bin/rm -f .prepbufr
#ln -s ${PREPBUFR} ./prepbufr  #JDE dont need

# Link to the radiance data
suffix=tm00.bufr_d
/bin/rm -f  ./tropomino2bufr 


#
##################################################################################

# echo " Copy fixed files and link CRTM coefficient files to working directory"

# Set fixed files
#   berror   = forecast model background error statistics
#   specoef  = CRTM spectral coefficients
#   trncoef  = CRTM transmittance coefficients
#   emiscoef = CRTM coefficients for IR sea surface emissivity model
#   aerocoef = CRTM coefficients for aerosol effects
#   cldcoef  = CRTM coefficients for cloud effects
#   satinfo  = text file with information about assimilation of brightness temperatures
#   satangl  = angle dependent bias correction file (fixed in time)
#   pcpinfo  = text file with information about assimilation of prepcipitation rates
#   ozinfo   = text file with information about assimilation of ozone data
#   errtable = text file with obs error for conventional data (regional only)
#   convinfo = text file with information about assimilation of conventional data
#   bufrtable= text file ONLY needed for single obs test (oneobstest=.true.)
#   bftab_sst= bufr table for sst ONLY needed for sst retrieval (retrieval=.true.)

#ANAVINFO=${FIX_ROOT}/global_anavinfo.l64.txt
ANAVINFO=${FIX_ROOT}/global_raqms.txt

# AJL this can be changed
# AJL 5 times inflation of NO2 Background covariance worked well with 15 percent NOX reduction GENBE
# Background covariance
# AJL will have to see if this is suitable for the lightning NOX experiment
export NO2BERRORMULT=5.

# AJL need to set to either 15 percent NOX reduction GENBE Background covariance or
# AJL the lightning NOX experiment GENBE Background covariance

#BERROR=${FIX_ROOT}/wrf-arw-gsi_be_big_endian_LNOX_test.gcv

SATINFO=${FIX_ROOT}/global_satinfo_reg_test.txt
scaninfo=${FIX_ROOT}/global_scaninfo.txt
SATANGL=${FIX_ROOT}/global_satangbias.txt
atmsbeamdat=${FIX_ROOT}/atms_beamwidth.txt
CONVINFO=${FIX_ROOT}/global_convinfo.txt
#OZINFO=${FIX_ROOT}/global_ozinfo.30.raqms.txt
OZINFO=${FIX_ROOT}/global_ozinfo.30.215.raqms.txt
PCPINFO=${FIX_ROOT}/global_pcpinfo.txt
OBERROR=${FIX_ROOT}/prepobs_errtable.global

# Only need this file for single obs test
#bufrtable=${FIX_ROOT}/prepobs_prep.bufrtable

# Only need this file for sst retrieval
#bftab_sst=${FIX_ROOT}/bufrtab.012

#  copy Fixed fields to working directory
cp $ANAVINFO anavinfo
cp $BERROR   berror_stats
cp $SATANGL  satbias_angle
cp $atmsbeamdat  atms_beamwidth.txt
cp $SATINFO  satinfo
cp $scaninfo scaninfo
cp $CONVINFO convinfo
cp $OZINFO   ozinfo
cp $PCPINFO  pcpinfo
cp $OBERROR  errtable

# cp $bufrtable ./prepobs_prep.bufrtable
# cp $bftab_sst ./bftab_sstphr

#
# CRTM Spectral and Transmittance coefficients
RTMFIX=${CRTM_ROOT}/${BYTE_ORDER}
emiscoef_IRwater=${RTMFIX}/Nalli.IRwater.EmisCoeff.bin
emiscoef_IRice=${RTMFIX}/NPOESS.IRice.EmisCoeff.bin
emiscoef_IRland=${RTMFIX}/NPOESS.IRland.EmisCoeff.bin
emiscoef_IRsnow=${RTMFIX}/NPOESS.IRsnow.EmisCoeff.bin
emiscoef_VISice=${RTMFIX}/NPOESS.VISice.EmisCoeff.bin
emiscoef_VISland=${RTMFIX}/NPOESS.VISland.EmisCoeff.bin
emiscoef_VISsnow=${RTMFIX}/NPOESS.VISsnow.EmisCoeff.bin
emiscoef_VISwater=${RTMFIX}/NPOESS.VISwater.EmisCoeff.bin
emiscoef_MWwater=${RTMFIX}/FASTEM5.MWwater.EmisCoeff.bin
aercoef=${RTMFIX}/AerosolCoeff.bin
cldcoef=${RTMFIX}/CloudCoeff.bin

#JDE# ln -s $emiscoef_IRwater ./Nalli.IRwater.EmisCoeff.bin
#JDE# ln -s $emiscoef_IRice ./NPOESS.IRice.EmisCoeff.bin
#JDE# ln -s $emiscoef_IRsnow ./NPOESS.IRsnow.EmisCoeff.bin
#JDE# ln -s $emiscoef_IRland ./NPOESS.IRland.EmisCoeff.bin
#JDE# ln -s $emiscoef_VISice ./NPOESS.VISice.EmisCoeff.bin
#JDE# ln -s $emiscoef_VISland ./NPOESS.VISland.EmisCoeff.bin
#JDE# ln -s $emiscoef_VISsnow ./NPOESS.VISsnow.EmisCoeff.bin
#JDE# ln -s $emiscoef_VISwater ./NPOESS.VISwater.EmisCoeff.bin
#JDE# ln -s $emiscoef_MWwater ./FASTEM5.MWwater.EmisCoeff.bin
#JDE# ln -s $aercoef  ./AerosolCoeff.bin
#JDE# ln -s $cldcoef  ./CloudCoeff.bin
#JDE# # Copy CRTM coefficient files based on entries in satinfo file
#JDE# for file in `awk '{if($1!~"!"){print $1}}' ./satinfo | sort | uniq` ;do
#JDE#    ln -s ${RTMFIX}/${file}.SpcCoeff.bin ./
#JDE#    ln -s ${RTMFIX}/${file}.TauCoeff.bin ./
#JDE# done

#
###################################################
#  run  GSI
###################################################

# This portion moved to SLURM - JDE
#echo ' Run GSI with' ${bk_core} 'background'
#/bin/rm -f sigf00*
#rsync -av $GSIDIR/$cmaqfile sigf00 || exit 1
#cp -p sigf00 sigf00.orig
# This portion moved to SLURM - JDE END

mkdir $GSIDATE
/bin/rm -fr dir.0*
echo JDE ${OBS_ROOT}/tropomi.no2.OFFL.${BUFRDATE}.bufr
if [ -s ${OBS_ROOT}/tropomi.no2.OFFL.${BUFRDATE}.bufr ] ; then
  ln -s ${OBS_ROOT}/tropomi.no2.OFFL.${BUFRDATE}.bufr   ./tropomino2bufr 
  echo JDE ${OBS_ROOT}/tropomi.no2.OFFL.${BUFRDATE}.bufr
#if [ -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE} ] ; then
#  ln -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE}           ./tropomino2bufr 
else
  #rsync -av iris:${OBS_ROOT}/tropomi.no2.OFFL.${BUFRDATE}.bufr   tropomino2bufr 
  echo JDE error! didnt find bufr file
  exit
fi
ANAVINFO=${FIX_ROOT}/global_raqms.oz.no2.txt
ANAVINFO=${FIX_ROOT}/regional_no2.txt
NO2INFO=${FIX_ROOT}/global_no2info.txt
cp $NO2INFO  no2info || exit 1
/bin/rm -f anavinfo
cp $ANAVINFO anavinfo
/bin/rm -f mlsbufr
                                                                                                   

# now do omi GSI

#if [ -s ${OBS_ROOT}/omi.no2.bufr.${BUFRDATE} ];then
if [ -s tropomino2bufr ] || [ -s omibufr ] ;then
  echo do NO2 GSI

  # Build the GSI namelist on-the-fly
  cat << EOF > gsiparm.anl.OMI
 &SETUP
   miter=2,niter(1)=25,niter(2)=25,
   niter_no_qc(1)=50,niter_no_qc(2)=50,
   write_diag(1)=.true.,write_diag(2)=.false.,write_diag(3)=.true.,
   gencode=82,qoption=1,
   factqmin=0.1,factqmax=0.1,deltim=$DELTIM,
   ndat=1,iguess=-1,
   oneobtest=.false.,retrieval=.false.,l_foto=.false.,
   use_pbl=.false.,use_compress=.true.,nsig_ext=12,gpstop=50.,
   use_gfs_nemsio=.false.,lrun_subdirs=.true.,
   nhr_assimilation=0,offtime_data=.true.,min_offset=0,
   $SETUP
 /
 &GRIDOPTS
   JCAP=$JCAP,JCAP_B=$JCAP_B,NLAT=$NLAT,NLON=$LONA,nsig=$LEVS,
   regional=.true.,cmaq_regional=.true.,nlayers(63)=3,nlayers(64)=6,raqms=.false.,
   netcdf=.true.,
   $GRIDOPTS
 /
 &BKGERR
   vs=0.7,
   hzscl=1.7,0.8,0.5,
   hswgt=0.45,0.3,0.25,
   bw=0.0,norsp=4,
   bkgv_flowdep=.true.,bkgv_rewgtfct=1.5,
   $BKGVERR
 /
 &ANBKGERR
   anisotropic=.false.,
   $ANBKGERR
 /
 &JCOPTS
   ljcdfi=.false.,alphajc=0.0,ljcpdry=.true.,bamp_jcpdry=5.0e7,
   $JCOPTS
 /
 &STRONGOPTS
   tlnmc_option=0,nstrong=1,nvmodes_keep=8,period_max=6.,period_width=1.5,
   baldiag_full=.true.,baldiag_inc=.true.,
   $STRONGOPTS
 /
 &OBSQC
   dfact=0.75,dfact1=3.0,noiqc=.true.,oberrflg=.false.,c_varqc=0.02,
   use_poq7=.true.,
   $OBSQC
 /
 &OBS_INPUT
   dmesh(1)=25.0,dmesh(2)=150.0,time_window_max=1.5,
   dfile(1)='tropomino2bufr',   dtype(1)='tropomino2',       dplat(1)='aura',    dsis(1)='omi_aura',        dval(1)=0.0,  dthin(1)=0,  dsfcalc(1)=0,
   $OBSINPUT
 /
  &SUPEROB_RADAR
   $SUPERRAD
 /
 &LAG_DATA
 /
 &HYBRID_ENSEMBLE
   l_hyb_ens=.false.,
 /
 &RAPIDREFRESH_CLDSURF
   dfi_radar_latent_heat_time_period=30.0,
 /
 &CHEM
   berror_chem=.false.,
   oneobtest_chem=.false.,
 /
 &SINGLEOB_TEST
   maginnov=0.1,magoberr=0.1,oneob_type='t',
   oblat=45.,oblon=180.,obpres=1000.,obdattim=${ANAL_TIME},
   obhourset=0.,
   $SINGLEOB
 /
EOF
  /bin/rm -f gsiparm.anl
  rsync -av gsiparm.anl.OMI gsiparm.anl
  sleep 2
  cat gsiparm.anl
  
  case $ARCH in
     'IBM_LSF')
        ${RUN_COMMAND} ./gsi.exe < gsiparm.anl > stdout.OMI.ibm 2>&1  ;;
  
     * )
        ldd ./gsi.exe > ldd.gsi.out
        pwd > pwd.gsi.out
        ls > ls.gsi.out
        #echo "${RUN_COMMAND} ./gsi.exe > ../stdout.OMI.$GSIDATE 2>&1  ;;"
        #${RUN_COMMAND} ./gsi.exe > ../stdout.OMI.$GSIDATE 2>&1  ;;
        echo 'SUBMITTING GSI TO SLURM:'
        echo 'sbatch submit.gsi'
        sbatch submit.gsi
  esac

  #exit 0
  # end of omi if there
  #####JDE#mv sigf00 sigf00.OMI.NO2 || exit 1
  #####JDE#ln -fs sigf00.OMI.NO2 sigf00.OMI || exit 1 # for model
  #####JDE##  make increment file and update restart file
  #####JDE##$GSISCRIPTDIR/updaterestart.x >& $scratch_d_gsi/outupdate.$GSIDATE
  #####JDE#$GSISCRIPTDIR/updaterestart.x > $scratch_d_gsi/outupdate.$GSIDATE 2>&1
  #####JDE##rsync -av $GSIMAINRUNDIR/stdout.OMI.$GSIDATE $CMAQGSIOUTDIR/
  #####JDE#rsync -av $GSIMAINRUNDIR/GSI.???????.out $CMAQGSIOUTDIR/

fi

exit 0
