--T_Morbidity_Ozone
CREATE TABLE IF NOT EXISTS T_Morbidity_Ozone(
	[Year] INTEGER NOT NULL,														--Year
	EndpointId INTEGER NOT NULL,													--Health Impact Function Param Id
	GeoId11 TEXT NOT NULL,															--State FIPS + County FIPS + CensusTract FIPS
	CreatedDate TEXT NOT NULL DEFAULT (DATETIME(CURRENT_TIMESTAMP,'LOCALTIME')),	--Created date
	IncidencesPer10K REAL NOT NULL,													--Incidences per 10k
	IncidencesPercentile REAL NOT NULL,												--Incidences percent rank
	Annual REAL NOT NULL,															--Annual value (µg/m3)
	Population REAL NOT NULL,														--Population
	PointEstimate REAL NOT NULL,													--PointEstimate
	PRIMARY KEY([Year],EndpointId,GeoId11),
	FOREIGN KEY (EndpointId) REFERENCES T_Endpoint(Id)
);

--创建索引
CREATE INDEX IF NOT EXISTS Index_Morbidity_Ozone_1 ON T_Morbidity_Ozone(IncidencesPer10K);
CREATE INDEX IF NOT EXISTS Index_Morbidity_Ozone_2 ON T_Morbidity_Ozone(IncidencesPercentile);
