﻿using NEXUS.Data.Dtos;

namespace NEXUS.WebApi.Controllers
{
    /// <summary>
    /// Cancer Risk
    /// </summary>
    [Route("api/{year}/[controller]/{pollutantType}")]
    public class CancerRiskController : ApiControllerBase
    {
        private readonly ICancerRiskRepository _cancerRiskRepository;

        public CancerRiskController(ICancerRiskRepository cancerRiskRepository)
        {
            _cancerRiskRepository = cancerRiskRepository;
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Percentile")]
        public async Task<Response<IEnumerable<string>>> GetPM25GeoId11(
            [FromRoute] Year year, [FromRoute] PollutantType pollutantType, [FromQuery] float min)
        {
            var data = await _cancerRiskRepository.QueryGeoId11ByMinPercentileAsync(year, pollutantType, min);
            return SucceededResult(data);
        }

        [ResponseCache(Duration = ResponseCache.Duration)]
        [Route("Value")]
        public async Task<Response<IEnumerable<string>>> GetPM25GeoId11(
            [FromRoute] Year year, [FromRoute] PollutantType pollutantType, [FromQuery] double min)
        {
            var data = await _cancerRiskRepository.QueryGeoId11ByMinValueAsync(year, pollutantType, min);
            return SucceededResult(data);
        }
    }
}