import VectorTileLayer from 'ol/layer/VectorTile';
import censusTractSource from './boundary-sources/census-tract';
import { Style, Fill, Stroke } from 'ol/style';
import { pm25GeoId5Set, ozoneGeoId5Set, pm25GeoId11Set, ozoneGeoId11Set, toxicsGeoId11Set, ejGeoId11Set } from './geoid-cache';

const baseLayer = new VectorTileLayer({
    source: censusTractSource,
    visible: true,
    style: null,
});

export default baseLayer;

const size = 16;
const space = 2;

const makePattern_EJ = () => {
    const cnv = document.createElement('canvas');
    const ctx = cnv.getContext('2d');
    cnv.width = size;
    cnv.height = size;

    ctx.beginPath();
    ctx.moveTo(space, size - space);
    ctx.lineTo(size - space, space);
    ctx.strokeStyle = 'green';
    ctx.stroke();

    return ctx.createPattern(cnv, 'repeat');
};
const makePattern = (fillColor) => {
    const cnv = document.createElement('canvas');
    const ctx = cnv.getContext('2d');
    cnv.width = size;
    cnv.height = size;

    ctx.fillStyle = fillColor;
    ctx.fillRect(0, 0, size, size);

    ctx.beginPath();
    ctx.moveTo(space, size - space);
    ctx.lineTo(size - space, space);
    ctx.strokeStyle = 'green';
    ctx.stroke();

    return ctx.createPattern(cnv, 'repeat');
};

// const makePattern = (fillColor) => {
//     const cnv = document.createElement('canvas');
//     const ctx = cnv.getContext('2d');
//     cnv.width = size;
//     cnv.height = size;

//     ctx.fillStyle = fillColor;
//     ctx.fillRect(0, 0, size, size);

//     ctx.globalCompositeOperation = 'source-over';

//     ctx.fillStyle = 'green';
//     for (let i = 0; i < size; i++) {
//         // y: 间隔
//         ctx.fillRect(i, size - i, 0.8, 1.2);
//     }

//     return ctx.createPattern(cnv, 'repeat');
// };

export const styles = {
    pm25: new Style({
        fill: new Fill({
            color: '#fe4040cc',
        }),
    }),
    pm25_ozone: new Style({
        fill: new Fill({
            color: '#d440ffcc',
        }),
    }),
    ozone: new Style({
        fill: new Fill({
            color: '#4095fecc',
        }),
    }),
    ozone_toxics: new Style({
        fill: new Fill({
            color: '#79ed40cc',
        }),
    }),
    toxics: new Style({
        fill: new Fill({
            color: '#fffe40cc',
        }),
    }),
    pm25_toxics: new Style({
        fill: new Fill({
            color: '#dd8f40cc',
        }),
    }),
    pm25_ozone_toxics: new Style({
        fill: new Fill({
            color: '#000000cc',
        }),
    }),
    ej: new Style({
        fill: new Fill({
            color: makePattern_EJ(),
        }),
        // stroke: new Stroke({
        //     color: 'black',
        //     width: 0.1,
        //     //lineDash: [4,2]
        // }),
    }),
    pm25_ej: new Style({
        fill: new Fill({
            color: makePattern('#fe4040cc'),
        }),
    }),
    pm25_ozone_ej: new Style({
        fill: new Fill({
            color: makePattern('#d440ffcc'),
        }),
    }),
    ozone_ej: new Style({
        fill: new Fill({
            color: makePattern('#4095fecc'),
        }),
    }),
    ozone_toxics_ej: new Style({
        fill: new Fill({
            color: makePattern('#79ed40cc'),
        }),
    }),
    toxics_ej: new Style({
        fill: new Fill({
            color: makePattern('#fffe40cc'),
        }),
    }),
    pm25_toxics_ej: new Style({
        fill: new Fill({
            color: makePattern('#dd8f40cc'),
        }),
    }),
    pm25_ozone_toxics_ej: new Style({
        fill: new Fill({
            color: makePattern('#000000cc'),
        }),
    }),
};

export const setStyle = () => {
    const styleFunction = (feature) => {
        const geoId11 = feature.getId();
        const geoId5 = geoId11.substr(0, 5);

        if (pm25GeoId5Set.has(geoId5) || pm25GeoId11Set.has(geoId11)) {
            if (ozoneGeoId5Set.has(geoId5) || ozoneGeoId11Set.has(geoId11)) {
                if (toxicsGeoId11Set.has(geoId11)) {
                    return ejGeoId11Set.has(geoId11) ? styles.pm25_ozone_toxics_ej : styles.pm25_ozone_toxics;
                } else {
                    return ejGeoId11Set.has(geoId11) ? styles.pm25_ozone_ej : styles.pm25_ozone;
                }
            } else if (toxicsGeoId11Set.has(geoId11)) {
                return ejGeoId11Set.has(geoId11) ? styles.pm25_toxics_ej : styles.pm25_toxics;
            } else {
                return ejGeoId11Set.has(geoId11) ? styles.pm25_ej : styles.pm25;
            }
        } else if (ozoneGeoId5Set.has(geoId5) || ozoneGeoId11Set.has(geoId11)) {
            if (toxicsGeoId11Set.has(geoId11)) {
                return ejGeoId11Set.has(geoId11) ? styles.ozone_toxics_ej : styles.ozone_toxics;
            } else {
                return ejGeoId11Set.has(geoId11) ? styles.ozone_ej : styles.ozone;
            }
        } else if (toxicsGeoId11Set.has(geoId11)) {
            return ejGeoId11Set.has(geoId11) ? styles.toxics_ej : styles.toxics;
        } else if (ejGeoId11Set.has(geoId11)) {
            return styles.ej;
        }
    };
    baseLayer.setStyle(styleFunction);
};
