%let base=c:\users\jthurman\documents\nata_2014\sterigenics\argonne_met\;

%macro clean(dat);
proc datasets library=work nolist;
	delete &dat.;
run;

%mend;


%macro read1;
%do yr=14 %to 19;
	%if &yr.=19 %then %let endmon=3;
	%else %let endmon=12;
	%do i=1 %to &endmon.;
		/* read in data*/
		data scratch(drop=dewpt rh dt) ;
			infile "&base.hourly\&&mnth&i..&yr.met.data";
			input @2 iday 2.0 @5 imonth @8 iyear @11 ihr 2.0 @13 imin @17 dir_60 wind_60 sigma_theta_60 temp_60
			dir_10 wind_10 sigma_theta_10 temp_10 dewpt rh dt precip inso net_rad pres; 
			if imin = 30 then do;
				ihr=ihr+1;
				idate=mdy(imonth,iday,iyear+2000);
				output;
			end;
		run;

		proc append base=all_met data=scratch force;
		run;

		%clean(scratch)
	%end;
%end;
%mend;
/* start */
data months;
	length month3 $3.;
	input imonth month3 $;
	cards;
	1 jan
	2 feb
	3 mar
	4 apr
	5 may
	6 jun
	7 jul
	8 aug
	9 sep
	10 oct
	11 nov
	12 dec
	;
run;
	
data _null_;
	set months;
	call symput('mnth'||trim(left(_n_)),trim(left(month3)));
run;

/* read met data */
%read1

/* get min and maxes to get idea of what could be missing value */
proc summary data=all_met;
	var temp_60 wind_60 dir_60 sigma_theta_60 precip temp_10 wind_10 dir_10 sigma_theta_10 inso net_rad pres;
	output out=min_max(drop=_type_ _freq_)min=temp_60_min wind_60_min dir_60_min sigma_theta_60_min precip_min 
	temp_10_min wind_10_min dir_10_min sigma_theta_10_min inso_min net_rad_min pres_min
	max=temp_60_max wind_60_max dir_60_max sigma_theta_60_max precip_max
	temp_10_max wind_10_max dir_10_max sigma_theta_10_max inso_max net_rad_max pres_max;
run;

/*now set variables to correct units and if missing, correct values for AERMET 
also set create time and minute variables */

data all_met1;
	set all_met;
	if temp_60 >= 99999 then temp_60=99;  *reset missing value, leave others as degree C;
	if wind_60 >= 99999 then wind_60=99; *reset missing value, leave others as m/s;
	if dir_60 >= 700 then dir_60=999; *reset missing value;
	if sigma_theta_60 > 35 then sigma_theta_60=99; *reset missing value;
	if precip >= 99999 then precip=-9; *reset missing value;
	else precip=precip*100; *reset from mm to mm*100;
	if temp_10 >= 99999 then temp_10=99;  *reset missing value, leave others as degree C;
	if wind_10 >= 99999 then wind_10=99; *reset missing value;
	if dir_10 >= 700 then dir_10=999; *reset missing value;
	if sigma_theta_10 > 35 then sigma_theta_10=99; *reset missing value;
	if inso >=99999 then inso=9999; *reset to missing value;
	if inso < 0 then inso=0;
	if net_rad >=99999 then net_rad=999; *reset to missing value;
	if pres ne 99999 then pres=pres*100; *convert kPa to mb*10;
	if pres <= 0 then pres=99999;
run;

proc summary data=all_met1;
	var temp_60 wind_60 dir_60 sigma_theta_60 precip temp_10 wind_10 dir_10 sigma_theta_10 inso net_rad pres;
	output out=min_max1(drop=_type_ _freq_)min=temp_60_min wind_60_min dir_60_min sigma_theta_60_min precip_min 
	temp_10_min wind_10_min dir_10_min sigma_theta_10_min inso_min net_rad_min pres_min
	max=temp_60_max wind_60_max dir_60_max sigma_theta_60_max precip_max
	temp_10_max wind_10_max dir_10_max sigma_theta_10_max inso_max net_rad_max pres_max;
run;
 
proc sort data=all_met1;
	by iyear imonth iday ihr;
run;

/* write output file */
/*
data _null_;
	file "&base.aermet\argonne_hourly.dat";
	set all_met1;
	put @1 iyear 2.0 imonth 2.0 iday 2.0 ihr 2.0 +1 inso 10.4 +1 net_rad 10.4 +1 pres 10.4;
	put @12 '10.0' @17 temp_10 10.4 +1 wind_10 10.4 +1 dir_10 10.4 +1 sigma_theta_10 10.4;
	put @12 '60.0' @17 temp_60 10.4 +1 wind_60 10.4 +1 dir_60 10.4 +1 sigma_theta_60 10.4;
run;

*/
/* NO NET RADIATION */
data _null_;
	file "&base.aermet\argonne_hourly.dat";
	set all_met1;
	put @1 iyear 2.0 imonth 2.0 iday 2.0 ihr 2.0 +1 inso 10.4 +1 pres 10.4;
	put @12 '10.0' @17 temp_10 10.4 +1 wind_10 10.4 +1 dir_10 10.4 +1 sigma_theta_10 10.4;
	put @12 '60.0' @17 temp_60 10.4 +1 wind_60 10.4 +1 dir_60 10.4 +1 sigma_theta_60 10.4;
run;

data _null_;
	file "&base.argonne_hourly_lakes.dat";
	set all_met1;
	statid=99999;
	if _n_=1 then put @1 'LAKES FORMAT';
	if wind_10 < 90 then wind_10=wind_10/0.51;  *m/s to knots;
	put statid 5.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr 2.0 +1 dir_10 3.0 wind_10 3.0;
	where dir_10 <= 360 and wind_10 < 90;
run;

/* temp stats */
data temps;
	set all_met1;
	where temp_10 < 90 and iyear < 19;
run;

/* min and max for each month */
proc summary data=temps;
	var temp_10;
	by iyear imonth;
	output out=min_max(drop=_type_ _freq_)min=min_temp max=max_temp;
run;

/*average of min max for each month across 5 years */
proc sort data=min_max;
	by imonth;
run;

proc summary data=min_max;
	var min_temp max_temp;
	by imonth;
	output out=min_max_avg(drop=_type_ _freq_)mean=min_temp max_temp;
run;

/* average for each month across years */
proc sort data=temps;
	by imonth;
run;

proc summary data=temps;
	var temp_10;
	by imonth;
	output out=mean_temps(drop=_type_ _freq_)mean=avg_temp;
run;

data merged_temps;
	merge min_max_avg(in=a) mean_temps(in=b);
	by imonth;
	if a and b then output;
run;

data scratch;
	infile "&base.aermet\mdw_2014_18.sfc" firstobs=2;
	input @1 iyear imonth iday jday ihr hflux ustar wstar vptg zic zim l zo bo r ws wdir zref temp ztemp ipcode precip rh pres ccvr;
	idate=mdy(imonth,iday,iyear+2000);
	if iyear ne 19 then output;
run;

/* temp stats */
data temps_mdw;
	set scratch;
	where temp <999;
run;

/* min and max for each month */
proc summary data=temps_mdw;
	var temp;
	by iyear imonth;
	output out=min_max_mdw(drop=_type_ _freq_)min=min_temp max=max_temp;
run;

/*average of min max for each month across 5 years */
proc sort data=min_max_mdw;
	by imonth;
run;

proc summary data=min_max_mdw;
	var min_temp max_temp;
	by imonth;
	output out=min_max_avg_mdw(drop=_type_ _freq_)mean=min_temp_mdw max_temp_mdw;
run;

/* average for each month across years */
proc sort data=temps_mdw;
	by imonth;
run;

proc summary data=temps_mdw;
	var temp;
	by imonth;
	output out=mean_temps_mdw(drop=_type_ _freq_)mean=avg_temp_mdw;
run;

data merged_temps_mdw;
	merge min_max_avg_mdw(in=a) mean_temps_mdw(in=b);
	by imonth;
	if a and b then output;
run;

data merged_temps_mdw;
	set merged_temps_mdw;
	min_temp_mdw=min_temp_mdw-273.16;
	max_temp_mdw=max_temp_mdw-273.16;
	avg_temp_mdw=avg_temp_mdw-273.16;
run;

data merged;
	merge merged_temps(in=a) merged_temps_mdw(in=b);
	by imonth;
	if a and b then output;
run;

proc sort data=temps;
	by idate ihr;
run;

proc sort data=temps_mdw;
	by idate ihr;
run;

/* hourly temps */
data merged_temps_hourly(keep=idate ihr temp_10 temp);
	merge temps(in=a) temps_mdw(in=b);
	by idate ihr;
	if a and b then output;
run;

data merged_temps_hourly;
	set merged_temps_hourly;
	diff=temp_10-(temp-273.16);
run;

proc summary data=merged_temps_hourly;
	var diff;
	output out=temp_stats(drop=_type_ _freq_) min=min1 mean=mean1 median=med1 max=max1;
run;

data nov_march_temps_hourly;
	set merged_temps_hourly;
	iyear=year(idate);
	if month(idate) >= 11 or month(idate) <=3 then output;
run;

proc summary data=nov_march_temps_hourly;
	var diff;
	output out=temp_stats_nov_march(drop=_type_ _freq_) min=min1 mean=mean1 median=med1 max=max1;
run;

proc sort data=nov_march_temps_hourly;
	by iyear;
run;

proc summary data=nov_march_temps_hourly;
	var diff;
	by iyear;
	output out=temp_stats_nov_march_annual(drop=_type_ _freq_) min=min1 mean=mean1 median=med1 max=max1;
run;


data check_temps;
	set merged_temps_hourly;
	where abs(diff) <= 5.0;
run;

/* winds */
data winds_arg(keep=idate ihr dir_10 wind_10);
	set all_met1;
	where dir_10 <= 360 and wind_10 < 90 and iyear < 19;
run;

data winds_mdw(keep=idate ihr wdir ws);
	set scratch;
	where wdir <=360 and ws < 900;
run;

data merged_winds;
	merge winds_arg(in=a) winds_mdw(in=b);
	by idate ihr;
	if a and b then output;
run;

data merged_winds;
	set merged_winds;
	speed_diff=wind_10-ws;
	dir_diff1=abs(dir_10-wdir);
	if dir_diff1 > 180 then dir_diff=360-dir_diff1;
	else dir_diff=dir_diff1;
run;

proc summary data=merged_winds;
	var speed_diff dir_diff;
	output out=wind_stats(drop=_type_ _freq_) min=min_speed min_dir mean=mean_speed mean_dir
	median=med_speed med_dir max=max_speed max_dir;
run;

data nov_march_winds;
	set merged_winds;
	if month(idate) >= 11 or month(idate) <=3 then output;
run;

proc summary data=nov_march_winds;
	var speed_diff dir_diff;
	output out=wind_stats_nov_march(drop=_type_ _freq_) min=min_speed min_dir mean=mean_speed mean_dir
	median=med_speed med_dir max=max_speed max_dir;
run;

data speed_check;
	set nov_march_winds;
	where abs(speed_diff) <= 1.0;
run;

data dir_check;
	set nov_march_winds;
	where dir_diff <= 10.0;
	*where dir_diff >170;
run;
