/* compare Argonne winds and temps to EPA and Midway for the sampling period */

%let base=c:\users\jthurman\documents\nata_2014\sterigenics\;

%macro clean(dat);
proc datasets library=work nolist;
	delete &dat.;
run;

%mend;


%macro read1;
%do yr=18 %to 19;
	%if &yr.=18 %then %do;
		%let startmon=11;
		%let endmon=12;
	%end;
	%if &yr.=19 %then %do;
		%let startmon=1;
		%let endmon=3;
	%end;
	%do i=&startmon. %to &endmon.;
		/* read in data*/
		data scratch(drop=dewpt rh dt) ;
			infile "&base.argonne_met\hourly\&&mnth&i..&yr.met.data";
			input @2 iday 2.0 @5 imonth @8 iyear @11 ihr 2.0 @13 imin @17 dir_60 wind_60 sigma_theta_60 temp_60
			dir_10 wind_10 sigma_theta_10 temp_10 dewpt rh dt precip inso net_rad pres; 
			if imin = 30 then do;
				ihr=ihr+1;
				idate=mdy(imonth,iday,iyear+2000);
				output;
			end;
		run;

		proc append base=all_met data=scratch force;
		run;

		%clean(scratch)
	%end;
%end;
%mend;

%macro temps(indat,tempvar,missval,conv,tag);
data temps_&tag.;
	set &indat.;
	where &tempvar. ne &missval.;
run;

data temps_&tag.;
	set temps_&tag.;
	&tempvar.=&tempvar.-&conv.;
run;


/* min mean and max by month */
proc sort data=temps_&tag.;
	by imonth;
run;

proc summary data=temps_&tag.;
	var &tempvar.;
	by imonth;
	output out=temps_stats_&tag.(drop=_type_ _freq_)min=min_&tag. mean=mean_&tag. max=max_&tag.;
run;

proc sort data=temps_&tag.;
	by idate ihr;
run;

%mend;
/* start */
data months;
	length month3 $3.;
	input imonth month3 $;
	cards;
	1 jan
	2 feb
	3 mar
	4 apr
	5 may
	6 jun
	7 jul
	8 aug
	9 sep
	10 oct
	11 nov
	12 dec
	;
run;
	
data _null_;
	set months;
	call symput('mnth'||trim(left(_n_)),trim(left(month3)));
run;

/* read met data */
%read1

data all_met1;
	set all_met;
	if temp_60 >= 99999 then temp_60=99;  *reset missing value, leave others as degree C;
	if wind_60 >= 99999 then wind_60=99; *reset missing value, leave others as m/s;
	if dir_60 >= 700 then dir_60=999; *reset missing value;
	if sigma_theta_60 > 35 then sigma_theta_60=99; *reset missing value;
	if precip >= 99999 then precip=-9; *reset missing value;
	else precip=precip*100; *reset from mm to mm*100;
	if temp_10 >= 99999 then temp_10=99;  *reset missing value, leave others as degree C;
	if wind_10 >= 99999 then wind_10=99; *reset missing value;
	if dir_10 >= 700 then dir_10=999; *reset missing value;
	if sigma_theta_10 > 35 then sigma_theta_10=99; *reset missing value;
	if inso >=99999 then inso=9999; *reset to missing value;
	if inso < 0 then inso=0;
	if net_rad >=99999 then net_rad=999; *reset to missing value;
	if pres ne 99999 then pres=pres*100; *convert kPa to mb*10;
	if pres <= 0 then pres=99999;
	if imonth=11 then do;
		if iday >= 13 then output;
	end;
	else output;
run;


data _null_;
	file "&base.argonne_mon_period_lakes.dat";
	set all_met1;
	statid=99999;
	if _n_=1 then put @1 'LAKES FORMAT';
	if wind_10 < 90 then wind_10=wind_10/0.51;  *m/s to knots;
	put statid 5.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr 2.0 +1 dir_10 3.0 wind_10 3.0;
	where dir_10 <= 360 and wind_10 < 90;
run;

/* epa met */
data epa_met(keep=idate imonth iday ihr ws_epa wdir_epa temp_epa);
	infile "&base.epa_met\epa_met.txt";
	input iyear 2.0 imonth 2.0 iday 2.0 ihr 2.0 +1 ht 4.1 +1 ws_epa 5.1 +1 wdir_epa 5.1 +1 temp_epa 6.1 +1 rh 5.1 +1 pres 8.1 +1 sigma_theta 5.1;
	iyear=iyear+2000;
	idate=mdy(imonth,iday,iyear);
	if ihr=0 then do;
		ihr=24;
		idate=idate-1;
	end;
	if imonth ne 4 then output;
run;

data _null_;
	file "&base.epa_mon_period_lakes.dat";
	set epa_met;
	if _n_=1 then put @1 'LAKES FORMAT';
	statid=99999;
	iyear=year(idate);
	if ws_epa < 90 then ws_epa=ws_epa/0.51;  *m/s to knots;
	if imonth = 11 then do;
		if iday >= 13 then put statid 5.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr 2.0 +1 wdir_epa 3.0 ws_epa 3.0;
	end;
	else put statid 5.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr 2.0 +1 wdir_epa 3.0 ws_epa 3.0;
	where wdir_epa <= 360 and ws_epa < 90;
run;

/*midway */
data mdw_met(keep=idate imonth ihr ws_mdw wdir_mdw temp_mdw);
	infile "&base.epa_met\aermod\mdw_92_lc.sfc" firstobs=2;
	input @1 iyear imonth iday jday ihr hflux ustar wstar vptg zic zim l zo bo r ws_mdw wdir_mdw zref temp_mdw ztemp ipcode precip rh pres ccvr;
	idate=mdy(imonth,iday,iyear+2000);	
run;

data arg_winds(keep=idate ihr dir_10 wind_10);
	set all_met1;
	where dir_10 <= 360 and wind_10 < 90;
run;

data epa_winds;
	set epa_met;
	where wdir_epa <=360 and ws_epa < 90;
run;

data mdw_winds;
	set mdw_met;
	where wdir_mdw <=360 and ws_mdw < 90;
run;

data merged_winds(keep=idate ihr dir_10 wind_10 ws_epa wdir_epa ws_mdw wdir_mdw);
	merge arg_winds(in=a) epa_winds(in=b) mdw_winds(in=c);
	by idate ihr;
	if a and b and c then output;
run;

data merged_winds;
	set merged_winds;
	speed_arg_mdw=wind_10-ws_mdw;
	speed_arg_epa=wind_10-ws_epa;
	speed_epa_mdw=ws_epa-ws_mdw;
	dir_arg_mdw=abs(dir_10-wdir_mdw);
	if dir_arg_mdw > 180 then dir_arg_mdw=360-dir_arg_mdw;
	dir_arg_epa=abs(dir_10-wdir_epa);
	if dir_arg_epa > 180 then dir_arg_epa=360-dir_arg_epa;
	dir_epa_mdw=abs(wdir_epa-wdir_mdw);
	if dir_epa_mdw > 180 then dir_epa_mdw=360-dir_epa_mdw;
run;

proc summary data=merged_winds;
	var speed_arg_mdw speed_arg_epa speed_epa_mdw dir_arg_mdw dir_arg_epa dir_epa_mdw;
	output out=wind_stats(drop=_type_ _freq_) min=min_spd_arg_mdw min_spd_arg_epa min_spd_epa_mdw
	min_dir_arg_mdw min_dir_arg_epa min_dir_epa_mdw mean=mean_spd_arg_mdw mean_spd_arg_epa mean_spd_epa_mdw
	mean_dir_arg_mdw mean_dir_arg_epa mean_dir_epa_mdw
	median=med_spd_arg_mdw med_spd_arg_epa med_spd_epa_mdw
	med_dir_arg_mdw med_dir_arg_epa med_dir_epa_mdw max=max_spd_arg_mdw max_spd_arg_epa max_spd_epa_mdw
	max_dir_arg_mdw max_dir_arg_epa max_dir_epa_mdw;
run;

proc transpose data=wind_stats out=trans_winds;
run;

data check;
	set merged_winds;
	where dir_epa_mdw > 170;
run;



%temps(all_met1,temp_10,99,0,arg)
%temps(epa_met,temp_epa,99,0,epa)
%temps(mdw_met,temp_mdw,999,276.16,mdw)

data merged_temps;
	merge temps_stats_arg(in=a) temps_stats_epa(in=b) temps_stats_mdw(in=c);
	by imonth;
	if a and b and c then output;
run;

data merged_temps_hourly;
	merge temps_arg(in=a) temps_epa(in=b) temps_mdw(in=c);
	by idate ihr;
	if a and b and c then output;
run;

data merged_temps_hourly;
	set merged_temps_hourly;
	arg_epa=temp_10-temp_epa;
	arg_mdw=temp_10-temp_mdw;
	epa_mdw=temp_epa-temp_mdw;
run;


proc summary data=merged_temps_hourly;
	var arg_mdw arg_epa epa_mdw;
	output out=temps_stats(drop=_type_ _freq_) min=min_arg_mdw min_arg_epa min_epa_mdw
	mean=mean_arg_mdw mean_arg_epa mean_epa_mdw
	median=med_arg_mdw med_arg_epa med_epa_mdw
	max=max_arg_mdw max_arg_epa max_epa_mdw;
run;

proc transpose data=temps_stats out=trans_temps;
run;

data check;
	set merged_temps_hourly;
	where abs(epa_mdw) < 1;
run;

data check;
	set merged_winds;
	where speed_arg_mdw < 0;
run;
