%let base=c:\users\jthurman\documents\nata_2014\sterigenics\;

%macro clean(dat);
proc datasets library=work nolist;
	delete &dat.;
run;
%mend;

%macro read(imonth,iday,iyear,makeaermod);

%if &imonth.=11 %then %let mnth=NOV;
%else %if &imonth.=12 %then %let mnth=DEC;
%else %if &imonth.=01 %then %let mnth=JAN;
%else %if &imonth.=02 %then %let mnth=FEB;
%else %let mnth=MAR;
/*
proc import datafile="c:\users\jthurman\documents\nata_2014\sterigenics\&xcel."
			out=work.scratch
			dbms=xlsx replace;
			sheet="&imonth._&iday._&iyear.";
			getnames=yes;
run;

data scratch1(keep=srcid b h emis isrc);
	length srcid $12.;
	set scratch;
	if _n_ >= 17 and _n_ <= 27 then do;
		if b='-' then b='STK3';
		srcid=b;
		if substr(srcid,1,3)='STK' then isrc=input(substr(srcid,4,1),1.0);
		else if srcid='A' then isrc=7;
		else if srcid='P' then isrc=8;
		else if srcid='Q' then isrc=9;
		else isrc=input(substr(srcid,2,1),1.0)+8;
		emis=input(h,best29.);
		output;
	end;
run;

proc sql;
	create table scratch2 as
	select a.*,b.emis
	from sources as a,scratch1 as b
	where a.srcid=b.srcid
	order by a.isrc,a.iline
	;
quit;

data _null_;
	file "&base.epa_met\aermod\sources_&mnth._&iday..dat";
	set scratch2;
	if iline=1 then put @1 line $70.;
	else do;
		ht=input(scan(line,5,' '),best12.);
		temp=input(scan(line,6,' '),best12.);
		vel=input(scan(line,7,' '),best12.);
		diam=input(scan(line,8,' '),best12.);
		put @1 'SO SRCPARAM' @13 srcid $12. +1 emis e13.6 +1 ht temp vel diam;
	end;
run;
*/
/* AERMOD control files */
%if &makeaermod.=Y %then %do;
	data _null_;	
		length str $6.;
		file "&base.epa_met\aermod\&mnth._&iday._mdw.inp";
		set aermod_grid;
		iday=&iday.;
		imonth=&imonth.;
		iyear=&iyear.;
		iday1=iday+1;
		ihr1=11;
		ihr2=10;
		str="&mnth._&iday.";
		line=tranwrd(line,'DEC_06',str);
		if line='SO INCLUDED sources.dat' then line="SO INCLUDED sources_&mnth._&iday..dat";
		if index(line,'SURFFILE') > 0 or index(line,'PROFFILE') then line=tranwrd(line,'EPA.','MDW.');
		if line='ME PROFBASE 216.0 METERS' then line='ME PROFBASE 188.0 METERS';
		if index(line,'.PLT') > 0 then line=tranwrd(line,'.PLT','_MDW.PLT');
		if index(line,'.PST') > 0 then line=tranwrd(line,'.PST','_MDW.PST');
		if index(line,'STARTEND') > 0 then
			put @1 'ME STARTEND' @13 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr1 2.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday1 2.0 +1 ihr2 2.0 +1;
		else if index(line,'OU PLOTFILE PERIOD STK6') > 0 then do;
			put @1 line $50.;
			line=tranwrd(line,'STK6','STK7');
			put @1 line $50.;
		end;
		else
			put @1 line $70.;
	run;

	data _null_;	
		length str $6.;
		file "&base.epa_met\aermod\&mnth._&iday._monitors_mdw.inp";
		set aermod_mon;
		iday=&iday.;
		imonth=&imonth.;
		iyear=&iyear.;
		iday1=iday+1;
		ihr1=11;
		ihr2=10;
		str="&mnth._&iday.";
		line=tranwrd(line,'DEC_06',str);
		if line='SO INCLUDED sources.dat' then line="SO INCLUDED sources_&mnth._&iday..dat";
		if line='SO INCLUDED sources.dat' then line="SO INCLUDED sources_&mnth._&iday..dat";
		if index(line,'SURFFILE') > 0 or index(line,'PROFFILE') then line=tranwrd(line,'EPA.','MDW.');
		if line='ME PROFBASE 216.0 METERS' then line='ME PROFBASE 188.0 METERS';
		if index(line,'.PLT') > 0 then line=tranwrd(line,'.PLT','_MDW.PLT');
		if index(line,'.PST') > 0 then line=tranwrd(line,'.PST','_MDW.PST');
		if index(line,'STARTEND') > 0 then
			put @1 'ME STARTEND' @13 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr1 2.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday1 2.0 +1 ihr2 2.0 +1;
		else if index(line,'OU PLOTFILE PERIOD STK6') > 0 then do;
			put @1 line $50.;
			line=tranwrd(line,'STK6','STK7');
			put @1 line $50.;
		end;
		else
			put @1 line $70.;
	run;
%end;
%clean(scratch1 scratch scratch2)
%mend;

*%let xcel=NS_Sterigenics Willowbrook Emissions and Model Inputs-March 1, 2019.xlsx;
*%let xcel=NS_Sterigenics Willowbrook Emissions and Model Inputs-March 13, 2019.xlsx;
*%let xcel=Copy of NS_Sterigenics Willowbrook Emissions and Model Inputs-March 15 2019.xlsx;
%let xcel=Sterigenics Willowbrook Emissions and Model Inputs-April 29 2019 (FINAL);
/* read in the source groups file, keeping EPA stack parameters */
data sources;
	length line $70. srcid1 $12. srcid $12. etemp $6.;
	infile "&base.epa_met\aermod\sources.dat" pad;
	input @1 line $70.;
	if index(line,'_E') > 0 then do;
		srcid1=scan(line,3,' ');
		srcid=scan(scan(line,3,' '),1,'_');
		if index(line,'LOCATION')  > 0 then iline=1;
		else iline=2;
		if substr(srcid,1,3)='STK' then isrc=input(substr(srcid,4,1),1.0);
		else if srcid='A' then isrc=7;
		else if srcid='P' then isrc=8;
		else if srcid='Q' then isrc=9;
		else isrc=input(substr(srcid,2,1),1.0)+8;
		line=tranwrd(line,srcid1,srcid);
		if index(line,'SRCPARAM') > 0 then do;
			etemp=scan(line,6,' ');
			line=tranwrd(line,etemp,'0.0');
		end;
		output;
	end;
run;

data aermod_grid;
	length line $70.;
	infile "&base.epa_met\aermod\base.inp" pad;
	input @1 line $70.;
run;

data aermod_mon;
	length line $70.;
	infile "&base.epa_met\aermod\base_monitors.inp" pad;
	input @1 line $70.;
run;


%read(11,13,2018,Y)
%read(11,16,2018,Y)
%read(11,19,2018,Y)
%read(11,23,2018,Y)
%read(11,25,2018,Y)
%read(11,28,2018,Y)
%read(12,01,2018,Y)
%read(12,06,2018,Y)
%read(12,07,2018,Y)
%read(12,10,2018,Y)
%read(12,13,2018,Y)
%read(12,16,2018,Y)
%read(12,19,2018,Y)
%read(12,22,2018,Y)
%read(12,26,2018,Y)
%read(12,28,2018,Y)
%read(01,02,2019,Y)
%read(01,03,2019,Y)
%read(01,06,2019,Y)
%read(01,09,2019,Y)
%read(01,12,2019,Y)
%read(01,15,2019,Y)
%read(01,17,2019,Y)
%read(01,22,2019,Y)
%read(01,24,2019,Y)
%read(01,27,2019,Y)
%read(02,01,2019,Y)
%read(02,02,2019,Y)
%read(02,05,2019,Y)
%read(02,08,2019,Y)
%read(02,11,2019,Y)
