%let base=c:\users\jthurman\documents\nata_2014\sterigenics\;

%macro clean(dat);
proc datasets library=work nolist;
	delete &dat.;
run;
%mend;

/* macro to read EPA met data */
%macro read_epa(infil,outdat,outfil);
data scratch(keep=idate ihr ws wdir temp pres sigma_theta rh);
	length line $80.;
	retain idate 0;
	retain iyear 0;
	retain imonth 0;
	retain iday 0;
	infile "&infil." firstobs=80 pad;
	input @1 line $80.;
	if scan(line,1,' ')='Report' then do;
		imonth=input(scan(scan(line,3,' '),1,'/'),2.0);
		iday=input(scan(scan(line,3,' '),2,'/'),2.0);
		iyear=input(scan(scan(line,3,' '),3,'/'),2.0);
		iyear=iyear+2000;
		idate=mdy(imonth,iday,iyear);
	end;
	if index(line,':') > 0 and substr(line,4,2) = '00' then do; 
		ihr=input(substr(line,1,2),2.0);
		ws=input(scan(line,2,' '),best12.)*0.44704; *winds mph to m/s;
		wdir=input(scan(line,3,' '),best12.); *wind direction;
		temp=(input(scan(line,4,' '),best12.)-32)*(5/9); *temp in F to C;
		rh=input(scan(line,5,' '),best12.);
		pres=(input(scan(line,6,' '),best12.)/0.02953)*10; *pressure from inches Hg to 10*millibars;
		sigma_theta=input(scan(line,11,' '),best11.);
		output;
	end;
run;

proc sort data=scratch;
	by idate ihr;
run;

data first_last(keep=idate1 ihr1 idate2 ihr2);
	retain idate1 0;
	retain ihr1 0;
	retain idate2 0;
	retain ihr2 0;
	set scratch end=done;
	if _n_=1 then do;
		idate1=idate;
		ihr1=ihr;
	end;
	if done then do;
		idate2=idate;
		ihr2=ihr;
		output;
	end;
run;

data period(keep=jday idate iyear imonth iday ihr);
	set first_last;
	do idate=idate1 to idate2;
		if idate=idate1 then do;
			hr1=ihr1;
			hr2=23;
		end;
		else if idate=idate2 then do;
			hr1=0;
			hr2=ihr2;
		end;
		else do;
			hr1=0;
			hr2=23;
		end;
		imonth=month(idate);
		iday=day(idate);
		iyear=year(idate);
		jday=idate-mdy(12,31,iyear-1);
		do ihr=hr1 to hr2;
			output;
		end;
	end;
run;

data &outdat.;
	merge period(in=a) scratch(in=b);
	by idate ihr;
	if a then output;
run;

data &outdat.;
	set &outdat.;
	if ws > 22 then do; * set anytning over 50 m/s to missing, winds are over 100 mph;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if imonth=1 and iday=22 and ihr >=18 and ihr <=22 then do;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if imonth=1 and iday=23 and ihr >=10 and ihr <=12 then do;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if imonth=2 and iday=2 and ihr >=0 and ihr <=2 then do;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if imonth=2 and iday=11 and ihr =22 then do;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if imonth=2 and iday=20 and ihr >=11 and ihr <=13 then do;
		ws=.;
		wdir=.;
		sigma_theta=.;
	end;
	if ws =. then ws=99;
	if wdir=. then wdir=999;
	if temp=. then temp=99;
	if rh=. then rh=999;
	if pres=. then pres=99999;
	if sigma_theta=. or sigma_theta > 35 then sigma_theta=99;
run;

/* AERMET input file */
data _null_;
	file "&outfil.";
	set &outdat.;
	ht=8.45; 
	/*if ihr = 0 then do;  *change hour 0 to hour 24 of previous day;
		ihr=24;
		idate=idate-1;
		iyear=year(idate);
		imonth=month(idate);
		iday=day(idate);
	end;*/
	iyear1=iyear-2000;
	*ihr=ihr-1;  *hour ending for AERMET 1/30/19 found out data is hour ending;
	put iyear1 2.0 imonth 2.0 iday 2.0 ihr 2.0 +1 ht 4.1 +1 ws 5.1 +1 wdir 5.1 +1 temp 6.1 +1 rh 5.1 +1 pres 8.1 +1 sigma_theta 5.1;
run;


%mend;


/* macro to output Lakes format for wind roses, individual sampling days */
%macro lakes(indat,outfil,iyear1,imonth1,iday1);

/* get julian day of the 1st sampling day */
data _null_;
	jday=mdy(&imonth1,&iday1,&iyear1)-mdy(12,31,&iyear1.-1);
	if jday=365 then jday2=1;
	else jday2=jday+1;
	call symput('jday1',trim(left(jday)));
	call symput('jday2',trim(left(jday2)));
run;

data _null_;
	file "&outfil..txt";
	set &indat.;
	statid=99999;
	if _n_=1 then put @1 'LAKES FORMAT';
	if ws < 99 then ws=ws/0.51;
	put statid 5.0 +1 iyear 4.0 +1 imonth 2.0 +1 iday 2.0 +1 ihr 2.0 +1 wdir 3.0 ws 3.0;
	where (jday=&jday1. and ihr >= 11) or (jday=&jday2. and ihr le 10); *start time of 10:00 end time of 10:00;
run;

data _null_;
	file "&outfil..csv" dlm=',';
	length adate $5.;
	set &indat.;
	if _n_=1 then put @1 'iobs,adate,wdir,ws,at';
	adate=put(iday,2.0)||'/'||put(ihr,z2.);
	if ws < 99 then ws=ws/0.51;  *m/s to knots;
	temp=temp*(9/5)+32; *c to f;
	put _n_ adate $ wdir ws temp;
	where (jday=&jday1. and ihr >= 11) or (jday=&jday2. and ihr le 10); *start time of 10:00 end time of 10:00;
run;

%mend;

/* begin */

/* read EPA met, the input file will change as new data comes in */
/*%read_epa(&base.epa_met\20181219.txt,epa_met,&base.epa_met\2018_11_13_12_19.txt)*/
/*%read_epa(&base.epa_met\Met 20181113 to 20190206.txt,epa_met,&base.epa_met\epa_met.txt)*/
/*%read_epa(&base.epa_met\20190317_combined.txt,epa_met,&base.epa_met\epa_met.txt)*/
%read_epa(&base.epa_met\20190408_combined.txt,epa_met,&base.epa_met\epa_met.txt)
/* lakes files */
/*
%lakes(epa_met,&base.epa_met\winds_nov_13,2018,11,13)
%lakes(epa_met,&base.epa_met\winds_nov_16,2018,11,16)
%lakes(epa_met,&base.epa_met\winds_nov_19,2018,11,19)
%lakes(epa_met,&base.epa_met\winds_nov_28,2018,11,28)

%lakes(epa_met,&base.epa_met\winds_dec_01,2018,12,01)
%lakes(epa_met,&base.epa_met\winds_dec_06,2018,12,06)
%lakes(epa_met,&base.epa_met\winds_dec_07,2018,12,07)

%lakes(epa_met,&base.epa_met\winds_dec_10,2018,12,10)
%lakes(epa_met,&base.epa_met\winds_dec_13,2018,12,13)
%lakes(epa_met,&base.epa_met\winds_dec_16,2018,12,16)

%lakes(epa_met,&base.epa_met\winds_dec_19,2018,12,19)
%lakes(epa_met,&base.epa_met\winds_dec_22,2018,12,22)
%lakes(epa_met,&base.epa_met\winds_dec_26,2018,12,26)
%lakes(epa_met,&base.epa_met\winds_dec_28,2018,12,28)

%lakes(epa_met,&base.epa_met\winds_jan_02,2019,01,02)
%lakes(epa_met,&base.epa_met\winds_jan_03,2019,01,03)
%lakes(epa_met,&base.epa_met\winds_jan_06,2019,01,06)
%lakes(epa_met,&base.epa_met\winds_jan_09,2019,01,09)
%lakes(epa_met,&base.epa_met\winds_jan_12,2019,01,12)
%lakes(epa_met,&base.epa_met\winds_jan_15,2019,01,15)
%lakes(epa_met,&base.epa_met\winds_jan_17,2019,01,17)

%lakes(epa_met,&base.epa_met\winds_jan_22,2019,01,22)
%lakes(epa_met,&base.epa_met\winds_jan_24,2019,01,24)
%lakes(epa_met,&base.epa_met\winds_jan_27,2019,01,27)


%lakes(epa_met,&base.epa_met\winds_feb_01,2019,02,01)
%lakes(epa_met,&base.epa_met\winds_feb_02,2019,02,02)
%lakes(epa_met,&base.epa_met\winds_feb_05,2019,02,05)
%lakes(epa_met,&base.epa_met\winds_feb_06,2019,02,06)
%lakes(epa_met,&base.epa_met\winds_feb_07,2019,02,07)
%lakes(epa_met,&base.epa_met\winds_feb_08,2019,02,08)

%lakes(epa_met,&base.epa_met\winds_feb_11,2019,02,11)
%lakes(epa_met,&base.epa_met\winds_feb_14,2019,02,14)

%lakes(epa_met,&base.epa_met\winds_feb_19,2019,02,19)
%lakes(epa_met,&base.epa_met\winds_feb_20,2019,02,20)
%lakes(epa_met,&base.epa_met\winds_feb_21,2019,02,21)
%lakes(epa_met,&base.epa_met\winds_feb_22,2019,02,22)
%lakes(epa_met,&base.epa_met\winds_feb_23,2019,02,23)
%lakes(epa_met,&base.epa_met\winds_feb_26,2019,02,26)

%lakes(epa_met,&base.epa_met\winds_mar_01,2019,03,01)
%lakes(epa_met,&base.epa_met\winds_mar_04,2019,03,04)
%lakes(epa_met,&base.epa_met\winds_mar_07,2019,03,07)
%lakes(epa_met,&base.epa_met\winds_mar_10,2019,03,10)
%lakes(epa_met,&base.epa_met\winds_mar_13,2019,03,13)
%lakes(epa_met,&base.epa_met\winds_mar_16,2019,03,16)
*/
%lakes(epa_met,&base.epa_met\winds_mar_19,2019,03,19)
%lakes(epa_met,&base.epa_met\winds_mar_22,2019,03,22)
%lakes(epa_met,&base.epa_met\winds_mar_25,2019,03,25)
%lakes(epa_met,&base.epa_met\winds_mar_28,2019,03,28)
%lakes(epa_met,&base.epa_met\winds_mar_31,2019,03,31)
