%let base=c:\users\jthurman\documents\nata_2014\sterigenics\;
options noxwait;

%macro clean(dat);
proc datasets library=work nolist;
    delete &dat.;
run;
%mend;


%macro read_file(infil,tag,outdat);
data &outdat.;
	infile "&infil." firstobs=9;
	input x y c_&tag.;
run;

proc sort data=&outdat.;
	by x y;
run;

%mend read_file;


%macro process(mnth,dy,bg);

/* monitor */
%read_file(&base.epa_met\aermod\ALL_&mnth._&dy._MON.PLT,tot,mon)

data mon;
	set mon;
	c_tot=c_tot+&bg.;
run;

proc sql;
	create table mon1 as
	select b.monid,a.x,a.y,a.c_tot
	from mon as a,monitors as b
	where a.x=b.x and a.y=b.y
	;
quit;

proc append base=all_mon_mod data=mon1 force;
run;

%clean(mon1 mon)

%mend process;

%let nobs1=4;
%macro loop;
%do nobs1 =4 %to 22;

data top10;
	set obs;
	where irank le &nobs1. ;
run;

proc summary data=top10;
	var obs1;
	by monitor;
	output out=mean10(drop=_type_ _freq_)mean=mean10;
run;

/* combine with 11th observation to calculate RHC */
proc sql;
	create table rhc_obs as
	select a.monitor,(a.obs1+(b.mean10-a.obs1)*2.772588722) as rhc
	from obs as a,mean10 as b
	where a.monitor=b.monitor and a.irank=&nobs1.+1
	;
quit;

proc sort data=rhc_obs;
	by rhc;
run;


/* get max of the observed RHC */
data max_obs_rhc(keep=monitor obs_rhc);
	set rhc_obs end=done;
	if done then do;
		obs_rhc=rhc;
		output;
	end;
run;

data top10_mod;
	set all_mon_mod1;
	where irank le &nobs1.;
run;

proc summary data=top10_mod;
	var c_tot;
	by monid;
	output out=mean10_mod(drop=_type_ _freq_)mean=mean10;
run;

/* combine with 11th observation to calculate RHC */
proc sql;
	create table rhc_mod as
	select a.monid,(a.c_tot+(b.mean10-a.c_tot)*2.772588722) as rhc
	from all_mon_mod1 as a,mean10_mod as b
	where a.monid=b.monid and a.irank=&nobs1.+1
	;
quit;

/* get max of the modeled RHC */

proc sort data=rhc_mod;
	by rhc;
run;

data max_mod_rhc(keep=monid mod_rhc);
	set rhc_mod end=done;
	if done then do;
		mod_rhc=rhc;
		output;
	end;
run;


/* calculate FB */
proc sql;
	create table bias as
	select (2*((obs_rhc-mod_rhc)/(obs_rhc+mod_rhc))) as frac_bias,obs_rhc,mod_rhc
	from max_obs_rhc,max_mod_rhc
	;
quit;

data bias;
	set bias;
	n=&nobs1.+1;
run;

proc append base=all_bias data=bias force;
run;

proc print data=bias;
	var obs_rhc mod_rhc frac_bias;
	title "fractional bias epa based on &nobs1.+1 observations";
run;

%clean(top10 mean10 rhc_obs top10_mod rhc_mod max_mod_rhc bias max_obs_rhc)
%end;
%mend;


*%let xcel=NS_Sterigenics Willowbrook Emissions and Model Inputs-March 1, 2019.xlsx;
*%let xcel=NS_Sterigenics Willowbrook Emissions and Model Inputs-March 13, 2019.xlsx;

data monitors;
	length monid $26.;
	input monid $ x y;
	cards;
Village_Hall 421754.41000 4622291.00000
EPA_Warehouse 421949.34000 4622160.50000
Gower_Middle_School 422344.41000 4621715.50000
West_Neighborhood 421383.66000 4622314.50000
Water_Tower 421922.84000 4623041.50000 
Willow_Pond_Park 421877.00000 4623998.50000
Hinsdale_South_High_School 421145.00000 4622863.50000
Gower_Elementary_School 420500.34000 4622332.00000

;
run;
/*Eisenhower_Jr._High_School 418612.50000 4622816.00000*/
data monitors;
	set monitors;
	monid=tranwrd(monid,'_',' ');
	imon=_n_;
run;

/* read in observed concentrations */
proc import datafile="&base.epa_met\rhc.xlsx"
			out=work.obs
			dbms=xlsx replace;
			sheet="all_obs_modeled";
			getnames=yes;
run;
/*
data obs;
	set obs;
	if monitor='Water Tower' and obs1 > 5 then obs1=-9;
run;
*/
proc sort data=obs;
	by monitor descending obs1;
	where obs1 > 0 and date not in ('NOV_28','DEC_16','NOV_13','NOV_16');
run;

/* rank by monitor */
data obs;
	length monitor1 $26.;
	retain monitor1 '12345678901234567892123456';
	retain irank 0;
	set obs;
	if monitor1 ne monitor then do;
		monitor1=monitor;
		irank=0;
	end;
	irank=irank+1;
run;

proc means data=obs max;
	var irank;
	by monitor;
run;
/*
%process(nov,13,0315)
%process(nov,16,0315)
*/
%process(nov,19,0.148)
%process(nov,23,0.190)
%process(nov,25,0.299)
/*
%process(nov,28,0.592)
*/
%process(dec,01,0.198)
%process(dec,06,0.060)
%process(dec,07,0.134)
%process(dec,10,0.121)
%process(dec,13,0.151)
/*
%process(dec,16,0.721)
*/
%process(dec,19,0.332)
%process(dec,22,0.333)
%process(dec,26,0.0)
%process(dec,28,0.123)
%process(jan,02,0.206)
%process(jan,03,0.042)
%process(jan,06,0.076)
%process(jan,09,0.268)
%process(jan,12,0.075)
%process(jan,15,0.074)
%process(jan,17,0.136)
%process(jan,22,0.290)
%process(jan,24,0.090)
%process(jan,27,0.110)
%process(feb,01,0.062)
%process(feb,02,0.355)
%process(feb,05,0.168)
%process(feb,08,0.192)
%process(feb,11,0.088)
/* calculate modeled RHC */
proc sort data=all_mon_mod;
	by monid descending c_tot;
run;

/* rank by monitor */
data all_mon_mod1;
	length monitor1 $26.;
	retain monitor1 '12345678901234567892123456';
	retain irank 0;
	set all_mon_mod;
	if monitor1 ne monid then do;
		monitor1=monid;
		irank=0;
	end;
	irank=irank+1;
run;


%loop


