#!/bin/csh -f
#BSUB 0:30

# Version @(#)$Id$
# Path    $Source$
# Date    $Date$

# This script sets up needed environment variables for running ptipm sector
# source emissions in SMOKE for the EPA 2002v3CAP modeling platform for 2002cc,
# and calls the scripts that runs the SMOKE programs. 
#
# Script created by : M. Houyoux, Environmental Protection Agency
# 10/31/2006 
#
#*********************************************************************

## If alternative output/intermediate location has been given, use to
#      define argument to Assigns file
if ( $# == 4 ) then
    setenv WORK $argv[4]
endif

# set Assigns file name
setenv ASSIGNS_FILE /orchid/oaqps/2002/smoke/subsys/v3/smoke23/assigns/ASSIGNS.2002cc.cmaq.cb05p25.36km
source $ASSIGNS_FILE

# set source category
setenv SMK_SOURCE P           # source category to process
setenv MRG_SOURCE P           # source category to merge
setenv MRG_CTLMAT_MULT ' '    # [A|P|AP] for merging with multiplier controls
setenv MRG_CTLMAT_REAC ' '    # [A|M|P|AMP] for merging with reactivity controls

## time-independent programs (except Smkinven run monthly for CEM import)
setenv RUN_CEMSCAN   N        #  run CEM data scanner program
setenv RUN_SMKINVEN1 Y        #  run inventory import program (annual)
setenv RUN_SMKINVEN2 Y        #  run inventory import program (day & hour-specific)
setenv RUN_SPCMAT    Y        #  run speciation matrix program
setenv RUN_GRDMAT    Y        #  run gridding matrix program
setenv RUN_ELEVPOINT Y        #  run elevated source selection program (once only since PELVCONFIG not based on emissions)

## day-dependent programs
setenv RUN_TEMPORAL  Y        #  run temporal allocation program
setenv RUN_LAYPOINT  Y        #  run layer fractions program
setenv RUN_SMKMERGE  Y        #  run merge program
setenv RUN_SMK2EMIS  N        #  run conversion of 2-d to UAM binary

## quality assurance
setenv RUN_SMKREPORT Y        # Y runs reporting for state reports
setenv BUD_REPORTS   N        # Y copies smkreport output to bud
setenv BUD_INSTALL   /bud2
setenv RUN_M3STAT    Y

## Program-specific controls...

## For Cemscan
setenv MAX_CEM_UNITS    10000  # Sets the maximum number of CEM units.

## For Smkinven
setenv FILL_ANNUAL          N  # Y fills annual value when only average day is provided
setenv FLOW_RATE_FACTOR 15875  # factor for calculating hourly flow rate
setenv IMPORT_AVEINV_YN     Y  # Y imports annual or ave-day inventory values
setenv RAW_DUP_CHECK        Y  # Y errors on duplicate records
setenv SMK_BASEYR_OVERRIDE  0  # Enter year of the base year when future-year inven provided
setenv SMK_NHAPEXCLUDE_YN   N  # Y uses NonHAP exclusions file
setenv SMKINVEN_FORMULA    "PMC=PM10-PM2_5" # Internal PMC calculation
setenv WEST_HSPHERE         Y  # Y converts ALL stack coords to western hemisphere
setenv WKDAY_NORMALIZE      N  # Y normalizes weekly profiles by weekdays
setenv WRITE_ANN_ZERO       Y  # Y writes 0 values to SMOKE intermediate inventory
setenv CHECK_STACKS_YN      Y  # Y Reset stack parms to min/max values and use PSTK to fill in
#     DAY_SPECIFIC_YN          # see multiple-program controls, below
#     HOUR_SPECIFIC_YN         # see multiple-program controls, below
#     OUTZONE                  # see multiple-program controls, below
#     REPORT_DEFAULTS          # see multiple-program controls, below
#     VELOC_RECALC             # see multiple-program controls, below

## For Grdmat
setenv SMK_DEFAULT_SRGID   100 # default surrogate code (8=popl'n)
#     FULLSCC_ONLY             # see multiple-program controls, below

## For Spcmat
setenv POLLUTANT_CONVERSION Y  # Y uses ROG to TOG file, for example
#     FULLSCC_ONLY             # see multiple-program controls, below
#     REPORT_DEFAULTS          # see multiple-program controls, below

# For Temporal
setenv RENORM_TPROF         Y  # Y renormalizes temporal profiles
setenv UNIFORM_TPROF_YN     N  # Y makes all temporal profiles uniform
setenv ZONE4WM              Y  # Y uses time zones for start of day & month
#     DAY_SPECIFIC_YN          # see multiple-program controls, below
#     HOUR_SPECIFIC_YN         # see multiple-program controls, below
#     FULLSCC_ONLY             # see multiple-program controls, below
#     OUTZONE                  # see multiple-program controls, below
#     REPORT_DEFAULTS          # see multiple-program controls, below
#     SMK_AVEDAY_YN            # see multiple-program controls, below
#     Date/time settings       # in Assigns file

# For Elevpoint
setenv SMK_ELEV_METHOD   1     # 0= treat all srcs as possibly elevated; 1= use PELVCONFIG file
# setenv SMK_PING_METHOD       # see multiple-program controls, below

# For Laypoint
setenv EXPLICIT_PLUMES_YN   N  # Y process layer fractions for only explicit plume sources
setenv HOUR_PLUMEDATA_YN    N  # Y then use precomputed plume rise from PHOUR file 
setenv REP_LAYER_MAX        9  # layer to use in reporting plumes that go to the highest emissions layer
#     SMK_EMLAYS               # see multiple-program controls, below
#     SMK_SPECELEV_YN          # see multiple-program controls, below
#     VELOC_RECALC             # see multiple-program controls, below

# For Smkmerge
setenv SMKMERGE_CUSTOM_OUTPUT Y        # Y allows AOUT, BOUT, MOUT, and POUT
setenv MRG_TEMPORAL_YN      Y          # Y merges with hourly emissions
setenv MRG_SPCMAT_YN        Y          # Y merges with speciation matrix
setenv MRG_GRDOUT_YN        Y          # Y outputs gridded file
setenv MRG_LAYERS_YN        Y          # Y outputs layered emissions
setenv MRG_REPSTA_YN        N          # Y outputs state totals
setenv MRG_REPCNY_YN        N          # Y outputs county totals
setenv MRG_GRDOUT_UNIT      moles/s    # units for gridded output file
setenv MRG_TOTOUT_UNIT      moles/day  # units for state and/or county totals
setenv MRG_REPORT_TIME      230000     # hour in OUTZONE for reporting emissions
setenv MRG_MARKETPEN_YN     N          # apply reac. controls market penetration
setenv SMK_ASCIIELEV_YN     N          # Y outputs elevtated ASCII file for CAMx or PinG approach
#     SMK_EMLAYS                       # see multiple-program controls, below
#     SMK_AVEDAY_YN                    # see multiple-program controls, below
#     SMK_PING_METHOD                  # see multiple-program controls, below

# For Smk2emis
setenv SMK2EMIS_VMAP_YN     N     # Y uses name remapping file

# Multiple-program controls
setenv DAY_SPECIFIC_YN      Y     # Y = import and use day-specific emissions inventories
setenv FULLSCC_ONLY         Y     # Y only matches profiles by full SCCs
setenv HOUR_SPECIFIC_YN     N     # Y = import and use hour-specific emissions inventories
setenv OUTZONE              0     # output time zone of emissions
setenv REPORT_DEFAULTS      N     # Y reports default profile application
setenv SMK_EMLAYS           10    # number of layers for emissions file
setenv SMK_DEFAULT_TZONE    5     # time zone to fix in missing COSTCY file
setenv SMK_AVEDAY_YN        N     # Y uses average day emissions instead of annual
setenv SMK_MAXWARNING       100   # maximum number of warnings in log file
setenv SMK_MAXERROR         10000   # maximum number of errors in log file
setenv SMK_PING_METHOD      0          # 0 = no Ping sources, 1 = PinG sources
setenv SMK_SPECELEV_YN      Y  # Y uses PELV file from Elevpoint
setenv VELOC_RECALC         N     # Y recalculates all stack velocities from flow & diameter

# Script settings
setenv SECTOR             ptipm
setenv SRCABBR            ptipm   # abbreviation for naming log files
setenv PROMPTFLAG         N       # Y (never set to Y for batch processing)
setenv AUTO_DELETE        Y       # Y deletes SMOKE I/O API output files (recommended)
setenv AUTO_DELETE_LOG    Y       # Y automatically deletes logs without asking
setenv DEBUGMODE          N       # Y changes script to use debugger
setenv DEBUG_EXE          pgdbg     # Sets the debugger to use when DEBUGMODE = Y

setenv RUN_HOLIDAYS       Y       # Y = run holiday dates in temporal loop
setenv L_TYPE             all     # Type for running temporal: aveday, mwdss, week, or all
setenv M_TYPE             all     # Type for running Smkmerge: aveday, mwdss, week, or all
setenv SPINUP_DURATION    10      # Number of days for a spinup period
setenv IOAPI_ISPH         19
#setenv RESTART_JDATE      2002088 # Set to Julian date for restarting run

##############################################################################

unsetenv DISPLAY

switch ( $# )
   case 0:
   case 1:
      echo "SCRIPT ERROR: Script requires -m or -q option with 2 settings."
      echo "  This script expects to be called using one of the following options:"
      echo "     -m <monthlist> <spinup>"
      echo "     -q <quarters> <spinup>"
      echo "  You can only use one option or the other."
      echo "  Examples:"
      echo "     <script name> -m '1 2 3' N: runs script for Jan, Feb, & Mar "
      echo "                                        with no spinup"
      echo "     <script name> -q 2 Y     : runs script for the 2nd quarter,"
      echo "                                        including spin-up days specified"
      echo "                                        SPIN_UP_DAYS environment variable."
      exit( 1 )
endsw

## Invoke script to interpret calling arguments
if ( $# == 2 ) then
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]"
   if ( $status == 1 ) exit ( 1 )
else
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]" $argv[3]
   if ( $status == 1 ) exit ( 1 )
endif

## If alternative output/intermediate location has been given, use to
#      define argument to Assigns file
if ( $# == 4 ) then
    setenv WORK $argv[4]
endif

set spinup_array = ( $SPINUP_LIST )  # SPINUP_LIST set by set_months.csh

set monname = ( jan feb mar apr may jun jul aug sep oct nov dec )

# Call Cemscan program to scan all days of CEM data in year
setenv RUN_PART0  Y
setenv SUBSECT $SECTOR
setenv EISECTOR $SECTOR
source $ASSIGNS_FILE                    # Invoke Assigns file 
setenv FILELIST $CEMLIST                # Set Cemscan input variables using Assigns variables
setenv OUTFILE  $CEMSUM                  
setenv REPFILE  $CEMREPORT
source $SCRIPTS/run/smk_run_v2b.csh     # Run programs
setenv RUN_PART0  N

## Run Smkinven (annual inventory only), Grdmat, and Spcmat
#
setenv RUN_PART1 Y
setenv RUN_SMKINVEN $RUN_SMKINVEN1
source $ASSIGNS_FILE                    # Invoke Assigns file to clean up files and set e.v.s

set save_daily_setting = $DAY_SPECIFIC_YN
set save_hourly_setting = $HOUR_SPECIFIC_YN
setenv DAY_SPECIFIC_YN N
setenv HOUR_SPECIFIC_YN N
source $SCRIPTS/run/smk_run_v2.csh      # Run programs

setenv QA_TYPE  inv                # Used to name the report inputs and outputs
setenv QA_LABEL $SECTOR            # Used to name the report inputs and outputs
setenv REPLABEL $SECTOR            # Used internally by Smkreport
source $SCRIPTS/run/qa_run_v3.csh  # Run QA for part 1
setenv RUN_PART1 N

## Run Elevpoint (only once, since elevated source criteria is not emissions-based)
#
setenv RUN_PART3 Y
source $ASSIGNS_FILE                    # Invoke Assigns file to clean up files and set e.v.s
source $SCRIPTS/run/smk_run_v2.csh      # Run programs
setenv RUN_PART3 N

# Loop through months to run 
set mc = 0
foreach m ( $MONTHS_LIST )   # MONTHS_LIST set by set_months.csh

   @ mc = $mc + 1   # month array counter

   setenv MONTH   ${monname[$m]}            # set variable for month name
   setenv SUBSECT ${SECTOR}_$MONTH
   setenv SRCABBR $SUBSECT

   ## Run Smkinven to import day-specific and hour-specific inventories
   setenv RUN_PART1 Y
   setenv RUN_SMKINVEN $RUN_SMKINVEN2

   set    save_import_annual = $IMPORT_AVEINV_YN
   setenv IMPORT_AVEINV_YN  N

   setenv DAY_SPECIFIC_YN $save_daily_setting
   setenv HOUR_SPECIFIC_YN $save_hourly_setting

   source $ASSIGNS_FILE                  # Invoke Assigns file to set for current month
   source $SCRIPTS/run/smk_run_v2.csh    # Run program

   setenv RUN_PART1 N

   ## Determine dates to run in this month
   setenv RUN_PART2 Y
   setenv MONTH_ARRAY  $m             # MONTH_ARRAY can have as many months listed as needed
   setenv SPINUP_ARRAY $spinup_array[$mc]

   # Source assigns file BEFORE set_days_v3.csh to set PROCDATES and SMK_RUN_DATES settings
   source $ASSIGNS_FILE                  # Invoke Assigns file to set new dates

   setenv T_TYPE $L_TYPE             # Set temporal type to type for temporal
   source $SCRIPTS/run/set_days_v3.csh  # Call script to set dates for run

   # Source assigns file AFTER set_days_v3.csh so that it can use PROCDATES file
   source $ASSIGNS_FILE                  # Invoke Assigns file to set new dates

   ## Run Temporal (using PROCDATES file - run for all days in month)
   source $SCRIPTS/run/smk_run_v2.csh        # Run programs
   setenv RUN_PART2 N

   ## Run Laypoint, Smkmerge and Smkreport, and optionally, Smk2emis (for 2-d CAMx)

   ## Determine the number of days to run.
   set ndays = `cat $SMK_RUN_DATES | wc -l`

   set n = 0
   set diff = 0
   set g_stdate_sav = $G_STDATE

   while ( $n < $ndays )

      @ n = $n + 1   

      set line = `head -$n $SMK_RUN_DATES | tail -1`
      @ diff = $line[1] - $g_stdate_sav

      setenv G_STDATE_ADVANCE $diff
      source $ASSIGNS_FILE               # Invoke Assigns file to set new dates

      setenv RUN_PART2 Y
      setenv QA_TYPE  temporal           # Used to name the report inputs and outputs
      setenv QA_LABEL $SUBSECT           # Used to name the report inputs and outputs
      setenv REPLABEL $SUBSECT           # Used internally by Smkreport
      source $SCRIPTS/run/qa_run_v3.csh  # Run QA for part 1
      setenv RUN_PART2 N

      setenv RUN_PART4 Y
      source $ASSIGNS_FILE                  # Invoke Assigns file
      source $SCRIPTS/run/smk_run_v2.csh    # Run programs

      # Run m3stat script on Smkmerge output file
      if ($RUN_M3STAT == Y) then
        $SCRIPTS/run/m3stat_chk_v2.csh $POUT
      endif

      # Save settings for rerunning Smkmerge
      set save_temporal = $RUN_TEMPORAL
      set save_smk2emis = $RUN_SMK2EMIS
      set save_smkreport = $RUN_SMKREPORT
      set save_laypoint = $RUN_LAYPOINT
      set save_mrggrd = $MRG_GRDOUT_YN 
      set save_mrgsta = $MRG_REPSTA_YN 
      set save_mrgcny = $MRG_REPCNY_YN
      set save_grdunt = $MRG_GRDOUT_UNIT
      set save_totunt = $MRG_TOTOUT_UNIT
      set save_abbr   = $SRCABBR

      # Reset settings for rerunning Smkmerge
      setenv RUN_TEMPORAL  N        #  run temporal allocation program
      setenv RUN_SMK2EMIS  N        #  run conversion of 2-d to UAM binary
      setenv RUN_SMKREPORT N        # run reporting as defined in qa_run_v2.csh
      setenv RUN_LAYPOINT  N

      setenv MRG_GRDOUT_YN        N          # Y outputs gridded file
      setenv MRG_REPSTA_YN        Y          # Y outputs state totals
      setenv MRG_REPCNY_YN        N          # Y outputs county totals
      setenv MRG_GRDOUT_UNIT      tons/hr    # units for gridded outputs
      setenv MRG_TOTOUT_UNIT      tons/day   # units for state and/or county totals   
      setenv SRCABBR  ${SRCABBR}_rpt

      # Run mass-based Smkmerge reports
      source $ASSIGNS_FILE                   # Invoke Assigns file
      source $SCRIPTS/run/smk_run_v2.csh

      # Reset settings back to original values.
      setenv RUN_TEMPORAL    $save_temporal
      setenv RUN_SMK2EMIS    $save_smk2emis
      setenv RUN_SMKREPORT   $save_smkreport
      setenv RUN_LAYPOINT    $save_laypoint
      setenv MRG_GRDOUT_YN   $save_mrggrd
      setenv MRG_REPSTA_YN   $save_mrgsta
      setenv MRG_REPCNY_YN   $save_mrgcny
      setenv MRG_GRDOUT_UNIT $save_grdunt
      setenv MRG_TOTOUT_UNIT $save_totunt
      setenv SRCABBR $save_abbr

      setenv RUN_PART4 N

      # Zip the daily intermediaries, because it's quite large
      if ( -e $PTMP ) then
         gzip -vf $PTMP
      endif
      if ( -e $PLAY ) then
         gzip -vf $PLAY
      endif
      setenv POUT  $INTERMED/emis_mole_${SECTOR}_${ESDATE}_${GRID}_${SPC}_${CASE}.ncf # in case smkmerge isn't run, so this doesn't crash it
      if ( -e $POUT ) then
         gzip -vf $POUT
      endif
      
   end  # End loop over days

   unsetenv G_STDATE_ADVANCE

end  # End loop over parts

#
## Ending of script
#
exit( 0 )

 
