#!/bin/csh -fx
#
##### run m3stat on SMKMERGE output to check for NaN and negative values
# Jonathan Petters 5/11/04
# Updated by M. Houyoux to use a script argument on 11/22/2006
#

echo 'Now running M3STAT'

switch ( $# )
   case 0:
      echo "SCRIPT ERROR: m3stat_chk_v2.csh script requires an argument that"
      echo "    gives the file name on which run the script."
      exit( 1 )
endsw

setenv TOOLS $IOAPIDIR

setenv INFILE $argv[1]

setenv LOGDIR  $M3STAT_LOGS
if (! -e $LOGDIR) then
   mkdir -p $LOGDIR
endif

setenv LOGFILE $LOGDIR/m3stat_${SUBSECT}_${ESDATE}_${GRID}_${SPC}_$CASE.log
if (-e $LOGFILE) then
  rm $LOGFILE
endif

setenv REPORT $LOGDIR/m3stat_${SUBSECT}_${ESDATE}_${GRID}_${SPC}_$CASE.rpt

if (-e $REPORT) then
   rm -f $REPORT
endif 

set m3stat_in = $INTERMED/.m3stat_${MONTH}_$$.in 
if ( -e $m3stat_in ) then
   rm -f $m3stat_in
endif

echo INFILE >> $m3stat_in
echo REPORT >> $m3stat_in
echo Y >> $m3stat_in
echo $G_STDATE >> $m3stat_in
echo 0 >> $m3stat_in
echo 250000 >> $m3stat_in

$TOOLS/m3stat < $m3stat_in 

setenv LOG_FILE $LOGFILE
$SCRIPTS/run/checklogfile.csh
if ($status != 0) then
  echo ERROR detected in M3STAT
  exit (1)
endif

grep -i NaN $REPORT 
if ($status == 0 ) then
   echo '*******************************' >> $LOGFILE
   echo '* ERROR detected in M3STAT report:' >> $LOGFILE
   echo "* Imaginary # found in "$REPORT >> $LOGFILE
   echo '*******************************' >> $LOGFILE
endif

grep ' -' $REPORT 
if ($status == 0 ) then
   echo '*******************************' >> $LOGFILE
   echo '* ERROR detected in M3STAT report:' >> $LOGFILE
   echo "* Negative # found in "$REPORT >> $LOGFILE
   echo '*******************************' >> $LOGFILE
endif

setenv LOG_FILE $LOGFILE
$SCRIPTS/run/checklogfile.csh
if ($status != 0) then
  echo ERROR detected in M3STAT
  exit (1)
endif

/bin/rm -rf $m3stat_in
   
  

    
