#!/bin/csh -f

# Version @(#)$Id: smk_run.csh,v 1.1.2.15 2003/09/22 18:59:21 cseppan Exp $
# Path    $Source: /afs/isis/depts/cep/emc/apps/archive/smoke/smoke/scripts/run/Attic/smk_run.csh,v $
# Date    $Date: 2003/09/22 18:59:21 $

# This script runs the SMOKE processors.  
#
# Time independent programs only need to be run once.
# Time dependent programs need to be processed once
# for each day needed for the air quality simulation.  
#
# Script created by : M. Houyoux and J. Vukovich, MCNC
#                     Environmental Modeling Center 
# Last edited : November 2006
#
#*********************************************************************

# Create directory for output program logs

setenv OUTLOG $LOGS
if ( ! -e $OUTLOG ) then
   mkdir -p $OUTLOG
   chmod ug+w $OUTLOG
endif

# Initialize exit status
set exitstat = 0

# Make sure that debug mode and debug executable are set
if ( $?DEBUGMODE ) then
   set debugmode = $DEBUGMODE
else
   set debugmode = N
endif

if ( $?DEBUG_EXE ) then
   set debug_exe = ( $DEBUG_EXE )
else
   set debug_exe = dbx
endif

### Set version of BEIS3 executables to use.
set nb = normbeis3
set tb = tmpbeis3

if ( $SMK_SOURCE == B ) then
if ( $?BEIS3_VERSION ) then

   if ( $BEIS3_VERSION == 3.09 ) then
   else

      if ( $BEIS3_VERSION == 3.11 ) then
	 set nb = normbeis311
	 set tb = tmpbeis311

      else if ( $BEIS3_VERSION == 3.12 ) then
	 set nb = normbeis312
	 set tb = tmpbeis312
	    
      else if ( $BEIS3_VERSION == 3.13 ) then
	 set nb = normbeis312
	 set tb = tmpbeis312
	    
      else
         echo 'SCRIPT WARNING: BEIS3_VERSION setting of "'$BEIS3_VERSION'"'
	 echo '                is not recognized.  Defaulting to BEIS3.09.'
	 
      endif


   endif
else
   echo 'SCRIPT NOTE: BEIS3_VERSION variable is not set, so defaulting'
   echo '             to BEIS3.09.  Settings are 3.09, 3.11, and 3.12'
	
endif
endif

### Ensure new controller variables are set
if ( $?RUN_PART1 ) then
   if ( $RUN_PART1 == Y || $RUN_PART1 == y ) then
      setenv RUN_PART1 Y
      echo 'Running part 1...'
   endif
else
   setenv RUN_PART1 N
endif
if ( $?RUN_PART2 ) then
   if ( $RUN_PART2 == Y || $RUN_PART2 == y ) then
      setenv RUN_PART2 Y
      echo "Running part 2, for $ESDATE ..."
   endif
else
   setenv RUN_PART2 N 
endif
if ( $?RUN_PART3 ) then
   if ( $RUN_PART3 == Y || $RUN_PART3 == y ) then
      setenv RUN_PART3 Y
      echo 'Running part 3 ...'
   endif
else
   setenv RUN_PART3 N 
endif
if ( $?RUN_PART4 ) then
   if ( $RUN_PART4 == Y || $RUN_PART4 == y ) then
      setenv RUN_PART4 Y
      echo "Running part 4, for $ESDATE..."
   endif
else
   setenv RUN_PART4 N 
endif

#
### Scan CEM Data
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/cemscan_${SRCABBR}_$CASE.log
if ( $?RUN_CEMSCAN ) then
   if ( $RUN_CEMSCAN == 'Y' && $RUN_PART0 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      ##  Create output directories, if needed
      source $SCRIPTS/run/make_invdir.csh
      set exitstat = $status

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $IV_SRC/cemscan.debug ) then
               $debug_exe $IV_SRC/cemscan.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/cemscan ) then
               time $SMK_BIN/cemscan
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Cemscan
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: cemscan program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: cemscan.debug program does not exist in:'
	 echo '              '$UT_SRC
         set exitstat = 1
      endif

   endif
endif

#
### Raw Inventory processing
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/smkinven_${SRCABBR}_$CASE.log
if ( $?RUN_SMKINVEN ) then
   if ( $RUN_SMKINVEN == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      ##  Create output directories, if needed
      source $SCRIPTS/run/make_invdir.csh
      set exitstat = $status

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $IV_SRC/smkinven.debug ) then
               $debug_exe $IV_SRC/smkinven.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/smkinven ) then
               time $SMK_BIN/smkinven
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Smkinven
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( -e $SMK_TMPDIR/import_tmp ) then
         /bin/rm -rf $SMK_TMPDIR/import_tmp
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: smkinven program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: smkinven.debug program does not exist in:'
	 echo '              '$IV_SRC
         set exitstat = 1
      endif

   endif
endif

#
### County or gridded landuse import
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/rawbio_${SRCABBR}_${CASE}_$GRID.log
if ( $?RUN_RAWBIO ) then

   if ( $RUN_RAWBIO == 'Y' && $RUN_PART1 == Y ) then

      # Use summer emission factors, if they are set for first rawbio run
      if ( $?S_BFAC ) then
          setenv BFAC $S_BFAC

      else

         if ( $?BFAC ) then
            echo 'SCRIPT WARNING: default biogenic emission factors, BFAC file:'
            echo '               '$BFAC
            echo '                are used directly based on user setting.'

         else
            echo 'SCRIPT ERROR: neither BFAC nor S_BFAC environment variables are set'
            set exitstat = 1

         endif

      endif

      set season = n
      # Use summer-specific processing if season-switch option in use
      if ( $?BIOSW_YN ) then
         if ( $BIOSW_YN == Y ) then
            set season = y
            setenv TMPLOG $OUTLOG/rawbio_${SRCABBR}_summer_${CASE}_$GRID.log
         endif  
      endif  

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program for standard or summer
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $BG_SRC/rawbio.debug ) then
               $debug_exe $BG_SRC/rawbio.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/rawbio ) then
               time $SMK_BIN/rawbio
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Rawbio
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      # Now do winter-specific processing, if season-switch option in use
      if ( $season == y ) then

         if ( $?W_BFAC && $?BGRDW ) then
            # Set input file 
            setenv BFAC $W_BFAC
            setenv BGRD $BGRDW
            setenv TMPLOG $OUTLOG/rawbio${SRCABBR}_winter_${CASE}_$GRID.log

            if ( -e $TMPLOG ) then
	       source $SCRIPTS/run/movelog.csh
            endif

            if ( $exitstat == 0 ) then         # Run program for winter
               setenv LOGFILE $TMPLOG

               if ( $debugmode == Y ) then
                  if ( -e $BG_SRC/rawbio.debug ) then
                     $debug_exe $BG_SRC/rawbio.debug
                  else
                      set debugexestat = 1
                  endif
               else
                  if ( -e $SMK_BIN/rawbio ) then
                     time $SMK_BIN/rawbio
        	     $SCRIPTS/run/checklogfile.csh
        	     if ( $status != 0 ) then
                       echo ERROR detected in Rawbio
                       exit( 1 )
        	     endif
                  else
                     set exestat = 1 
                  endif
               endif
            endif

         if ( -e $SCRIPTS/fort.99 ) then
            mv $LOGFILE $LOGFILE.tmp
            cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
            /bin/rm -rf $LOGFILE.tmp
            /bin/rm -rf $SCRIPTS/fort.99
         endif

         else
      	    echo 'SCRIPT ERROR: BIOSW_YN (biogenics seasonality switch) set to'
            echo '              Y, but W_BFAC (winter biogenic factors input) and/or'
            echo '              BGRDW (winter normalized emissions) environment'
            echo '              variables are not defined.'
	    set exitstat = 1
         endif
    
      endif
   endif

   if ( $exestat == 1 ) then
      echo 'SCRIPT ERROR: rawbio program does not exist in:'
      echo '              '$SMK_BIN
      set exitstat = 1
   endif

   if ( $debugexestat == 1 ) then
      echo 'SCRIPT ERROR: rawbio.debug program does not exist in:'
      echo '              '$BG_SRC
      set exitstat = 1
   endif

endif


#
# BELD3 gridded landuse import for use in BEIS3
#

set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/${nb}_${SRCABBR}_${CASE}_$GRID.log
if ( $?RUN_NORMBEIS3 ) then

   if ( $RUN_NORMBEIS3 == 'Y' && $RUN_PART1 == Y ) then

      set season = n
      # Use summer-specific processing if season-switch option in use
      if ( $?BIOSW_YN ) then
         if ( $BIOSW_YN == Y ) then
            set season = y
            setenv TMPLOG $OUTLOG/${nb}_${SRCABBR}_summer_${CASE}_$GRID.log
         endif  
      endif  

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program for standard or summer
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $BG_SRC/$nb.debug ) then
               $debug_exe $BG_SRC/$nb.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/$nb ) then
               time $SMK_BIN/$nb
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in $nb
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

   endif

   if ( $exestat == 1 ) then
      echo 'SCRIPT ERROR: '$nb' program does not exist in:'
      echo '              '$SMK_BIN
      set exitstat = 1
   endif

   if ( $debugexestat == 1 ) then
      echo 'SCRIPT ERROR: '$nb'.debug program does not exist in:'
      echo '              '$BG_SRC
      set exitstat = 1
   endif

endif

#
### Speciation Matrix generation
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/spcmat_${SRCABBR}_${CASE}_$SPC.log
if ( $?RUN_SPCMAT ) then
   if ( $RUN_SPCMAT == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $SP_SRC/spcmat.debug ) then
               $debug_exe $SP_SRC/spcmat.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/spcmat ) then
               time $SMK_BIN/spcmat
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Spcmat
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: spcmat program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: spcmat.debug program does not exist in:'
	 echo '              '$SP_SRC
         set exitstat = 1
      endif

   endif
endif

#
### Gridding Matrix generation
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/grdmat_${SRCABBR}_${CASE}_$GRID.log
if ( $?RUN_GRDMAT ) then
   if ( $RUN_GRDMAT == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $GD_SRC/grdmat.debug ) then
               $debug_exe $GD_SRC/grdmat.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/grdmat ) then
               time $SMK_BIN/grdmat
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Grdmat
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: grdmat program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: grdmat.debug program does not exist in:'
	 echo '              '$GD_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Mobile setup for MOBILE6 runs
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/mbsetup_${SRCABBR}_${CASE}.log
if ( $?RUN_MBSETUP ) then
   if ( $RUN_MBSETUP == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
         source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
         if ( $debugmode == Y ) then
            if ( -e $MB_SRC/mbsetup.debug ) then
               $debug_exe $MB_SRC/mbsetup.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/mbsetup ) then
               time $SMK_BIN/mbsetup
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Mbsetup
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: mbsetup program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: mbsetup.debug program does not exist in:'
	 echo '              '$MB_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Pre-mobile-source processing
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/premobl_${SRCABBR}_${CASE}_$GRID.log
if ( $?RUN_PREMOBL ) then
   if ( $RUN_PREMOBL == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( -e $METLIST ) /bin/rm -rf $METLIST

      ls $METDAT/METCRO2D* > $METLIST

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG

         if ( $debugmode == Y ) then
            if ( -e $MB_SRC/premobl.debug ) then
               $debug_exe $MB_SRC/premobl.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/premobl ) then
               time $SMK_BIN/premobl
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Premobl
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: premobl program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: premobl.debug program does not exist in:'
	 echo '              '$MB_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Meteorology scan for bioseason file
# 
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/metscan_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
if ( $?RUN_METSCAN ) then
   if ( $RUN_METSCAN == 'Y' && $RUN_PART1 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
        setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $UT_SRC/metscan.debug ) then
               $debug_exe $UT_SRC/metscan.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/metscan ) then
               time $SMK_BIN/metscan
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Metscan
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: metscan program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: metscan.debug program does not exist in:'
	 echo '              '$UT_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Temporal Allocation - anthropogenic sources
# 
set debugexestat = 0
set exestat = 0
if ( $SMK_SOURCE == 'M' ) then
   setenv TMPLOG   $OUTLOG/temporal_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
else
   setenv TMPLOG   $OUTLOG/temporal_${SRCABBR}_${CASE}_${ESDATE}.log
endif
if ( $?RUN_TEMPORAL ) then
   if ( $RUN_TEMPORAL == 'Y' && $RUN_PART2 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      ## For mobile sources, create MEFLIST file if there are any files
      #    to put into the list
      if ( $SMK_SOURCE == M ) then
         setenv MEFLIST $SMK_EMISPATH/meflist.txt
         set ef_cnt = `ls $SMK_EMISPATH/emisfacs*ncf | wc -l`
         if ( $ef_cnt > 0 ) then

            if ( -e $SMK_EMISPATH/meflist.txt ) /bin/rm -rf $SMK_EMISPATH/meflist.txt

            set extension = `ls $SMK_EMISPATH/emisfacs*ncf | cut -d. -f4`
            if ( $extension[1] == 'ncf' ) then
               ls $SMK_EMISPATH/emisfacs*ncf > $SMK_EMISPATH/meflist.txt
            else 
               ls $SMK_EMISPATH/emisfacs*1.ncf | cut -d. -f1,2,3,5 > $SMK_EMISPATH/meflist.txt
            endif
         endif
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $TM_SRC/temporal.debug ) then
               $debug_exe $TM_SRC/temporal.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/temporal ) then
               time $SMK_BIN/temporal
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Temporal
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: temporal program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: temporal.debug program does not exist in:'
	 echo '              '$TM_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Elevated source selection
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/elevpoint_${SRCABBR}_${CASE}.log
if ( $?RUN_ELEVPOINT ) then
   if ( $RUN_ELEVPOINT == Y && $RUN_PART3 == Y ) then      

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      # Create PTMPLIST file, in case it is needed.
      if ( -e $PTMP ) then
         setenv PTMPLIST $INVDIR/other/ptmplist.txt
         if ( -e $PTMPLIST ) /bin/rm -rf $PTMPLIST

         ls $SMKDAT/run_$PSCEN/*/ptmp*$PSCEN*ncf > $PTMPLIST
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $PT_SRC/elevpoint.debug ) then
               $debug_exe $PT_SRC/elevpoint.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/elevpoint ) then
               time $SMK_BIN/elevpoint
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Elevpoint
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: elevpoint program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: elevpoint.debug program does not exist in:'
	 echo '              '$PT_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Layer fractions creation
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/laypoint_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
if ( $?RUN_LAYPOINT ) then
   if ( $RUN_LAYPOINT == 'Y' && $RUN_PART4 == Y ) then

      if ( $?SMK_PING_METHOD ) then
         if ( $SMK_PING_METHOD == 2 ) then
            setenv SMK_PING_YN Y
         endif
      endif

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $PT_SRC/laypoint.debug ) then
               $debug_exe $PT_SRC/laypoint.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/laypoint ) then
               time $SMK_BIN/laypoint
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Laypoint
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: laypoint program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: laypoint.debug program does not exist in:'
	 echo '              '$PT_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Temporal Allocation - biogenic sources
# 
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/tmpbio_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
if ( $?RUN_TMPBIO ) then
   if ( $RUN_TMPBIO == 'Y' && $RUN_PART2 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( -e $METLIST ) /bin/rm -rf $METLIST
      if ( -e $RADLIST ) /bin/rm -rf $RADLIST

      ls $MET_FILE1 > $METLIST
      ls $MET_FILE2 > $RADLIST

      if ( $exitstat == 0 ) then         # Run program
        setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $BG_SRC/tmpbio.debug ) then
               $debug_exe $BG_SRC/tmpbio.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/tmpbio ) then
               time $SMK_BIN/tmpbio
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Tmpbio
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: tmpbio program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: tmpbio.debug program does not exist in:'
	 echo '              '$BG_SRC
         set exitstat = 1
      endif
   endif
endif

#
# Temporal allocation for biogenics for BEIS3
#

set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/${tb}_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
if ( $?RUN_TMPBEIS3 ) then
   if ( $RUN_TMPBEIS3 == 'Y' && $RUN_PART2 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
        setenv LOGFILE $TMPLOG
        if ( $debugmode == Y ) then
            if ( -e $BG_SRC/$tb.debug ) then
               $debug_exe $BG_SRC/$tb.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/$tb ) then
               time $SMK_BIN/$tb
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in $tb
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo "SCRIPT ERROR: "$tb" program does not exist in:"
	 echo "              "$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo "SCRIPT ERROR: "$tb".debug program does not exist in:"
	 echo "              "$BG_SRC
         set exitstat = 1
      endif
   endif
endif

#

#
### Merging
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/smkmerge_${SRCABBR}_${CASE}_${ESDATE}_${GRID}_$SPC.log
if ( $?RUN_SMKMERGE ) then
   if ( $RUN_SMKMERGE == 'Y' && $RUN_PART4 == Y ) then

      # Set mole/mass-based speciation matrices.
      set unit = tons
      if( $?MRG_GRDOUT_UNIT ) then 
         set unit = `echo $MRG_GRDOUT_UNIT | cut -c1-4`
      endif
      if ( $unit == mole ) then   # mole
         if ( $?ASMAT_L ) then
            setenv ASMAT $ASMAT_L
         endif
         if ( $?BGTS_L ) then
            setenv BGTS $BGTS_L
         endif
         if ( $?MSMAT_L ) then
            setenv MSMAT $MSMAT_L
         endif
         if ( $?PSMAT_L ) then
            setenv PSMAT $PSMAT_L
         endif

      else                       # mass
         if ( $?ASMAT_S ) then
            setenv ASMAT $ASMAT_S
         endif
         if ( $?BGTS_S ) then
            setenv BGTS $BGTS_S
         endif
         if ( $?MSMAT_S ) then
            setenv MSMAT $MSMAT_S
         endif
         if ( $?PSMAT_S ) then
            setenv PSMAT $PSMAT_S
         endif
      endif

      if ( -e $TMPLOG ) then
         source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
         if ( $debugmode == Y ) then
            if ( -e $MG_SRC/smkmerge.debug ) then
               $debug_exe $MG_SRC/smkmerge.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/smkmerge ) then
               time $SMK_BIN/smkmerge
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Smkmerge
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: smkmerge program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: smkmerge.debug program does not exist in:'
	 echo '              '$MG_SRC
         set exitstat = 1
      endif
   endif
endif

set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/mrggrid_${SRCABBR}_${CASE}_${ESDATE}_${GRID}_$SPC.log
if ( $?RUN_MRGGRID ) then
   if ( $RUN_MRGGRID == 'Y' && $RUN_PART4 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      ## If Mrggrid file list defined, create list file
      if ( $?MRGFILES ) then

         ## Remove existing file list, if it is there
         if ( -e $FILELIST ) then
            /bin/rm -rf $FILELIST
         endif
         set mrg_cnt = 0
         foreach f ( $MRGFILES )
            @ mrg_cnt = $mrg_cnt + 1
            if ( $mrg_cnt == 1 ) then
               echo $f > $FILELIST
            else
               echo $f >> $FILELIST
            endif
         end

         if ( $mrg_cnt == 0 ) then
             echo "SCRIPT ERROR: MRGFILES defined, but no logical file names included."
             echo "              MRGFILES script variable = "${MRGFILES}.
             echo "              Please reset and rerun script"
             set exitstat = 1
         echo
             echo "SCRIPT NOTE: File FILELIST created with logical files:"
             echo "             "$MRGFILES
         endif
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
         if ( $debugmode == Y ) then
            if ( -e $MG_SRC/mrggrid.debug ) then
               $debug_exe $MG_SRC/mrggrid.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/mrggrid ) then
               time $SMK_BIN/mrggrid
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Mrggrid
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: mrggrid program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: mrggrid.debug program does not exist in:'
	 echo '              '$MG_SRC
         set exitstat = 1
      endif
   endif
endif

#
### Formats conversion
#
set debugexestat = 0
set exestat = 0
setenv TMPLOG   $OUTLOG/smk2emis_${SRCABBR}_${CASE}_${ESDATE}_$GRID.log
if ( $?RUN_SMK2EMIS ) then
   if ( $RUN_SMK2EMIS == 'Y' && $RUN_PART4 == Y ) then

      if ( -e $TMPLOG ) then
	 source $SCRIPTS/run/movelog.csh
      endif

      if ( $exitstat == 0 ) then         # Run program
         setenv LOGFILE $TMPLOG
         if ( $debugmode == Y ) then
            if ( -e $UT_SRC/smk2emis.debug ) then
               $debug_exe $UT_SRC/smk2emis.debug
            else
                set debugexestat = 1
            endif
         else
            if ( -e $SMK_BIN/smk2emis ) then
               time $SMK_BIN/smk2emis
               $SCRIPTS/run/checklogfile.csh
               if ( $status != 0 ) then
                 echo ERROR detected in Smk2emis
                 exit( 1 )
               endif
            else
               set exestat = 1 
            endif
         endif
      endif

      if ( -e $SCRIPTS/fort.99 ) then
         mv $LOGFILE $LOGFILE.tmp
         cat $LOGFILE.tmp $SCRIPTS/fort.99 > $LOGFILE
         /bin/rm -rf $LOGFILE.tmp
         /bin/rm -rf $SCRIPTS/fort.99
      endif

      if ( $exestat == 1 ) then
	 echo 'SCRIPT ERROR: smk2emis program does not exist in:'
	 echo '              '$SMK_BIN
         set exitstat = 1
      endif

      if ( $debugexestat == 1 ) then
	 echo 'SCRIPT ERROR: smk2emis.debug program does not exist in:'
	 echo '              '$UT_SRC
         set exitstat = 1
      endif
   endif
endif

#
## Ending of script with exit status
#
exit( $exitstat )

