#!/bin/csh -f
#BSUB -c 0:20

# Version @(#)$Id$
# Path    $Source$
# Date    $Date$

#********************************************************************
# This script sets up needed environment variables for creating
#  a 2009cc BASE ptnonipm inventory from a 2002cc inventory
#  -applying PROJECTION FACTORS to 2002cc
#
# Script created by : M. Houyoux, US EPA
#
# When running cntlmat and grwinven (first step(s) here), use the following settings:
#    SECTOR = ptnonipm (because it uses SMKINVEN intermediate files from 2002cc_proj
#    USE_CASE_CON = N (set to Y when running SMKINVEN AFTER creating the projected/controlled inventory
#    CNTLCASE is needed (2020cc) because SECTOR needs to be 2002cc_proj for CREATING the grwinven inventory file
#    reassign PTINV_O to NOT use $SECTOR variable
#  When creating IDA file vs ORL file, need to change number of header rows to head from 6 vs 5
#
# When running SMKINVEN and SMKREPORT after cntlmat and grwinven, use the following settings:
#    SECTOR = ptnonipm    
#    USE_CASE_CON = Y
# comment out reassignment of EV PTINV_O
#  add exit before cntl_run_v2.csh -for cleaner standard output
#********************************************************************

# set Assigns file name
setenv ASSIGNS_FILE /orchid/oaqps/2002/smoke/subsys/v3/smoke232/assigns/ASSIGNS.2002cc_proj_2009cc.cmaq.cb05p25.36km
source $ASSIGNS_FILE
setenv DEBUGMODE          N       # Y changes script to use debugger
setenv AUTO_DELETE        Y       # Y deletes SMOKE I/O API output files (recommended)
setenv AUTO_DELETE_LOG    Y       # Y automatically deletes logs without asking
setenv SECTOR               ptnonipm # Sets the run ID for resetting scenario name used: when running cntlmat/grwinven 
setenv EISECTOR           $SECTOR  # if you do not initialize this, it will be set to nonpt
##############################################################################

#unsetenv DISPLAY

switch ( $# )
   case 0:
   case 1:
      echo "SCRIPT ERROR: Script requires -m or -q option with 2 settings."
      echo "  This script expects to be called using one of the following options:"
      echo "     -m <monthlist> <spinup>"
      echo "     -q <quarters> <spinup>"
      echo "  You can only use one option or the other."
      echo "  Examples:"
      echo "     <script name> -m '1 2 3' N: runs script for Jan, Feb, & Mar "
      echo "                                 with no spinup"
      echo "     <script name> -q 2 Y      : runs script for the 2nd quarter,"
      echo "                                 including spin-up days specified"
      echo "                                 SPINUP_DURATION environment variable."
      exit( 1 )
endsw

## Invoke script to interpret calling arguments
if ( $# == 2 ) then
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]"
   if ( $status == 1 ) exit ( 1 )
else
   source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]" $argv[3]
   if ( $status == 1 ) exit ( 1 )
endif
## Invoke script to interpret calling arguments
switch ( $#argv )
   case 2:
      source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]"
      if ( $status == 1 ) exit ( 1 )
   breaksw
   case 3:
      source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]" $argv[3]
      if ( $status == 1 ) exit ( 1 )
   breaksw
   case 4:
      source $SCRIPTS/run/set_months.csh $argv[1] "$argv[2]" $argv[3]
      if ( $status == 1 ) exit ( 1 )

      setenv TLABEL $argv[4]
   breaksw

endsw

# Set Time Log filename and initialize file
if ( $DEBUGMODE != Y && $DEBUGMODE != y ) then

   # ************************************************
   if ( $?TLABEL ) then
      setenv TIMELOG $LOGS/timelog_${SECTOR}_${CASE}_${GRID}_${TLABEL}.txt
   else
      setenv TIMELOG $LOGS/timelog_${SECTOR}_${CASE}_${GRID}.txt
   endif
   # ************************************************

   $SCRIPTS/run/timetracker.csh Y $TIMELOG
   if ( $status > 0 ) exit ( $status )

endif

# [**2**] End new "timetracker" lines

set spinup_array = ( $SPINUP_LIST )

## END CUT/PASTE

setenv USE_CASE_CON      N  # set to Y to use $CASE_CON in ASSIGNS file (instead of $CASE)
setenv RUN_PART1B N
#source $ASSIGNS_FILE

# set source category
setenv SMK_SOURCE P           # source category to process
setenv MRG_SOURCE P           # source category to merge
setenv MRG_CTLMAT_MULT ' '    # [A|P|AP] for merging with multiplier controls
setenv MRG_CTLMAT_ADD  ' '    # [A|P|AP] for merging with additive controls
setenv MRG_CTLMAT_REAC ' '    # [A|M|P|AMP] for merging with reactivity controls

## time independent programs and QA
setenv RUN_SMKINVEN  N        #  run inventory import program
setenv RUN_SPCMAT    N        #  run speciation matrix program
setenv RUN_SMKREPORT N        #  run smoke report program
setenv RUN_CNTLMAT   Y        #  run control matrix program
setenv RUN_GRWINVEN  Y        #  run control application program
setenv BUD_REPORTS   N        # Y copies smkreport output to bud
setenv BUD_INSTALL   /bud2

## Program-specific controls...

## For Smkinven
setenv FILL_ANNUAL          N  # Y fills annual value when only average day is provided
setenv IMPORT_GRDIOAPI_YN   N  # Y imported gridded I/O API inventory
setenv RAW_DUP_CHECK        Y  # Y errors on duplicate records

## For Spcmat
setenv POLLUTANT_CONVERSION Y     # Y uses ROG to TOG file, for example

#### set SMK_ARTOPNT_YN to N if SMKINVEN PRIOR TO CNTLMAT AND GRWINVEN
setenv SMK_ARTOPNT_YN       N  # Y uses area-to-point conversions
setenv SMK_BASEYR_OVERRIDE  0  # Enter year of the base year when future-year inven provided
setenv SMK_NHAPEXCLUDE_YN   N  # Y uses NonHAP exclusions file
setenv SMKINVEN_FORMULA     " "  # Internal PMC calculation
setenv WEST_HSPHERE         Y  # Y converts ALL stack coords to western hemisphere
setenv WKDAY_NORMALIZE      N  # Y normalizes weekly profiles by weekdays
#     REPORT_DEFAULTS      # see multiple-program controls, below

# For Cntlmat
#      SMK_AVEDAY_YN (see below)  # Y uses seas emis in assessing cutoff, etc.
#      REPORT_DEFAULTS            # See multi-program controls
setenv XREF_SICOVERSCC      Y     # not needed for PM NAAQS: most growth factors removed
setenv COMPARE_REPLACE_CONTROL  Y # Applies CONTROL packet cntls only when Replacement control
#                                   (repflag) > baseline controls

# For Grwinven
setenv SMK_NUM_CTLMAT       2     # number of control/projection matrices
setenv SMK_GRWSMKOUT_YN     N     # Y outputs a SMOKE-formatted inventory
setenv SMK_GRWIDAOUT_YN     N     # Y outputs an IDA-formatted inventory
setenv SMK_GRWORLOUT_YN     Y     # Y outputs an ORL-formatted inventory
setenv ORL_NONROAD_OUT      N     # Y outputs NONROAD ORL format

setenv REPORT_DEFAULTS      Y     # Y reports default profile application
setenv SMK_DEFAULT_TZONE    5     # time zone to fix in missing COSTCY file
setenv SMK_AVEDAY_YN        N     # Y uses average day emissions instead of annual
setenv SMK_MAXWARNING       100   # maximum number of warnings in log file
setenv SMK_MAXERROR         100   # maximum number of errors in log file

# Script settings
setenv QA_TYPE            custom  # [none, all, part1, part2, or custom]
setenv PROMPTFLAG         N       # Y (never set to Y for batch processing)
setenv AUTO_DELETE        Y       # Y deletes SMOKE I/O API output files (recommended)
setenv AUTO_DELETE_LOG    Y       # Y automatically deletes logs without asking
setenv DEBUGMODE          N       # Y changes script to use debugger
setenv DEBUG_EXE          totalview   # Sets the debugger to use when DEBUGMODE = Y
#setenv SECTOR               ptnonipm # Sets the run ID for resetting scenario name used: when running cntlmat/grwinven 
#setenv EISECTOR           $SECTOR  # if you do not initialize this, it will be set to nonpt

setenv RUN_HOLIDAYS       N       # Y = run holiday dates in temporal loop
setenv L_TYPE             mwdss   # Type for running temporal: aveday, mwdss, week, or all
setenv M_TYPE             mwdss   # Type for running Smkmerge: aveday, mwdss, week, or all
setenv MONTH_ARRAY        "1 1 1 1 1 1 1 1 1 1 1 1"
setenv SPINUP_DURATION    10     # 10 days for 36-km grid, 3 days for 12-km

# set to N if running cntlmat or grwinven
setenv USE_CASE_CON      N  # set to Y to use $CASE_CON in ASSIGNS file (instead of $CASE)
setenv REPLABEL  $SECTOR

# Override settings
setenv YEAR_OVERRIDE        2009  # Overrides YEAR (base) in Assigns file

## Set up scripting environment variables prior to calling the Assigns file
setenv SUBSECT $SECTOR                   # set variable for input/output names
setenv SRCABBR $SUBSECT                  # set abbreviation for naming log files

## Run Smkinven, Grdmat, and Spcmat

setenv RUN_PART1 Y
source $ASSIGNS_FILE               # Invoke Assigns file
echo "gsref 2002= " $GSREF
source $SCRIPTS/run/smk_run_v4.csh # Run programs

#setenv QA_TYPE  inv                # Used to name the report inputs and outputs
setenv QA_TYPE  custom                # Used to name the report inputs and outputs
setenv QA_LABEL $SUBSECT           # Used to name the report inputs and outputs
setenv REPLABEL $SUBSECT           # Used internally by Smkreport

mkdir -p $REPOUT/custom/create_2020cc

setenv REPCONFIG $SCRIPTS/cases/$CASE/repconfigs/repconfig_2002cc_proj_ptnonipm_custom.txt
setenv REPORT1 $REPOUT/custom/create_2009cc/rep_${SECTOR}_${CASE}_st.txt
setenv REPORT2 $REPOUT/custom/create_2009cc/rep_${SECTOR}_${CASE}_SCC.txt
setenv REPORT3 $REPOUT/custom/create_2009cc/rep_${SECTOR}_${CASE}_stSCC.txt
setenv REPORT8 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_FIPS_SCCspcmat.txt
setenv REPORT10 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_PLANT_SCCspcmat.txt

source $SCRIPTS/run/qa_run_v4.csh  # Run QA for part 1

setenv RUN_PART1 N

##############################################################################
# use this exit if already run cntlmat and grwinven
#exit( 0 )
##############################################################################
##############################################################################
## Set projection and control matrices to use in Grwinven
#      NOTE: Grwinven setting SMK_NUM_CTLMAT > 1 to use ACMAT02-04
## NOTE: GCNTL file for area sources must be in the $ARDAT (if oarea -see cntl_run.csh) directory for the
#        base case simulation and should have the names, as follows:
#            Projection only       :  gcntl_$YEAR_$FYEAR.txt,            # ONLY IF FYEAR IS PROVIDED
#            Control only          :  gcntl_$CNTLCASE.txt,               # ONLY IF CNTLCASE IS PROVIDED
#            Projection and control:  gcntl_$YEAR_$FYEAR_$CNTLCASE.txt,  # will be named this if FYEAR and CNTLCASE provided
#        where YEAR is set in the Assigns file and FYEAR and CNTLCASE
#        are set in this script.

# PART1B runs cntlmat and grwinven
setenv RUN_PART1B Y

## Run Cntlmat and Grwinven
#
setenv SMK_FUTURE_YN Y
setenv SMK_CONTROL_YN Y
setenv FYEAR              2009    # future year (in this case ne base)
setenv CNTLCASE BASE
setenv FULLSCC_ONLY             N # assign PROJECTION/CONTROL packet explicitly
setenv pnts_sav $PNTS
source $ASSIGNS_FILE   # Invoke Assigns file
setenv PNTS $pnts_sav
setenv PCMAT01 $PPMAT
setenv PCMAT02 $PCMAT #PCMAT01= $PPMAT when running projections or projections only
   mkdir -p $DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/work
################################################################################################################
source $SCRIPTS/run/cntl_run_v4.csh    # Run programs

setenv RUN_PART1B N
echo "case= " $CASE

# Move output file to new file name and location
if ( -e $PTINV_O ) then
#   mkdir -p $DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/work

  set dird = `pwd`

  #####################################################################################################
  # the PTINV_O file is named:
  #   $DAT_ROOT/inventory/$platform/$CASE_CON/$SECTOR/ptinv_${SUBSECT}_${CASE_CON}_${nicedate}_orl.txt
  #####################################################################################################
  #####################################################################################################
  # careful here!  head is 5 for ORL and 6 for IDA
  #####################################################################################################
  #####################################################################################################
  head -5  $PTINV_O > header
echo "OK to step 2"
  set dlines = (`cat $PTINV_O | wc -l `)
  echo "dlines first= " $dlines
    @ dlines -= 5
  echo "dlines= " $dlines
  tail -$dlines  $PTINV_O > x
  echo "#DESC SECTOR is: " $SECTOR > grwinvhead
  echo "#DESC CNTLCASE is: " $CASE_CON >> grwinvhead
  echo "#DESC ptnonipm 2002cc as base inventory for this 2009cc (BASE) control scenario" >> grwinvhead
  echo "#DESC Created $nicedate by $user  with create script at:  $dird/" >> grwinvhead

  rm  $PTINV_O
  cat header grwinvhead x > $DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/work/ptinv_${SUBSECT}_${CASE_CON}_${nicedate}_orl.txt
  rm grwinvhead x header

  # Create SMOKE lst file
  echo "#LIST" > $DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/ptinv_${SUBSECT}_${CASE_CON}.lst
  echo "$DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/work/ptinv_${SUBSECT}_${CASE_CON}_${nicedate}_orl.txt" >> $DAT_ROOT/inventory/$platform/$CASE_CON/$SUBSECT/ptinv_${SUBSECT}_${CASE_CON}.lst

endif

#
## Ending of script
#
setenv RUN_PART1B N

source $ASSIGNS_FILE
setenv RUN_SMKINVEN  Y        #  run inventory import program
setenv RUN_SPCMAT    Y        #  run speciation matrix program
setenv RUN_SMKREPORT Y        #  run smoke report program
setenv BUD_REPORTS   N        # Y copies smkreport output to bud
setenv BUD_INSTALL   /bud2

## Program-specific controls...

## For Smkinven
setenv FILL_ANNUAL          N  # Y fills annual value when only average day is provided
setenv IMPORT_GRDIOAPI_YN   N  # Y imported gridded I/O API inventory
setenv RAW_DUP_CHECK        Y  # Y errors on duplicate records
setenv SMK_ARTOPNT_YN       N  # Y uses area-to-point conversions 
setenv SMK_BASEYR_OVERRIDE  0  # Enter year of the base year when future-year inven provided
setenv SMK_NHAPEXCLUDE_YN   N  # Y uses NonHAP exclusions file
setenv SMKINVEN_FORMULA     "PMC=PM10-PM2_5"  # Internal PMC calculation
setenv WEST_HSPHERE         Y  # Y converts ALL stack coords to western hemisphere
setenv WKDAY_NORMALIZE      N  # Y normalizes weekly profiles by weekdays

## For Spcmat
setenv POLLUTANT_CONVERSION Y     # Y uses ROG to TOG file, for example

# Script settings
setenv QA_TYPE            custom  # [none, all, part1, part2, or custom]
setenv PROMPTFLAG         N       # Y (never set to Y for batch processing)
setenv AUTO_DELETE        Y       # Y deletes SMOKE I/O API output files (recommended)
setenv AUTO_DELETE_LOG    Y       # Y automatically deletes logs without asking
setenv DEBUGMODE          N       # Y changes script to use debugger
setenv DEBUG_EXE          pgdbg   # Sets the debugger to use when DEBUGMODE = Y
setenv SECTOR               ptnonipm   # Sets the run ID for resetting scenario name used: when cntlmat/grwinven DONE
setenv EISECTOR           $SECTOR  # if you do not initialize this, it will be set to nonpt

## Set up scripting environment variables prior to calling the Assigns file
setenv SUBSECT $SECTOR                   # set variable for input/output names
setenv SRCABBR $SUBSECT                  # set abbreviation for naming log files

setenv RUN_HOLIDAYS       N       # Y = run holiday dates in temporal loop
setenv L_TYPE             mwdss   # Type for running temporal: aveday, mwdss, week, or all
setenv M_TYPE             mwdss   # Type for running Smkmerge: aveday, mwdss, week, or all
setenv MONTH_ARRAY        "1 1 1 1 1 1 1 1 1 1 1 1"
setenv SPINUP_DURATION    10     # 10 days for 36-km grid, 3 days for 12-km

# set to N if running cntlmat or grwinven
setenv USE_CASE_CON      Y  # set to Y to use $CASE_CON in ASSIGNS file (instead of $CASE)
setenv REPLABEL  $SECTOR

# Override settings
setenv YEAR_OVERRIDE        2009  # Overrides YEAR (base) in Assigns file

## Run Smkinven, Grdmat, and Spcmat

setenv RUN_PART1 Y
source $ASSIGNS_FILE               # Invoke Assigns file
echo "gsref 2020= " $GSREF
source $SCRIPTS/run/smk_run_v4.csh # Run programs

#setenv QA_TYPE  inv                # Used to name the report inputs and outputs
setenv QA_TYPE  custom                # Used to name the report inputs and outputs
setenv QA_LABEL $SUBSECT           # Used to name the report inputs and outputs
setenv REPLABEL $SUBSECT           # Used internally by Smkreport

mkdir -p $REPOUT/custom/create_2009cc

setenv REPCONFIG $SCRIPTS/cases/$CASE_CON/repconfigs/repconfig_2009cc_ptnonipm_custom.txt
setenv REPORT1 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_st.txt
setenv REPORT2 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_SCC.txt
setenv REPORT3 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_stSCC.txt
setenv REPORT8 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_FIPS_SCCspcmat.txt
setenv REPORT10 $REPOUT/custom/create_2009cc/rep_${SUBSECT}_${CASE}_PLANT_SCCspcmat.txt

source $SCRIPTS/run/qa_run_v4.csh  # Run QA for part 1
setenv RUN_PART1 N

echo "Ending early \!"
exit ( 1 )
