#!/bin/tcsh -f
#PBS -W group_list=romo
#PBS -A sectors
#PBS -q romo
#PBS -l walltime=24:00:00
#PBS -l select=ncpus=1
unset verbose

setenv SMK_HOME "/amber/work/cvy/WO94.1_test" # [**Change this to your installation directory**]

if ( $?PBS_JOBID ) then
 cd $PBS_O_WORKDIR
else
 set PBS_JOBID = $?
endif

#-----------------------------------------------------------------#

set CTM_2DEMIS = Y 
set CTM_PT3DEMIS = Y 

setenv GRID 12EUS1
setenv CASE 2005ck_05b
set ptnonipm_case = 2005ck_05b
set ptipm_case = 2005ck_05b
set seca_case = 2005ck_05b
set othpt_case = 2005ck_05b
set othpt_hg_case = 2005ck_05b

# Grid parameters
setenv XORG -1008.
setenv YORG -1620.
setenv NX 279
setenv NY 240
setenv DX 12.

set start_date = 2004364          #first day
set end_date = 2005365          #last day

#set start_date = 2005001          #first day
#set end_date = 2005005          #last day

set QADIR = $cwd/qatemp #location for QA files - domain totals and domain total 2D plots of point emissions
mkdir -p $QADIR

set tempdir = $cwd/work
mkdir -p $tempdir
setenv SCRIPTLOG cmaq2camx_${CASE}_${GRID}_${PBS_JOBID}.log 
if ( -e $cwd/$SCRIPTLOG) then
	rm $cwd/$SCRIPTLOG
endif
#-----------------------------------------------------------------#

set today = $start_date

while ($today <= $end_date )

echo $today >> $cwd/$SCRIPTLOG
#-----------------------------------------------------------------#
set STDATE = $today

set GDAY = (`$cwd/j2g.csh $today`)
set YYYY = $GDAY[1]
set YY = `echo $YYYY | cut -c3-4`
set MM = $GDAY[2]
set DD = $GDAY[3]
set G_DAY = $YYYY$MM$DD
set GS_DAY = $YY$MM$DD
set YYDDD = `echo $today | cut -c3-8`

set iday = `grep ^$STDATE $cwd/mergedates.txt` 
#---------------------------------------------------------------------------#


if ($CTM_2DEMIS == Y) then ## 2D emissions preparation
#need to combine these files, adjust species names, and add duplicate species

set PATHA = ${SMK_HOME}/smoke_out/${CASE}/${GRID}/cmaq_cb05_soa
set FILEA = emis_mole_all_${G_DAY}_${GRID}_cmaq_cb05_soa_${CASE}.ncf

if (! -e $PATHA/$FILEA) then
        gunzip -c $PATHA/${FILEA}.gz > ${tempdir}/temp_${PBS_JOBID}.ncf
else
        cp $PATHA/$FILEA ${tempdir}/temp_${PBS_JOBID}.ncf
endif

ls -l ${tempdir}/temp_${PBS_JOBID}.ncf

echo ${PATHA}/${FILEA} >> $cwd/$SCRIPTLOG
set OUTPATH = ${SMK_HOME}/smoke_out/${CASE}/${GRID}/camx
if (! -e $OUTPATH) mkdir -p $OUTPATH
set OUTFILE = emis2d.$G_DAY.$GRID.$CASE.camx

# 1. run cmaq2camx to convert IOAPI 2D file to camx format and adjust species 
# 2. run qaemis on camx input file

rm -f ${tempdir}/tmp_emis_${PBS_JOBID}
set SPECIES_MAPPING  = ./conv2d/MAPTBL.cmaq2camx.toxics
setenv INFILE  ${tempdir}/temp_${PBS_JOBID}.ncf
setenv OUTFILE ${tempdir}/tmp_emis_${PBS_JOBID}
setenv MAPTBL  $SPECIES_MAPPING
echo "before spcmap"

./conv2d/spcmap

echo "after spcmap"
setenv CMAQEMIS ${tempdir}/tmp_emis_${PBS_JOBID}
rm -f ${tempdir}/tmp_pnt_${PBS_JOBID} $OUTPATH/$OUTFILE 

./conv2d/cmaq2uam << EOF
File Type          |EMIS
OutFile1 (IC,BC,AR)|$OUTPATH/$OUTFILE
OutFile2 (TopC,PT) |${tempdir}/tmp_pnt_${PBS_JOBID}
Output Timezone    |0
EOF
rm -f ${tempdir}/tmp_pnt_${PBS_JOBID} ${tempdir}/tmp_emis_${PBS_JOBID}

rm -f ${tempdir}/qaemis.low.${PBS_JOBID}.in
cat << ieof > ${tempdir}/qaemis.low.${PBS_JOBID}.in
$OUTPATH/$OUTFILE
$QADIR/emis2d.$G_DAY.$GRID.$CASE.camx.tot.txt
$QADIR/emis2d.$G_DAY.$GRID.$CASE.camx.hrs.txt
$QADIR/emis2d.$G_DAY.$GRID.$CASE.camx.pave.bin
ieof

# Optional QA step
./qaemis/qalowemis < ${tempdir}/qaemis.low.${PBS_JOBID}.in
rm -f ${tempdir}/qaemis.low.${PBS_JOBID}.in
rm -f ${tempdir}/temp_${PBS_JOBID}.ncf
endif ## end 2D emissions preparation


if ($CTM_PT3DEMIS == Y) then ## elevated point file preparation
#convert to camx point format and merge into a single point source file and then run qaemis on camx input file

set SEMIS = (${SMK_HOME}/intermed/$ptipm_case/ptipm/inln_mole_ptipm_${iday[8]}_${GRID}_cmaq_cb05_soa_${ptipm_case}.ncf \
             ${SMK_HOME}/intermed/$ptnonipm_case/ptnonipm/inln_mole_ptnonipm_${iday[5]}_${GRID}_cmaq_cb05_soa_${ptnonipm_case}.ncf \
             ${SMK_HOME}/intermed/$seca_case/seca_c3/inln_mole_seca_c3_${iday[2]}_${GRID}_cmaq_cb05_soa_${seca_case}.ncf \
             ${SMK_HOME}/intermed/$othpt_case/othpt/inln_mole_othpt_${iday[4]}_${GRID}_cmaq_cb05_soa_${othpt_case}.ncf \
             ${SMK_HOME}/intermed/$othpt_hg_case/othpt_hg/inln_mole_othpt_hg_${iday[4]}_${GRID}_cmaq_cb05_soa_${othpt_hg_case}.ncf)
	     
set SINFO = (${SMK_HOME}/smoke_out/$ptipm_case/$GRID/cmaq_cb05_soa/stack_groups_ptipm_${GRID}_${ptipm_case}.ncf \
             ${SMK_HOME}/smoke_out/$ptnonipm_case/$GRID/cmaq_cb05_soa/stack_groups_ptnonipm_${GRID}_${ptnonipm_case}.ncf \
             ${SMK_HOME}/smoke_out/$seca_case/$GRID/cmaq_cb05_soa/stack_groups_seca_c3_${GRID}_${seca_case}.ncf \
             ${SMK_HOME}/smoke_out/$othpt_case/$GRID/cmaq_cb05_soa/stack_groups_othpt_${GRID}_${othpt_case}.ncf \
             ${SMK_HOME}/smoke_out/$othpt_hg_case/$GRID/cmaq_cb05_soa/stack_groups_othpt_hg_${GRID}_${othpt_hg_case}.ncf)


set STYPE = (ptipm ptnonipm secac3 othpt othpt_hg) 

foreach i ( 1 2 3 4 5 )

ls $SEMIS[$i] $SINFO[$i]

echo $SEMIS[$i] >> $cwd/$SCRIPTLOG



if (! -e $SEMIS[$i]) then
        gunzip -c $SEMIS[$i].gz > ${tempdir}/temp_${PBS_JOBID}.ncf
else
        cp $SEMIS[$i] ${tempdir}/temp_${PBS_JOBID}.ncf
endif


#gunzip -c $SEMIS[$i] > ${tempdir}/temp_${PBS_JOBID}.ncf

setenv INFILE1 $SINFO[$i] 
setenv INFILE2 ${tempdir}/temp_${PBS_JOBID}.ncf 
rm -rf ${tempdir}/textfile_${PBS_JOBID} io_${PBS_JOBID} 

./inline2camx/inline2camx.x <<EOF
 -97.,40.,33.,45.,$NX,$NY,$XORG,$YORG,$DX
${tempdir}/textfile_${PBS_JOBID}
${tempdir}/ptsr.$STYPE[$i].${PBS_JOBID}.bin
io_${PBS_JOBID}
2
INFILE1
INFILE2
EOF

rm -f ${tempdir}/temp_${PBS_JOBID}.ncf
mv ${tempdir}/textfile_${PBS_JOBID} $QADIR/$STYPE[$i].$G_DAY.$CASE.domtot.txt 
mv io_${PBS_JOBID} $QADIR/$STYPE[$i].$G_DAY.$CASE.daytot2D.ncf

end ## end loop over the elevated point files for this day

set OUTPATH = ${SMK_HOME}/smoke_out/${CASE}/${GRID}/camx
set OUTFILE = mrgpt.$G_DAY.$GRID.$CASE.camx

./ptsmrg/ptsmrg << EOF
jdate    |$YYDDD
emissions|$OUTPATH/$OUTFILE
number pt| 5 
sat ptsr |${tempdir}/ptsr.ptipm.${PBS_JOBID}.bin
group num| 1
sat ptsr |${tempdir}/ptsr.ptnonipm.${PBS_JOBID}.bin
group num| 2
         |${tempdir}/ptsr.secac3.${PBS_JOBID}.bin
         | 3
         |${tempdir}/ptsr.othpt.${PBS_JOBID}.bin
         | 4
         |${tempdir}/ptsr.othpt_hg.${PBS_JOBID}.bin
         | 5









EOF

rm -rf ${tempdir}/qaemis.elev.${PBS_JOBID}.in
cat << ieof > ${tempdir}/qaemis.elev.${PBS_JOBID}.in
$OUTPATH/$OUTFILE
$QADIR/mrgpt.$G_DAY.$GRID.$CASE.camx.tot.txt
$QADIR/mrgpt.$G_DAY.$GRID.$CASE.camx.hrs.txt
$QADIR/mrgpt.$G_DAY.$GRID.$CASE.camx.pave.bin
ieof

./qaemis/qaelev < ${tempdir}/qaemis.elev.${PBS_JOBID}.in
rm -f ${tempdir}/qaemis.elev.${PBS_JOBID}.in
rm -f ${tempdir}/ptsr.*.${PBS_JOBID}.bin 
endif  ## end point source file processing

@ today = $today + 1

if ($today == 2004367) then
set today = 2005001
endif

end #loop back to next day

exit


