        program domaintotal
!
!   Purpose:           get a daily domain total of a species from an IOAPI file
!   application used:  
!   Date: April 2, 2009
!
!
!******** environmental variables used
!
!        ESDATE (yyyymmdd)
!        FILENAME
!        
!
         implicit none
         include 'PARMS3.EXT'      ! I/O API constants
         include 'FDESC3.EXT'      ! I/O API file description data structure
         include 'IODECL3.EXT'     ! I/O API function declarations 

       integer logdev
       character(len=16) :: this_program, esdate_env, input, spec_env
       character(len=16) :: output

       integer nsteps,nvars, nlays, ncols, nrows, tstep, sdate, stime
       integer index, istatus, esdate

       character(len=16), allocatable :: vname(:), units(:)
       character(len=16)   :: s_unit
       character(len=16)   ::  species, final_units

       character(len=30)   :: ofmt

       real, allocatable :: data(:,:,:)
       integer i_loop, t_loop, jdate, jtime
       integer s_loop
       logical found,fmtflag,rdonly
       integer iout
       
       double precision domainsum
       character*80 mesg

       integer trimlen, envint,getefile
       external trimlen, envint, getefile

       logdev = init3()	!  initialization returns unit # for log

       this_program = 'domaintotal'
       input        = 'FILENAME'
       esdate_env   = 'JDATE'
       output       = 'OUTPUT'

       rdonly = .false.
       fmtflag = .true.

       iout  = getefile(output,rdonly,fmtflag,istatus)

       esdate = envint(esdate_env,'emissions date',0,istatus)


        if ( .not. open3( input, FSREAD3, this_program ) ) THEN
           MESG = 'Could not open file "' //
     &     input( 1: TRIMLEN(input))
     &     // '" for input'
           CALL M3EXIT( this_program, 0, 0, MESG, 2 )
        end if

        IF ( .NOT. DESC3(input))THEN
           MESG = 'Could not get description info for file  "' //
     &              input( 1: TRIMLEN( input) ) //'"'
           CALL M3EXIT( this_program, 0, 0, MESG, 2 )
        ENDIF

        nsteps  = MXREC3D
	nvars   = NVARS3D
        nlays   = NLAYS3D
	ncols   = NCOLS3D
	nrows   = NROWS3D
        sdate   = SDATE3D
	stime   = STIME3D
	tstep   = TSTEP3D	

	jdate    = sdate
	jtime    = stime

	allocate (vname(nvars))
        allocate (units(nvars))
        ! vname(1:nvars) = VNAME3D(1:NVARS3D)
        ! units(1:nvars) = UNITS3D(1:NVARS3D)
        vname  = VNAME3D
        units  = UNITS3D
        allocate(data(ncols,nrows,nlays))
!        found = .false.
!        do i_loop = 1,nvars
!           write (*,*) i_loop, vname(i_loop)(1:trimlen(vname(i_loop))),
!     &        species(1:trimlen(species))
!           if   (vname(i_loop)(1:trimlen(vname(i_loop)))
!     &       .eq.      species(1:trimlen(species))) then
!              index = i_loop
!              found = .true.
!           endif
!        enddo
!
!       if (.not. found) then
!          write (*,*) 'ERROR: '//species//'not found in '//input
!          stop
!       endif


         write(*,*) 'nvars = ', nvars
         
         do s_loop = 1, nvars

          jdate = esdate
          jtime = 0
          domainsum = 0.0

          species = vname(s_loop)
          s_unit  = units(s_loop)(1:trimlen(units(s_loop)))
        do t_loop = 1,24
	     if ( .not. read3(input,species,ALLAYS3,jdate,jtime,data)) then
              mesg = 'Error reading '//species//'from file '//
     &           input( 1: TRIMLEN( input ) )
              call m3exit( this_program, 0, 0, MESG, 2 )
           end if
           domainsum = domainsum + SUM(data(1:ncols,1:nrows,1:nlays))
           call nextime(jdate, jtime, tstep)
        enddo

!        select case(s_unit)
!           case('moles/hr')
!             final_units = 'moles/day'
!           case('moles/s','mole/s')
!             final_units = 'moles/day'
!             domainsum = domainsum*3600.0
!           case ('g/hr')
!             final_units = 'g/day'
!           case default
!              write (*,*) 'WARNING: unknown units in input',
!     &        s_unit
!              final_units = ' '
!        end select
        ! ofmt = '(A12,A8,A8,I8,F20.4,A10)'
        ! Changed by CC requested by Chris
        ! ofmt = '(A12,A16,A16,I8,F20.4,A10)'
        ofmt = '(A16,I8,F20.4,A10)' ! remove species = and date = 
        final_units = ' '
        write (iout,ofmt) species,esdate,
     &     domainsum, final_units

        enddo ! s_loop

	 if (.not. shut3()) then
	    write (*,*) 'UNRECOVERABLE ERROR: could not do a shut3'
 	endif
	
	end
