#!/bin/csh -f

##Manually set directory names [**change**]
setenv SMK_HOME "/garnet/work/bte/WO105.1/tree"
setenv MET_ROOT "/orchid/oaqps/met/MCIP_v3.4b4/MM5_2005b_14aL"  #Change to your MCIP path

setenv CASE "2005ck_05b"
setenv RUN_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv SPINUP_DURATION "0"

## Derived directory and filenames
setenv OUT_ROOT "$SMK_HOME/smoke_out"
setenv IMD_ROOT "$SMK_HOME/intermed"
setenv DAT_ROOT $SMK_HOME
set dirinputs  = "$SMK_HOME/inputs"
set dirscripts = "$SMK_HOME/subsys26/smoke26/scripts"
setenv RUNSET "$dirscripts/cases/$CASE/run_settings_$CASE.txt"
setenv ASSIGNS_FILE "$SMK_HOME/subsys26/smoke26/assigns/ASSIGNS.emf"

## EMF Command line client -- source environment variables needed and setup EMF JAVACMDLINE to java executable and EMF_PYTHON to python cmd line
setenv EMF_CLIENT false

## Job run file for job: Annual_beis3_36US1

## EMF specific variables
setenv EMF_JOBID "7689"
setenv EMF_JOBNAME "Annual_beis3_36US1"
setenv EMF_USER "bte"
setenv EMF_SCRIPTDIR "${dirscripts}/cases/${CASE}"
setenv EMF_SCRIPTNAME "${dirscripts}/cases/${CASE}/Annual_beis3_36US1_${CASE}_20090330144225.csh"
setenv EMF_JOBKEY "7689_1238438546788"

## Inputs -- for all sectors and all jobs
setenv GRIDDESC "${dirinputs}/${CASE}/../ge_dat/griddesc_lambertonly_23jun2008_v13.txt"
setenv COSTCY "${dirinputs}/${CASE}/../ge_dat/costcy_for_2002_10mar2009_v4.txt"
setenv GSCNV "${dirinputs}/${CASE}/../ge_dat/gscnv_cmaq_cb05_tx_pf4_14nov2008_v2.txt"
setenv PELVCONFIG "${dirinputs}/${CASE}/../ge_dat/pelvconfig_inline_allpts_11apr2008_v0.txt"
setenv ORISDESC "${dirinputs}/${CASE}/../ge_dat/orisdesc_04dec2006_v0.txt"
setenv PSTK "${dirinputs}/${CASE}/../ge_dat/pstk_20nov2006_v0.txt"
## surrogate ratios USA 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/USA_100_NOFILL.txt
## surrogate ratios MEX 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/MEX_100.txt
## surrogate ratios CAN 36km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/36km_surg/CAN_100.txt
## surrogate ratios USA 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/USA_100_NOFILL.txt
## surrogate ratios MEX 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/MEX_100.txt
## surrogate ratios CAN 12km = /orchid/oaqps/2002/em_v31/inputs/ge_dat/12km_surg/CAN_100.txt
setenv AGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_mex_revised_12mar2009_v5.txt"
setenv ATREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_13mar2009_v1.txt"
setenv ATPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv PTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_13mar2009_v1.txt"
setenv PTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv MTREF "${dirinputs}/${CASE}/../ge_dat/amptref_v3_3_revised_24feb2009_v0.txt"
setenv REPCONFIG_INV "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv_caphap_08aug2008_v0.txt"
setenv SICDESC "${dirinputs}/${CASE}/../ge_dat/sic_desc_04oct2006_v0.txt"
setenv SCCDESC "${dirinputs}/${CASE}/../ge_dat/sccdesc_pf31_03feb2009_v5.txt"
setenv ARTOPNT "${dirinputs}/${CASE}/../ge_dat/artopnt_2002detroit_12jul2007_v0.txt"
setenv HOLIDAYS "${dirinputs}/${CASE}/../ge_dat/holidays_04may2006_v0.txt"
setenv MTPRO "${dirinputs}/${CASE}/../ge_dat/amptpro_2005_us_can_revised_10mar2009_v0.txt"
setenv MGREF "${dirinputs}/${CASE}/../ge_dat/amgref_us_can_mex_revised_18mar2009_v7.txt"
setenv MCODES "${dirinputs}/${CASE}/../ge_dat/mcodes_21nov2008_v1.txt"
setenv GSPRO_COMBO "${dirinputs}/${CASE}/../ge_dat/gspro_combo_2005_09sep2008_v2.txt"
setenv MACTDESC "${dirinputs}/${CASE}/../ge_dat/mactdesc_2002v3_23apr2008_v1.txt"
setenv NAICSDESC "${dirinputs}/${CASE}/../ge_dat/naicsdesc_02jan2008_v0.txt"
setenv REPCONFIG_INV2 "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_inv2_02jan2008_v0.txt"
setenv REPCONFIG_GRID "${dirinputs}/${CASE}/../ge_dat/repconfig/default/repconfig_area_invgrid_caphap_05sep2008_v1.txt"
setenv GSPROTMP_C  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_pm25_26jun2007_v0.txt"
setenv GSPROTMP_D  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_tog_cb05_soa_pf4_pretier2_08feb2009_v1.txt"
setenv GSPROTMP_B  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_sulf_29jun2007_v1.txt"
setenv GSPROTMP_A  "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_static_cmaq_19mar2009_v9.txt"
setenv GSREFTMP_B "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_sulf_09jul2007_v0.txt"
setenv GSREFTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_general_20mar2009_v19.txt"
setenv GSREFTMP_G "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_voc_2005_23feb2009_v2.txt"
setenv GSPROTMP_G "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nox_hono_pf4_06aug2008_v0.txt"
setenv SECTORLIST "${dirinputs}/${CASE}/mrggrid/sectorlist_${CASE}_30mar2009_nf_v3"
setenv SRGDESC "${dirinputs}/${CASE}/../ge_dat/srgdesc_36km_revised_17mar2009_v1.txt"
setenv GSPROTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_hg_26nov2007_v2.txt"
setenv GSREFTMP_A "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_cap_pf4_06aug2008_v0.txt"
setenv GSREFTMP_K "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_hg_21nov2008_v5.txt"
setenv GSPROTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_nonhaptog_cb05_tx_pf4_pretier2_14nov2008_v1.txt"
setenv GSPROTMP_F "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_integratehaps_cb05_tx_pf4_16mar2009_v1.txt"
setenv GSREFTMP_I "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_2005_11feb2009_v1.txt"
setenv GSREFTMP_H "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_nonhapvoc_general_update_12mar2009_v3.txt"
setenv GSREFTMP_C "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_nox_hono_pf4_26feb2009_v3.txt"
setenv MRGDATE_FILES "${dirinputs}/ge_dat/smk_dates/2005/smk_merge_dates_200412.txt"
setenv GSREFTMP_J "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_static_integratehap_emv4_10feb2009_v2.txt"
setenv INVTABLE "${dirinputs}/${CASE}/../ge_dat/invtable_hapcapintegate_cb05soa_nomp_09mar2009_v4.txt"
setenv GSREFTMP_E "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_pm25_pf4_nondiesel_20mar2009_v8.txt"
setenv GSREFTMP_D "${dirinputs}/${CASE}/../ge_dat/spec_parts/gsref_no_dieselpm_20mar2009_v1.txt"
setenv GSPROTMP_M "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_speciated_voc_30jan2009_v0.txt"

## Inputs -- sector (beis) and all jobs
setenv B3FAC "${dirinputs}/${CASE}/../ge_dat/beis3_efac_v3_14_16may2008_v0"
setenv GSPROTMP_O "${dirinputs}/${CASE}/../ge_dat/spec_parts/gspro_biogenics_19mar2009_v0.txt"

## Inputs -- for all sectors and job: Annual beis3 36US1

## Inputs -- sector (beis) and job: Annual beis3 36US1
setenv BGPRO "${dirinputs}/ge_dat/bgpro.36km.txt"
setenv BELD3_TOT "${dirinputs}/${CASE}/beis/LAND_TOTALS_US36_148X112"
setenv BELD3_B "${dirinputs}/${CASE}/beis/LANDB_US36_148X112"
setenv BELD3_A "${dirinputs}/${CASE}/beis/LANDA_US36_148X112"
setenv BIOSEASON "${dirinputs}/${CASE}/beis/bioseason.cmaq.2005b_36km.ncf"

## Parameters -- from Case summary 
setenv MODEL_LABEL "SMOKE2.6"
setenv IOAPI_GRIDNAME_1 "US36KM_148X112"
setenv EMF_GRID "36km, 12km-EUS"
setenv EMF_AQM "CMAQ v4.7 N1c"
setenv EMF_SPC "cmaq_cb05_soa"
setenv BASE_YEAR "2005"
setenv FUTURE_YEAR "2005"
setenv EPI_STDATE_TIME "2005-01-01 00:00:00.0"
setenv EPI_ENDATE_TIME "2005-12-31 23:59:00.0"
setenv PARENT_CASE "2005cm_05b"

## Parameters -- from job tab
setenv SECTOR "beis"

## Parameters -- all sectors, all jobs 
setenv SRGPRO_PATH "${dirinputs}/ge_dat/36US1_surg_revised/"
setenv EMF_QUEUE_OPTIONS "-A fedrules -q workq -W group_list=romo -W umask=022"
setenv SPINUP_DURATION_1 "10"
setenv IOAPI_GRIDNAME_1 "36US1_148X112"
setenv SPINUP_DURATION_3 "3"
setenv SPINUP_DURATION_2 "3"
setenv IOAPI_GRIDNAME_2 "12EUS1_279X240"
setenv IOAPI_GRIDNAME_3 "12WUS1_213X192"
setenv GRID_3 "12WUS1"
setenv GRID_2 "12EUS1"
setenv GRID_1 "36US1"
setenv SMK_EMLAYS "10"
setenv SPC "$EMF_SPC"
setenv PLATFORM "v4"
setenv EGU_TYPE "model_performance"
setenv MCIPNAME "MCIP_v3.4beta4"
setenv RUN_PYTHON_ANNUAL "Y"
setenv INLINE_MODE "both"
setenv SMK_PING_METHOD "0"
setenv SMK_SPECELEV_YN "Y"
setenv RAW_DUP_CHECK "Y"
setenv M_TYPE "mwdss"
setenv L_TYPE "mwdss"
setenv RUN_HOLIDAYS "Y"
setenv FULLSCC_ONLY "Y"
setenv SMK_MAXERROR "10000"
setenv SMK_MAXWARNING "10"
setenv SMK_AVEDAY_YN "N"
setenv REPORT_DEFAULTS "Y"
setenv SMK_DEFAULT_SRGID "100"
setenv SMKINVEN_FORMULA "PMC=PM10-PM2_5"
setenv FILL_ANNUAL "N"
setenv MRG_MARKETPEN_YN "N"
setenv WEST_HSPHERE "Y"
setenv ALL_MONTHS "1 2 3 4 5 6 7 8 9 10 11 12"
setenv MRG_REPCNY_YN "N"
setenv EMF_LOGGERPYTHONDIR "$EMF_SCRIPTDIR/case_logs_python"
setenv OUTZONE "0"
setenv RENORM_TPROF "Y"
setenv POLLUTANT_CONVERSION "Y"
setenv IOAPI_ISPH "19"
setenv MRG_REPSTA_YN "Y"
setenv SMKMERGE_CUSTOM_OUTPUT "Y"
setenv OUTPUT_FORMAT "$EMF_AQM"

## Parameters -- sectors (beis), all jobs 
setenv BEIS3_VERSION "3.14"
setenv BIOG_SPRO "B10C5"
setenv AREA_SURROGATE_NUM "340"
setenv L_TYPE "all"
setenv M_TYPE "all"
setenv BIO_COUNTY_SUMS "Y"
setenv BIO_STATE_SUMS "Y"
setenv RAD_VAR "RGRND"
setenv TMPR_VAR "TEMP2"
setenv PRES_VAR "PRSFC"
setenv PX_VERSION "Y"
setenv SOILT_VAR "SOIT1"
setenv ISLTYP_VAR "SLTYP"
setenv SOIM1_VAR "SOIM1"
setenv RC_VAR "RC"

## Parameters -- all sectors, job: Annual beis3 36US1

## Parameters -- sectors (beis), job: Annual beis3 36US1

## job executable
$EMF_CLIENT -k $EMF_JOBKEY -x $SMK_HOME/subsys26/smoke26/scripts/emf/smk_beis_emf.csh -m "Running top level script for job: Annual_beis3_36US1"
$SMK_HOME/subsys26/smoke26/scripts/emf/smk_beis_emf.csh $GRID_1 $IOAPI_GRIDNAME_1  -m "$RUN_MONTHS" $SPINUP_DURATION jan-dec
if ( $status != 0 ) then
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Failed' -m "ERROR running Job: $EMF_JOBNAME" -t 'e' 
	 exit(1)
else
	 $EMF_CLIENT -k $EMF_JOBKEY -s 'Completed' -m "Completed job: $EMF_JOBNAME"
endif

