      BLOCK DATA BD01 
C 
C  BLOCK DATA Subprogram 01: /SPEED1/ 
C 
C  BLOCK DATA 01 defines and initializes the speed correction factor (scf) 
C  coefficients for vehicle types LDGV, LDGT, and MC. 
C 
C  Changes : 
C 
C 
C  Common block array subscripts: 
C 
C  SK1(6,18,3)     -  SK1  ( ICOEF5, ISP, IP ) 
C  SH(6,18)        -  SH ( ICOEF5, ISP ) 
C  SC(6,18)        -  SC ( ICOEF5, ISP ) 
C  SN(6,18)        -  SN ( ICOEF5, ISP ) 
C  SK2C(2,14,3,5)  -  SK2C ( IS2C, ISP, IPG, IVLDG ) 
C  SK4C(2,14,3,5)  -  SK4C ( IS2N, ISP, IPG, IVLDG ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  ----------------------------------------------- 
C  /SPEED1/: 
C 
C  SK1      R    scf coefficients for HC, CO & NOx for LDGV, LDGT, & MC 
C                SH/C/N - the 3 arrays in this BD appear as SK1 in BIGIN1 
C                SK1 is partitioned in BD 01 so that the local arrays can be 
C                EQUIVALENCEd to its storage area.  FORTRAN does not allow a 
C                local array to be EQU'd to beyond the first cell of a COMMON 
C                array dimension (SK1(1,10,1),SH2(1,1) is illegal), unless 
C                the dimension is rightmost (SK1(1,1,2),SC2(1,1) is legal). 
C  SH       R    HC scf coefficients for IV=1,2,3,4,5,24 
C  SC       R    CO scf coefficients for IV=1,2,3,4,5,24 
C  SN       R    NOX scf coefficients for IV=1,2,3,4,5,24 
C  SK2C     R    low spd <19.6 scf coeffs for the 1st new eq case (A/X+B) 
C  SK4C     R    HC & CO Mid speeds scf coef for A/Speed + B equation 
C 
C  Local array subscripts: 
C 
C  SH1(6,9)  -  SH1( ICOEF5, ISP ) 
C  SH2(6,9)  -  SH2( ICOEF5, ISP ) 
C  SC1(6,9)  -  SC1( ICOEF5, ISP ) 
C  SC2(6,9)  -  SC2( ICOEF5, ISP ) 
C  SN1(6,9)  -  SN1( ICOEF5, ISP ) 
C  SN2(6,9)  -  SN2( ICOEF5, ISP ) 
C  SK2CV(2,14,3)   -  SK2CV   ( IS2C, ISP, IPG ) 
C  SK2CT1A(2,14,3) -  SK2CT1A ( IS2C, ISP, IPG ) 
C  SK2CT1B(2,14,3) -  SK2CT1B ( IS2C, ISP, IPG ) 
C  SK2CT2A(2,14,3) -  SK2CT2A ( IS2C, ISP, IPG ) 
C  SK2CT2B(2,14,3) -  SK2CT2B ( IS2C, ISP, IPG ) 
C  SK4CV(2,14,3)   -  SK4CV   ( IS2C, ISP, IPG ) 
C  SK4CT1A(2,14,3) -  SK4CT1A ( IS2C, ISP, IPG ) 
C  SK4CT1B(2,14,3) -  SK4CT1B ( IS2C, ISP, IPG ) 
C  SK4CT2A(2,14,3) -  SK4CT2A ( IS2C, ISP, IPG ) 
C  SK4CT2B(2,14,3) -  SK4CT2B ( IS2C, ISP, IPG ) 
C 
C  Local array dictionary: 
C 
C   Name   Type             Description 
C  ------  ----  -------------------------------------------- 
C  SH1      R    5th degree poly. coef. for SK1 HC  IG=1 thru 9 
C  SH2      R    5th degree poly. coef. for SK1 HC  IG=10 thru 18 
C  SC1      R    5th degree poly. coef. for SK1 CO  IG=1 thru 9 
C  SC2      R    5th degree poly. coef. for SK1 CO  IG=10 thru 18 
C  SN1      R    5th degree poly. coef. for SK1 NOx IG=1 thru 9 
C  SN2      R    5th degree poly. coef. for SK1 NOx IG=10 thru 18 
C  SK2C     R    Low Speed A/X+B coef. for HC & CO 
C  SK2CV    R    Low Speed A/X+B coef. for LDGV HC & CO 
C  SK2CT1A  R    Low Speed A/X+B coef. for LDGT1 HC & CO 
C  SK2CT1B  R    Low Speed A/X+B coef. for LDGT2 HC & CO 
C  SK2CT2A  R    Low Speed A/X+B coef. for LDGT3 HC & CO 
C  SK2CT2B  R    Low Speed A/X+B coef. for LDGT4 HC & CO 
C  SK4C     R    Mid Speed (A/X+B) coef. for HC & CO 
C  SK4CV    R    Mid Speed (A/X+B) coef. for HC & CO LDGV 
C  SK4CT1A  R    Mid Speed (A/X+B) coef. for HC & CO LDGT1 
C  SK4CT1B  R    Mid Speed (A/X+B) coef. for HC & CO LDGT2 
C  SK4CT2A  R    Mid Speed (A/X+B) coef. for HC & CO LDGT3 
C  SK4CT2B  R    Mid Speed (A/X+B) coef. for HC & CO LDGT4 
C 
C  Notes: 
C 
C   7 Nov 96 DynTel@MLA 2-622  Changed the last dimensions of SK2C and SK4C 
C            from 3 to 5 to accomodate new vehicle types LDGT1A and LDGT1B 
C            in place of LDGT1, and LDGT2A and LDGT2B in place of LDGT2. 
C  23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C            certification naming conventions. 
C 
      IMPLICIT NONE 
      INCLUDE 'SPEED1.I' 
C 
      REAL SH1(6,9),SH2(6,9),SC1(6,9),SC2(6,9),SN1(6,9),SN2(6,9) 
      REAL SK2CV(2,14,3),SK2CT1A(2,14,3),SK2CT1B(2,14,3) 
      REAL SK2CT2A(2,14,3),SK2CT2B(2,14,3) 
      REAL SK4CV(2,14,3),SK4CT1A(2,14,3),SK4CT1B(2,14,3) 
      REAL SK4CT2A(2,14,3),SK4CT2B(2,14,3) 
C 
      EQUIVALENCE 
     *  (SK1(1,1,1),SH1(1,1)),  (SK1(1,10,1),SH2(1,1)), 
     *  (SK1(1,1,2),SC1(1,1)),  (SK1(1,10,2),SC2(1,1)), 
     *  (SK1(1,1,3),SN1(1,1)),  (SK1(1,10,3),SN2(1,1)), 
     *  (SK2C(1,1,1,1),SK2CV(1,1,1)), 
     *  (SK2C(1,1,1,2),SK2CT1A(1,1,1)), 
     *  (SK2C(1,1,1,3),SK2CT1B(1,1,1)), 
     *  (SK2C(1,1,1,4),SK2CT2A(1,1,1)), 
     *  (SK2C(1,1,1,5),SK2CT2B(1,1,1)), 
     *  (SK4C(1,1,1,1),SK4CV(1,1,1)), 
     *  (SK4C(1,1,1,2),SK4CT1A(1,1,1)), 
     *  (SK4C(1,1,1,3),SK4CT1B(1,1,1)), 
     *  (SK4C(1,1,1,4),SK4CT2A(1,1,1)), 
     *  (SK4C(1,1,1,5),SK4CT2B(1,1,1)) 
C 
C  5th degree polynomial HC scf coefficients 
C 
      DATA SH1/ 
     *    2.24612E+00,  -2.90973E-01,   1.58890E-02, 
     *                  -4.72494E-04,   6.94077E-06,  -3.92798E-08, 
     *    2.31026E+00,  -2.89572E-01,   1.52990E-02, 
     *                  -4.46689E-04,   6.48183E-06,  -3.63456E-08, 
     *    2.16556E+00,  -2.69992E-01,   1.44221E-02, 
     *                  -4.33638E-04,   6.50735E-06,  -3.78100E-08, 
     *    2.39726E+00,  -2.99985E-01,   1.61351E-02, 
     *                  -4.87491E-04,   7.29093E-06,  -4.19769E-08, 
     *    2.40873E+00,  -3.08187E-01,   1.68168E-02, 
     *                  -5.06843E-04,   7.53855E-06,  -4.31596E-08, 
     *    2.23217E+00,  -2.84985E-01,   1.53833E-02, 
     *                  -4.56738E-04,   6.73486E-06,  -3.83798E-08, 
     *    2.25223E+00,  -2.87778E-01,   1.56820E-02, 
     *                  -4.73179E-04,   7.07954E-06,  -4.08456E-08, 
     *    2.02779E+00,  -2.73049E-01,   1.53577E-02, 
     *                  -4.60304E-04,   6.78527E-06,  -3.84880E-08, 
     *    2.15056E+00,  -2.83620E-01,   1.53836E-02, 
     *                  -4.42136E-04,   6.28732E-06,  -3.46311E-08/ 
      DATA SH2/ 
     *    2.23021E+00,  -2.93648E-01,   1.62356E-02, 
     *                  -4.84148E-04,   7.11591E-06,  -4.02861E-08, 
     *    2.12230E+00,  -2.91072E-01,   1.69089E-02, 
     *                  -5.26148E-04,   8.02705E-06,  -4.70117E-08, 
     *    2.15361E+00,  -2.83451E-01,   1.56948E-02, 
     *                  -4.69759E-04,   6.93832E-06,  -3.94707E-08, 
     *    2.07346E+00,  -2.89353E-01,   1.73042E-02, 
     *                  -5.54707E-04,   8.64204E-06,  -5.13107E-08, 
     *    2.34948E+00,  -3.04959E-01,   1.68416E-02, 
     *                  -5.09623E-04,   7.59516E-06,  -4.34963E-08, 
     *    2.11340E+00,  -2.85676E-01,   1.63180E-02, 
     *                  -5.00793E-04,   7.55067E-06,  -4.37187E-08, 
     *    2.11940E+00,  -2.98632E-01,   1.84473E-02, 
     *                  -6.16544E-04,   9.92062E-06,  -6.04021E-08, 
     *    2.68382E+00,  -3.44633E-01,   1.95417E-02, 
     *                  -6.25720E-04,   9.78442E-06,  -5.83369E-08, 
     *    2.39540E+00,  -3.35781E-01,   2.11609E-02, 
     *                  -7.31550E-04,   1.20715E-05,  -7.48567E-08/ 
C 
C  5th degree polynomial CO scf coefficients 
C 
      DATA SC1/ 
     *    1.81978E+00,  -2.54663E-01,   1.52347E-02, 
     *                  -4.87397E-04,   7.58207E-06,  -4.49514E-08, 
     *    2.33989E+00,  -2.96978E-01,   1.60071E-02, 
     *                  -4.77396E-04,   7.06752E-06,  -4.03978E-08, 
     *    2.44154E+00,  -2.91473E-01,   1.42949E-02, 
     *                  -3.87852E-04,   5.29781E-06,  -2.82441E-08, 
     *    2.46551E+00,  -3.05023E-01,   1.60497E-02, 
     *                  -4.73969E-04,   6.99075E-06,  -3.99758E-08, 
     *    2.77804E+00,  -3.19130E-01,   1.53183E-02, 
     *                  -4.22327E-04,   5.84948E-06,  -3.14969E-08, 
     *    2.78899E+00,  -3.27107E-01,   1.62943E-02, 
     *                  -4.67573E-04,   6.71906E-06,  -3.74401E-08, 
     *    2.70743E+00,  -3.31038E-01,   1.76179E-02, 
     *                  -5.38583E-04,   8.17402E-06,  -4.77803E-08, 
     *    1.86919E+00,  -2.76679E-01,   1.72335E-02, 
     *                  -5.58279E-04,   8.71678E-06,  -5.16980E-08, 
     *    1.82133E+00,  -2.72054E-01,   1.70304E-02, 
     *                  -5.52021E-04,   8.62543E-06,  -5.11440E-08/ 
      DATA SC2/ 
     *    2.01421E+00,  -2.95188E-01,   1.86353E-02, 
     *                  -6.21606E-04,   9.93657E-06,  -5.99779E-08, 
     *    2.04533E+00,  -3.10618E-01,   2.04852E-02, 
     *                  -7.08527E-04,   1.16215E-05,  -7.15690E-08, 
     *    2.31868E+00,  -3.41147E-01,   2.09446E-02, 
     *                  -6.65891E-04,   1.02225E-05,  -5.98265E-08, 
     *    2.57522E+00,  -3.28888E-01,   1.89747E-02, 
     *                  -6.28263E-04,   1.00924E-05,  -6.12727E-08, 
     *    2.68454E+00,  -3.32817E-01,   1.76277E-02, 
     *                  -5.24123E-04,   7.72221E-06,  -4.37025E-08, 
     *    2.15487E+00,  -3.29116E-01,   2.10112E-02, 
     *                  -6.89057E-04,   1.08390E-05,  -6.47125E-08, 
     *    2.54557E+00,  -3.62954E-01,   2.32775E-02, 
     *                  -8.15039E-04,   1.36231E-05,  -8.55909E-08, 
     *    2.83929E+00,  -3.68756E-01,   2.10782E-02, 
     *                  -6.76438E-04,   1.06267E-05,  -6.36405E-08, 
     *    2.48747E+00,  -3.91562E-01,   2.70721E-02, 
     *                  -9.76178E-04,   1.65270E-05,  -1.04317E-07/ 
C 
C  5th degree polynomial NOX scf coefficients 
C 
      DATA SN1/ 
     *    2.44424E+00,  -2.50107E-01,   1.38293E-02, 
     *                  -2.87025E-04,   2.07585E-06,   0.00000E+00, 
     *    1.68635E+00,  -1.18303E-01,   6.54975E-03, 
     *                  -1.37139E-04,   1.00849E-06,   0.00000E+00, 
     *    1.12646E+00,  -3.93405E-02,   2.68637E-03, 
     *                  -6.08024E-05,   4.77286E-07,   0.00000E+00, 
     *    1.22677E+00,  -4.44978E-02,   2.62476E-03, 
     *                  -5.67150E-05,   4.34293E-07,   0.00000E+00, 
     *    1.01743E+00,  -1.18958E-02,   9.14365E-04, 
     *                  -2.15740E-05,   1.82300E-07,   0.00000E+00, 
     *    9.87600E-01,  -1.95674E-02,   1.69645E-03, 
     *                  -4.04000E-05,   3.28001E-07,   0.00000E+00, 
     *    1.15917E+00,  -4.44536E-02,   2.96425E-03, 
     *                  -6.68990E-05,   5.22365E-07,   0.00000E+00, 
     *    1.88656E+00,  -1.61289E-01,   9.04995E-03, 
     *                  -1.85609E-04,   1.32555E-06,   0.00000E+00, 
     *    1.55777E+00,  -1.13032E-01,   6.71832E-03, 
     *                  -1.43409E-04,   1.06079E-06,   0.00000E+00/ 
      DATA SN2/ 
     *    2.04516E+00,  -1.94014E-01,   1.10736E-02, 
     *                  -2.31754E-04,   1.68372E-06,   0.00000E+00, 
     *    1.63262E+00,  -1.21861E-01,   7.03020E-03, 
     *                  -1.46293E-04,   1.06141E-06,   0.00000E+00, 
     *    1.44825E+00,  -1.22444E-01,   7.95024E-03, 
     *                  -1.71078E-04,   1.25777E-06,   0.00000E+00, 
     *    2.45969E-01,   8.41954E-02,  -3.40841E-03, 
     *                   6.29880E-05,  -4.13975E-07,   0.00000E+00, 
     *    1.28169E+00,  -8.04874E-02,   5.35735E-03, 
     *                  -1.18891E-04,   9.01060E-07,   0.00000E+00, 
     *    1.53447E+00,  -1.25671E-01,   7.85919E-03, 
     *                  -1.69428E-04,   1.25494E-06,   0.00000E+00, 
     *    7.04805E-01,   3.81527E-02,  -1.73907E-03, 
     *                   3.26140E-05,  -2.03847E-07,   0.00000E+00, 
     *    7.83838E-01,   3.28549E-04,   1.06029E-03, 
     *                  -3.19350E-05,   2.90389E-07,   0.00000E+00, 
     *    9.42131E-01,  -4.23240E-02,   3.86253E-03, 
     *                  -9.39853E-05,   7.53883E-07,   0.00000E+00/ 
C 
C  Low Speed ( LT 19.6 ) CF for HC,CO,NOX - SCF equation form A /X + B 
C 
C          A        B          A        B          A        B 
      DATA SK2CV/ 
C  HC  IV = 1 LDGV 
     H  19.60000, 0.00000,  13.98408, 0.28648,  13.98408, 0.28648, 
     H  14.30260, 0.27027,  14.29548, 0.27057,  14.90497, 0.23954, 
     H  15.38309, 0.21515,  14.96745, 0.23636,  11.53038, 0.41161, 
     H  11.08753, 0.43431,  10.72124, 0.45300,  10.01464, 0.48907, 
     H   9.89869, 0.49498,   9.89869, 0.49498, 
C  CO 
     C  21.28050,-0.08574,  15.17920, 0.22551,  15.17920, 0.22551, 
     C  18.64882, 0.04853,  17.80678, 0.09143,  17.54159, 0.10502, 
     C  17.70625, 0.09662,  15.58220, 0.20499,  10.15800, 0.48162, 
     C   9.23252, 0.52895,   9.51016, 0.51478,   9.45370, 0.51768, 
     C   9.48514, 0.51607,   9.48514, 0.51607, 
C  NOx (1979=0.0 Not Used) 
     N   0.00000, 0.00000,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600/ 
C 
      DATA SK2CT1A/ 
C  HC  IV = 2 LDGT1 
     H  19.60000, 0.00000,  14.79943, 0.21458,  14.79943, 0.21458, 
     H  15.19938, 0.22452,  12.72329, 0.32482,  13.24083, 0.32444, 
     H  13.27086, 0.32291,  13.93844, 0.28885,  11.69134, 0.40351, 
     H  11.22095, 0.41764,  10.82497, 0.44772,  10.59274, 0.45852, 
     H  10.72619, 0.45276,  10.72619, 0.45276, 
C  CO 
     C  22.26410,-0.13593,  21.33377,-0.11880,  21.33377,-0.11880, 
     C  21.73530,-0.10894,  20.61025,-0.07756,  20.21742,-0.03150, 
     C  18.63834, 0.04907,  18.00197, 0.08154,  12.42999, 0.36582, 
     C   9.02787, 0.52952,   8.78893, 0.55159,   8.74776, 0.55264, 
     C   8.67966, 0.55716,   8.67966, 0.55716, 
C  NOx (1979=0.0 Not Used 
     N   0.00000, 0.00000,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600/ 
C 
      DATA SK2CT1B/ 
C  HC  IV = 3 LDGT2 
     H  19.60000, 0.00000,  14.79943, 0.21458,  14.79943, 0.21458, 
     H  15.19938, 0.22452,  12.72329, 0.32482,  13.24083, 0.32444, 
     H  13.27086, 0.32291,  13.93844, 0.28885,  11.69134, 0.40351, 
     H  11.22095, 0.41764,  10.82497, 0.44772,  10.59274, 0.45852, 
     H  10.72619, 0.45276,  10.72619, 0.45276, 
C  CO 
     C  22.26410,-0.13593,  21.33377,-0.11880,  21.33377,-0.11880, 
     C  21.73530,-0.10894,  20.61025,-0.07756,  20.21742,-0.03150, 
     C  18.63834, 0.04907,  18.00197, 0.08154,  12.42999, 0.36582, 
     C   9.02787, 0.52952,   8.78893, 0.55159,   8.74776, 0.55264, 
     C   8.67966, 0.55716,   8.67966, 0.55716, 
C  NOx (1979=0.0 Not Used 
     N   0.00000, 0.00000,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600/ 
C 
      DATA SK2CT2A/ 
C  HC  IV = 4 LDGT3 
     H  19.60000, 0.00000,  14.79943, 0.21458,  14.79943, 0.21458, 
     H  15.19938, 0.22452,  12.72329, 0.32482,  13.24083, 0.32444, 
     H  13.27086, 0.32291,  13.93844, 0.28885,  11.69134, 0.40351, 
     H  11.22095, 0.41764,  10.82497, 0.44772,  10.59274, 0.45852, 
     H  10.72619, 0.45276,  10.72619, 0.45276, 
C  CO 
     C  22.26410,-0.13593,  21.33377,-0.11880,  21.33377,-0.11880, 
     C  21.73530,-0.10894,  20.61025,-0.07756,  20.21742,-0.03150, 
     C  18.63834, 0.04907,  18.00197, 0.08154,  12.42999, 0.36582, 
     C   9.02787, 0.52952,   8.78893, 0.55159,   8.74776, 0.55264, 
     C   8.67966, 0.55716,   8.67966, 0.55716, 
C  NOx (1979=0.0 Not Used) 
     N   0.00000, 0.00000,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600/ 
C 
      DATA SK2CT2B/ 
C  HC  IV = 5 LDGT4 
     H  19.60000, 0.00000,  14.79943, 0.21458,  14.79943, 0.21458, 
     H  15.19938, 0.22452,  12.72329, 0.32482,  13.24083, 0.32444, 
     H  13.27086, 0.32291,  13.93844, 0.28885,  11.69134, 0.40351, 
     H  11.22095, 0.41764,  10.82497, 0.44772,  10.59274, 0.45852, 
     H  10.72619, 0.45276,  10.72619, 0.45276, 
C  CO 
     C  22.26410,-0.13593,  21.33377,-0.11880,  21.33377,-0.11880, 
     C  21.73530,-0.10894,  20.61025,-0.07756,  20.21742,-0.03150, 
     C  18.63834, 0.04907,  18.00197, 0.08154,  12.42999, 0.36582, 
     C   9.02787, 0.52952,   8.78893, 0.55159,   8.74776, 0.55264, 
     C   8.67966, 0.55716,   8.67966, 0.55716, 
C  NOx (1979=0.0 Not Used) 
     N   0.00000, 0.00000,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600,   1.45600, 0.92600, 
     N   1.45600, 0.92600,   1.45600, 0.92600/ 
C 
C  Mid Speed ( GT 19.6 & LT 48.0 ) for HC,CO,NOx - SCF equation form A/X+B 
C 
      DATA SK4CV/ 
C     SK4CV was modified for MOBILE5 Aug 92 
C  HC IV = 1 LDGV 
C       -  1979  -        - 1980 -         - 1981 - 
C         A      B         A      B         A      B 
     H  19.60,  0.00,    22.66, -0.15,    15.82,  0.19, 
     H  14.99,  0.23,    14.44,  0.26,    15.15,  0.23, 
     H  14.39,  0.27,    14.69,  0.24,    15.52,  0.21, 
     H  16.46,  0.16,    17.42,  0.11,    18.40,  0.06, 
     H  18.70,  0.04,    18.70,  0.04, 
C  CO 
     C  19.60,  0.00,    23.13, -0.18,    13.54,  0.31, 
     C  13.10,  0.34,     9.08,  0.54,     9.79,  0.50, 
     C   9.55,  0.51,    11.47,  0.41,    16.98,  0.13, 
     C  20.65, -0.05,    21.12, -0.08,    22.56, -0.15, 
     C  23.25, -0.19,    23.25, -0.19, 
C  NOx 
     N   0.00,  0.00,     5.50,  0.71,    -4.20,  1.21, 
     N  -3.99,  1.20,    -5.25,  1.27,    -4.10,  1.21, 
     N  -3.84,  1.20,    -3.32,  1.17,    -2.31,  1.12, 
     N  -1.35,  1.07,    -2.04,  1.10,    -2.49,  1.13, 
     N  -2.70,  1.14,    -2.70,  1.14/ 
C 
      DATA SK4CT1A/ 
C         - 1979 - was modifed Oct 5, 1992 
C  HC IV = 2 LDGT1 
C         A        B          A        B          A        B 
     H  19.60000, 0.00000,  13.48,    0.31,     13.48,    0.31, 
     H  13.49   , 0.31   ,  13.45,    0.31,     13.39,    0.32, 
     H  13.95   , 0.29   ,  14.32,    0.27,     15.44,    0.21, 
     H  15.94   , 0.19   ,  16.67,    0.15,     17.07,    0.13, 
     H  16.95   , 0.13   ,  16.95,    0.13, 
C  CO 
     C  19.60000, 0.00000,   9.47,    0.52,      9.47,    0.52, 
     C   9.61   , 0.51   ,   9.22,    0.53,      8.77,    0.56, 
     C   9.99   , 0.49   ,  10.80,    0.45,     16.43,    0.16, 
     C  19.84   ,-0.01   ,  19.85,   -0.01,     21.07,   -0.07, 
     C  21.71   ,-0.11   ,  21.71,   -0.11, 
C  NOx 
     N   0.00000, 0.00000, -7.55,     1.39,     -7.55,    1.39, 
     N   -7.40  , 1.38   , -7.31,     1.37,     -7.10,    1.36, 
     N   -6.31  , 1.32   , -5.14,     1.26,     -2.40,    1.12, 
     N   -0.45  , 1.02   , -0.33,     1.02,     -0.46,    1.02, 
     N   -0.48  , 1.02   , -0.48,     1.02/ 
C 
      DATA SK4CT1B/ 
C         - 1979 - was modifed Oct 5, 1992 
C  HC IV = 3 LDGT2 
C         A        B          A        B          A        B 
     H  19.60000, 0.00000,  13.48,    0.31,     13.48,    0.31, 
     H  13.49   , 0.31   ,  13.45,    0.31,     13.39,    0.32, 
     H  13.95   , 0.29   ,  14.32,    0.27,     15.44,    0.21, 
     H  15.94   , 0.19   ,  16.67,    0.15,     17.07,    0.13, 
     H  16.95   , 0.13   ,  16.95,    0.13, 
C  CO 
     C  19.60000, 0.00000,   9.47,    0.52,      9.47,    0.52, 
     C   9.61   , 0.51   ,   9.22,    0.53,      8.77,    0.56, 
     C   9.99   , 0.49   ,  10.80,    0.45,     16.43,    0.16, 
     C  19.84   ,-0.01   ,  19.85,   -0.01,     21.07,   -0.07, 
     C  21.71   ,-0.11   ,  21.71,   -0.11, 
C  NOx 
     N   0.00000, 0.00000, -7.55,     1.39,     -7.55,    1.39, 
     N   -7.40  , 1.38   , -7.31,     1.37,     -7.10,    1.36, 
     N   -6.31  , 1.32   , -5.14,     1.26,     -2.40,    1.12, 
     N   -0.45  , 1.02   , -0.33,     1.02,     -0.46,    1.02, 
     N   -0.48  , 1.02   , -0.48,     1.02/ 
C 
C 
C 
      DATA SK4CT2A/ 
C         - 1979 - was modifed Oct 5, 1992 
C  HC IV = 4 LDGT3 
C         A        B          A        B          A        B 
     H  19.60000, 0.00000,  13.48,    0.31,     13.48,    0.31, 
     H  13.49   , 0.31   ,  13.45,    0.31,     13.39,    0.32, 
     H  13.95   , 0.29   ,  14.32,    0.27,     15.44,    0.21, 
     H  15.94   , 0.19   ,  16.67,    0.15,     17.07,    0.13, 
     H  16.95   , 0.13   ,  16.95,    0.13, 
C  CO 
     C  19.60000, 0.00000,   9.47,    0.52,      9.47,    0.52, 
     C   9.61   , 0.51   ,   9.22,    0.53,      8.77,    0.56, 
     C   9.99   , 0.49   ,  10.80,    0.45,     16.43,    0.16, 
     C  19.84   ,-0.01   ,  19.85,   -0.01,     21.07,   -0.07, 
     C  21.71   ,-0.11   ,  21.71,   -0.11, 
C  NOx 
     N   0.00000, 0.00000, -7.55,     1.39,     -7.55,    1.39, 
     N   -7.40  , 1.38   , -7.31,     1.37,     -7.10,    1.36, 
     N   -6.31  , 1.32   , -5.14,     1.26,     -2.40,    1.12, 
     N   -0.45  , 1.02   , -0.33,     1.02,     -0.46,    1.02, 
     N   -0.48  , 1.02   , -0.48,     1.02/ 
C 
      DATA SK4CT2B/ 
C         - 1979 - was modifed Oct 5, 1992 
C  HC IV = 5 LDGT4 
C         A        B          A        B          A        B 
     H  19.60000, 0.00000,  13.48,    0.31,     13.48,    0.31, 
     H  13.49   , 0.31   ,  13.45,    0.31,     13.39,    0.32, 
     H  13.95   , 0.29   ,  14.32,    0.27,     15.44,    0.21, 
     H  15.94   , 0.19   ,  16.67,    0.15,     17.07,    0.13, 
     H  16.95   , 0.13   ,  16.95,    0.13, 
C  CO 
     C  19.60000, 0.00000,   9.47,    0.52,      9.47,    0.52, 
     C   9.61   , 0.51   ,   9.22,    0.53,      8.77,    0.56, 
     C   9.99   , 0.49   ,  10.80,    0.45,     16.43,    0.16, 
     C  19.84   ,-0.01   ,  19.85,   -0.01,     21.07,   -0.07, 
     C  21.71   ,-0.11   ,  21.71,   -0.11, 
C  NOx 
     N   0.00000, 0.00000, -7.55,     1.39,     -7.55,    1.39, 
     N   -7.40  , 1.38   , -7.31,     1.37,     -7.10,    1.36, 
     N   -6.31  , 1.32   , -5.14,     1.26,     -2.40,    1.12, 
     N   -0.45  , 1.02   , -0.33,     1.02,     -0.46,    1.02, 
     N   -0.48  , 1.02   , -0.48,     1.02/ 
C 
      END 
