      BLOCK DATA BD03 
C 
C  BLOCK DATA Subprogram 03: /BASEQ2/,/BASEQ4/,/BASEQ6/ 
C 
C  BLOCK DATA 03 defines the model year groups (by their upper bounds) and 
C  associated parameters used to select and index the intercept and slope 
C  arrays for the basic FTP Emission Rate (ER) equations. 
C 
C  Changes: (Last change first) 
C 
C  23 Mar 01 @EPA-bag BUG 320 2007 rule for heavy duty GAS vehicles; added zero mile 
C            emission rates and emission line slopes 
C  18 Jan 01 @EPA-bag 2007 rule for heavy duty vehicles; added zero mile 
C            emission rates and emission line slopes 
C 13 Jul 00 @EPA-ddj Bug191 Added 1993 to IERHI28 (LDDT34) and IERHI28 
C           (LDDT12) to accommodate null altitude effect for post-1993 
C           LDDT emissions. 
C  10 May 00 @EPA-MB  Changed low(IERLOW27) and high(IERHI27) altitude HDDBS years 
C                     for HC to accommodate standard for 2004+ 
C  24 Apr 00 @EPA-djb Altered LDDT12 & LDDT34 high altitude model year ranges. 
C  17 Apr 00 @EPA-djb Removed dead code. 
C   2 Feb 00 @DynTel-ddj 1-032  Changed LDDT to LDDT12 and created 
C            LDDT34 by copying LDDT12 data to place holder for 
C            vehicle type 28. 
C  27 Oct. 99 @Dyntel-HXQ 2-680 Added more model years for gas bus. 
C  21 July 99 @Dyntel-JWR 2-705 Increased range of IFAC to 7920 
C                (= 33*3*16*2  + 33*3*12*2*2) to allow all possible 
C               user inputs in one single run. 
C  15 July 99 @Dyntel-JWR 2-705 Increased range of IFAC to allow 250 input records/run. 
C            Arrays thus increased are NEWPAR, BERNEW, NEWFIT, and NEWOML as well as MAXCT.  
C            Also increased MAXERU to 33 to allow more user input BERs 
C            per vehicle class, region, pollutant, running/start. 
C            MYGERU also has more initialised values (now 22176). 
C  15 Jun 99 @DynTel-HXQ Fixing the model years for HDGV8B 
C  22 Oct. 98 @DynTel-HXQ 2-680 to incorporate more recent model years. 
C  11 Aug 98 @DynTel-MLA 2-000  Changed HDG and HDD names to conform to 
C            new naming conventions. 
C  5 Nov 96 DynTel@MLA 2-622  7 new HDG vehicle types, 7 new HDD types, and 
C           2 new LDGT types were added (LDGT1A and LDGT1B replace LDGT1, 
C           and LDGT2A and LDGT2B replace LDGT2). Changed the third dimension 
C           of MYGERB and the fourth dimension of MYGERU from 8 to 24 and 
C           renamed the IERLO and IERHI arrays to accomodate two-character 
C           vehicle numbers (IERLO1 -> IERLOW01, etc.). Added arrays for 
C           vehicle numbers 9-22 (IERLOW09, IERLOW10, ..., IERLOW24, 
C           IERHI09, ..., IERHI24). Changed the second dimension of NUMERU 
C           from 8 to 24. 
C 
C  2 Apr 97 - DynTel@MLA 2-622  Expanded MYGERU and NUMERU to accomodate  
C             the new BUS vehicle categories. 
C 
C  8 Apr 98  @DynTel-RJD 2-654  Added an extra field to the BER parameter 
C             record to determine if the record pertains to starting or 
C             running emissions. 
C 
C  23 Jul 98 @DynTel-MLA 2-000  Changed LDGT names to conform to 
C            certification naming conventions. 
C 
C  Common block array subscripts: 
C 
C  BERNEW(3,250)         -  BERNEW ( IBER, IFAC ) 
C  MYGERB(33,3,28,2)     -  MYGERB ( IG, IP, IV, IR ) 
C  MYGERU(33,2,3,28,2,2) -  MYGERU ( JG, IFL, IP, IV, IR, ISR ) 
C  NEWFIT(250)           -  NEWFIT ( IFAC ) 
C  NEWPAR(5,250)         -  NEWPAR ( IPAR, IFAC ) 
C  NUMERU(3,28,2,2)      -  NUMERU ( IP, IV, IR, ISR ) 
C 
C  Common block dictionary: 
C 
C   Name   Type              Description 
C  ------  ----  -------------------------------------------- 
C  /BASEQ2/: 
C 
C  MYGERB   I    myg upper bounds for Block Data hardcoded FTP emission rate 
C                equation intercept & (LDGV <50K) slope arrays (ERBZML, ERBDR) 
C  MAXERB   I    maximum number of BD hardcoded ER equations possible for any 
C                given combination of IP, IV and IR.  MAXERB is the limit of 
C                the myg dimension of arrays ERBZML, ERBDR and MYGERB. 
C 
C  /BASEQ4/: 
C 
C  NEWOML   C    operating mode label identifying if the user supplied  
C                emission rates apply to vehicles in starting or running  
C                mode. 
C  NEWPAR   R    parameters identifying where (region, vehicle type and 
C                pollutant) and when (first & last model years included) 
C                to use new (user supplied) emission rates 
C  BERNEW   R    intercept and slopes of user supplied emission rates 
C  NEWFIT   I    whether or not (1 or 0) user supplied emission rate 
C                information can be fit into the affected data arrays 
C                (no => the new rate is not stored & not used) 
C  NEWCT    I    count of number of sets of new emission rate specifications 
C                entered by user (not necessarily the number actually used - 
C                see NEWFIT) 
C  MAXCT    I    maximum number of sets allowed by NEWFLG = sets dimension of 
C                the arrays of /BASEQ4/ 
C 
C  /BASEQ6/: 
C 
C  MYGERU   I    myg lower & upper bounds for User supplied FTP emission rate 
C                equation intercept and slopes arrays (ERUZML, ERUDR, ERU50K) 
C  MAXERU   I    maximum number of user supplied ER equation parameters sets 
C                allowed for each IP x IV x IR case (same limit for each case) 
C  NUMERU   I    number of user supplied ER records successfully stored for 
C                each IP x IV x IR case. 
C 
C  Local array subscripts: 
C 
C  IERLOW<IV>(33,3) - IERLOW<IV> ( IG, IP ) 
C  IERHI<IV>(33,3)  - IERHI<IV>  ( IG, IP ) 
C 
C  Local array dictionary: 
C 
C   Name      Type                 Descriptions 
C  ---------  ----  --------------------------------------------------- 
C  IERLOW<IV>  I    low altitude myg upper bounds for hardcoded FTP ERs 
C  IERHI<IV>   I    high altitude myg upper bounds for hardcoded FTP ERs 
C 
C  Notes: 
C 
C 
      IMPLICIT NONE 
      INCLUDE 'BASEQ2.I' 
      INCLUDE 'BASEQ4.I' 
      INCLUDE 'BASEQ6.I' 
      INCLUDE 'PARAME.I' 
C 
      INTEGER 
     * IERLOW01(35,3), IERLOW02(35,3), IERLOW03(35,3), IERLOW04(35,3), 
     * IERLOW05(35,3), IERLOW06(35,3), IERLOW07(35,3), IERLOW08(35,3), 
     * IERLOW09(35,3), IERLOW10(35,3), IERLOW11(35,3), IERLOW12(35,3), 
     * IERLOW13(35,3), IERLOW14(35,3), IERLOW15(35,3), IERLOW16(35,3), 
     * IERLOW17(35,3), IERLOW18(35,3), IERLOW19(35,3), IERLOW20(35,3), 
     * IERLOW21(35,3), IERLOW22(35,3), IERLOW23(35,3), IERLOW24(35,3), 
     * IERLOW25(35,3), IERLOW26(35,3), IERLOW27(35,3), IERLOW28(35,3) 
C 
      EQUIVALENCE 
     * (MYGERB(1,1,01,1),IERLOW01(1,1)),  
     * (MYGERB(1,1,02,1),IERLOW02(1,1)), 
     * (MYGERB(1,1,03,1),IERLOW03(1,1)), 
     * (MYGERB(1,1,04,1),IERLOW04(1,1)), 
     * (MYGERB(1,1,05,1),IERLOW05(1,1)), 
     * (MYGERB(1,1,06,1),IERLOW06(1,1)), 
     * (MYGERB(1,1,07,1),IERLOW07(1,1)), 
     * (MYGERB(1,1,08,1),IERLOW08(1,1)), 
     * (MYGERB(1,1,09,1),IERLOW09(1,1)), 
     * (MYGERB(1,1,10,1),IERLOW10(1,1)), 
     * (MYGERB(1,1,11,1),IERLOW11(1,1)), 
     * (MYGERB(1,1,12,1),IERLOW12(1,1)) 
C 
      EQUIVALENCE 
     * (MYGERB(1,1,13,1),IERLOW13(1,1)), 
     * (MYGERB(1,1,14,1),IERLOW14(1,1)), 
     * (MYGERB(1,1,15,1),IERLOW15(1,1)), 
     * (MYGERB(1,1,16,1),IERLOW16(1,1)), 
     * (MYGERB(1,1,17,1),IERLOW17(1,1)), 
     * (MYGERB(1,1,18,1),IERLOW18(1,1)), 
     * (MYGERB(1,1,19,1),IERLOW19(1,1)), 
     * (MYGERB(1,1,20,1),IERLOW20(1,1)), 
     * (MYGERB(1,1,21,1),IERLOW21(1,1)), 
     * (MYGERB(1,1,22,1),IERLOW22(1,1)), 
     * (MYGERB(1,1,23,1),IERLOW23(1,1)), 
     * (MYGERB(1,1,24,1),IERLOW24(1,1)), 
     * (MYGERB(1,1,25,1),IERLOW25(1,1)), 
     * (MYGERB(1,1,26,1),IERLOW26(1,1)), 
     * (MYGERB(1,1,27,1),IERLOW27(1,1)), 
     * (MYGERB(1,1,28,1),IERLOW28(1,1)) 
C 
      INTEGER 
     * IERHI01(35,3), IERHI02(35,3), IERHI03(35,3), IERHI04(35,3), 
     * IERHI05(35,3), IERHI06(35,3), IERHI07(35,3), IERHI08(35,3), 
     * IERHI09(35,3), IERHI10(35,3), IERHI11(35,3), IERHI12(35,3), 
     * IERHI13(35,3), IERHI14(35,3), IERHI15(35,3), IERHI16(35,3), 
     * IERHI17(35,3), IERHI18(35,3), IERHI19(35,3), IERHI20(35,3), 
     * IERHI21(35,3), IERHI22(35,3), IERHI23(35,3), IERHI24(35,3), 
     * IERHI25(35,3), IERHI26(35,3), IERHI27(35,3), IERHI28(35,3) 
C 
      EQUIVALENCE 
     * (MYGERB(1,1,01,2),IERHI01(1,1)), 
     * (MYGERB(1,1,02,2),IERHI02(1,1)), 
     * (MYGERB(1,1,03,2),IERHI03(1,1)), 
     * (MYGERB(1,1,04,2),IERHI04(1,1)), 
     * (MYGERB(1,1,05,2),IERHI05(1,1)), 
     * (MYGERB(1,1,06,2),IERHI06(1,1)), 
     * (MYGERB(1,1,07,2),IERHI07(1,1)), 
     * (MYGERB(1,1,08,2),IERHI08(1,1)), 
     * (MYGERB(1,1,09,2),IERHI09(1,1)), 
     * (MYGERB(1,1,10,2),IERHI10(1,1)), 
     * (MYGERB(1,1,11,2),IERHI11(1,1)), 
     * (MYGERB(1,1,12,2),IERHI12(1,1)), 
     * (MYGERB(1,1,13,2),IERHI13(1,1)), 
     * (MYGERB(1,1,14,2),IERHI14(1,1)), 
     * (MYGERB(1,1,15,2),IERHI15(1,1)), 
     * (MYGERB(1,1,16,2),IERHI16(1,1)), 
     * (MYGERB(1,1,17,2),IERHI17(1,1)), 
     * (MYGERB(1,1,18,2),IERHI18(1,1)), 
     * (MYGERB(1,1,19,2),IERHI19(1,1)), 
     * (MYGERB(1,1,20,2),IERHI20(1,1)), 
     * (MYGERB(1,1,21,2),IERHI21(1,1)), 
     * (MYGERB(1,1,22,2),IERHI22(1,1)), 
     * (MYGERB(1,1,23,2),IERHI23(1,1)), 
     * (MYGERB(1,1,24,2),IERHI24(1,1)), 
     * (MYGERB(1,1,25,2),IERHI25(1,1)), 
     * (MYGERB(1,1,26,2),IERHI26(1,1)), 
     * (MYGERB(1,1,27,2),IERHI27(1,1)), 
     * (MYGERB(1,1,28,2),IERHI28(1,1)) 
C 
C  /BASEQ2/: 
C 
C  Continuation line code is the pollutant type: 
C 
C      H = HC    C = CO    N = NOx 
C 
C  mygs for low altitude FTP emission rates 
C 
        DATA IERLOW01/ 
C       LDGV 
     H   1967,1969,1971,1974,1979,1980,1981,1982,1983,1984, 
     H   1985,1986,1987,1988,1989,1990,1991,1993,1994,1995, 
     H   1996,1997,NEYR,12*0000, 
     C   1967,1969,1971,1974,1979,1980,1981,1982,1983,1984, 
     C   1985,1986,1987,1988,1989,1990,1991,NEYR,17*0000, 
     N   1967,1972,1974,1976,1979,1980,1981,1982,1983,1984, 
     N   1985,1986,1987,1988,1989,1990,1991,1993,1994,1995, 
     N   NEYR,14*0000/ 
C 
        DATA IERLOW02/ 
C       LDGT1 
     H   1967,1969,1971,1974,1978,1980,1983,1984,1985,1986, 
     H   1987,1988,1989,1990,1991,1992,1993,1994,1995,1996, 
     H   1997,NEYR,13*0000, 
     C   1967,1969,1971,1974,1978,1980,1983,1984,1985,1986, 
     C   1987,1988,1989,1990,1991,1992,1993,1994,1995,1996, 
     C   1997,NEYR,13*0000, 
     N   1967,1972,1974,1978,1980,1983,1984,1985,1986,1987, 
     N   1988,1989,1990,1991,1992,1993,1994,1995,1996,1997, 
     N   NEYR,14*0000/ 
C 
        DATA IERLOW03/ 
C       LDGT2 
     H   1967,1969,1971,1974,1978,1980,1983,1984,1985,1986, 
     H   1987,1988,1989,1990,1991,1992,1993,1994,1995,1996, 
     H   1997,NEYR,13*0000, 
     C   1967,1969,1971,1974,1978,1980,1983,1984,1985,1986, 
     C   1987,1988,1989,1990,1991,1992,1993,1994,1995,1996, 
     C   1997,NEYR,13*0000, 
     N   1967,1972,1974,1978,1980,1983,1984,1985,1986,1987, 
     N   1988,1989,1990,1991,1992,1993,1994,1995,1996,1997, 
     N   NEYR,14*0000/ 
C 
        DATA IERLOW04/ 
C       LDGT3 
     H   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     H   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     H   NEYR,14*0000, 
     C   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     C   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     C   NEYR,14*0000, 
     N   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     N   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     N   NEYR,14*0000/ 
C 
        DATA IERLOW05/ 
C       LDGT4 
     H   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     H   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     H   NEYR,14*0000, 
     C   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     C   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     C   NEYR,14*0000, 
     N   1969,1973,1978,1980,1983,1984,1985,1986,1987,1988, 
     N   1989,1990,1991,1992,1993,1994,1995,1996,1997,1998, 
     N   NEYR,14*0000/ 
C 
        DATA IERLOW06/ 
C       HDGV2B    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW07/ 
C       HDGV3    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW08/ 
C       HDGV4    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW09/ 
C       HDGV5    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW10/ 
C       HDGV6    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW11/ 
C       HDGV7    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW12/ 
C       HDGV8A    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW13/ 
C       HDGV8B    
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERLOW14/ 
C       LDDV 
     H   1974,1979,NEYR,0000,0000,0000,0000,0000,0000,0000, 
     H   0000,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     H   0000,0000,0000,0000,0000,10*0000, 
     C   1974,1979,NEYR,0000,0000,0000,0000,0000,0000,0000, 
     C   0000,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     C   0000,0000,0000,0000,0000,10*0000, 
     N   1974,1980,1984,NEYR,0000,0000,0000,0000,0000,0000, 
     N   0000,0000,0000,0000,0000,0000,0000,0000,0000,0000, 
     N   0000,0000,0000,0000,0000,10*0000/ 
C 
        DATA IERLOW15/ 
C       LDDT12 
     H   1977,1980,NEYR,32*0000, 
     C   1977,1980,NEYR,32*0000, 
     N   1977,1980,1987,1989,NEYR,30*0000/ 
C 
        DATA IERLOW16/ 
C       HDDV2B 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW17/ 
C       HDDV3 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW18/ 
C       HDDV4 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW19/ 
C       HDDV5 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW20/ 
C       HDDV6 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW21/ 
C       HDDV7 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW22/ 
C       HDDV8A 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW23/ 
C       HDDV8B 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW24/ 
C       MC 
     H   1977,1979,1981,1984,1987,NEYR,29*0000, 
     C   1977,1979,1981,NEYR,31*0000, 
     N   1977,1979,NEYR,32*0000/ 
C 
        DATA IERLOW25/ 
C       GASOLINE-POWERED BUS (AFTER HDGV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2007,2008,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   NEYR,4*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2007,2008,NEYR,0000/ 
C 
        DATA IERLOW26/ 
C       HDDBT DIESEL TRANSIT BUS (AFTER HDDV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2006,NEYR,3*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW27/ 
C       HDDBS DIESEL SCHOOL BUS (AFTER HDDV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERLOW28/ 
C       LDDT34 
     H   1977,1980,NEYR,32*0000, 
     C   1977,1980,NEYR,32*0000, 
     N   1977,1980,1987,1989,NEYR,30*0000/ 
C 
C  mygs for high altitude FTP emission rates 
C 
        DATA IERHI01/ 
C       LDGV 
     H   1967,1969,1971,1974,1976,1977,1979,1980,1981,1982, 
     H   1983,1984,1985,1986,1987,1988,1989,1990,1991,1993, 
     H   1994,1995,1996,1997,NEYR,10*0000, 
     C   1967,1969,1971,1974,1976,1977,1979,1980,1981,1982, 
     C   1983,1984,1985,1986,1987,1988,1989,1990,1991,NEYR, 
     C   15*0000, 
     N   1967,1972,1974,1976,1977,1979,1980,1981,1982,1983, 
     N   1984,1985,1986,1987,1988,1989,1990,1991,1993,1994, 
     N   1995,NEYR,13*0000/ 
C 
        DATA IERHI02/ 
C       LDGT1 
     H   1967,1969,1971,1974,1976,1977,1978,1980,1981,1983, 
     H   1984,1985,1986,1987,1988,1989,1990,1991,1993,1994, 
     H   1995,1996,1997,NEYR,11*0000, 
     C   1967,1969,1971,1974,1976,1977,1978,1980,1981,1983, 
     C   1984,1985,1986,1987,1988,1989,1990,1991,1993,1994, 
     C   1995,1996,1997,NEYR,11*0000, 
     N   1967,1972,1974,1976,1977,1978,1980,1981,1983,1984, 
     N   1985,1986,1987,1988,1989,1990,1991,1993,1994,1995, 
     N   1996,1997,NEYR,12*0000/ 
C 
        DATA IERHI03/ 
C       LDGT2 
     H   1967,1969,1971,1974,1976,1977,1978,1980,1981,1983, 
     H   1984,1985,1986,1987,1988,1989,1990,1991,1993,1994, 
     H   1995,1996,1997,NEYR,11*0000, 
     C   1967,1969,1971,1974,1976,1977,1978,1980,1981,1983, 
     C   1984,1985,1986,1987,1988,1989,1990,1991,1993,1994, 
     C   1995,1996,1997,NEYR,11*0000, 
     N   1967,1972,1974,1976,1977,1978,1980,1981,1983,1984, 
     N   1985,1986,1987,1988,1989,1990,1991,1993,1994,1995, 
     N   1996,1997,NEYR,12*0000/ 
C 
        DATA IERHI04/ 
C       LDGT3 
     H   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     H   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     H   NEYR,14*0000, 
     C   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     C   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     C   NEYR,14*0000, 
     N   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     N   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     N   NEYR,14*0000/ 
C 
        DATA IERHI05/ 
C       LDGT4 
     H   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     H   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     H   NEYR,14*0000, 
     C   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     C   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     C   NEYR,14*0000, 
     N   1969,1973,1978,1980,1981,1983,1984,1985,1986,1987, 
     N   1988,1989,1990,1991,1993,1994,1995,1996,1997,1998, 
     N   NEYR,14*0000/ 
C 
        DATA IERHI06/ 
C       HDGV2B 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI07/ 
C       HDGV3 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI08/ 
C       HDGV4 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI09/ 
C       HDGV5 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI10/ 
C       HDGV6 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI11/ 
C       HDGV7 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI12/ 
C       HDGV8A 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI13/ 
C       HDGV8B 
     H   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     H   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     H   1992,1993,1994,1995,2007,2008,NEYR,8*0000, 
     C   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     C   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     C   1992,1993,1994,1995,NEYR,10*0000, 
     N   1969,1973,1974,1975,1976,1977,1978,1979,1980,1981, 
     N   1982,1983,1984,1985,1986,1987,1988,1989,1990,1991, 
     N   1992,1993,1994,1995,1997,2007,2008,NEYR,7*0000/ 
C 
        DATA IERHI14/ 
C       LDDV 
     H   1974,1979,1981,1983,NEYR,30*0000, 
     C   1974,1979,1983,NEYR,31*0000, 
     N   1974,1980,1984,NEYR,31*0000/ 
C 
        DATA IERHI15/ 
C       LDDT12 
     H   1980,1983,1993,NEYR,31*0000, 
     C   1983,1993,NEYR,32*0000, 
     N   1980,1987,1989,1993,NEYR,30*0000/ 
C 
        DATA IERHI16/ 
C       HDDV2B 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI17/ 
C       HDDV3 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI18/ 
C       HDDV4 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI19/ 
C       HDDV5 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI20/ 
C       HDDV6 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI21/ 
C       HDDV7 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI22/ 
C       HDDV8A 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI23/ 
C       HDDV8B 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI24/ 
C       MC 
     H   1977,1979,1981,1984,1987,NEYR,29*0000, 
     C   1977,1979,1981,NEYR,31*0000, 
     N   1977,1979,NEYR,32*0000/ 
C 
        DATA IERHI25/ 
C       GASOLINE-POWERED BUS (AFTER HDGV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2007,2008,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   NEYR,4*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2007,2008,NEYR,0000/ 
C 
        DATA IERHI26/ 
C       HDDBT DIESEL TRANSIT BUS (AFTER HDDV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2006,NEYR,3*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI27/ 
C       HDDBS DIESEL SCHOOL BUS (AFTER HDDV) 
     H   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     H   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     H   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     H   2003,2006,NEYR,2*0000, 
     C   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     C   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     C   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     C   2006,NEYR,3*0000, 
     N   1966,1967,1968,1969,1970,1971,1972,1973,1974,1975, 
     N   1976,1977,1978,1979,1980,1981,1982,1983,1984,1985, 
     N   1986,1987,1988,1989,1990,1991,1992,1993,1994,1995, 
     N   1997,2003,2006,2009,NEYR/ 
C 
        DATA IERHI28/ 
C       LDDT34 
     H   1980,1983,1993,NEYR,31*0000, 
     C   1983,1993,NEYR,32*0000, 
     N   1980,1987,1989,1993,NEYR,30*0000/ 
C 
        DATA MAXERB/35/ 
C 
C  /BASEQ4/: 
C 
C  Except for the limit on the total number of replacement ef parameter records, 
C  the /BASEQ4/ block is initialized to dummy zeroes, since the cells either 
C  get read in or assigned values or are not used. 
C 
      DATA NEWOML/8400*'R'/,NEWPAR/42000*0/,BERNEW/25200*0.0/ 
      DATA NEWCT/0/,NEWFIT/8400*0/ 
      DATA MAXCT/8400/ 
C 
C  /BASEQ6/: 
C 
C  Initialize all user supplied myg cases to 0, to allow IERPTR storage 
C  algorithm to work, and NUMERU to 0, to allow storage and access algorithms 
C  to work. 
C 
      DATA MYGERU/23520*0/,MAXERU/35/,NUMERU/336*0/ 
C 
      END 
